/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import java.awt.Color;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import plugins.adufour.activecontours.ActiveContours;
import plugins.adufour.activecontours.SlidingWindow;
import plugins.adufour.activecontours.TopologyException;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.nchenouard.spot.Detection;

public abstract class ActiveContour
extends Detection
implements Iterable<Point3d> {
    protected static final Processor processor = new Processor(SystemUtil.getNumberOfCPUs() * 2);
    protected String name = "";
    protected int id = -1;
    protected SlidingWindow convergence;
    protected int lastConvergedFrame = -1;
    protected VarDouble sampling = new VarDouble("sampling", 1.0);
    protected final BoundingSphere boundingSphere = new BoundingSphere();
    protected final BoundingBox boundingBox = new BoundingBox();
    protected Var<Double> divisionSensitivity;

    protected ActiveContour() {
        super(0.0, 0.0, 0.0, 0);
    }

    protected ActiveContour(Var<Double> sampling, SlidingWindow convergenceWindow) {
        super(0.0, 0.0, 0.0, 0);
        while (sampling.getReference() != null) {
            sampling = sampling.getReference();
        }
        this.sampling.setReference(sampling);
        this.convergence = convergenceWindow;
        processor.setThreadName(this.getClass().getSimpleName());
        this.setColor(Color.getHSBColor((float)Math.random(), 0.8f, 0.9f));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract ActiveContour clone();

    protected abstract void addPoint(Point3d var1);

    protected abstract ActiveContour[] checkSelfIntersection(double var1);

    abstract void computeAxisForces(double var1);

    abstract void computeBalloonForces(double var1);

    abstract void computeEdgeForces(Sequence var1, int var2, double var3);

    abstract void computeRegionForces(Sequence var1, int var2, double var3, double var5, double var7, double var9);

    abstract void computeInternalForces(double var1);

    abstract void computeVolumeConstraint(double var1, double var3);

    abstract int computeFeedbackForces(ActiveContour var1);

    public abstract double computeAverageIntensity(Sequence var1, BooleanMask3D var2) throws TopologyException;

    public abstract double computeBackgroundIntensity(Sequence var1, BooleanMask3D var2);

    public abstract double getDistanceToEdge(Point3d var1);

    public abstract double getDimension(int var1);

    abstract void move(ROI var1, double var2);

    public abstract void reSample(double var1, double var3) throws TopologyException;

    @Deprecated
    public abstract ROI toROI();

    public abstract ROI toROI(ActiveContours.ROIType var1, Sequence var2) throws UnsupportedOperationException;

    public abstract void toSequence(Sequence var1, double var2);

    protected void updateMetaData() {
        Point3d center = new Point3d();
        double radius = 0.0;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        double nbPts = 0.0;
        for (Point3d p : this) {
            nbPts += 1.0;
            center.add((Tuple3d)p);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (p.z < minZ) {
                minZ = p.z;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y > maxY) {
                maxY = p.y;
            }
            if (!(p.z > maxZ)) continue;
            maxZ = p.z;
        }
        center.scale(1.0 / nbPts);
        this.setX(center.x);
        this.setY(center.y);
        this.setZ(center.z);
        this.boundingSphere.setCenter(center);
        for (Point3d p : this) {
            double d = p.distanceSquared(center);
            if (!(d > radius)) continue;
            radius = d;
        }
        this.boundingSphere.setRadius(Math.sqrt(radius));
        this.boundingBox.setLower(minX, minY, minZ);
        this.boundingBox.setUpper(maxX, maxY, maxZ);
        this.updateNormals();
    }

    protected abstract void updateNormals();

    protected abstract void clean();

    public abstract boolean hasConverged(SlidingWindow.Operation var1, double var2);

    public int getLastConvergedFrame() {
        return this.lastConvergedFrame;
    }

    public void setLastConvergedFrame(int frame) {
        this.lastConvergedFrame = frame;
    }

    public void setDivisionSensitivity(Var<Double> divisionSensitivity) {
        this.divisionSensitivity = divisionSensitivity;
    }
}

