/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import icy.file.FileUtil;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.math.ArrayMath;
import icy.plugin.interface_.PluginBundled;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.util.XLSUtil;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.ActiveContours;
import plugins.adufour.activecontours.Mesh3D;
import plugins.adufour.quickhull.QuickHull3D;
import plugins.adufour.roi.mesh.Vertex3D;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class DeformationProfiler
extends PluginTrackManagerProcessor
implements PluginBundled {
    private static XMLPreferences preferences = null;
    private JComboBox<Descriptors> jComboDescriptors = new JComboBox<Descriptors>(Descriptors.values());
    private JButton jButtonSaveToVTK = new JButton("Export meshes to VTK files");
    private JButton jButtonSaveShapeToXLS = new JButton("Export shape measures to XLS");
    private JPanel chartPanel = new JPanel();
    private double tScale;

    public DeformationProfiler() {
        if (preferences == null) {
            preferences = this.getPreferencesRoot();
        }
        super.getDescriptor().setDescription("Monitor the 3D deformation over time");
        super.setName("3D Deformation Profiler");
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.panel.add(Box.createVerticalStrut(5));
        this.panel.add(new JLabel("Warning: this plug-in is in development and may change at any time", 0));
        this.panel.add(Box.createVerticalStrut(5));
        JPanel panelExport = new JPanel();
        panelExport.setLayout(new BoxLayout(panelExport, 0));
        panelExport.add(this.jButtonSaveToVTK);
        panelExport.add(Box.createHorizontalStrut(5));
        panelExport.add(this.jButtonSaveShapeToXLS);
        this.panel.add(panelExport);
        this.panel.add(Box.createVerticalStrut(5));
        this.panel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalStrut(10), new JLabel("Plot descriptor:"), Box.createHorizontalStrut(10), this.jComboDescriptors, Box.createHorizontalStrut(10)}));
        this.jComboDescriptors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeformationProfiler.this.Compute();
            }
        });
        this.jButtonSaveToVTK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String vtkFolder = preferences.get("vtkFolder", null);
                        String path = SaveDialog.chooseFile((String)"Export shape information", (String)vtkFolder, (String)"Mesh");
                        if (path == null) {
                            return;
                        }
                        preferences.put("vtkFolder", FileUtil.getDirectory((String)path));
                        try (AnnounceFrame message = new AnnounceFrame("Saving VTK files...", 0);){
                            DeformationProfiler.this.exportMeshToVTK(path);
                        }
                    }
                }.start();
            }
        });
        this.jButtonSaveShapeToXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String xlsFolder = preferences.get("xlsFolder", null);
                        String path = SaveDialog.chooseFile((String)"Export shape information", (String)xlsFolder, (String)"Shape", (String)".xls");
                        if (path == null) {
                            return;
                        }
                        preferences.put("xlsFolder", FileUtil.getDirectory((String)path));
                        try (AnnounceFrame message = new AnnounceFrame("Saving shape information...", 0);){
                            DeformationProfiler.this.exportShapeToXLS(path);
                        }
                    }
                }.start();
            }
        });
        this.panel.add(this.chartPanel);
    }

    public void Close() {
    }

    public synchronized void Compute() {
        this.chartPanel.removeAll();
        if (!super.isEnabled()) {
            return;
        }
        if (this.trackPool.getDisplaySequence() == null) {
            return;
        }
        this.tScale = this.trackPool.getDisplaySequence().getTimeInterval();
        ChartPanel chart = null;
        Descriptors descriptor = (Descriptors)((Object)this.jComboDescriptors.getSelectedItem());
        switch (descriptor) {
            case None: {
                return;
            }
            case Width: {
                double[][] w = this.computeBoxWidth();
                chart = this.createChartPanel(w, descriptor.toString(), "Time (sec.)", "\u03bcm\u00b2");
                break;
            }
            case Height: {
                double[][] h = this.computeBoxHeight();
                chart = this.createChartPanel(h, descriptor.toString(), "Time (sec.)", "\u03bcm\u00b2");
                break;
            }
            case Depth: {
                double[][] d = this.computeBoxDepth();
                chart = this.createChartPanel(d, descriptor.toString(), "Time (sec.)", "\u03bcm\u00b2");
                break;
            }
            case Norm1: {
                double[][] dim1 = this.computeDimension(1);
                chart = this.createChartPanel(dim1, descriptor.toString(), "Time (sec.)", "\u03bcm\u00b2");
                break;
            }
            case Norm2: {
                double[][] dim2 = this.computeDimension(2);
                chart = this.createChartPanel(dim2, descriptor.toString(), "Time (sec.)", "\u03bcm\u00b3");
                break;
            }
            case Roundness: {
                double[][] roundness = this.computeRoundness();
                chart = this.createChartPanel(roundness, descriptor.toString(), "Time (sec.)", "%");
                break;
            }
            case Sphericity: {
                double[][] radiivar = this.computeSphericity();
                chart = this.createChartPanel(radiivar, descriptor.toString(), "Time (sec.)", "%");
                break;
            }
            case Convexity: {
                double[][] convexHullDiff = this.computeConvexity();
                chart = this.createChartPanel(convexHullDiff, descriptor.toString(), "Time (sec.)", "%");
                break;
            }
            case Smoothness: {
                double[][] roughness = this.computeSmoothness();
                chart = this.createChartPanel(roughness, descriptor.toString(), "Time (sec.)", "%");
                break;
            }
            case Elongation: {
                double[][] elongation = this.computeElongation();
                chart = this.createChartPanel(elongation, descriptor.toString(), "Time (sec.)", "A.U.");
                break;
            }
            case Flatness: {
                double[][] flatness = this.computeFlatness();
                chart = this.createChartPanel(flatness, descriptor.toString(), "Time (sec.)", "%");
                break;
            }
            default: {
                throw new UnsupportedOperationException("\"" + descriptor.toString() + "\" measure is not yet implemented");
            }
        }
        this.jComboDescriptors.setSelectedItem((Object)Descriptors.None);
        if (chart != null) {
            XYItemRenderer renderer = ((XYPlot)chart.getChart().getPlot()).getRenderer();
            for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
                renderer.setSeriesPaint(this.trackPool.getTrackIndex(ts), (Paint)ts.getFirstDetection().getColor());
            }
            this.chartPanel.add((Component)chart);
        }
        this.panel.updateUI();
    }

    private double[][] computeBoxWidth() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                double value;
                if (!(det instanceof ActiveContour)) continue;
                Mesh3D contour = (Mesh3D)det;
                result[trackIndex][det.getT()] = value = contour.toROI(ActiveContours.ROIType.POLYGON, seq).getBounds5D().getSizeX() * contour.pixelSize.x;
            }
        }
        return result;
    }

    private double[][] computeBoxHeight() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                double value;
                if (!(det instanceof ActiveContour)) continue;
                Mesh3D contour = (Mesh3D)det;
                result[trackIndex][det.getT()] = value = contour.toROI(ActiveContours.ROIType.POLYGON, seq).getBounds5D().getSizeY() * contour.pixelSize.y;
            }
        }
        return result;
    }

    private double[][] computeBoxDepth() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                double value;
                if (!(det instanceof ActiveContour)) continue;
                Mesh3D contour = (Mesh3D)det;
                result[trackIndex][det.getT()] = value = contour.toROI(ActiveContours.ROIType.POLYGON, seq).getBounds5D().getSizeZ() * contour.pixelSize.z;
            }
        }
        return result;
    }

    private void exportShapeToXLS(String xlsPath) {
        try {
            WritableWorkbook wb = XLSUtil.createWorkbook((String)xlsPath);
            this.saveToXls(wb, "Surface area", this.computeDimension(1));
            this.saveToXls(wb, "Volume", this.computeDimension(2));
            this.saveToXls(wb, "Roundness", this.computeRoundness());
            this.saveToXls(wb, "Convexity", this.computeConvexity());
            this.saveToXls(wb, "Sphericity", this.computeSphericity());
            this.saveToXls(wb, "Smoothness", this.computeSmoothness());
            wb.write();
            wb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    private void exportMeshToVTK(String vtkPath) {
        int cpt = 0;
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            String filePrefix = "_#" + (cpt < 1000 ? "0" : "");
            filePrefix = filePrefix + (cpt < 100 ? "0" : "");
            filePrefix = filePrefix + (cpt < 10 ? "0" : "") + cpt;
            for (Detection det : ts.getDetectionList()) {
                if (!(det instanceof Mesh3D)) continue;
                int t = det.getT();
                String fileName = filePrefix + "_T" + (t < 10 ? "000" : (t < 100 ? "00" : (t < 1000 ? "0" : ""))) + t + ".vtk";
                if (det.getDetectionType() == 2) continue;
                ((Mesh3D)det).mesh.saveToVTK(new File(vtkPath + fileName));
            }
            ++cpt;
        }
    }

    private ChartPanel createChartPanel(double[][] array, String title, String xLabel, String yLabel) {
        XYSeriesCollection plot = new XYSeriesCollection();
        for (int track = 0; track < array.length; ++track) {
            XYSeries series = new XYSeries((Comparable)Integer.valueOf(track));
            double[] row = array[track];
            for (int frame = 0; frame < row.length; ++frame) {
                double value = row[frame];
                if (value == 0.0) continue;
                series.add((double)frame * this.tScale, value);
            }
            plot.addSeries(series);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)plot, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return new ChartPanel(chart, 500, 300, 500, 300, 500, 300, false, false, true, true, true, true);
    }

    private void saveToXls(WritableWorkbook book, String pageTitle, double[][] array) {
        WritableSheet sheet = XLSUtil.createNewPage((WritableWorkbook)book, (String)pageTitle);
        XLSUtil.setCellString((WritableSheet)sheet, (int)0, (int)0, (String)"Track \\ Time");
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            XLSUtil.setCellNumber((WritableSheet)sheet, (int)(t + 1), (int)0, (double)((double)t * this.tScale));
        }
        for (int i = 0; i < this.trackPool.getTrackSegmentList().size(); ++i) {
            XLSUtil.setCellNumber((WritableSheet)sheet, (int)0, (int)(i + 1), (double)i);
            double[] row = array[i];
            for (int j = 0; j < row.length; ++j) {
                if (row[j] == 0.0) continue;
                XLSUtil.setCellNumber((WritableSheet)sheet, (int)(j + 1), (int)(i + 1), (double)row[j]);
            }
        }
    }

    private double[][] computeConvexity() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                if (!(det instanceof Mesh3D)) continue;
                Mesh3D contour = (Mesh3D)det;
                Point3d[] points = new Point3d[(int)contour.getDimension(0)];
                int i = 0;
                for (Point3d p : contour) {
                    if (p == null) continue;
                    points[i++] = p;
                }
                QuickHull3D q3d = new QuickHull3D(points);
                int[][] hullFaces = q3d.getFaces();
                Point3d[] hullPoints = q3d.getVertices();
                double hullVolume = 0.0;
                Vector3d v12 = new Vector3d();
                Vector3d v13 = new Vector3d();
                Vector3d cross = new Vector3d();
                for (int[] face : hullFaces) {
                    Point3d v1 = hullPoints[face[0]];
                    Point3d v2 = hullPoints[face[1]];
                    Point3d v3 = hullPoints[face[2]];
                    v12.sub((Tuple3d)v2, (Tuple3d)v1);
                    v13.sub((Tuple3d)v3, (Tuple3d)v1);
                    cross.cross(v12, v13);
                    double surf = cross.length() * 0.5;
                    cross.normalize();
                    hullVolume += surf * cross.dot(new Vector3d((Tuple3d)v1)) / 3.0;
                }
                result[trackIndex][det.getT()] = 100.0 * contour.getDimension(2) / hullVolume;
            }
        }
        return result;
    }

    private double[][] computeDimension(int order) {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            if (result.length <= trackIndex) continue;
            for (Detection det : ts.getDetectionList()) {
                double value;
                if (!(det instanceof ActiveContour) || sizeT <= det.getT()) continue;
                result[trackIndex][det.getT()] = value = ((ActiveContour)det).getDimension(order);
            }
        }
        return result;
    }

    private double[][] computeElongation() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                if (!(det instanceof Mesh3D)) continue;
                Point3d radii = new Point3d();
                DeformationProfiler.computeEllipse((Mesh3D)det, null, radii, null, null);
                result[trackIndex][det.getT()] = radii.x / radii.y;
            }
        }
        return result;
    }

    private double[][] computeFlatness() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                if (!(det instanceof Mesh3D)) continue;
                Point3d radii = new Point3d();
                DeformationProfiler.computeEllipse((Mesh3D)det, null, radii, null, null);
                result[trackIndex][det.getT()] = 100.0 * (1.0 - radii.y / radii.x);
            }
        }
        return result;
    }

    private double[][] computeSmoothness() {
        ExecutorService service = Executors.newCachedThreadPool();
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        final double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        ArrayList results = new ArrayList();
        for (TrackSegment trackSegment : this.trackPool.getTrackSegmentList()) {
            final int trackIndex = this.trackPool.getTrackIndex(trackSegment);
            for (Detection det : trackSegment.getDetectionList()) {
                if (!(det instanceof Mesh3D)) continue;
                final Mesh3D.ActiveMesh mesh = ((Mesh3D)det).mesh;
                results.add(service.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] localRoughness = new double[mesh.getNumberOfVertices(true)];
                        int n = 0;
                        for (Vertex3D v1 : mesh.getVertices()) {
                            if (v1 == null) continue;
                            ArrayList<Vertex3D> neighborhood = new ArrayList<Vertex3D>();
                            for (Integer n1 : v1.neighbors) {
                                Vertex3D vn1 = mesh.getVertex(n1.intValue());
                                if (vn1 == v1 || neighborhood.contains(vn1)) continue;
                                neighborhood.add(vn1);
                                for (Integer n2 : vn1.neighbors) {
                                    Vertex3D vn2 = mesh.getVertex(n2.intValue());
                                    if (vn2 == v1 || vn2 == vn1 || neighborhood.contains(vn2)) continue;
                                    neighborhood.add(vn2);
                                }
                            }
                            double[] distances = new double[neighborhood.size()];
                            for (int i = 0; i < distances.length; ++i) {
                                distances[i] = ((Vertex3D)neighborhood.get((int)i)).normal.angle(v1.normal);
                            }
                            localRoughness[n++] = ArrayMath.std((double[])distances, (boolean)false) / ArrayMath.mean((double[])distances);
                        }
                        result[trackIndex][mesh.getT()] = 100.0 / (1.0 + ArrayMath.mean((double[])localRoughness));
                    }
                }));
            }
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        return result;
    }

    private double[][] computeRoundness() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                if (!(det instanceof Mesh3D)) continue;
                Mesh3D contour = (Mesh3D)det;
                Point3d center = contour.getMassCenter();
                double minRadius = contour.mesh.getMinDistance(center, null, contour.pixelSize);
                double maxRadius = contour.mesh.getMaxDistance(center, null, contour.pixelSize);
                result[trackIndex][det.getT()] = 100.0 * minRadius / maxRadius;
            }
        }
        return result;
    }

    private double[][] computeSphericity() {
        Sequence seq = this.trackPool.getDisplaySequence();
        int sizeT = seq == null ? this.trackPool.getLastDetectionTimePoint() + 1 : seq.getSizeT();
        double[][] result = new double[this.trackPool.getTrackSegmentList().size()][sizeT];
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            int trackIndex = this.trackPool.getTrackIndex(ts);
            for (Detection det : ts.getDetectionList()) {
                if (!(det instanceof Mesh3D)) continue;
                Mesh3D contour = (Mesh3D)det;
                double surfaceArea = contour.getDimension(1);
                double volume = contour.getDimension(2);
                result[trackIndex][det.getT()] = 100.0 * Math.cbrt(113.09733552923255 * volume * volume) / surfaceArea;
            }
        }
        return result;
    }

    public void displaySequenceChanged() {
    }

    public String getMainPluginClassName() {
        return ActiveContours.class.getName();
    }

    public static void computeEllipse(Iterable<Point3d> in_points, Point3d out_center, Point3d out_radii, Vector3d[] out_eigenVectors, double[] out_equation) throws IllegalArgumentException {
        Matrix V;
        ArrayList<double[]> rawMatrix = new ArrayList<double[]>();
        for (Point3d p : in_points) {
            rawMatrix.add(new double[]{p.x * p.x, p.y * p.y, p.z * p.z, p.x * p.y * 2.0, p.x * p.z * 2.0, p.y * p.z * 2.0, p.x * 2.0, p.y * 2.0, p.z * 2.0});
        }
        double[][] _rawMatrix = (double[][])rawMatrix.toArray((T[])new double[rawMatrix.size()][9]);
        Matrix D = new Matrix(_rawMatrix);
        Matrix ones = DeformationProfiler.ones(_rawMatrix.length, 1);
        try {
            V = D.transpose().times(D).inverse().times(D.transpose().times(ones));
        }
        catch (RuntimeException e) {
            throw new SingularMatrixException("The component is most probably flat (i.e. lies in a 2D plane)");
        }
        double[] v = V.getColumnPackedCopy();
        double[][] a = new double[][]{{v[0], v[3], v[4], v[6]}, {v[3], v[1], v[5], v[7]}, {v[4], v[5], v[2], v[8]}, {v[6], v[7], v[8], -1.0}};
        Matrix A = new Matrix((double[][])a);
        Matrix C = A.getMatrix(0, 2, 0, 2).times(-1.0).inverse().times(V.getMatrix(6, 8, 0, 0));
        Matrix T = Matrix.identity((int)4, (int)4);
        T.setMatrix(3, 3, 0, 2, C.transpose());
        Matrix R = T.times(A.times(T.transpose()));
        double r33 = R.get(3, 3);
        Matrix R02 = R.getMatrix(0, 2, 0, 2);
        EigenvalueDecomposition E = new EigenvalueDecomposition(R02.times(-1.0 / r33));
        Matrix eVal = E.getD();
        Matrix eVec = E.getV();
        Matrix diagonal = DeformationProfiler.diag(eVal);
        if (out_radii != null) {
            out_radii.set(Math.sqrt(1.0 / diagonal.get(0, 0)), Math.sqrt(1.0 / diagonal.get(1, 0)), Math.sqrt(1.0 / diagonal.get(2, 0)));
        }
        if (out_center != null) {
            out_center.set(C.get(0, 0), C.get(1, 0), C.get(2, 0));
        }
        if (out_eigenVectors != null && out_eigenVectors.length == 3) {
            out_eigenVectors[0] = new Vector3d(eVec.get(0, 0), eVec.get(0, 1), eVec.get(0, 2));
            out_eigenVectors[1] = new Vector3d(eVec.get(1, 0), eVec.get(1, 1), eVec.get(1, 2));
            out_eigenVectors[2] = new Vector3d(eVec.get(2, 0), eVec.get(2, 1), eVec.get(2, 2));
        }
        if (out_equation != null && out_equation.length == 9) {
            System.arraycopy(v, 0, out_equation, 0, v.length);
        }
    }

    private static Matrix diag(Matrix matrix) {
        int min = Math.min(matrix.getRowDimension(), matrix.getColumnDimension());
        double[][] diag = new double[min][1];
        for (int i = 0; i < min; ++i) {
            diag[i][0] = matrix.get(i, i);
        }
        return new Matrix(diag);
    }

    private static Matrix ones(int m, int n) {
        double[][] array;
        for (double[] row : array = new double[m][n]) {
            Arrays.fill(row, 1.0);
        }
        return new Matrix(array, m, n);
    }

    private static enum Descriptors {
        None("None"),
        Width("Box width"),
        Height("Box height"),
        Depth("Box depth"),
        Norm1("Perimeter (2D) or surface area (3D)"),
        Norm2("Surface (2D) or Volume (3D)"),
        Roundness("Roundness (min radius / max radius)"),
        Convexity("Solidity (area / convex area)"),
        Smoothness("Contour smoothness"),
        Sphericity("Sphericity"),
        Elongation("Elongation factor"),
        Flatness("Flatness");

        final String name;

        private Descriptors(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

