/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.DoubleScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble1D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.DoubleGenerator;

public class FlatDouble1D
extends Double1D {
    static final int order = 1;
    final double[] data;

    public FlatDouble1D(int dim1) {
        super(dim1);
        this.data = new double[this.number];
    }

    public FlatDouble1D(int[] dims) {
        super(dims);
        this.data = new double[this.number];
    }

    public FlatDouble1D(Shape shape) {
        super(shape);
        this.data = new double[this.number];
    }

    public FlatDouble1D(double[] arr, int dim1) {
        super(dim1);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatDouble1D(double[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatDouble1D(double[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(double[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1) {
        return i1;
    }

    @Override
    public final double get(int i1) {
        return this.data[i1];
    }

    @Override
    public final void set(int i1, double value) {
        this.data[i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(double value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(DoubleGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextDouble();
        }
    }

    @Override
    public void increment(double value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(double value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(double value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(DoubleFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(DoubleScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public double[] flatten(boolean forceCopy) {
        if (forceCopy) {
            double[] result = new double[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public DoubleScalar slice(int idx) {
        idx = Helper.fixIndex(idx, this.dim1);
        return new DoubleScalar(this.data, idx);
    }

    @Override
    public DoubleScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new DoubleScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Double1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenDouble1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Double1D view(int[] sel1) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        return new SelectedDouble1D(this.data, idx1);
    }

    @Override
    public Double1D as1D() {
        return this;
    }
}

