/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.variants;

import icy.util.StringUtil;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.variants.DimensionScalar;

public class VariantScalar
extends Variant {
    private double _value;

    public VariantScalar() {
        this(0.0);
    }

    public VariantScalar(double value) {
        super(Variant.Type.SCALAR);
        this._value = value;
    }

    @Override
    public double getAsScalar() {
        return this._value;
    }

    @Override
    public String getRepresentation(boolean addParenthesisIfFragile) {
        String retVal = StringUtil.toString((double)this._value);
        if (addParenthesisIfFragile && this._value < 0.0) {
            retVal = "(" + retVal + ")";
        }
        return retVal;
    }

    @Override
    public Variant.Dimension getDimension() {
        return new DimensionScalar();
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    protected Variant.ReadIterator implGetReadIterator() {
        return new ReadScalarIterator(this._value);
    }

    @Override
    protected Variant.WriteIterator implGetWriteIterator() {
        return new WriteScalarIterator(this);
    }

    @Override
    protected void implBeginUpdate() {
    }

    @Override
    protected void implEndUpdate() {
    }

    private static class WriteScalarIterator
    implements Variant.WriteIterator {
        private VariantScalar _target;
        private boolean _valid;

        public WriteScalarIterator(VariantScalar target) {
            this._target = target;
            this._valid = true;
        }

        @Override
        public boolean valid() {
            return this._valid;
        }

        @Override
        public void next() {
            this._valid = false;
        }

        @Override
        public void startAt(long num) {
            if (num > 0L) {
                this._valid = false;
            }
        }

        @Override
        public void set(double value) {
            this._target._value = value;
        }
    }

    private static class ReadScalarIterator
    implements Variant.ReadIterator {
        double _value;

        public ReadScalarIterator(double value) {
            this._value = value;
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public void next() {
        }

        @Override
        public void startAt(long num) {
        }

        @Override
        public double get() {
            return this._value;
        }
    }
}

