/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.model;

import java.util.HashMap;
import plugins.adufour.vars.gui.model.VarEditorModel;

public abstract class RangeModel<N extends Number>
implements VarEditorModel<N> {
    private RangeEditorType editorType = RangeEditorType.SPINNER;
    protected N defaultValue;
    protected N step;
    protected Comparable<N> min;
    protected Comparable<N> max;
    protected HashMap<N, String> labels;

    public RangeModel(N defaultValue, Comparable<N> min, Comparable<N> max, N step) {
        this(defaultValue, min, max, step, RangeEditorType.SPINNER, null);
    }

    public RangeModel(N defaultValue, Comparable<N> min, Comparable<N> max, N step, RangeEditorType editorType, HashMap<N, String> labels) {
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.step = step;
        this.setEditorType(editorType);
        this.labels = labels;
    }

    @Override
    public N getDefaultValue() {
        return this.defaultValue;
    }

    public RangeEditorType getEditorType() {
        return this.editorType;
    }

    public HashMap<N, String> getLabels() {
        return this.labels;
    }

    public abstract int getRangeSize();

    public Comparable<N> getMaximum() {
        return this.max;
    }

    public Comparable<N> getMinimum() {
        return this.min;
    }

    public N getStepSize() {
        return this.step;
    }

    public abstract N getValueForIndex(int var1);

    public abstract int indexOf(N var1);

    public void setMaximum(Comparable<N> maximum) {
        this.max = maximum;
    }

    public void setEditorType(RangeEditorType editorType) {
        this.editorType = editorType;
    }

    public void setMinimum(Comparable<N> minimum) {
        this.min = minimum;
    }

    public void setStepSize(N step) {
        this.step = step;
    }

    public static enum RangeEditorType {
        SPINNER,
        SLIDER;

    }
}

