/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import org.jdesktop.swingx.icon.EmptyIcon;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class ColorChooser
extends SwingVarEditor<Color> {
    private ActionListener listener;

    public ColorChooser(Var<Color> variable) {
        super(variable);
    }

    @Override
    protected JComponent createEditorComponent() {
        if (this.getEditorComponent() != null) {
            this.deactivateListeners();
        }
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color defaultColor = (Color)ColorChooser.this.variable.getDefaultValue();
                Color newColor = JColorChooser.showDialog(ColorChooser.this.getEditorComponent(), ColorChooser.this.variable.getName(), defaultColor);
                if (newColor == null) {
                    return;
                }
                ColorChooser.this.variable.setValue(newColor);
            }
        };
        JButton button = new JButton((Icon)new EmptyIcon(16, 16)){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor((Color)ColorChooser.this.variable.getValue());
                g.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
            }
        };
        button.setFocusable(false);
        button.setContentAreaFilled(false);
        return button;
    }

    @Override
    public JButton getEditorComponent() {
        return (JButton)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        this.getEditorComponent().addActionListener(this.listener);
    }

    @Override
    protected void deactivateListeners() {
        this.getEditorComponent().removeActionListener(this.listener);
    }

    @Override
    protected void updateInterfaceValue() {
    }
}

