/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class SwimmingObjectChooser
extends SwingVarEditor<SwimmingObject>
implements SwimmingPoolListener {
    private JComboBoxListener jComboBoxListener;
    private JComboBoxModel jComboBoxModel;
    private JComboBoxRenderer jComboBoxRenderer;
    private ArrayList<SwimmingObject> validObjects;

    public SwimmingObjectChooser(Var<SwimmingObject> variable) {
        super(variable);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.validObjects.clear();
        JComponent jComboBox = this.getEditorComponent();
        ((JComboBox)jComboBox).setRenderer(new DefaultListCellRenderer());
        ((JComboBox)jComboBox).setModel(new DefaultComboBoxModel());
    }

    @Override
    public JComponent createEditorComponent() {
        this.validObjects = new ArrayList();
        this.jComboBoxListener = new JComboBoxListener();
        this.jComboBoxModel = new JComboBoxModel();
        this.jComboBoxRenderer = new JComboBoxRenderer();
        JComboBox<SwimmingObject> jComboBox = new JComboBox<SwimmingObject>(this.jComboBoxModel);
        for (SwimmingObject swObj : Icy.getMainInterface().getSwimmingPool().getObjects()) {
            if (!this.variable.getDefaultEditorModel().isValid(swObj)) continue;
            this.validObjects.add(swObj);
        }
        if (this.validObjects.size() > 0) {
            jComboBox.setSelectedIndex(1);
        }
        jComboBox.setRenderer(this.jComboBoxRenderer);
        return jComboBox;
    }

    @Override
    protected void updateInterfaceValue() {
        if (this.variable.getReference() != null) {
            ((JComboBox)this.getEditorComponent()).setSelectedItem(this.variable.getValue());
            this.getEditorComponent().repaint();
        } else if (this.variable.getValue() == null) {
            ((JComboBox)this.getEditorComponent()).setSelectedIndex(0);
            this.getEditorComponent().repaint();
        }
        String valueAsString = this.variable.getValueAsString(true);
        this.getEditorComponent().setToolTipText(valueAsString.length() == 0 ? null : "<html><pre><font size=3>" + valueAsString + "</font></pre></html>");
    }

    public void swimmingPoolChangeEvent(SwimmingPoolEvent event) {
        SwimmingObject object = event.getResult();
        if (!this.variable.getDefaultEditorModel().isValid(object)) {
            return;
        }
        switch (event.getType()) {
            case ELEMENT_ADDED: {
                this.validObjects.add(object);
                break;
            }
            case ELEMENT_REMOVED: {
                this.validObjects.remove(object);
            }
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SwimmingObjectChooser.this.getEditorComponent().repaint();
                ((JComboBox)SwimmingObjectChooser.this.getEditorComponent()).updateUI();
            }
        });
    }

    @Override
    public JComboBox<SwimmingObject> getEditorComponent() {
        return (JComboBox)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        ((JComboBox)this.getEditorComponent()).addActionListener(this.jComboBoxListener);
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)this);
    }

    @Override
    protected void deactivateListeners() {
        ((JComboBox)this.getEditorComponent()).removeActionListener(this.jComboBoxListener);
        Icy.getMainInterface().getSwimmingPool().removeListener((SwimmingPoolListener)this);
    }

    private final class JComboBoxListener
    implements ActionListener {
        private JComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwimmingObject newValue = (SwimmingObject)((JComboBox)SwimmingObjectChooser.this.getEditorComponent()).getSelectedItem();
            if (newValue != null) {
                SwimmingObjectChooser.this.getEditorComponent().setToolTipText(newValue.getName());
            }
            SwimmingObjectChooser.this.variable.setValue(newValue);
        }
    }

    private final class JComboBoxRenderer
    implements ListCellRenderer<SwimmingObject> {
        private JComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SwimmingObject> list, SwimmingObject value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return new JLabel("No selection");
            }
            String name = value.getName();
            return new JLabel(name);
        }
    }

    private final class JComboBoxModel
    extends DefaultComboBoxModel<SwimmingObject> {
        private static final long serialVersionUID = 1L;

        private JComboBoxModel() {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public SwimmingObject getElementAt(int index) {
            if (index == 0) {
                return null;
            }
            return (SwimmingObject)SwimmingObjectChooser.this.validObjects.get(index - 1);
        }

        @Override
        public int getSize() {
            return 1 + SwimmingObjectChooser.this.validObjects.size();
        }
    }
}

