/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.tree.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

class DnDBorderFactory {
    private Border dropAllowedBorder;
    private Border dropNotAllowedBorder;
    private Border offsetBorder;
    private Border emptyBorder;

    public DnDBorderFactory() {
        this.setDropAllowedBorder(new DropAllowedBorder());
        this.setDropNotAllowedBorder(new DropNotAllowedBorder());
        this.setOffsetBorder(new OffsetBorder());
        this.setEmptyBorder(BorderFactory.createEmptyBorder());
    }

    public Border getDropAllowedBorder() {
        return this.dropAllowedBorder;
    }

    public void setDropAllowedBorder(Border dropAllowedBorder) {
        this.dropAllowedBorder = dropAllowedBorder;
    }

    public Border getDropNotAllowedBorder() {
        return this.dropNotAllowedBorder;
    }

    public void setDropNotAllowedBorder(Border dropNotAllowedBorder) {
        this.dropNotAllowedBorder = dropNotAllowedBorder;
    }

    public Border getOffsetBorder() {
        return this.offsetBorder;
    }

    public void setOffsetBorder(Border offsetBorder) {
        this.offsetBorder = offsetBorder;
    }

    public Border getEmptyBorder() {
        return this.emptyBorder;
    }

    public void setEmptyBorder(Border anEmptyBorder) {
        this.emptyBorder = anEmptyBorder;
    }

    static class DropAllowedBorder
    implements Border {
        private static Insets insets = new Insets(0, 0, 3, 0);
        private ImageIcon plusIcon;

        public DropAllowedBorder() {
            URL iconURL = DropAllowedBorder.class.getResource("icons/drop-on-leaf.png");
            if (iconURL != null) {
                this.plusIcon = new ImageIcon(iconURL);
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int yh = y + height - 1;
            if (this.plusIcon != null) {
                this.plusIcon.paintIcon(c, g, x + 8, yh - 8);
            }
            g.setColor(Color.DARK_GRAY);
            g.drawLine(x + 24, yh -= 4, x + 48, yh);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    class DropNotAllowedBorder
    implements Border {
        private Insets insets = new Insets(0, 0, 0, 0);
        private ImageIcon plusIcon;

        public DropNotAllowedBorder() {
            URL iconURL = DnDBorderFactory.class.getResource("icons/drop-not-allowed.png");
            if (iconURL != null) {
                this.plusIcon = new ImageIcon(iconURL);
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.plusIcon != null) {
                this.plusIcon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    class OffsetBorder
    implements Border {
        private Insets insets = new Insets(5, 0, 0, 0);

        OffsetBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

