/*
 * Decompiled with CFR 0.152.
 */
package icy.file;

import icy.file.FileUtil;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.gui.frame.progress.FileFrame;
import icy.sequence.DimensionId;
import icy.sequence.MetaDataUtil;
import icy.type.DataType;
import icy.util.StringUtil;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.xml.meta.OMEXMLMetadata;
import plugins.kernel.importer.LociImporterPlugin;

public class SequenceFileSticher {
    public static Collection<SequenceFileGroup> groupAllFiles(SequenceFileImporter importer, Collection<String> paths, boolean findPosition, FileFrame loadingFrame) {
        List<String> sortedPaths = Loader.cleanNonImageFile(Loader.explode(new ArrayList<String>(paths)));
        if (sortedPaths.isEmpty()) {
            return new ArrayList<SequenceFileGroup>();
        }
        if (loadingFrame != null) {
            loadingFrame.setAction("Sort paths...");
        }
        if (sortedPaths.size() > 1) {
            Collections.sort(sortedPaths, new StringUtil.AlphanumComparator());
        }
        if (loadingFrame != null) {
            loadingFrame.setAction("Extracting positions from paths...");
        }
        HashMap<String, ArrayList<FilePosition>> pathPositionsMap = new HashMap<String, ArrayList<FilePosition>>();
        for (String path : sortedPaths) {
            FilePosition filePosition = new FilePosition(path);
            String base = filePosition.base;
            ArrayList<FilePosition> positions = (ArrayList<FilePosition>)pathPositionsMap.get(base);
            if (positions == null) {
                positions = new ArrayList<FilePosition>();
                pathPositionsMap.put(base, positions);
            }
            positions.add(filePosition);
        }
        HashMap<SequenceIdent, SequenceFileGroup> result = new HashMap<SequenceIdent, SequenceFileGroup>();
        for (List positions : pathPositionsMap.values()) {
            while (SequenceFileSticher.cleanPositions(positions, DimensionId.NULL)) {
            }
            while (SequenceFileSticher.cleanPositions(positions, DimensionId.T)) {
            }
            while (SequenceFileSticher.cleanPositions(positions, DimensionId.Z)) {
            }
            while (SequenceFileSticher.cleanPositions(positions, DimensionId.C)) {
            }
            while (SequenceFileSticher.cleanPositions(positions, DimensionId.Y)) {
            }
            while (SequenceFileSticher.cleanPositions(positions, DimensionId.X)) {
            }
            for (FilePosition pos : positions) {
                SequenceFileSticher.addToGroup(result, new SequencePosition(pos), importer);
            }
        }
        if (loadingFrame != null) {
            loadingFrame.setAction("Cleanup up positions and rebuilding indexes...");
        }
        for (SequenceFileGroup group : result.values()) {
            if (findPosition) {
                group.checkZTDimIdPos();
                Collections.sort(group.positions);
            }
            group.buildIndexesAndSizesFromPositions(findPosition);
        }
        return result.values();
    }

    public static SequenceFileGroup groupFiles(SequenceFileImporter importer, Collection<String> paths, boolean findPosition, FileFrame loadingFrame) {
        SequenceFileGroup result = null;
        for (SequenceFileGroup group : SequenceFileSticher.groupAllFiles(importer, paths, findPosition, loadingFrame)) {
            if (result == null) {
                result = group;
                continue;
            }
            if (result.positions.size() >= group.positions.size()) continue;
            result = group;
        }
        return result;
    }

    static int compare(double v1, double v2) {
        if (v1 != -1.0 && v2 != -1.0) {
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
        }
        return 0;
    }

    static SequenceFileImporter tryOpen(SequenceFileImporter importer, String path, boolean minimumMetadata) {
        boolean tryAnotherImporter;
        SequenceFileImporter imp;
        if (importer == null) {
            imp = Loader.getSequenceFileImporter(path, true);
            tryAnotherImporter = false;
        } else {
            imp = importer;
            tryAnotherImporter = true;
        }
        if (imp != null) {
            if (imp instanceof LociImporterPlugin) {
                ((LociImporterPlugin)imp).setGroupFiles(false);
                ((LociImporterPlugin)imp).setReadOriginalMetadata(false);
            }
            try {
                imp.open(path, minimumMetadata ? 1 : 0);
            }
            catch (ClosedByInterruptException e) {
                return null;
            }
            catch (Throwable t) {
                if (tryAnotherImporter) {
                    return SequenceFileSticher.tryOpen(null, path, minimumMetadata);
                }
                return null;
            }
        }
        return imp;
    }

    private static void addToGroup(Map<SequenceIdent, SequenceFileGroup> groups, SequencePosition position, SequenceFileImporter importer) {
        SequenceFileGroup group = groups.get(SequenceFileSticher.getSequenceIdent(importer, position, true));
        if (group == null) {
            SequenceIdent ident = SequenceFileSticher.getSequenceIdent(importer, position, false);
            if (ident == null) {
                return;
            }
            group = new SequenceFileGroup(ident);
            groups.put(ident, group);
        }
        group.positions.add(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SequenceIdent getSequenceIdent(SequenceFileImporter importer, SequencePosition position, boolean minimumMetadata) {
        SequenceIdent sequenceIdent;
        SequenceFileImporter imp = SequenceFileSticher.tryOpen(importer, position.getPath(), minimumMetadata);
        if (imp == null) {
            return null;
        }
        try {
            OMEXMLMetadata meta = imp.getOMEXMLMetaData();
            SequenceType type = new SequenceType();
            type.sizeX = MetaDataUtil.getSizeX(meta, 0);
            type.sizeY = MetaDataUtil.getSizeY(meta, 0);
            type.sizeZ = MetaDataUtil.getSizeZ(meta, 0);
            type.sizeT = MetaDataUtil.getSizeT(meta, 0);
            type.sizeC = MetaDataUtil.getSizeC(meta, 0);
            type.dataType = MetaDataUtil.getDataType(meta, 0);
            if (!minimumMetadata) {
                type.minimumMeta = false;
                type.pixelSizeX = MetaDataUtil.getPixelSizeX(meta, 0, 0.0);
                type.pixelSizeY = MetaDataUtil.getPixelSizeY(meta, 0, 0.0);
                type.pixelSizeZ = MetaDataUtil.getPixelSizeZ(meta, 0, 0.0);
                type.timeInterval = MetaDataUtil.getTimeInterval(meta, 0, 0.0);
            }
            type.computeHashCode();
            sequenceIdent = new SequenceIdent(position.getBase(), position.getIndexS(), type, imp);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                SequenceIdent sequenceIdent2 = null;
                return sequenceIdent2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    imp.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            imp.close();
            return sequenceIdent;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sequenceIdent;
    }

    private static boolean cleanPositions(Collection<FilePosition> filePositions, DimensionId dim) {
        int value = -1;
        for (FilePosition position : filePositions) {
            int v = position.getValue(dim);
            if (v == -1) continue;
            if (value == -1) {
                value = v;
                continue;
            }
            if (value == v) continue;
            value = -1;
            break;
        }
        if (value != -1) {
            for (FilePosition position : filePositions) {
                if (position.getValue(dim) == -1) continue;
                position.removeChunk(dim);
            }
            return true;
        }
        return false;
    }

    public static class FilePosition
    implements Comparable<FilePosition> {
        final String path;
        final String base;
        final List<PositionChunk> chunks;

        FilePosition(String path) {
            this.path = path;
            this.base = FilePosition.getBase(path);
            this.chunks = new ArrayList<PositionChunk>();
            this.build();
        }

        private void build() {
            String name = FileUtil.getFileName(this.path);
            int len = name.length();
            int index = 0;
            while (index < len) {
                int startInd = StringUtil.getNextDigitCharIndex(name, index);
                if (startInd >= 0) {
                    int endInd = StringUtil.getNextNonDigitCharIndex(name, startInd);
                    if (endInd < 0) {
                        endInd = len;
                    }
                    String prefix = FilePosition.getPositionPrefix(name, startInd - 1);
                    int value = StringUtil.parseInt(name.substring(startInd, endInd), -1);
                    this.addChunk(prefix, value);
                    index = endInd;
                    continue;
                }
                index = len;
            }
        }

        private static String getBase(String path) {
            int st;
            String result = FileUtil.getFileName(path);
            int pos = 0;
            while (pos < result.length() && (st = StringUtil.getNextDigitCharIndex(result, pos)) != -1) {
                int end = StringUtil.getNextNonDigitCharIndex(result, st);
                if (end < 0) {
                    end = result.length();
                }
                if (st > 2 && Character.isLetter(result.charAt(st - 1)) && " -_".contains(result.substring(st - 2, st - 1))) {
                    st -= 2;
                } else if (st > 1) {
                    if (!Character.isLetter(result.charAt(st - 2)) && Character.isLetter(result.charAt(st - 1))) {
                        --st;
                    } else if (" -_".contains(result.substring(st - 1, st - 0))) {
                        --st;
                    }
                }
                result = result.substring(0, st) + result.substring(end);
                pos = st;
            }
            return result;
        }

        private static String getPositionPrefix(String text, int ind) {
            if (ind >= 0 && ind < text.length() && Character.isLetter(text.charAt(ind))) {
                return text.substring(StringUtil.getPreviousNonLetterCharIndex(text, ind) + 1, ind + 1);
            }
            return "";
        }

        private void addChunk(String prefix, int value) {
            PositionChunk chunk = new PositionChunk(prefix, value);
            PositionChunk previousChunk = this.getChunk(chunk.dim, false);
            if (previousChunk != null) {
                previousChunk.dim = null;
            }
            this.chunks.add(chunk);
        }

        private boolean removeChunk(PositionChunk chunk) {
            return this.chunks.remove(chunk);
        }

        boolean removeChunk(DimensionId dim) {
            return this.removeChunk(this.getChunk(dim, true));
        }

        public int getValue(DimensionId dim) {
            PositionChunk chunk = this.getChunk(dim, true);
            if (chunk != null) {
                return chunk.value;
            }
            return -1;
        }

        boolean isUnknowDim(DimensionId dim) {
            return this.getChunk(dim, false) == null;
        }

        public PositionChunk getChunk(DimensionId dim, boolean allowUnknown) {
            if (dim != null) {
                for (PositionChunk chunk : this.chunks) {
                    if (chunk.dim != dim) continue;
                    return chunk;
                }
                if (allowUnknown) {
                    return this.getChunkFromUnknown(dim);
                }
            }
            return null;
        }

        private PositionChunk getChunkFromUnknown(DimensionId dim) {
            boolean hasCChunk = this.getChunk(DimensionId.C, false) != null;
            boolean hasZChunk = this.getChunk(DimensionId.Z, false) != null;
            boolean hasTChunk = this.getChunk(DimensionId.T, false) != null;
            switch (dim) {
                case Z: {
                    if (hasZChunk) {
                        return null;
                    }
                    if (hasTChunk) {
                        return this.getUnknownChunk(0);
                    }
                    return this.getUnknownChunk(1);
                }
                case T: {
                    if (hasTChunk) {
                        return null;
                    }
                    return this.getUnknownChunk(0);
                }
                case C: {
                    if (hasCChunk) {
                        return null;
                    }
                    if (hasTChunk) {
                        if (hasZChunk) {
                            return this.getUnknownChunk(0);
                        }
                        return this.getUnknownChunk(1);
                    }
                    if (hasZChunk) {
                        return this.getUnknownChunk(1);
                    }
                    return this.getUnknownChunk(2);
                }
            }
            return null;
        }

        private PositionChunk getUnknownChunk(int i) {
            int ind = 0;
            for (PositionChunk chunk : this.chunks) {
                if (chunk.dim != null) continue;
                if (ind == i) {
                    return chunk;
                }
                ++ind;
            }
            return null;
        }

        int getUnknownChunkCount() {
            int result = 0;
            for (PositionChunk chunk : this.chunks) {
                if (chunk.dim != null) continue;
                ++result;
            }
            return result;
        }

        public int compareSeries(FilePosition ipb) {
            int result = 0;
            String bn1 = this.base;
            String bn2 = ipb.base;
            if (!StringUtil.isEmpty(bn1) && !StringUtil.isEmpty(bn2)) {
                result = bn1.compareTo(bn2);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.getValue(DimensionId.NULL), ipb.getValue(DimensionId.NULL));
            }
            return result;
        }

        public int compare(FilePosition ipb, boolean compareSeries) {
            int result = 0;
            if (compareSeries) {
                result = this.compareSeries(ipb);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.getValue(DimensionId.T), ipb.getValue(DimensionId.T));
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.getValue(DimensionId.Z), ipb.getValue(DimensionId.Z));
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.getValue(DimensionId.C), ipb.getValue(DimensionId.C));
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.getValue(DimensionId.Y), ipb.getValue(DimensionId.Y));
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.getValue(DimensionId.X), ipb.getValue(DimensionId.X));
            }
            return result;
        }

        public DimensionId getDifference(FilePosition ipb, boolean compareSeries) {
            if (compareSeries && this.compareSeries(ipb) != 0) {
                return DimensionId.NULL;
            }
            if (SequenceFileSticher.compare(this.getValue(DimensionId.T), ipb.getValue(DimensionId.T)) != 0) {
                return DimensionId.T;
            }
            if (SequenceFileSticher.compare(this.getValue(DimensionId.Z), ipb.getValue(DimensionId.Z)) != 0) {
                return DimensionId.Z;
            }
            if (SequenceFileSticher.compare(this.getValue(DimensionId.C), ipb.getValue(DimensionId.C)) != 0) {
                return DimensionId.C;
            }
            if (SequenceFileSticher.compare(this.getValue(DimensionId.Y), ipb.getValue(DimensionId.Y)) != 0) {
                return DimensionId.Y;
            }
            if (SequenceFileSticher.compare(this.getValue(DimensionId.X), ipb.getValue(DimensionId.X)) != 0) {
                return DimensionId.X;
            }
            return null;
        }

        @Override
        public int compareTo(FilePosition ipb) {
            return this.compare(ipb, false);
        }

        public String toString() {
            return "FilePosition [S:" + this.getValue(DimensionId.NULL) + " C:" + this.getValue(DimensionId.C) + " T:" + this.getValue(DimensionId.T) + " Z:" + this.getValue(DimensionId.Z) + " Y:" + this.getValue(DimensionId.Y) + " X:" + this.getValue(DimensionId.X) + "]";
        }

        private static class PositionChunk {
            static final String[] prefixesX = new String[]{"x", "xpos", "posx", "xposition", "positionx"};
            static final String[] prefixesY = new String[]{"y", "ypos", "posy", "yposition", "positiony"};
            static final String[] prefixesZ = new String[]{"fp", "sec", "z", "zs", "plane", "focal", "focalplane"};
            static final String[] prefixesT = new String[]{"t", "tl", "tp", "time", "frame"};
            static final String[] prefixesC = new String[]{"c", "ch", "channel", "b", "band", "w", "wl", "wave", "wavelength"};
            static final String[] prefixesS = new String[]{"s", "series", "sp", "f", "field"};
            public DimensionId dim = null;
            public int value;

            PositionChunk(String prefix, int value) {
                if (!StringUtil.isEmpty(prefix)) {
                    String prefixLC = prefix.toLowerCase();
                    if (this.dim == null) {
                        this.dim = PositionChunk.getDim(prefixLC, prefixesX, DimensionId.X);
                    }
                    if (this.dim == null) {
                        this.dim = PositionChunk.getDim(prefixLC, prefixesY, DimensionId.Y);
                    }
                    if (this.dim == null) {
                        this.dim = PositionChunk.getDim(prefixLC, prefixesZ, DimensionId.Z);
                    }
                    if (this.dim == null) {
                        this.dim = PositionChunk.getDim(prefixLC, prefixesT, DimensionId.T);
                    }
                    if (this.dim == null) {
                        this.dim = PositionChunk.getDim(prefixLC, prefixesC, DimensionId.C);
                    }
                    if (this.dim == null) {
                        this.dim = PositionChunk.getDim(prefixLC, prefixesS, DimensionId.NULL);
                    }
                }
                this.value = value;
            }

            private static DimensionId getDim(String prefix, String[] prefixes, DimensionId d) {
                for (String p : prefixes) {
                    if (!prefix.endsWith(p)) continue;
                    return d;
                }
                return null;
            }
        }
    }

    public static class SequencePosition
    implements Comparable<SequencePosition> {
        final SequenceIndexPosition indPos;
        FilePosition filePosition;

        public SequencePosition(FilePosition filePosition) {
            this.filePosition = filePosition;
            this.indPos = new SequenceIndexPosition();
        }

        public String getBase() {
            return this.filePosition.base;
        }

        public String getPath() {
            return this.filePosition.path;
        }

        public int getIndexS() {
            int result = this.filePosition.getValue(DimensionId.NULL);
            if (result == -1) {
                result = 0;
            }
            return result;
        }

        public int getIndexX() {
            if (this.indPos.x != -1) {
                return this.indPos.x;
            }
            return 0;
        }

        public int getIndexY() {
            if (this.indPos.y != -1) {
                return this.indPos.x;
            }
            return 0;
        }

        public int getIndexC() {
            if (this.indPos.c != -1) {
                return this.indPos.c;
            }
            return 0;
        }

        public int getIndexZ() {
            if (this.indPos.z != -1) {
                return this.indPos.z;
            }
            return 0;
        }

        public int getIndexT() {
            if (this.indPos.t != -1) {
                return this.indPos.t;
            }
            return 0;
        }

        public int compareSeries(SequencePosition sp) {
            return this.filePosition.compareSeries(sp.filePosition);
        }

        public DimensionId getDifference(SequencePosition sp) {
            if (this.compareSeries(sp) != 0) {
                return DimensionId.NULL;
            }
            DimensionId result = this.filePosition.getDifference(sp.filePosition, false);
            if (result == null) {
                result = this.indPos.getDifference(this.indPos);
            }
            return result;
        }

        @Override
        public int compareTo(SequencePosition sp) {
            int result = this.compareSeries(sp);
            if (result == 0) {
                result = this.filePosition.compare(sp.filePosition, false);
            }
            if (result == 0) {
                result = this.indPos.compare(sp.indPos);
            }
            return result;
        }

        public String toString() {
            return "Path=" + this.getPath() + " Position=[S:" + this.getIndexS() + " T:" + this.getIndexT() + " Z:" + this.getIndexZ() + " C:" + this.getIndexC() + " Y:" + this.getIndexY() + " X:" + this.getIndexX() + "]";
        }
    }

    public static class SequenceFileGroup {
        public final SequenceIdent ident;
        public final List<SequencePosition> positions;
        public int totalSizeX;
        public int totalSizeY;
        public int totalSizeZ;
        public int totalSizeT;
        public int totalSizeC;
        public String basePath;

        public SequenceFileGroup(SequenceIdent ident) {
            this.ident = ident;
            this.positions = new ArrayList<SequencePosition>();
            this.totalSizeX = 0;
            this.totalSizeY = 0;
            this.totalSizeZ = 0;
            this.totalSizeT = 0;
            this.totalSizeC = 0;
            this.basePath = "";
        }

        void checkZTDimIdPos() {
            boolean tMulti;
            boolean zMulti = this.ident.baseType.sizeZ > 1;
            boolean bl = tMulti = this.ident.baseType.sizeT > 1;
            if (tMulti ^ zMulti) {
                boolean tSet = false;
                boolean tCanChange = true;
                boolean zSet = false;
                boolean zCanChange = true;
                for (SequencePosition pos : this.positions) {
                    FilePosition idPos = pos.filePosition;
                    if (idPos == null) continue;
                    if (idPos.getValue(DimensionId.T) != -1) {
                        tSet = true;
                    }
                    if (idPos.getValue(DimensionId.Z) != -1) {
                        zSet = true;
                    }
                    if (!idPos.isUnknowDim(DimensionId.T)) {
                        tCanChange = false;
                    }
                    if (idPos.isUnknowDim(DimensionId.Z)) continue;
                    zCanChange = false;
                }
                if (tCanChange && zCanChange) {
                    boolean swapZT = false;
                    if (tMulti) {
                        if (tSet && tCanChange && !zSet) {
                            swapZT = true;
                        }
                    } else if (zSet && zCanChange && !tSet) {
                        swapZT = true;
                    }
                    if (swapZT) {
                        for (SequencePosition pos : this.positions) {
                            FilePosition idPos = pos.filePosition;
                            if (idPos == null) continue;
                            FilePosition.PositionChunk zChunk = idPos.getChunk(DimensionId.Z, true);
                            FilePosition.PositionChunk tChunk = idPos.getChunk(DimensionId.T, true);
                            if (zChunk != null) {
                                zChunk.dim = DimensionId.T;
                            }
                            if (tChunk == null) continue;
                            tChunk.dim = DimensionId.Z;
                        }
                    }
                }
            }
        }

        void buildIndexesAndSizesFromPositions(boolean findPosition) {
            int size = this.positions.size();
            if (size <= 0) {
                return;
            }
            SequenceType baseType = this.ident.baseType;
            int sc = baseType.sizeC;
            int st = baseType.sizeT;
            int sz = baseType.sizeZ;
            int sy = baseType.sizeY;
            int sx = baseType.sizeX;
            int t = 0;
            int z = 0;
            int c = 0;
            int y = 0;
            int x = 0;
            int mt = 0;
            int mz = 0;
            int mc = 0;
            int my = 0;
            int mx = 0;
            SequencePosition previous = this.positions.get(0);
            SequenceIndexPosition indPos = previous.indPos;
            indPos.t = t;
            indPos.z = z;
            indPos.c = c;
            indPos.y = y;
            indPos.x = x;
            for (int i = 1; i < size; ++i) {
                SequencePosition current = this.positions.get(i);
                DimensionId diff = null;
                if (findPosition) {
                    diff = previous.getDifference(current);
                }
                if (diff == null) {
                    diff = DimensionId.T;
                }
                switch (diff) {
                    default: {
                        mt = Math.max(mt, t += st);
                        z = 0;
                        c = 0;
                        y = 0;
                        x = 0;
                        break;
                    }
                    case Z: {
                        mz = Math.max(mz, z += sz);
                        c = 0;
                        y = 0;
                        x = 0;
                        break;
                    }
                    case C: {
                        mc = Math.max(mc, c += sc);
                        y = 0;
                        x = 0;
                        break;
                    }
                    case Y: {
                        my = Math.max(my, ++y);
                        x = 0;
                        break;
                    }
                    case X: {
                        mx = Math.max(mx, ++x);
                    }
                }
                indPos = current.indPos;
                indPos.t = t;
                indPos.z = z;
                indPos.c = c;
                indPos.y = y;
                indPos.x = x;
                previous = current;
            }
            if (++mt * ++mz * ++mc * ++my * ++mx != size) {
                System.err.println("Warning: SequenceFileSticher - number of image doesn't match: " + size + " (expected = " + mt * mz * mc * my * mx + ")");
            }
            this.totalSizeC = mc * sc;
            this.totalSizeT = mt * st;
            this.totalSizeZ = mz * sz;
            this.totalSizeY = my * sy;
            this.totalSizeX = mx * sx;
            this.basePath = this.buildBasePath();
        }

        public List<String> getPaths() {
            ArrayList<String> results = new ArrayList<String>();
            for (SequencePosition pos : this.positions) {
                results.add(pos.getPath());
            }
            return results;
        }

        private static List<String> getNumberChunks(String path) {
            int st;
            ArrayList<String> result = new ArrayList<String>();
            String name = FileUtil.getFileName(path);
            int pos = 0;
            while (pos < name.length() && (st = StringUtil.getNextDigitCharIndex(name, pos)) != -1) {
                int end = StringUtil.getNextNonDigitCharIndex(name, st);
                if (end < 0) {
                    end = name.length() + 1;
                }
                result.add(name.substring(st, end));
                pos = end;
            }
            return result;
        }

        private static String getBase(String path, Set<Integer> acceptedNumberChunks) {
            int st;
            String folder = FileUtil.getDirectory(path, true);
            String result = FileUtil.getFileName(path);
            int pos = 0;
            int ind = 0;
            while (pos < result.length() && (st = StringUtil.getNextDigitCharIndex(result, pos)) != -1) {
                int end = StringUtil.getNextNonDigitCharIndex(result, st);
                if (end < 0) {
                    end = result.length();
                }
                if (!acceptedNumberChunks.contains(ind++)) {
                    if (st > 1 && Character.isLetter(result.charAt(st - 1)) && " -_".contains(result.substring(st - 2, st - 1))) {
                        st -= 2;
                    } else if (st > 1) {
                        if (!Character.isLetter(result.charAt(st - 2)) && Character.isLetter(result.charAt(st - 1))) {
                            --st;
                        } else if (" -_".contains(result.substring(st - 1, st - 0))) {
                            --st;
                        }
                    }
                    result = result.substring(0, st) + result.substring(end);
                    pos = st;
                    continue;
                }
                pos = end;
            }
            return folder + result;
        }

        public String getBasePath() {
            if (StringUtil.isEmpty(this.basePath)) {
                this.basePath = this.buildBasePath();
            }
            return this.basePath;
        }

        private String buildBasePath() {
            if (this.positions.isEmpty()) {
                return "";
            }
            HashMap<Integer, String> chunks = new HashMap<Integer, String>();
            SequencePosition firstPos = this.positions.get(0);
            for (String chunk : SequenceFileGroup.getNumberChunks(firstPos.getPath())) {
                chunks.put(chunks.size(), chunk);
            }
            for (SequencePosition pos : this.positions) {
                int ind = 0;
                for (String chunk : SequenceFileGroup.getNumberChunks(pos.getPath())) {
                    Integer key;
                    String old;
                    if ((old = (String)chunks.get(key = Integer.valueOf(ind++))) == null || StringUtil.equals(old, chunk)) continue;
                    chunks.remove(key);
                }
            }
            return SequenceFileGroup.getBase(firstPos.getPath(), chunks.keySet());
        }
    }

    public static class SequenceIdent {
        public final String base;
        public final int series;
        public final SequenceType baseType;
        public final SequenceFileImporter importer;
        private final int hc;

        public SequenceIdent(String base, int series, SequenceType type, SequenceFileImporter importer) {
            this.base = base;
            this.series = series;
            this.baseType = type;
            this.importer = importer;
            this.hc = base.hashCode() ^ this.baseType.hashCode() ^ series;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SequenceIdent) {
                SequenceIdent ident = (SequenceIdent)obj;
                return this.base.equals(ident.base) && this.series == ident.series && this.baseType.equals(ident.baseType);
            }
            return super.equals(obj);
        }
    }

    public static class SequenceType {
        public boolean minimumMeta = true;
        public int sizeX = 0;
        public int sizeY = 0;
        public int sizeZ = 0;
        public int sizeT = 0;
        public int sizeC = 0;
        public DataType dataType = null;
        public double pixelSizeX = 0.0;
        public double pixelSizeY = 0.0;
        public double pixelSizeZ = 0.0;
        public double timeInterval = 0.0;
        int hc = 0;

        void computeHashCode() {
            this.hc = this.sizeX << 0 ^ this.sizeY << 4 ^ this.sizeZ << 8 ^ this.sizeT << 12 ^ this.sizeC << 16 ^ (this.dataType != null ? this.dataType.ordinal() >> 12 : 0);
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SequenceType) {
                boolean result;
                SequenceType st = (SequenceType)obj;
                boolean bl = result = st.sizeX == this.sizeX && st.sizeY == this.sizeY && st.sizeZ == this.sizeZ && st.sizeT == this.sizeT && st.sizeC == this.sizeC && st.dataType == this.dataType;
                if (!st.minimumMeta && !this.minimumMeta) {
                    result = result && st.pixelSizeX == this.pixelSizeX && st.pixelSizeY == this.pixelSizeY && st.pixelSizeZ == this.pixelSizeZ && st.timeInterval == this.timeInterval;
                }
                return result;
            }
            return super.equals(obj);
        }
    }

    public static class SequenceIndexPosition
    implements Comparable<SequenceIndexPosition> {
        public int x = -1;
        public int y = -1;
        public int z = -1;
        public int t = -1;
        public int c = -1;

        public DimensionId getDifference(SequenceIndexPosition sip) {
            if (SequenceFileSticher.compare(this.t, sip.t) != 0) {
                return DimensionId.T;
            }
            if (SequenceFileSticher.compare(this.z, sip.z) != 0) {
                return DimensionId.Z;
            }
            if (SequenceFileSticher.compare(this.c, sip.c) != 0) {
                return DimensionId.C;
            }
            if (SequenceFileSticher.compare(this.y, sip.y) != 0) {
                return DimensionId.Y;
            }
            if (SequenceFileSticher.compare(this.x, sip.x) != 0) {
                return DimensionId.X;
            }
            return null;
        }

        public int hashCode() {
            return this.x ^ this.y << 6 ^ this.z << 12 ^ this.t << 18 ^ this.c << 24;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SequenceIndexPosition) {
                SequenceIndexPosition sip = (SequenceIndexPosition)obj;
                return sip.x == this.x && sip.y == this.y && sip.z == this.z && sip.t == this.t && sip.c == this.c;
            }
            return super.equals(obj);
        }

        public int compare(SequenceIndexPosition sip) {
            int result = 0;
            if (result == 0) {
                result = SequenceFileSticher.compare(this.t, sip.t);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.z, sip.z);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.c, sip.c);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.y, sip.y);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.x, sip.x);
            }
            return result;
        }

        @Override
        public int compareTo(SequenceIndexPosition sip) {
            return this.compare(sip);
        }
    }

    public static class SequenceAbsolutePosition
    implements Comparable<SequenceAbsolutePosition> {
        public double posX = -1.0;
        public double posY = -1.0;
        public double posZ = -1.0;
        public double posT = -1.0;
        public double indX = -1.0;
        public double indY = -1.0;
        public double indZ = -1.0;
        public double indT = -1.0;
        protected int hc;

        public void setIndexX(SequenceType type) {
            if (this.posX != -1.0) {
                double pixPos = type.pixelSizeX > 0.0 ? 2.0 * this.posX / type.pixelSizeX : this.posX;
                this.indX = Math.round(pixPos / (double)type.sizeX);
            }
        }

        public void setIndexY(SequenceType type) {
            if (this.posY != -1.0) {
                double pixPos = type.pixelSizeY > 0.0 ? 2.0 * this.posY / type.pixelSizeY : this.posY;
                this.indY = Math.round(pixPos / (double)type.sizeY);
            }
        }

        public void setIndexZ(SequenceType type) {
            if (this.posZ != -1.0) {
                double pixPos = type.pixelSizeZ > 0.0 ? 2.0 * this.posZ / type.pixelSizeZ : this.posZ;
                this.indZ = Math.round(pixPos / (double)type.sizeZ);
            }
        }

        public void setIndexT(SequenceType type) {
            if (this.posT != -1.0) {
                double timePos = type.timeInterval > 0.0 ? 2.0 * this.posT / type.timeInterval : this.posT;
                this.indT = Math.round(timePos / (double)type.sizeT);
            }
        }

        public void clearIndX() {
            this.indX = -1.0;
        }

        public void clearIndY() {
            this.indY = -1.0;
        }

        public void clearIndZ() {
            this.indZ = -1.0;
        }

        public void clearIndT() {
            this.indT = -1.0;
        }

        public DimensionId getDifference(SequenceAbsolutePosition sap) {
            if (SequenceFileSticher.compare(this.indT, sap.indT) != 0) {
                return DimensionId.T;
            }
            if (SequenceFileSticher.compare(this.indZ, sap.indZ) != 0) {
                return DimensionId.Z;
            }
            if (SequenceFileSticher.compare(this.indY, sap.indY) != 0) {
                return DimensionId.Y;
            }
            if (SequenceFileSticher.compare(this.indX, sap.indX) != 0) {
                return DimensionId.X;
            }
            return null;
        }

        public void computeHashCode() {
            this.hc = Float.floatToIntBits((float)this.indX) ^ Float.floatToIntBits((float)this.indY) << 8 ^ Float.floatToIntBits((float)this.indZ) << 16 ^ Float.floatToIntBits((float)this.indT) << 24 ^ Float.floatToIntBits((float)this.posX) ^ Float.floatToIntBits((float)this.posY) >> 8 ^ Float.floatToIntBits((float)this.posZ) >> 16 ^ Float.floatToIntBits((float)this.posT) >> 24;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SequenceAbsolutePosition) {
                SequenceAbsolutePosition sap = (SequenceAbsolutePosition)obj;
                return sap.indX == this.indX && sap.indY == this.indY && sap.indZ == this.indZ && sap.indT == this.indT;
            }
            return super.equals(obj);
        }

        @Override
        public int compareTo(SequenceAbsolutePosition sap) {
            int result = SequenceFileSticher.compare(this.indT, sap.indT);
            if (result == 0) {
                result = SequenceFileSticher.compare(this.indZ, sap.indZ);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.indY, sap.indY);
            }
            if (result == 0) {
                result = SequenceFileSticher.compare(this.indX, sap.indX);
            }
            return result;
        }
    }
}

