/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormap;

import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.file.FileUtil;
import icy.file.xml.XMLPersistent;
import icy.file.xml.XMLPersistentHelper;
import icy.image.colormap.FireColorMap;
import icy.image.colormap.GlowColorMap;
import icy.image.colormap.HSVColorMap;
import icy.image.colormap.IceColorMap;
import icy.image.colormap.IcyColorMapComponent;
import icy.image.colormap.IcyColorMapEvent;
import icy.image.colormap.IcyColorMapListener;
import icy.image.colormap.JETColorMap;
import icy.image.colormap.LinearColorMap;
import icy.util.ColorUtil;
import icy.util.XMLUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Node;

public class IcyColorMap
implements ChangeListener,
XMLPersistent {
    private static final String ID_TYPE = "type";
    private static final String ID_NAME = "name";
    private static final String ID_ENABLED = "enabled";
    private static final String ID_RED = "red";
    private static final String ID_GREEN = "green";
    private static final String ID_BLUE = "blue";
    private static final String ID_GRAY = "gray";
    private static final String ID_ALPHA = "alpha";
    public static final int COLORMAP_BITS = 8;
    public static final int MAX_LEVEL = 255;
    public static final int SIZE = 256;
    public static final int MAX_INDEX = 255;
    public static final String DEFAULT_COLORMAP_DIR = "colormap";
    private static List<IcyColorMap> customMaps = null;
    private String name;
    private boolean enabled;
    public final IcyColorMapComponent red;
    public final IcyColorMapComponent green;
    public final IcyColorMapComponent blue;
    public final IcyColorMapComponent gray;
    public final IcyColorMapComponent alpha;
    private IcyColorMapType type;
    private final int[][] premulRGB;
    private final float[][] premulRGBNorm;
    private final EventListenerList listeners;
    private final UpdateEventHandler updater;

    public static List<IcyColorMap> getLinearColorMaps(boolean wantGrayInverse, boolean wantAlpha) {
        ArrayList<IcyColorMap> result = new ArrayList<IcyColorMap>();
        result.add(LinearColorMap.gray_);
        if (wantGrayInverse) {
            result.add(LinearColorMap.gray_inv_);
        }
        result.add(LinearColorMap.red_);
        result.add(LinearColorMap.green_);
        result.add(LinearColorMap.blue_);
        result.add(LinearColorMap.magenta_);
        result.add(LinearColorMap.yellow_);
        result.add(LinearColorMap.cyan_);
        if (wantAlpha) {
            result.add(LinearColorMap.alpha_);
        }
        return result;
    }

    public static List<IcyColorMap> getSpecialColorMaps() {
        ArrayList<IcyColorMap> result = new ArrayList<IcyColorMap>();
        result.add(new IceColorMap());
        result.add(new FireColorMap());
        result.add(new HSVColorMap());
        result.add(new JETColorMap());
        result.add(new GlowColorMap(true));
        return result;
    }

    public static synchronized List<IcyColorMap> getCustomColorMaps() {
        if (customMaps == null) {
            customMaps = new ArrayList<IcyColorMap>();
            File[] fileArray = FileUtil.getFiles(new File(DEFAULT_COLORMAP_DIR), null, false, false, false);
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                IcyColorMap map = new IcyColorMap();
                File f = fileArray[i];
                if (!XMLPersistentHelper.loadFromXML((XMLPersistent)map, f)) continue;
                customMaps.add(map);
            }
        }
        return new ArrayList<IcyColorMap>(customMaps);
    }

    public static synchronized List<IcyColorMap> getAllColorMaps(boolean wantGrayInverse, boolean wantAlpha) {
        ArrayList<IcyColorMap> result = new ArrayList<IcyColorMap>();
        result.addAll(IcyColorMap.getLinearColorMaps(wantGrayInverse, wantAlpha));
        result.addAll(IcyColorMap.getSpecialColorMaps());
        result.addAll(IcyColorMap.getCustomColorMaps());
        return result;
    }

    public IcyColorMap(String name, IcyColorMapType type) {
        this.name = name;
        this.enabled = true;
        this.listeners = new EventListenerList();
        this.updater = new UpdateEventHandler(this, false);
        this.red = this.createColorMapBand((short)0);
        this.green = this.createColorMapBand((short)0);
        this.blue = this.createColorMapBand((short)0);
        this.gray = this.createColorMapBand((short)0);
        this.alpha = this.createColorMapBand((short)255);
        this.type = type;
        this.premulRGB = new int[256][3];
        this.premulRGBNorm = new float[256][3];
    }

    public IcyColorMap(String name) {
        this(name, IcyColorMapType.RGB);
    }

    public IcyColorMap(String name, Object maps) {
        this(name, IcyColorMapType.RGB);
        if (maps instanceof byte[][]) {
            this.copyFrom((byte[][])maps);
        } else if (maps instanceof short[][]) {
            this.copyFrom((short[][])maps);
        }
        this.setTypeFromData(false);
    }

    public IcyColorMap(IcyColorMap colormap) {
        this(colormap.name, colormap.type);
        this.copyFrom(colormap);
    }

    public IcyColorMap() {
        this("");
    }

    protected IcyColorMapComponent createColorMapBand(short initValue) {
        return new IcyColorMapComponent(this, initValue);
    }

    public boolean isRGB() {
        return this.type == IcyColorMapType.RGB;
    }

    public boolean isGray() {
        return this.type == IcyColorMapType.GRAY;
    }

    public boolean isAlpha() {
        return this.type == IcyColorMapType.ALPHA;
    }

    public IcyColorMapType getType() {
        return this.type;
    }

    public void setType(IcyColorMapType value) {
        if (this.type != value) {
            this.type = value;
            this.changed(IcyColorMapEvent.IcyColorMapEventType.TYPE_CHANGED);
        }
    }

    public void setTypeFromData(boolean notifyChange) {
        IcyColorMapType cmType;
        boolean grayColor = true;
        boolean noColor = true;
        boolean hasAlpha = false;
        for (int i = 0; i < 255; ++i) {
            short r = this.red.map[i];
            short g = this.green.map[i];
            short b = this.blue.map[i];
            short a = this.alpha.map[i];
            grayColor &= r == g && r == b;
            noColor &= r == 0 && g == 0 && b == 0;
            hasAlpha |= a != 255;
        }
        if (noColor && hasAlpha) {
            cmType = IcyColorMapType.ALPHA;
        } else if (grayColor && !noColor) {
            this.gray.copyFrom(this.red.map, 0);
            cmType = IcyColorMapType.GRAY;
        } else {
            cmType = IcyColorMapType.RGB;
        }
        if (notifyChange) {
            this.setType(cmType);
        } else {
            this.type = cmType;
        }
    }

    public void setTypeFromData() {
        this.setTypeFromData(true);
    }

    public void setRedControlPoint(int index, int value) {
        this.red.setControlPoint(index, value);
    }

    public void setGreenControlPoint(int index, int value) {
        this.green.setControlPoint(index, value);
    }

    public void setBlueControlPoint(int index, int value) {
        this.blue.setControlPoint(index, value);
    }

    public void setGrayControlPoint(int index, int value) {
        this.gray.setControlPoint(index, value);
    }

    public void setAlphaControlPoint(int index, int value) {
        this.alpha.setControlPoint(index, value);
    }

    public void setRGBControlPoint(int index, Color value) {
        this.red.setControlPoint(index, (short)value.getRed());
        this.green.setControlPoint(index, (short)value.getGreen());
        this.blue.setControlPoint(index, (short)value.getBlue());
        this.gray.setControlPoint(index, (short)ColorUtil.getGrayMix(value));
    }

    public void setARGBControlPoint(int index, Color value) {
        this.alpha.setControlPoint(index, (short)value.getAlpha());
        this.red.setControlPoint(index, (short)value.getRed());
        this.green.setControlPoint(index, (short)value.getGreen());
        this.blue.setControlPoint(index, (short)value.getBlue());
        this.gray.setControlPoint(index, (short)ColorUtil.getGrayMix(value));
    }

    public short[] getBlueMap() {
        if (this.type == IcyColorMapType.RGB) {
            return this.blue.map;
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.map;
        }
        return null;
    }

    public short[] getGreenMap() {
        if (this.type == IcyColorMapType.RGB) {
            return this.green.map;
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.map;
        }
        return null;
    }

    public short[] getRedMap() {
        if (this.type == IcyColorMapType.RGB) {
            return this.red.map;
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.map;
        }
        return null;
    }

    public short[] getAlphaMap() {
        return this.alpha.map;
    }

    public float[] getNormalizedBlueMap() {
        if (this.type == IcyColorMapType.RGB) {
            return this.blue.mapf;
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.mapf;
        }
        return null;
    }

    public float[] getNormalizedGreenMap() {
        if (this.type == IcyColorMapType.RGB) {
            return this.green.mapf;
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.mapf;
        }
        return null;
    }

    public float[] getNormalizedRedMap() {
        if (this.type == IcyColorMapType.RGB) {
            return this.red.mapf;
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.mapf;
        }
        return null;
    }

    public float[] getNormalizedAlphaMap() {
        return this.alpha.mapf;
    }

    public short getBlue(int index) {
        if (this.type == IcyColorMapType.RGB) {
            return this.blue.map[index];
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.map[index];
        }
        return 0;
    }

    public short getGreen(int index) {
        if (this.type == IcyColorMapType.RGB) {
            return this.green.map[index];
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.map[index];
        }
        return 0;
    }

    public short getRed(int index) {
        if (this.type == IcyColorMapType.RGB) {
            return this.red.map[index];
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.map[index];
        }
        return 0;
    }

    public short getAlpha(int index) {
        return this.alpha.map[index];
    }

    public float getNormalizedBlue(int index) {
        if (this.type == IcyColorMapType.RGB) {
            return this.blue.mapf[index];
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.mapf[index];
        }
        return 0.0f;
    }

    public float getNormalizedGreen(int index) {
        if (this.type == IcyColorMapType.RGB) {
            return this.green.mapf[index];
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.mapf[index];
        }
        return 0.0f;
    }

    public float getNormalizedRed(int index) {
        if (this.type == IcyColorMapType.RGB) {
            return this.red.mapf[index];
        }
        if (this.type == IcyColorMapType.GRAY) {
            return this.gray.mapf[index];
        }
        return 0.0f;
    }

    public float getNormalizedAlpha(int index) {
        return this.alpha.mapf[index];
    }

    public short getBlue(float index) {
        return this.getBlue((int)(index * 255.0f));
    }

    public short getGreen(float index) {
        return this.getGreen((int)(index * 255.0f));
    }

    public short getRed(float index) {
        return this.getRed((int)(index * 255.0f));
    }

    public short getAlpha(float index) {
        return this.getAlpha((int)(index * 255.0f));
    }

    public float getNormalizedBlue(float index) {
        return this.getNormalizedBlue((int)(index * 255.0f));
    }

    public float getNormalizedGreen(float index) {
        return this.getNormalizedGreen((int)(index * 255.0f));
    }

    public float getNormalizedRed(float index) {
        return this.getNormalizedRed((int)(index * 255.0f));
    }

    public float getNormalizedAlpha(float index) {
        return this.getNormalizedAlpha((int)(index * 255.0f));
    }

    public void setRed(int index, short value) {
        this.red.setValue(index, value);
    }

    public void setGreen(int index, short value) {
        this.green.setValue(index, value);
    }

    public void setBlue(int index, short value) {
        this.blue.setValue(index, value);
    }

    public void setGray(int index, short value) {
        this.gray.setValue(index, value);
    }

    public void setAlpha(int index, short value) {
        this.alpha.setValue(index, value);
    }

    public void setNormalizedRed(int index, float value) {
        this.red.setNormalizedValue(index, value);
    }

    public void setNormalizedGreen(int index, float value) {
        this.green.setNormalizedValue(index, value);
    }

    public void setNormalizedBlue(int index, float value) {
        this.blue.setNormalizedValue(index, value);
    }

    public void setNormalizedGray(int index, float value) {
        this.gray.setNormalizedValue(index, value);
    }

    public void setNormalizedAlpha(int index, float value) {
        this.alpha.setNormalizedValue(index, value);
    }

    public void setRGB(int index, int rgb) {
        this.alpha.setValue(index, 255);
        this.red.setValue(index, rgb >> 16 & 0xFF);
        this.green.setValue(index, rgb >> 8 & 0xFF);
        this.blue.setValue(index, rgb >> 0 & 0xFF);
        this.gray.setValue(index, ColorUtil.getGrayMix(rgb));
    }

    public void setRGB(int index, Color value) {
        this.setRGB(index, value.getRGB());
    }

    public void setARGB(int index, int argb) {
        this.alpha.setValue(index, argb >> 24 & 0xFF);
        this.red.setValue(index, argb >> 16 & 0xFF);
        this.green.setValue(index, argb >> 8 & 0xFF);
        this.blue.setValue(index, argb >> 0 & 0xFF);
        this.gray.setValue(index, ColorUtil.getGrayMix(argb));
    }

    public void setARGB(int index, Color value) {
        this.setARGB(index, value.getRGB());
    }

    public void setAlphaToOpaque() {
        this.alpha.beginUpdate();
        try {
            this.alpha.removeAllControlPoint();
            this.alpha.setControlPoint(0, 1.0f);
            this.alpha.setControlPoint(255, 1.0f);
        }
        finally {
            this.alpha.endUpdate();
        }
    }

    public void setAlphaToLinear() {
        this.alpha.beginUpdate();
        try {
            this.alpha.removeAllControlPoint();
            this.alpha.setControlPoint(0, 0.0f);
            this.alpha.setControlPoint(255, 1.0f);
        }
        finally {
            this.alpha.endUpdate();
        }
    }

    public void setAlphaToLinear3D() {
        this.alpha.beginUpdate();
        try {
            this.alpha.removeAllControlPoint();
            this.alpha.setControlPoint(0, 0.0f);
            this.alpha.setControlPoint(16, 0.0f);
            this.alpha.setControlPoint(32, 0.1f);
            this.alpha.setControlPoint(255, 0.75f);
        }
        finally {
            this.alpha.endUpdate();
        }
    }

    @Deprecated
    public void setDefaultAlphaFor3D() {
        this.setAlphaToLinear3D();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.changed(IcyColorMapEvent.IcyColorMapEventType.ENABLED_CHANGED);
        }
    }

    public Color getColor(int index) {
        switch (this.type) {
            case RGB: {
                return new Color(this.red.map[index], this.green.map[index], this.blue.map[index], this.alpha.map[index]);
            }
            case GRAY: {
                return new Color(this.gray.map[index], this.gray.map[index], this.gray.map[index], this.alpha.map[index]);
            }
            case ALPHA: {
                return new Color(0, 0, 0, this.alpha.map[index]);
            }
        }
        return Color.black;
    }

    public int[][] getPremulRGB() {
        return this.premulRGB;
    }

    public float[][] getPremulRGBNorm() {
        return this.premulRGBNorm;
    }

    public void copyFrom(IcyColorMap srcColorMap, boolean copyAlpha) {
        this.beginUpdate();
        try {
            this.red.copyFrom(srcColorMap.red);
            this.green.copyFrom(srcColorMap.green);
            this.blue.copyFrom(srcColorMap.blue);
            this.gray.copyFrom(srcColorMap.gray);
            if (copyAlpha || this.isAlpha()) {
                this.alpha.copyFrom(srcColorMap.alpha);
            }
            this.setType(srcColorMap.type);
            this.setName(srcColorMap.getName());
        }
        finally {
            this.endUpdate();
        }
    }

    public void copyFrom(IcyColorMap srcColorMap) {
        this.copyFrom(srcColorMap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(byte[][] maps, boolean copyAlpha) {
        int len = maps.length;
        this.beginUpdate();
        try {
            if (len > 0) {
                this.red.copyFrom(maps[0]);
            }
            if (len > 1) {
                this.green.copyFrom(maps[1]);
            }
            if (len > 2) {
                this.blue.copyFrom(maps[2]);
            }
            if (copyAlpha && len > 3) {
                this.alpha.copyFrom(maps[3]);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void copyFrom(byte[][] maps) {
        this.copyFrom(maps, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(short[][] maps, boolean copyAlpha) {
        int len = maps.length;
        this.beginUpdate();
        try {
            if (len > 0) {
                this.red.copyFrom(maps[0], 8);
            }
            if (len > 1) {
                this.green.copyFrom(maps[1], 8);
            }
            if (len > 2) {
                this.blue.copyFrom(maps[2], 8);
            }
            if (copyAlpha && len > 3) {
                this.alpha.copyFrom(maps[3], 8);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void copyFrom(short[][] maps) {
        this.copyFrom(maps, true);
    }

    public boolean isLinear() {
        switch (this.type) {
            default: {
                return this.red.isLinear() && this.green.isLinear() && this.blue.isLinear();
            }
            case GRAY: {
                return this.gray.isLinear();
            }
            case ALPHA: 
        }
        return this.alpha.isLinear();
    }

    public boolean isBlack() {
        switch (this.type) {
            case RGB: {
                for (int i = 0; i < 255; ++i) {
                    if ((this.red.map[i] | this.green.map[i] | this.blue.map[i]) == 0) continue;
                    return false;
                }
                return true;
            }
            case GRAY: {
                for (int i = 0; i < 255; ++i) {
                    if (this.gray.map[i] == 0) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Color getDominantColor() {
        Color[] colors = new Color[256];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = this.getColor(i);
        }
        return ColorUtil.getDominantColor(colors);
    }

    private void updateRGBCache() {
        for (int i = 0; i < 256; ++i) {
            float af = this.alpha.mapf[i];
            float[] rgbn = this.premulRGBNorm[i];
            switch (this.type) {
                case GRAY: {
                    float grayValue;
                    rgbn[0] = grayValue = this.gray.mapf[i] * af;
                    rgbn[1] = grayValue;
                    rgbn[2] = grayValue;
                    break;
                }
                case RGB: {
                    rgbn[0] = this.blue.mapf[i] * af;
                    rgbn[1] = this.green.mapf[i] * af;
                    rgbn[2] = this.red.mapf[i] * af;
                    break;
                }
                default: {
                    rgbn[0] = 0.0f;
                    rgbn[1] = 0.0f;
                    rgbn[2] = 0.0f;
                }
            }
            int[] rgb = this.premulRGB[i];
            rgb[0] = (int)(rgbn[0] * 255.0f);
            rgb[1] = (int)(rgbn[1] * 255.0f);
            rgb[2] = (int)(rgbn[2] * 255.0f);
        }
    }

    public void addListener(IcyColorMapListener listener) {
        this.listeners.add(IcyColorMapListener.class, listener);
    }

    public void removeListener(IcyColorMapListener listener) {
        this.listeners.remove(IcyColorMapListener.class, listener);
    }

    public void fireEvent(IcyColorMapEvent e) {
        for (IcyColorMapListener listener : (IcyColorMapListener[])this.listeners.getListeners(IcyColorMapListener.class)) {
            listener.colorMapChanged(e);
        }
    }

    public void changed() {
        this.changed(IcyColorMapEvent.IcyColorMapEventType.MAP_CHANGED);
    }

    private void changed(IcyColorMapEvent.IcyColorMapEventType type) {
        this.updater.changed(new IcyColorMapEvent(this, type));
    }

    @Override
    public void onChanged(CollapsibleEvent e) {
        IcyColorMapEvent event = (IcyColorMapEvent)e;
        switch (event.getType()) {
            case MAP_CHANGED: 
            case TYPE_CHANGED: {
                this.updateRGBCache();
                break;
            }
        }
        this.fireEvent(event);
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
        this.red.beginUpdate();
        this.green.beginUpdate();
        this.blue.beginUpdate();
        this.gray.beginUpdate();
        this.alpha.beginUpdate();
    }

    public void endUpdate() {
        this.alpha.endUpdate();
        this.gray.endUpdate();
        this.blue.endUpdate();
        this.green.endUpdate();
        this.red.endUpdate();
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IcyColorMap) {
            IcyColorMap colormap = (IcyColorMap)obj;
            if (colormap.getType() != this.type) {
                return false;
            }
            if (!this.red.equals(colormap.red)) {
                return false;
            }
            if (!this.green.equals(colormap.green)) {
                return false;
            }
            if (!this.blue.equals(colormap.blue)) {
                return false;
            }
            if (!this.gray.equals(colormap.gray)) {
                return false;
            }
            return this.alpha.equals(colormap.alpha);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.red.map.hashCode() ^ this.green.map.hashCode() ^ this.blue.map.hashCode() ^ this.gray.map.hashCode() ^ this.alpha.map.hashCode() ^ this.type.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.setName(XMLUtil.getElementValue(node, ID_NAME, ""));
            this.setEnabled(XMLUtil.getElementBooleanValue(node, ID_ENABLED, true));
            this.setType(IcyColorMapType.valueOf(XMLUtil.getElementValue(node, ID_TYPE, IcyColorMapType.RGB.toString())));
            boolean result = true;
            result = result && this.red.loadFromXML(XMLUtil.getElement(node, ID_RED));
            result = result && this.green.loadFromXML(XMLUtil.getElement(node, ID_GREEN));
            result = result && this.blue.loadFromXML(XMLUtil.getElement(node, ID_BLUE));
            result = result && this.gray.loadFromXML(XMLUtil.getElement(node, ID_GRAY));
            boolean bl = result = result && this.alpha.loadFromXML(XMLUtil.getElement(node, ID_ALPHA));
            return bl;
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementValue(node, ID_NAME, this.getName());
        XMLUtil.setElementBooleanValue(node, ID_ENABLED, this.isEnabled());
        XMLUtil.setElementValue(node, ID_TYPE, this.getType().toString());
        boolean result = true;
        result = result && this.red.saveToXML(XMLUtil.setElement(node, ID_RED));
        result = result && this.green.saveToXML(XMLUtil.setElement(node, ID_GREEN));
        result = result && this.blue.saveToXML(XMLUtil.setElement(node, ID_BLUE));
        result = result && this.gray.saveToXML(XMLUtil.setElement(node, ID_GRAY));
        result = result && this.alpha.saveToXML(XMLUtil.setElement(node, ID_ALPHA));
        return result;
    }

    public static enum IcyColorMapType {
        RGB,
        GRAY,
        ALPHA;

    }
}

