/*
 * Decompiled with CFR 0.152.
 */
package icy.system;

import icy.gui.dialog.LoaderDialog;
import icy.gui.frame.AboutFrame;
import icy.gui.preferences.PreferenceFrame;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AppleUtil {
    static final Thread fixThread = new Thread(new Runnable(){

        @Override
        public void run() {
            AppleUtil.appleFixLiveRun();
        }
    }, "AppleFix");

    public static void init() {
        if (!Icy.getMainInterface().isHeadLess()) {
            try {
                ClassLoader classLoader = SystemUtil.getSystemClassLoader();
                Class<?> appClass = classLoader.loadClass("com.apple.eawt.Application");
                Object app = appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Class<?> listenerClass = classLoader.loadClass("com.apple.eawt.ApplicationListener");
                Object listener = Proxy.newProxyInstance(classLoader, new Class[]{listenerClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        Object applicationEvent = args[0];
                        Class<?> appEventClass = applicationEvent.getClass();
                        Method m = appEventClass.getMethod("setHandled", Boolean.TYPE);
                        if (method.getName().equals("handleQuit")) {
                            m.invoke(applicationEvent, Icy.exit(false));
                        }
                        if (method.getName().equals("handleAbout")) {
                            new AboutFrame();
                            m.invoke(applicationEvent, true);
                        }
                        if (method.getName().equals("handleOpenFile")) {
                            new LoaderDialog();
                            m.invoke(applicationEvent, true);
                        }
                        if (method.getName().equals("handlePreferences")) {
                            new PreferenceFrame("General");
                            m.invoke(applicationEvent, true);
                        }
                        return null;
                    }
                });
                Method m = appClass.getMethod("addApplicationListener", listenerClass);
                m.invoke(app, listener);
                m = appClass.getMethod("setDockIconImage", Image.class);
                m.invoke(app, ResourceUtil.IMAGE_ICY_256);
                m = appClass.getMethod("addPreferencesMenuItem", new Class[0]);
                m.invoke(app, new Object[0]);
                SystemUtil.setProperty("com.apple.mrj.application.apple.menu.about.name", "Icy");
            }
            catch (Exception e) {
                System.err.println("Can't install OSX application wrapper...");
            }
        }
        fixThread.start();
    }

    static void appleFixLiveRun() {
        while (true) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            PropertyChangeListener[] leak = toolkit.getPropertyChangeListeners("apple.awt.contentScaleFactor");
            for (int i = 0; i < leak.length; ++i) {
                toolkit.removePropertyChangeListener("apple.awt.contentScaleFactor", leak[i]);
            }
            ThreadUtil.sleep(500);
        }
    }
}

