/*
 * Decompiled with CFR 0.152.
 */
package icy.system;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class FileDrop {
    transient Border normalBorder;
    transient DropTargetListener dropListener;
    private static Color defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    private static String ZERO_CHAR_STRING = "\u0000";

    public FileDrop(Component c, FileDropListener listener) {
        this(c, (Border)BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, listener);
    }

    public FileDrop(Component c, boolean recursive, FileDropListener listener) {
        this(c, (Border)BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(Component c, Border dragBorder, FileDropListener listener) {
        this(c, dragBorder, false, listener);
    }

    public FileDrop(Component c, Border dragBorder, boolean recursive, FileDropListener listener) {
        this(c, dragBorder, recursive, listener, null);
    }

    public FileDrop(Component c, Border dragBorder, boolean recursive, FileDropExtListener listener) {
        this(c, dragBorder, recursive, null, listener);
    }

    FileDrop(final Component c, final Border dragBorder, boolean recursive, final FileDropListener listener, final FileDropExtListener listenerExt) {
        this.dropListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent evt) {
                if (FileDrop.this.isDragOk(evt)) {
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        FileDrop.this.normalBorder = jc.getBorder();
                        jc.setBorder(dragBorder);
                    }
                    evt.acceptDrag(1);
                } else {
                    evt.rejectDrag();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent evt) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void drop(DropTargetDropEvent evt) {
                try {
                    Transferable tr = evt.getTransferable();
                    if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        evt.acceptDrop(1);
                        List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                        File[] filesTemp = new File[fileList.size()];
                        fileList.toArray(filesTemp);
                        File[] files = filesTemp;
                        if (listener != null) {
                            listener.filesDropped(files);
                        }
                        if (listenerExt != null) {
                            listenerExt.filesDropped(evt, files);
                        }
                        evt.getDropTargetContext().dropComplete(true);
                    } else {
                        DataFlavor[] flavors = tr.getTransferDataFlavors();
                        boolean handled = false;
                        for (int zz = 0; zz < flavors.length; ++zz) {
                            if (!flavors[zz].isRepresentationClassReader()) continue;
                            evt.acceptDrop(1);
                            Reader reader = flavors[zz].getReaderForText(tr);
                            BufferedReader br = new BufferedReader(reader);
                            if (listener != null) {
                                listener.filesDropped(FileDrop.createFileArray(br));
                            }
                            if (listenerExt != null) {
                                listenerExt.filesDropped(evt, FileDrop.createFileArray(br));
                            }
                            evt.getDropTargetContext().dropComplete(true);
                            handled = true;
                            break;
                        }
                        if (!handled) {
                            evt.rejectDrop();
                        }
                    }
                }
                catch (IOException io) {
                    System.err.println("FileDrop: IOException - abort:");
                    io.printStackTrace();
                    evt.rejectDrop();
                }
                catch (UnsupportedFlavorException ufe) {
                    System.err.println("FileDrop: UnsupportedFlavorException - abort:");
                    ufe.printStackTrace();
                    evt.rejectDrop();
                }
                finally {
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(FileDrop.this.normalBorder);
                    }
                }
            }

            @Override
            public void dragExit(DropTargetEvent evt) {
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setBorder(FileDrop.this.normalBorder);
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent evt) {
                if (FileDrop.this.isDragOk(evt)) {
                    evt.acceptDrag(1);
                } else {
                    evt.rejectDrag();
                }
            }
        };
        this.makeDropTarget(c, recursive);
    }

    static File[] createFileArray(BufferedReader bReader) {
        try {
            ArrayList<File> list = new ArrayList<File>();
            String line = null;
            while ((line = bReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    File file = new File(new URI(line));
                    list.add(file);
                }
                catch (Exception ex) {
                    System.err.println("Error with " + line + ": " + ex.getMessage());
                }
            }
            return list.toArray(new File[list.size()]);
        }
        catch (IOException ex) {
            System.err.println("FileDrop: IOException");
            return new File[0];
        }
    }

    private void makeDropTarget(final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
            System.err.println("FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        c.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                } else {
                    new DropTarget(c, FileDrop.this.dropListener);
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.makeDropTarget(comps[i], recursive);
            }
        }
    }

    boolean isDragOk(DropTargetDragEvent evt) {
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (int i = 0; !ok && i < flavors.length; ++i) {
            DataFlavor curFlavor = flavors[i];
            if (!curFlavor.equals(DataFlavor.javaFileListFlavor) && !curFlavor.isRepresentationClassReader()) continue;
            ok = true;
        }
        return ok;
    }

    public static boolean remove(Component c) {
        return FileDrop.remove(null, c, true);
    }

    public static boolean remove(PrintStream out, Component c, boolean recursive) {
        c.setDropTarget(null);
        if (recursive && c instanceof Container) {
            Component[] comps = ((Container)c).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                FileDrop.remove(out, comps[i], recursive);
            }
            return true;
        }
        return false;
    }

    public static interface FileDropListener {
        public void filesDropped(File[] var1);
    }

    public static interface FileDropExtListener {
        public void filesDropped(DropTargetDropEvent var1, File[] var2);
    }

    public static class TransferableObject
    implements Transferable {
        public static final String MIME_TYPE = "application/x-net.iharder.TransferableObject";
        public static final DataFlavor DATA_FLAVOR = new DataFlavor(TransferableObject.class, "application/x-net.iharder.TransferableObject");
        private Fetcher fetcher;
        private Object data;
        private DataFlavor customFlavor;

        public TransferableObject(Object data) {
            this.data = data;
            this.customFlavor = new DataFlavor(data.getClass(), MIME_TYPE);
        }

        public TransferableObject(Fetcher fetcher) {
            this.fetcher = fetcher;
        }

        public TransferableObject(Class dataClass, Fetcher fetcher) {
            this.fetcher = fetcher;
            this.customFlavor = new DataFlavor(dataClass, MIME_TYPE);
        }

        public DataFlavor getCustomDataFlavor() {
            return this.customFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.customFlavor != null) {
                return new DataFlavor[]{this.customFlavor, DATA_FLAVOR, DataFlavor.stringFlavor};
            }
            return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DATA_FLAVOR)) {
                return this.fetcher == null ? this.data : this.fetcher.getObject();
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.fetcher == null ? this.data.toString() : this.fetcher.getObject().toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor.equals(DATA_FLAVOR)) {
                return true;
            }
            return flavor.equals(DataFlavor.stringFlavor);
        }

        public static interface Fetcher {
            public Object getObject();
        }
    }
}

