/*
 * Decompiled with CFR 0.152.
 */
package icy.system.profile;

import com.sun.management.OperatingSystemMXBean;
import icy.system.SystemUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

public class CPUMonitor {
    public static final int MONITOR_CURRENT_THREAD = 0;
    public static final int MONITOR_ALL_THREAD_ROUGHLY = 1;
    public static final int MONITOR_ALL_THREAD_FINELY = 2;
    private static final double NANO_TO_MILLI = 1.0E-6;
    private static final double MILLI_TO_SEC = 0.001;
    private static final double NANO_TO_SEC = 1.0E-9;
    private CPUTime time;
    private Map<Long, CPUTime> threadTimes;
    private ThreadMXBean bean;
    private java.lang.management.OperatingSystemMXBean osBean;
    private int monitorType;

    public CPUMonitor() {
        this(0);
    }

    public CPUMonitor(int type) {
        this.monitorType = type;
        this.time = new CPUTime();
        this.bean = ManagementFactory.getThreadMXBean();
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
    }

    public void start() throws IllegalAccessError {
        if (!this.bean.isCurrentThreadCpuTimeSupported()) {
            throw new IllegalAccessError("This JVM does not support time benchmarking");
        }
        switch (this.monitorType) {
            case 0: {
                this.time.setStartUserTime(this.bean.getCurrentThreadUserTime());
                this.time.setStartCPUTime(this.bean.getCurrentThreadCpuTime());
                break;
            }
            case 1: {
                if (!(this.osBean instanceof OperatingSystemMXBean)) {
                    throw new IllegalAccessError("This JVM does not support this version of multiple threads time benchmarking");
                }
                this.time.setStartUserTime(((OperatingSystemMXBean)this.osBean).getProcessCpuTime());
                this.time.setStartCPUTime(this.time.getStartUserTime());
                break;
            }
            case 2: {
                long[] tids;
                this.threadTimes = new HashMap<Long, CPUTime>();
                this.time.setStartUserTime(0L);
                this.time.setStartCPUTime(0L);
                for (long id : tids = this.bean.getAllThreadIds()) {
                    CPUTime cput = new CPUTime();
                    cput.setStartCPUTime(this.bean.getThreadCpuTime(id));
                    cput.setStartUserTime(this.bean.getThreadUserTime(id));
                    this.threadTimes.put(id, cput);
                }
                break;
            }
        }
        this.time.setStartTime(System.currentTimeMillis());
    }

    public void stop() {
        switch (this.monitorType) {
            case 0: {
                this.time.setStopUserTime(this.bean.getCurrentThreadUserTime());
                this.time.setStopCPUTime(this.bean.getCurrentThreadCpuTime());
                break;
            }
            case 1: {
                this.time.setStopUserTime(((OperatingSystemMXBean)this.osBean).getProcessCpuTime());
                this.time.setStopCPUTime(this.time.getStopUserTime());
                break;
            }
            case 2: {
                long[] tids = this.bean.getAllThreadIds();
                long c = 0L;
                long u = 0L;
                for (long id : tids) {
                    CPUTime cput = this.threadTimes.get(id);
                    if (cput == null) {
                        cput = new CPUTime();
                    }
                    cput.setStopCPUTime(this.bean.getThreadCpuTime(id));
                    cput.setStopUserTime(this.bean.getThreadUserTime(id));
                    c += cput.getCPUElapsedTimeNano();
                    u += cput.getUserElapsedTimeNano();
                }
                this.time.setStopCPUTime(c);
                this.time.setStopUserTime(u);
            }
        }
        this.time.setStopTime(System.currentTimeMillis());
    }

    private long nanoToMilli(long nano) {
        return Math.round((double)nano * 1.0E-6);
    }

    private double nanoToSec(long nano) {
        return (double)nano * 1.0E-9;
    }

    private double milliToSec(long milli) {
        return (double)milli * 0.001;
    }

    public long getCPUElapsedTimeMilli() {
        return this.nanoToMilli(this.time.getCPUElapsedTimeNano());
    }

    public long getUserElapsedTimeMilli() {
        return this.nanoToMilli(this.time.getUserElapsedTimeNano());
    }

    public double getCPUElapsedTimeSec() {
        return this.nanoToSec(this.time.getCPUElapsedTimeNano());
    }

    public double getUserElapsedTimeSec() {
        return this.nanoToSec(this.time.getUserElapsedTimeNano());
    }

    public double getElapsedTimeSec() {
        return this.milliToSec(this.time.getElapsedTimeMilli());
    }

    public int getThreadCount() {
        return this.bean.getThreadCount();
    }

    @Deprecated
    public static int getAvailableProcessors() {
        return SystemUtil.getNumberOfCPUs();
    }

    public long getElapsedTimeMilli() {
        return this.time.getElapsedTimeMilli();
    }

    private class CPUTime {
        private long startTime = 0L;
        private long stopTime = 0L;
        private long startUserTime = 0L;
        private long startCPUTime = 0L;
        private long stopUserTime = 0L;
        private long stopCPUTime = 0L;

        public void setStartTime(long startTime) {
            this.startTime = startTime;
            this.setStopTime(startTime);
        }

        public void setStopTime(long stopTime) {
            this.stopTime = stopTime;
        }

        public long getStartUserTime() {
            return this.startUserTime;
        }

        public void setStartUserTime(long startUserTime) {
            this.startUserTime = startUserTime;
            this.setStopUserTime(startUserTime);
        }

        public void setStartCPUTime(long startCPUTime) {
            this.startCPUTime = startCPUTime;
            this.setStopCPUTime(startCPUTime);
        }

        public long getStopUserTime() {
            return this.stopUserTime;
        }

        public void setStopUserTime(long stopUserTime) {
            this.stopUserTime = stopUserTime;
        }

        public void setStopCPUTime(long stopCPUTime) {
            this.stopCPUTime = stopCPUTime;
        }

        public long getCPUElapsedTimeNano() {
            return this.stopCPUTime - this.startCPUTime;
        }

        public long getUserElapsedTimeNano() {
            return this.stopUserTime - this.startUserTime;
        }

        public long getElapsedTimeMilli() {
            return this.stopTime - this.startTime;
        }
    }
}

