package plugins.ylemontag.sequencecomparator.comparators;


/**
 * 
 * @author Yoann Le Montagner
 *
 */
public abstract class GlobalSquaredErrorBased extends PixelSeparableGlobalComparator
{
	/**
	 * Constructor
	 */
	public GlobalSquaredErrorBased(String distanceName)
	{
		super(distanceName);
	}
	
	@Override
	protected double aggregateInsideXY(double accu, double refPixel, double seqPixel)
	{
		double currentDiff = seqPixel - refPixel;
		return accu + currentDiff*currentDiff;
	}

	@Override
	protected double aggregateOutsideXY(double accu, double errorOverPlane)
	{
		return accu + errorOverPlane;
	}
}
