package plugins.fab.trackmanager.processors;

import icy.canvas.IcyCanvas;
import icy.gui.dialog.MessageDialog;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.gui.viewer.ViewerEvent.ViewerEventType;
import icy.main.Icy;
import icy.painter.Painter;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;


import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

// FIXME : changer la gestion du painter pour tous les getDisplaySequence avec painter. 

/**
 * Track Processor Flow
 * 
 * WARNING: BETA Version
 */
public class TrackProcessorFlow extends PluginTrackManagerProcessor implements ActionListener , Painter , SequenceListener, ViewerListener {
	
	//public TrackProcessorFlow(TrackPool trackPool) {
	public TrackProcessorFlow( ) {
		//super(trackPool , "Track Flow Processor" );
		setName("Track Flow Processor");
		
//		setPanelHeight( 260 );
//		panel.setLayout( new GridLayout( 1 , 2  ) );
		
		JPanel panelLeft = new JPanel();
		panelLeft.setBorder( new TitledBorder( "Options" ) );
		panelLeft.setLayout( new BoxLayout( panelLeft , BoxLayout.PAGE_AXIS ) );
		
		affectSequenceButton.setSelected( true );
		affectSequenceButton.addActionListener( this );
		
		// FIXME:  trackPool.getDisplaySequence().addPainter( this );
		panelLeft.add(resolutionTextArea);
		resolutionTextArea.setBorder( new TitledBorder( "Square side for 1 arrow in pixels" ) );
		panelLeft.add(rayonRechercheTextArea);
		rayonRechercheTextArea.setBorder( new TitledBorder( "Gaussian Parameter - Search Radius" ) );
		panelLeft.add( affectSequenceButton );
		panelLeft.add(removeZeroSpeedCheckBox);
		panelLeft.add(refreshComputeButton);
		refreshComputeButton.addActionListener( this );
		affectSequenceButton.addActionListener( this );		
		removeZeroSpeedCheckBox.setSelected( true );		
		removeZeroSpeedCheckBox.addActionListener( this );
		doNotReComputeCheckBox.setSelected( false );
		panelLeft.add( doNotReComputeCheckBox );
		panelLeft.add( displayGraphInSequenceCheckBox );
		panelLeft.add( useRoiAsBoundsForChartButton );
		
		//panelLeft.add( new JLabel("Scale:") );
		scaleTextField.setBorder( new TitledBorder( "Graphic Scale on sequence" ) );
		
		panelLeft.add(scaleTextField );		
		
		panel.add( panelLeft );
		panel.add( chartpanel );		
		
		displayGraphInSequenceCheckBox.addActionListener( this );		
		useRoiAsBoundsForChartButton.addActionListener( this );

		// FIXME: trackPool.getDisplaySequence().addListener( this );
	}

	JFreeChart chart;
	JPanel chartpanel = new JPanel();		
	JCheckBox affectSequenceButton = new JCheckBox("Display on sequence.");
	ArrayList<FlowArrow> flowArrowList = new ArrayList<FlowArrow>();
	JTextField resolutionTextArea = new JTextField("10");
	JTextField rayonRechercheTextArea = new JTextField("100");
	JButton refreshComputeButton = new JButton("Refresh.");
	JTextField scaleTextField = new JTextField( "1.0" );
	JCheckBox removeZeroSpeedCheckBox = new JCheckBox("Remove Zero-Speed Arrows.");
	JCheckBox doNotReComputeCheckBox = new JCheckBox("Do not automaticaly re-compute.");
	/** If set to false, force recompute at Compute() call
	 * Introduced to avoid computing at each compute() call
	 * */
	Boolean computed = false;
	JCheckBox displayGraphInSequenceCheckBox = new JCheckBox("Display graph on sequence.", false );
	JButton useRoiAsBoundsForChartButton = new JButton("place graph in ROI #1");

	int tmpT;
	
	@Override
	public void Compute() {
		
		synchronized (flowArrowList) {

			try
			{
				tmpT = trackPool.getTrackManager().getCurrentPositionT();
			}
			catch ( NullPointerException e )
			{
				tmpT = 0;
			}
			
			try
			{
				trackPool.getDisplaySequence().addPainter( this );
			}
			catch ( NullPointerException e) {
				// sequence or trackpool is null
			}

			if ( !isEnabled() ) return;

			if ( doNotReComputeCheckBox.isSelected() )
				if ( computed ) return;

			/** number of pixel for the square containing the arrow */
			double resolution;		
			try
			{
				resolution = new Double( resolutionTextArea.getText() );
				if ( resolution < 4 ) resolution = 4;
			}
			catch( Exception e)
			{
				resolution = 10;
			}

			if ( affectSequenceButton.isSelected() )
			{
				/** list which will contain the instant speed data */
				ArrayList<InstantSpeed> instantSpeed = new ArrayList<InstantSpeed>(); 

				// generates all instant speed;
				for ( TrackSegment ts : trackPool.getTrackSegmentList() )
				{

					for ( int i = 0;  i < ts.getDetectionList().size() - 1 ; i++  )
					{				
						Detection d1 = ts.getDetectionList().get( i );
						Detection d2 = ts.getDetectionList().get( i + 1 );

						if ( d1.isEnabled() && d2.isEnabled() )
						{
							instantSpeed.add( new InstantSpeed(
									( d1.getX()+d2.getX() ) /2d ,
									( d1.getY()+d2.getY() ) /2d ,
									getDistance( d1 , d2 ),
									d2.getX() - d1.getX(),
									d2.getY() - d1.getY()							
									) );
						}
					}							
				}			

				// generates Arrows
				flowArrowList.clear();

				double rayonRecherche;		
				try
				{
					rayonRecherche = new Double( rayonRechercheTextArea.getText() );
					if( rayonRecherche < 4 ) rayonRecherche=4;
				}
				catch( Exception e)
				{
					rayonRecherche = 100;
				}			
				Sequence sequence = trackPool.getDisplaySequence();

				int sequenceWidth = 100;
				int sequenceHeight = 100;

				if ( sequence !=null )
				{
					sequenceWidth = trackPool.getDisplaySequence().getWidth();
					sequenceHeight = trackPool.getDisplaySequence().getHeight();
				}

				{
					for ( double x = resolution / 2d ; x < sequenceWidth ; x+=resolution )
						for ( double y = resolution / 2d ; y < sequenceHeight ; y+=resolution )
						{
							FlowArrow flowarrow = new FlowArrow( x , y );

							double nbIs = 0;
							double sommGaussianAttenuation = 0;
							for ( InstantSpeed is : instantSpeed )
							{
								double dis = getDistance( x , y , 0 , is.x , is.y , 0 );
								{						
									double gaussianAttenuation = Math.exp( -( dis * dis ) / (2d* rayonRecherche * rayonRecherche ) )/Math.sqrt(2d*Math.PI*rayonRecherche * rayonRecherche);
									if (gaussianAttenuation > 0.00001)
									{
										flowarrow.vx += is.vx * gaussianAttenuation;
										flowarrow.vy += is.vy * gaussianAttenuation;
										nbIs++;
										sommGaussianAttenuation += gaussianAttenuation;
									}
								}					
							}
							if ( nbIs > 0 )
							{
								//					flowarrow.vx /=sommGaussianAttenuation/= nbIs;
								//					flowarrow.vy /=sommGaussianAttenuation/= nbIs;
								flowarrow.vx /= nbIs;
								flowarrow.vy /= nbIs;

							}
							flowArrowList.add( flowarrow );
						}
				}

				for ( FlowArrow flowarrow : flowArrowList )
				{
					flowarrow.norme = getDistance( 0 ,0 ,0 , flowarrow.vx , flowarrow.vy , 0 );
					flowarrow.angle = Math.atan2( flowarrow.vy , flowarrow.vx );
				}

				// normalize
				{
					double max = 0;
					for ( FlowArrow flowarrow : flowArrowList )
					{					
						if ( flowarrow.norme > max ) max = flowarrow.norme ;
					}				

					if ( max > 0 )
						for ( FlowArrow flowarrow : flowArrowList )
						{					
							double rapport =  resolution / max ;
							flowarrow.norme *= rapport ;
							flowarrow.vx *= rapport;
							flowarrow.vy *= rapport;

							float norme1 = (float)flowarrow.norme / (float)resolution ;
							//					flowarrow.color = new Color( norme1 , 0f , 1f - norme1 ) ;
							flowarrow.color = new Color( norme1 , 1f , 0f ) ;
						}
				}

			}



			// Generates graph.


			XYSeriesCollection xyDataset = new XYSeriesCollection();		
			XYSeries series = new XYSeries( "All Instant orientation" );

			for ( FlowArrow flowarrow : flowArrowList )
			{
				series.add( Math.toDegrees( flowarrow.angle ) + 90 , flowarrow.norme );
			}

			xyDataset.addSeries( series );	

			chart = ChartFactory.createPolarChart(
					"Polar Inst. Speed",
					xyDataset, 
					false , true , false);

			chartpanel.removeAll();
			chartpanel.add( new ChartPanel( chart , 180 , 180 , 180 , 180 , 180 , 180 , false , false, true , true , true, true) );
			panel.updateUI();

			computed = true;
		}
	}

	class FlowArrow implements Comparable<FlowArrow>
	{
		public FlowArrow( double x , double y )
		{
			this.x = x;
			this.y = y;
		}
		double norme;
		double vx = 0;
		double vy = 0;
		double x,y,angle,thickness;
		Color color;
		
		public int compareTo(FlowArrow o) {
			
			if ( o.angle < this.angle ) return -1;
			return 1;
		}
		
		
	}
	
	//TODO: comment x? y?
	class InstantSpeed
	{
		public InstantSpeed( double x , double y , double InstantSpeed , double vx , double vy )
		{
			this.x = x;
			this.y = y;
			this.instantSpeed= instantSpeed;
			this.vx = vx;
			this.vy = vy;
		}
		double x;
		double y;
		double instantSpeed;
		double vx;
		double vy;
		
	}
	

	JLabel outLabel = new JLabel();		

	public double getDistance( double x1 , double y1 , double z1 , double x2 , double y2 , double z2 )
	{
		double distance = Math.sqrt( (x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)+(z1-z2)*(z1-z2) );		
		return distance;
	}

	public double getDistance( Detection d1, Detection d2 )
	{		
		return getDistance( d1.getX() , d1.getY() , d1.getZ() , d2.getX() , d2.getY() , d2.getZ() );
	}

	public void actionPerformed(ActionEvent e) {
		
		if ( e.getSource() == useRoiAsBoundsForChartButton )
		{			 
			try
			{
				Shape shape = (Shape) trackPool.getDisplaySequence().getROIs().get( 0 );
				chartRectangleInSequence = (Rectangle2D) shape.getBounds2D().clone();
				displayGraphInSequenceCheckBox.setEnabled( true );
			}
			catch( Exception e1 )
			{
				MessageDialog.showDialog( "No Sequence or No ROI to perform the operation." , MessageDialog.ERROR_MESSAGE );				
			}
		}
		
		computed = false;
		trackPool.fireTrackEditorProcessorChange();
	}


	// ==============================
	// 		  PAINTER SUB PART
	// ==============================

//	public void keyPressed(Point p, KeyEvent e) {
//		
//	}
//
//	public void mouseClick(Point p, MouseEvent e) {
//
//	}
//
//	public void mouseDrag(Point p, MouseEvent e) {
//
//	}
//
//	public void mouseMove(Point p, MouseEvent e) {
//	}

//	public void paint(Graphics g) {
//		
//	}

	Rectangle2D chartRectangleInSequence = new Rectangle2D.Float( 250 , 20 + 260 * 0 ,490,240 );
	
//	public void paint(Graphics3D g) {
//		
//	}

	@Override
	public void Close() {
		try
		{
		trackPool.getDisplaySequence().removePainter( this );
		}
		catch( NullPointerException e )
		{
			// no sequence.
		}		
	}


//	public void ROIChanged(SequenceChangeEvent e) {
//	}
//
//	public void dimensionChanged(SequenceChangeEvent e) {
//	}
//
//	public void nameChanged(SequenceChangeEvent e) {		
//	}

//	public void selectionChanged(SequenceChangeEvent e) {
//		trackPool.fireTrackEditorProcessorChange();		
//	}

	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		synchronized ( flowArrowList ) {

			double resolution;		
			try
			{
				resolution = new Double( resolutionTextArea.getText() );
			}
			catch( Exception e)
			{
				resolution = 1;
			}
			float maxWidth= 4;
			float minWidth= 1;


			if ( !isEnabled() ) return;
			if ( !affectSequenceButton.isSelected() ) return;

			Graphics2D g2 = ( Graphics2D ) g;
			g2.setColor( Color.yellow );

			g2.setStroke( new BasicStroke( 2 ) );
			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

			for ( FlowArrow flowarrow : flowArrowList )
			{
				boolean display = true;
				if ( removeZeroSpeedCheckBox.isSelected() )
				{
					if ( flowarrow.norme < 0.1 )
					{
						display = false;
					}
				}

				if ( display )
				{		
					g2.setStroke(new BasicStroke((float)(minWidth+(maxWidth-minWidth)*flowarrow.norme/resolution)));

					g2.setColor( flowarrow.color );
					AffineTransform at = g2.getTransform();
					g2.translate( (int)flowarrow.x , (int)flowarrow.y );
					g2.rotate( flowarrow.angle );
					g2.translate( (int)-flowarrow.x , (int)-flowarrow.y );

					Line2D l1 = new Line2D.Double(
							flowarrow.x - flowarrow.norme / 2,
							flowarrow.y , 
							flowarrow.x - flowarrow.norme / 2 + flowarrow.norme ,
							flowarrow.y
							);

					Line2D l2 = new Line2D.Double(
							flowarrow.x - flowarrow.norme / 2 + 3*flowarrow.norme / 4,
							flowarrow.y + flowarrow.norme / 4,
							flowarrow.x - flowarrow.norme / 2 + flowarrow.norme,
							flowarrow.y
							);

					Line2D l3 = new Line2D.Double(
							flowarrow.x - flowarrow.norme / 2 + 3*flowarrow.norme / 4 ,
							flowarrow.y - flowarrow.norme / 4 ,
							flowarrow.x - flowarrow.norme / 2 + flowarrow.norme ,
							flowarrow.y 
							);

					g2.draw( l1 );
					g2.draw( l2 );
					g2.draw( l3 );
					g2.setTransform( at );
				}
			}
			g2.setStroke( new BasicStroke( 1 ) );

			// graphic

			double scale = Double.parseDouble( scaleTextField.getText() );
			if ( scale < 0.1 )
			{
				scale =0.1;
			}
			double minX = chartRectangleInSequence.getCenterX();
			double minY = chartRectangleInSequence.getCenterY();

			Rectangle2D transformedChartRectangleInSequence = (Rectangle2D) chartRectangleInSequence.clone();		
			transformedChartRectangleInSequence.setRect(
					( -chartRectangleInSequence.getWidth()/2 )  * ( 1d/scale ) ,
					( -chartRectangleInSequence.getHeight()/2 )  * ( 1d/scale ) , 
					chartRectangleInSequence.getWidth() * ( 1d/scale ) ,  
					chartRectangleInSequence.getHeight() * ( 1d/scale ) );

			//Graphics2D g2 = (Graphics2D) g;

			AffineTransform transform = g2.getTransform();

			g2.scale( scale , scale );		
			g2.translate( minX * (1d/scale) , minY * (1d/scale) );		


			if ( displayGraphInSequenceCheckBox.isSelected() )
				chart.draw( (Graphics2D)g , transformedChartRectangleInSequence );

			g2.setTransform( transform );

			//		if ( displayGraphInSequenceCheckBox.isSelected() )
			//			chart.draw( (Graphics2D)g , chartRectangleInSequence );
		}
	}

	@Override
	public void viewerChanged(ViewerEvent event) {
		if ( event.getType() == ViewerEventType.POSITION_CHANGED )
		{
			trackPool.fireTrackEditorProcessorChange();
		}
	}

	@Override
	public void sequenceChanged(SequenceEvent sequenceEvent) {
		
		for ( Viewer viewer : Icy.getMainInterface().getViewers() )
		{
			viewer.removeListener( this );			
		}
		if( trackPool.getDisplaySequence() != null )
		{
			trackPool.getDisplaySequence().getViewers().get( 0 ).addListener( this );			
		}
		
	}
	@Override
	public void sequenceClosed(Sequence sequence) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void displaySequenceChanged() {

		for ( Sequence sequence: Icy.getMainInterface().getSequencesContaining( this ) )
		{
			sequence.removePainter( this );
		}
		
		Sequence displaySequence = trackPool.getDisplaySequence();
		if ( displaySequence != null )
		{
			trackPool.getDisplaySequence().addPainter( this );
		}
	
	}

	@Override
	public void viewerClosed(Viewer viewer) {
		// TODO Auto-generated method stub
		
	}

	
}
