/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.importer.xuggler;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import icy.common.exception.UnsupportedFormatException;
import icy.file.FileUtil;
import icy.image.IcyBufferedImage;
import icy.type.collection.CollectionUtil;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.HashSet;
import java.util.Set;

public class Util {
    private static final Set<String> supportedExtensions = new HashSet<String>(CollectionUtil.asList((Object[])new String[]{"avi", "mp4", "mov", "wmv", "mpg", "mpeg"}));
    private static final Set<String> unsupportedExtensions = new HashSet<String>(CollectionUtil.asList((Object[])new String[]{"xml", "txt", "pdf", "xls", "xlsx", "doc", "docx", "pdf", "rtf", "exe", "wav", "mp3", "app", "lsm", "bmp", "png"}));

    public static int getVideoStreamIndex(IContainer container) {
        for (int i = 0; i < container.getNumStreams(); ++i) {
            ICodec codec;
            IStreamCoder streamCoder = container.getStream((long)i).getStreamCoder();
            if (streamCoder == null || (codec = streamCoder.getCodec()) == null || codec.getType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            return i;
        }
        return -1;
    }

    public static double getTimeInterval(IStream stream, IStreamCoder streamCoder) {
        double result = streamCoder.getFrameRate().getValue();
        if (result > 0.0) {
            return 1.0 / result;
        }
        result = stream.getFrameRate().getValue();
        if (result > 0.0) {
            return 1.0 / result;
        }
        return 0.0;
    }

    public static IcyBufferedImage getFirstChannelImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        byte[] data = new byte[w * h];
        byte[] srcData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData(0);
        for (int i = 0; i < data.length; ++i) {
            data[i] = srcData[i * 3];
        }
        return new IcyBufferedImage(w, h, (Object)data, false, true);
    }

    public static IContainer open(String path) throws UnsupportedFormatException {
        IContainer container = IContainer.make();
        if (container.open(FileUtil.getGenericPath((String)path), IContainer.Type.READ, null, false, false) < 0) {
            container.delete();
            throw new UnsupportedFormatException(path + " file format is not supported by Xuggler.");
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canOpenFile(String filename) {
        boolean bl;
        if (!FileUtil.exists((String)filename) || FileUtil.isDirectory((String)filename)) {
            return false;
        }
        String ext = FileUtil.getFileExtension((String)filename, (boolean)false).toLowerCase();
        if (supportedExtensions.contains(ext)) {
            return true;
        }
        if (unsupportedExtensions.contains(ext)) {
            return false;
        }
        IContainer container = Util.open(filename);
        try {
            bl = container.getBitRate() > 0 && Util.getVideoStreamIndex(container) != -1;
        }
        catch (Throwable throwable) {
            try {
                container.close();
                container.delete();
                throw throwable;
            }
            catch (UnsupportedFormatException e) {
                return false;
            }
        }
        container.close();
        container.delete();
        return bl;
    }
}

