/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ARef;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.LockingTransaction;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ref
extends ARef
implements IFn,
Comparable<Ref>,
IRef {
    TVal tvals;
    final AtomicInteger faults;
    final ReentrantReadWriteLock lock;
    LockingTransaction.Info tinfo;
    final long id = ids.getAndIncrement();
    volatile int minHistory = 0;
    volatile int maxHistory = 10;
    static final AtomicLong ids = new AtomicLong();

    @Override
    public int compareTo(Ref ref2) {
        if (this.id == ref2.id) {
            return 0;
        }
        if (this.id < ref2.id) {
            return -1;
        }
        return 1;
    }

    public int getMinHistory() {
        return this.minHistory;
    }

    public Ref setMinHistory(int minHistory) {
        this.minHistory = minHistory;
        return this;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public Ref setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        return this;
    }

    public Ref(Object initVal) {
        this(initVal, null);
    }

    public Ref(Object initVal, IPersistentMap meta2) {
        super(meta2);
        this.faults = new AtomicInteger();
        this.lock = new ReentrantReadWriteLock();
        this.tvals = new TVal(initVal, 0L, System.currentTimeMillis());
    }

    Object currentVal() {
        try {
            this.lock.readLock().lock();
            if (this.tvals != null) {
                Object object = this.tvals.val;
                return object;
            }
            throw new IllegalStateException(this.toString() + " is unbound.");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object deref() {
        LockingTransaction t = LockingTransaction.getRunning();
        if (t == null) {
            return this.currentVal();
        }
        return t.doGet(this);
    }

    public Object set(Object val2) {
        return LockingTransaction.getEx().doSet(this, val2);
    }

    public Object commute(IFn fn2, ISeq args) {
        return LockingTransaction.getEx().doCommute(this, fn2, args);
    }

    public Object alter(IFn fn2, ISeq args) {
        LockingTransaction t = LockingTransaction.getEx();
        return t.doSet(this, fn2.applyTo(RT.cons(t.doGet(this), args)));
    }

    public void touch() {
        LockingTransaction.getEx().doEnsure(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBound() {
        try {
            this.lock.readLock().lock();
            boolean bl = this.tvals != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimHistory() {
        try {
            this.lock.writeLock().lock();
            if (this.tvals != null) {
                this.tvals.next = this.tvals;
                this.tvals.prior = this.tvals;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryCount() {
        try {
            this.lock.writeLock().lock();
            int n = this.histCount();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    int histCount() {
        if (this.tvals == null) {
            return 0;
        }
        int count2 = 0;
        TVal tv = this.tvals.next;
        while (tv != this.tvals) {
            ++count2;
            tv = tv.next;
        }
        return count2;
    }

    public final IFn fn() {
        return (IFn)this.deref();
    }

    public Object call() {
        return this.invoke();
    }

    @Override
    public void run() {
        try {
            this.invoke();
        }
        catch (Exception e2) {
            throw Util.runtimeException(e2);
        }
    }

    @Override
    public Object invoke() {
        return this.fn().invoke();
    }

    @Override
    public Object invoke(Object arg1) {
        return this.fn().invoke(arg1);
    }

    @Override
    public Object invoke(Object arg1, Object arg2) {
        return this.fn().invoke(arg1, arg2);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3) {
        return this.fn().invoke(arg1, arg2, arg3);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.fn().invoke(arg1, arg2, arg3, arg4);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args);
    }

    @Override
    public Object applyTo(ISeq arglist) {
        return AFn.applyToHelper(this, arglist);
    }

    public static class TVal {
        Object val;
        long point;
        long msecs;
        TVal prior;
        TVal next;

        TVal(Object val2, long point, long msecs, TVal prior) {
            this.val = val2;
            this.point = point;
            this.msecs = msecs;
            this.prior = prior;
            this.next = prior.next;
            this.prior.next = this;
            this.next.prior = this;
        }

        TVal(Object val2, long point, long msecs) {
            this.val = val2;
            this.point = point;
            this.msecs = msecs;
            this.next = this;
            this.prior = this;
        }
    }
}

