/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.gui.component.NumberTextField;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;

public class LiveSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 3710457297904488668L;
    MMMainFrame mainFrame;
    private JLabel lblZStart;
    private NumberTextField zStartField;
    private NumberTextField zEndField;
    private JLabel lblNewLabel;
    private NumberTextField zStepField;
    JCheckBox customAcqNameCheckBox;
    JTextField acqNameField;
    private JCheckBox dateSuffixCheckBox;

    public LiveSettingsPanel(MMMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.initialize();
        this.customAcqNameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveSettingsPanel.this.acqNameField.setEnabled(LiveSettingsPanel.this.customAcqNameCheckBox.isSelected());
            }
        });
    }

    private void initialize() {
        this.setBorder(new TitledBorder(null, "Snap / Live / Album settings", 4, 2, null, null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{60, 0, 60, 0, 0, 60, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.customAcqNameCheckBox = new JCheckBox("Custom name");
        this.customAcqNameCheckBox.setToolTipText("Set a custom acquisition name");
        GridBagConstraints gbc_customAcqNameCheckBox = new GridBagConstraints();
        gbc_customAcqNameCheckBox.anchor = 17;
        gbc_customAcqNameCheckBox.gridwidth = 2;
        gbc_customAcqNameCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_customAcqNameCheckBox.gridx = 0;
        gbc_customAcqNameCheckBox.gridy = 0;
        this.add((Component)this.customAcqNameCheckBox, gbc_customAcqNameCheckBox);
        this.acqNameField = new JTextField();
        this.acqNameField.setEnabled(false);
        this.acqNameField.setText("Acquisition");
        GridBagConstraints gbc_acqNameField = new GridBagConstraints();
        gbc_acqNameField.gridwidth = 3;
        gbc_acqNameField.insets = new Insets(0, 0, 5, 5);
        gbc_acqNameField.fill = 2;
        gbc_acqNameField.gridx = 2;
        gbc_acqNameField.gridy = 0;
        this.add((Component)this.acqNameField, gbc_acqNameField);
        this.acqNameField.setColumns(10);
        this.dateSuffixCheckBox = new JCheckBox("Date suffix");
        this.dateSuffixCheckBox.setToolTipText("Add date suffix to acquisition name");
        this.dateSuffixCheckBox.setSelected(true);
        GridBagConstraints gbc_dateSuffixCheckBox = new GridBagConstraints();
        gbc_dateSuffixCheckBox.anchor = 17;
        gbc_dateSuffixCheckBox.gridwidth = 2;
        gbc_dateSuffixCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_dateSuffixCheckBox.gridx = 5;
        gbc_dateSuffixCheckBox.gridy = 0;
        this.add((Component)this.dateSuffixCheckBox, gbc_dateSuffixCheckBox);
        this.lblZStart = new JLabel("Z start");
        this.lblZStart.setToolTipText("Z start position (um) for stack acquisition (used only if Z step is not 0)");
        GridBagConstraints gbc_lblZStart = new GridBagConstraints();
        gbc_lblZStart.fill = 3;
        gbc_lblZStart.anchor = 17;
        gbc_lblZStart.insets = new Insets(0, 0, 0, 5);
        gbc_lblZStart.gridx = 0;
        gbc_lblZStart.gridy = 1;
        this.add((Component)this.lblZStart, gbc_lblZStart);
        this.zStartField = new NumberTextField();
        this.zStartField.setText("0");
        GridBagConstraints gbc_zStartField = new GridBagConstraints();
        gbc_zStartField.insets = new Insets(0, 0, 0, 5);
        gbc_zStartField.fill = 1;
        gbc_zStartField.gridx = 1;
        gbc_zStartField.gridy = 1;
        this.add((Component)this.zStartField, gbc_zStartField);
        this.zStartField.setColumns(4);
        this.lblNewLabel = new JLabel("Z end");
        this.lblNewLabel.setToolTipText("Z end position (um) for stack acquisition (used only if Z step is not 0)");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.gridx = 2;
        gbc_lblNewLabel.gridy = 1;
        this.add((Component)this.lblNewLabel, gbc_lblNewLabel);
        this.zEndField = new NumberTextField();
        this.zEndField.setText("0");
        GridBagConstraints gbc_zEndField = new GridBagConstraints();
        gbc_zEndField.insets = new Insets(0, 0, 0, 5);
        gbc_zEndField.fill = 1;
        gbc_zEndField.gridx = 4;
        gbc_zEndField.gridy = 1;
        this.add((Component)this.zEndField, gbc_zEndField);
        this.zEndField.setColumns(4);
        JLabel lblZSlices = new JLabel("Z step");
        lblZSlices.setToolTipText("Z step (um) between each Z slice (keep 0 for 2D acquisition)");
        GridBagConstraints gbc_lblZSlices = new GridBagConstraints();
        gbc_lblZSlices.fill = 3;
        gbc_lblZSlices.insets = new Insets(0, 0, 0, 5);
        gbc_lblZSlices.anchor = 17;
        gbc_lblZSlices.gridx = 5;
        gbc_lblZSlices.gridy = 1;
        this.add((Component)lblZSlices, gbc_lblZSlices);
        this.zStepField = new NumberTextField();
        this.zStepField.setText("0");
        GridBagConstraints gbc_zStepField = new GridBagConstraints();
        gbc_zStepField.fill = 1;
        gbc_zStepField.gridx = 6;
        gbc_zStepField.gridy = 1;
        this.add((Component)this.zStepField, gbc_zStepField);
        this.zStepField.setColumns(4);
    }

    public boolean hasCustomAcqName() {
        return this.customAcqNameCheckBox.isSelected();
    }

    public void setCustomAcqName(boolean value) {
        this.customAcqNameCheckBox.setSelected(value);
    }

    public String getAcqName() {
        return this.acqNameField.getText();
    }

    public void setAcqName(String value) {
        this.acqNameField.setText(value);
    }

    public boolean hasDateSuffix() {
        return this.dateSuffixCheckBox.isSelected();
    }

    public void setDateSuffix(boolean value) {
        this.dateSuffixCheckBox.setSelected(value);
    }

    public boolean isZStackAcquisition() {
        return this.getZStep() != 0.0;
    }

    public double getZStart() {
        return StringUtil.parseDouble((String)this.zStartField.getText(), (double)0.0);
    }

    public void setZStart(double value) {
        this.zStartField.setText(StringUtil.toString((double)value));
    }

    public double getZEnd() {
        return StringUtil.parseDouble((String)this.zEndField.getText(), (double)0.0);
    }

    public void setZEnd(double value) {
        this.zEndField.setText(StringUtil.toString((double)value));
    }

    public double getZStep() {
        return StringUtil.parseDouble((String)this.zStepField.getText(), (double)0.0);
    }

    public void setZStep(double value) {
        this.zStepField.setText(StringUtil.toString((double)value));
    }
}

