/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.common.MenuCallback;
import icy.file.FileUtil;
import icy.gui.dialog.ActionDialog;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.preferences.PluginPreferences;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.ReflectionUtil;
import icy.util.StringUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import mmcorej.MMEventCallback;
import org.micromanager.MMOptions;
import org.micromanager.MMStudio;
import org.micromanager.MainFrame;
import org.micromanager.PropertyEditor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.conf2.ConfiguratorDlg2;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.dialogs.CalibrationListDlg;
import org.micromanager.utils.ReportingUtils;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.core.AcquisitionHandler;
import plugins.tprovoost.Microscopy.MicroManager.gui.AboutPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.AcquisitionInfoPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.ActionsPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.CameraSettingsPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.ConfigurationPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.LiveSettingsPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.LoadFrame;
import plugins.tprovoost.Microscopy.MicroManager.gui.LoadingFrame;
import plugins.tprovoost.Microscopy.MicroManager.gui.MainPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.OptionsPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.PluginsToolbar;
import plugins.tprovoost.Microscopy.MicroManager.tools.FrameUtils;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;
import plugins.tprovoost.Microscopy.MicroManager.tools.StageMover;
import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicromanagerPlugin;
import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicroscopePlugin;

public class MMMainFrame
extends IcyFrame {
    public static final String ID_STORELASTACQ = "storeLastAcquisition";
    public static final String ID_DISPLAYACQ = "displayAcquisition";
    MMStudio mmstudio = null;
    AcquisitionHandler acquisitionHandler = null;
    MMOptions options = null;
    Preferences mainPreferences = null;
    Preferences exposurePrefs = null;
    Preferences colorPrefs = null;
    Preferences contrastPrefs = null;
    public ActionsPanel actionsPanel = null;
    public ConfigurationPanel configPanel = null;
    public CameraSettingsPanel cameraPanel = null;
    public LiveSettingsPanel livePanel = null;
    public AcquisitionInfoPanel acquisitionInfoPanel = null;
    public PluginsToolbar pluginsPanel = null;
    MMEventCallback mainCallback = null;
    final ReentrantLock rlock;
    public XMLPreferences preferences = PluginPreferences.getPreferences().node(MicromanagerPlugin.class.getName());
    boolean doNotAskConfigFileSave;
    boolean hideMDADisplaySave;
    boolean closeOnExitSave;

    public MMMainFrame() throws Exception {
        super("Micro-Manager For Icy", true, true, false, true);
        this.rlock = new ReentrantLock(true);
        try {
            MMOptions opt = new MMOptions();
            opt.loadSettings();
            this.doNotAskConfigFileSave = opt.doNotAskForConfigFile_;
            opt.doNotAskForConfigFile_ = true;
            opt.saveSettings();
        }
        catch (Throwable opt) {
            // empty catch block
        }
        ThreadUtil.invokeNow((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    MMMainFrame.this.mmstudio = new MMStudio(true);
                }
                catch (Throwable t) {
                    MMMainFrame.this.shutdown();
                    throw new Exception("Could not initialize Micro Manager !", t);
                }
                try {
                    try {
                        MMMainFrame.this.options = (MMOptions)ReflectionUtil.getFieldObject((Object)MMMainFrame.this.mmstudio, (String)"options_");
                        MMMainFrame.this.hideMDADisplaySave = MMMainFrame.this.options.hideMDADisplay_;
                        MMMainFrame.this.closeOnExitSave = MMMainFrame.this.options.closeOnExit_;
                        MMMainFrame.this.options.hideMDADisplay_ = true;
                        MMMainFrame.this.options.closeOnExit_ = false;
                    }
                    catch (Exception ex) {
                        System.err.println("Warning: cannot patch options informations from Micro-Manager.");
                    }
                    try {
                        MMMainFrame.this.mainPreferences = (Preferences)ReflectionUtil.getFieldObject((Object)MMMainFrame.this.mmstudio, (String)"mainPrefs_");
                        MMMainFrame.this.colorPrefs = (Preferences)ReflectionUtil.getFieldObject((Object)MMMainFrame.this.mmstudio, (String)"colorPrefs_");
                        MMMainFrame.this.exposurePrefs = (Preferences)ReflectionUtil.getFieldObject((Object)MMMainFrame.this.mmstudio, (String)"exposurePrefs_");
                        MMMainFrame.this.contrastPrefs = (Preferences)ReflectionUtil.getFieldObject((Object)MMMainFrame.this.mmstudio, (String)"contrastPrefs_");
                    }
                    catch (Exception ex) {
                        System.err.println("Warning: cannot retrieve Preferences from Micro-Manager.");
                    }
                    MainFrame frame = MMStudio.getFrame();
                    if (frame != null) {
                        frame.dispatchEvent((AWTEvent)new WindowEvent((Window)frame, 200));
                        frame.setVisible(false);
                    }
                    MMMainFrame.this.acquisitionHandler = new AcquisitionHandler(MMMainFrame.this);
                    return null;
                }
                catch (Throwable t) {
                    MMMainFrame.this.shutdown();
                    throw new Exception("Error while initializing Micro Manager !", t);
                }
            }
        });
        CMMCore core = this.mmstudio.getCore();
        if (core == null) {
            this.shutdown();
            throw new Exception("Could not retrieve Micro Manager core !");
        }
        core.enableDebugLog(false);
        core.enableStderrLog(false);
        this.mainCallback = new CustomEventCallback();
        core.registerCallback(this.mainCallback);
    }

    public void init() {
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                MMMainFrame.this.initializeSystemMenu();
                MMMainFrame.this.initializeGUI();
                MMMainFrame.this.setDefaultCloseOperation(0);
                MMMainFrame.this.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                    public void icyFrameClosing(IcyFrameEvent e) {
                        MMMainFrame.this.preClose();
                    }
                });
                MMMainFrame.this.getInternalFrame().pack();
                MMMainFrame.this.getExternalFrame().pack();
                Dimension size = MMMainFrame.this.getSize();
                size.height = 400;
                size.width -= 40;
                MMMainFrame.this.setMinimumSizeExternal(size);
                MMMainFrame.this.setMinimumSizeInternal(size);
                size = new Dimension(size);
                size.width += 40;
                size.height += 80;
                MMMainFrame.this.setPreferredSizeExternal(size);
                MMMainFrame.this.setPreferredSizeInternal(size);
                MMMainFrame.this.getInternalFrame().pack();
                MMMainFrame.this.getExternalFrame().pack();
                MMMainFrame.this.addToDesktopPane();
                MMMainFrame.this.center();
                MMMainFrame.this.setVisible(true);
            }
        });
        ToolTipFrame tooltip = new ToolTipFrame("<html>You can access more Micro-Manager options from menu by clicking on top left icon:<br><img src=\"" + ((Object)((Object)this)).getClass().getResource("/image/menu_tip.jpg").toString() + "\" /></html>", 30, "MicroManager.HiddenMenu.Tip");
        tooltip.setSize(264, 192);
    }

    public void preClose() {
        if (this.getInternalFrame().getDefaultCloseOperation() == 0) {
            if (!Icy.isExiting() && this.pluginsPanel.getRunningPluginsCount() > 0 && !ConfirmDialog.confirm((String)"Some Micro-Manager plugins are still running.\nClosing this frame will interrupt all Micro-Manager activities. Continue ?")) {
                return;
            }
            MicroManager.shutdown();
        }
    }

    public void onClosed() {
        this.shutdown();
        super.onClosed();
    }

    void shutdown() {
        if (this.pluginsPanel != null) {
            this.pluginsPanel.shutdownPlugins();
        }
        if (this.acquisitionHandler != null) {
            this.acquisitionHandler.shutdown();
        }
        if (this.mmstudio != null) {
            this.mmstudio.closeAllAcquisitions();
            this.mmstudio.closeSequence(true);
        }
        this.mainCallback = null;
        if (this.options != null) {
            this.options.doNotAskForConfigFile_ = this.doNotAskConfigFileSave;
            this.options.hideMDADisplay_ = this.hideMDADisplaySave;
            this.options.closeOnExit_ = this.closeOnExitSave;
        }
    }

    void initializeGUI() {
        MainPanel mainPanel = new MainPanel(this);
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "Center");
        this.actionsPanel = mainPanel.actionsPanel;
        this.configPanel = mainPanel.configPanel;
        this.cameraPanel = mainPanel.cameraPanel;
        this.livePanel = mainPanel.livePanel;
        this.acquisitionInfoPanel = mainPanel.acquisitionInfoPanel;
        this.pluginsPanel = mainPanel.pluginsPanel;
        this.configPanel.refreshConfigsNow(false);
        this.cameraPanel.refreshNow();
        this.acquisitionInfoPanel.refreshNow();
    }

    void initializeSystemMenu() {
        final int SHORTCUTKEY_MASK = SystemUtil.getMenuCtrlMask();
        this.setSystemMenuCallback(new MenuCallback(){

            public JMenu getMenu() {
                JMenu toReturn = MMMainFrame.this.getDefaultSystemMenu();
                JMenuItem hconfig = new JMenuItem("Configuration Wizard");
                hconfig.setIcon((Icon)new IcyIcon("star.png"));
                hconfig.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MMMainFrame.this.pluginsPanel.getRunningPluginsCount() > 0 && !ConfirmDialog.confirm((String)"Are you sure ?", (String)"<html>Loading the Configuration Wizard will unload all the devices and pause all running acquisitions.</br> Are you sure you want to continue ?</html>")) {
                            return;
                        }
                        try {
                            MMMainFrame.this.mmstudio.getCore().unloadAllDevices();
                        }
                        catch (Exception e1) {
                            MMMainFrame.this.mmstudio.logError(e1);
                        }
                        ConfiguratorDlg2 configurator = new ConfiguratorDlg2(MMMainFrame.this.mmstudio.getCore(), MicroManager.getDefaultConfigFileName());
                        configurator.setVisible(true);
                        MicroManager.setDefaultConfigFileName(configurator.getFileName());
                        MMMainFrame.this.loadDefaultConfig();
                        MMMainFrame.this.refreshConfigs();
                        MMMainFrame.this.refreshGUI();
                    }
                });
                JMenuItem menuPxSizeConfigItem = new JMenuItem("Pixel Size Config");
                menuPxSizeConfigItem.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_PROPERTIES));
                menuPxSizeConfigItem.setAccelerator(KeyStroke.getKeyStroke(71, 0x40 | SHORTCUTKEY_MASK));
                menuPxSizeConfigItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CalibrationListDlg dlg = new CalibrationListDlg(MMMainFrame.this.mmstudio.getCore());
                        dlg.setDefaultCloseOperation(2);
                        dlg.setParentGUI((ScriptInterface)MMMainFrame.this.mmstudio);
                        IcyFrame pixelSizeConfig = FrameUtils.addMMWindowToDesktopPane((Window)dlg);
                        pixelSizeConfig.setSize(320, 260);
                        pixelSizeConfig.center();
                        pixelSizeConfig.setResizable(true);
                    }
                });
                JMenuItem loadConfigItem = new JMenuItem("Load Configuration");
                loadConfigItem.setAccelerator(KeyStroke.getKeyStroke(79, 0x40 | SHORTCUTKEY_MASK));
                loadConfigItem.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_OPEN));
                loadConfigItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoadFrame f = new LoadFrame();
                        if (1 != f.showDialog()) {
                            try {
                                MMMainFrame.this.mmstudio.getCore().unloadAllDevices();
                            }
                            catch (Exception e1) {
                                MMMainFrame.this.mmstudio.logError(e1);
                            }
                            MicroManager.setDefaultConfigFileName(f.getConfigFilePath());
                            MMMainFrame.this.loadDefaultConfig();
                            MMMainFrame.this.refreshConfigs();
                            MMMainFrame.this.refreshGUI();
                        }
                    }
                });
                JMenuItem saveConfigItem = new JMenuItem("Save Configuration");
                saveConfigItem.setAccelerator(KeyStroke.getKeyStroke(83, 0x40 | SHORTCUTKEY_MASK));
                saveConfigItem.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_SAVE));
                saveConfigItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MMMainFrame.this.saveConfig();
                    }
                });
                JMenuItem aboutItem = new JMenuItem("About");
                aboutItem.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_INFO));
                aboutItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final JDialog dialog = new JDialog((Frame)Icy.getMainInterface().getMainFrame(), "About");
                        dialog.getContentPane().setLayout(new BorderLayout());
                        dialog.getContentPane().add((Component)new AboutPanel(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                dialog.dispose();
                            }
                        }), "Center");
                        dialog.setResizable(false);
                        dialog.pack();
                        ComponentUtil.center((Window)dialog);
                        dialog.setVisible(true);
                    }
                });
                JMenuItem propertyBrowserItem = new JMenuItem("Property Browser");
                propertyBrowserItem.setAccelerator(KeyStroke.getKeyStroke(44, SHORTCUTKEY_MASK));
                propertyBrowserItem.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_DATABASE));
                propertyBrowserItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropertyEditor editor = new PropertyEditor();
                        editor.setGui((ScriptInterface)MMMainFrame.this.mmstudio);
                        editor.setCore(MMMainFrame.this.mmstudio.getCore());
                        editor.setDefaultCloseOperation(2);
                        IcyFrame propertyBrowser = FrameUtils.addMMWindowToDesktopPane((Window)editor);
                        propertyBrowser.setSize(380, 480);
                        propertyBrowser.center();
                        propertyBrowser.setResizable(true);
                    }
                });
                JMenuItem resetMMPath = new JMenuItem("Reset Micro-Manager path");
                resetMMPath.setIcon((Icon)new IcyIcon("folder"));
                resetMMPath.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MMUtils.resetLibrayPath();
                        MessageDialog.showDialog((String)"Information", (String)"You need to restart Icy now to change the defined Micro-Manager folder.", (int)1);
                    }
                });
                JMenuItem mmSettingItem = new JMenuItem("Micro-Manager options");
                mmSettingItem.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_COG, true));
                mmSettingItem.setToolTipText("Set a variety of Micro-Manager configuration options");
                mmSettingItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MMMainFrame.this.options == null) {
                            return;
                        }
                        OptionsPanel optionsPanel = new OptionsPanel(MMMainFrame.this, MMMainFrame.this.options, MMMainFrame.this.mmstudio.getCore());
                        ActionDialog optionsDialog = new ActionDialog("Micro-Manager Options", (JComponent)optionsPanel, (Frame)Icy.getMainInterface().getMainFrame());
                        optionsDialog.setOkAction((ActionListener)optionsPanel);
                        optionsDialog.pack();
                        optionsDialog.setResizable(false);
                        optionsDialog.setLocationRelativeTo((Component)MMMainFrame.this.getFrame());
                        optionsDialog.setVisible(true);
                    }
                });
                JMenuItem mmScriptPanel = new JMenuItem("Script panel");
                mmScriptPanel.setIcon((Icon)new IcyIcon(ResourceUtil.getAlphaIconAsImage((String)"text_curstor"), true));
                mmScriptPanel.setToolTipText("Open Micro-Manager script panel");
                mmScriptPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MMMainFrame.this.mmstudio.showScriptPanel();
                    }
                });
                int idx = 0;
                toReturn.insert(hconfig, idx++);
                toReturn.insert(loadConfigItem, idx++);
                toReturn.insert(saveConfigItem, idx++);
                toReturn.insert(resetMMPath, idx++);
                toReturn.insertSeparator(idx++);
                toReturn.insert(propertyBrowserItem, idx++);
                toReturn.insert(menuPxSizeConfigItem, idx++);
                toReturn.insert(mmScriptPanel, idx++);
                toReturn.insert(mmSettingItem, idx++);
                toReturn.insertSeparator(idx++);
                toReturn.insert(aboutItem, idx++);
                return toReturn;
            }
        });
    }

    public void lock() {
        this.rlock.lock();
    }

    public boolean lock(long wait) throws InterruptedException {
        return this.rlock.tryLock(wait, TimeUnit.MILLISECONDS);
    }

    public void unlock() {
        this.rlock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(String filePath) {
        loadingFrame.show();
        try (LoadingFrame loadingFrame = new LoadingFrame("  Please wait while loading Micro-Manager configuration, it may take a while...  ");){
            this.mmstudio.getCore().waitForSystem();
            this.mmstudio.getCore().loadSystemConfiguration(filePath);
            try {
                if (!StringUtil.isEmpty((String)this.mmstudio.getCore().getCameraDevice())) {
                    this.mmstudio.getCore().initializeCircularBuffer();
                }
            }
            catch (Throwable e) {
                throw new Exception("Error while initializing circular buffer of Micro Manager", e);
            }
        }
    }

    void loadDefaultConfig() {
        this.loadConfig(MicroManager.getDefaultConfigFileName());
    }

    public void saveConfig() {
        try {
            MicroscopeModel model = new MicroscopeModel();
            model.loadFromFile(MicroManager.getDefaultConfigFileName());
            model.createSetupConfigsFromHardware(this.mmstudio.getCore());
            model.createResolutionsFromHardware(this.mmstudio.getCore());
            String path = SaveDialog.chooseFile((String)"Save the configuration file", (String)FileUtil.getApplicationDirectory(), (String)"myConfig", (String)".cfg");
            if (path != null) {
                model.saveToFile(path);
            }
        }
        catch (MMConfigFileException e) {
            ReportingUtils.logError((Throwable)e);
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
            new FailedAnnounceFrame("Unable to save configuration file");
        }
    }

    public MMStudio getMMStudio() {
        return this.mmstudio;
    }

    public AcquisitionHandler getAcquisitionHandler() {
        return this.acquisitionHandler;
    }

    public MMOptions getOptions() {
        return this.options;
    }

    public Preferences getMainPreferences() {
        return this.mainPreferences;
    }

    public XMLPreferences getPreferences() {
        return this.preferences;
    }

    public boolean getStoreLastAcquisition() {
        return this.preferences.getBoolean(ID_STORELASTACQ, true);
    }

    public void setStoreLastAcquisition(boolean value) {
        this.preferences.putBoolean(ID_STORELASTACQ, value);
    }

    public boolean getDisplayAcquisitionSequence() {
        return this.preferences.getBoolean(ID_DISPLAYACQ, true);
    }

    public void setDisplayAcquisitionSequence(boolean value) {
        this.preferences.putBoolean(ID_DISPLAYACQ, value);
    }

    public void refreshGUI() {
        if (this.cameraPanel != null) {
            this.cameraPanel.refresh();
        }
        if (this.acquisitionInfoPanel != null) {
            this.acquisitionInfoPanel.refresh();
        }
    }

    public void refreshConfigs() {
        if (this.configPanel != null) {
            this.configPanel.refreshConfigs(false);
        }
    }

    public void addPlugin(MicroscopePlugin plugin) {
        if (this.pluginsPanel != null) {
            this.pluginsPanel.addPlugin(plugin);
        }
    }

    public void removePlugin(MicroscopePlugin plugin) {
        if (this.pluginsPanel != null) {
            this.pluginsPanel.removePlugin(plugin);
        }
    }

    public void liveStarted() {
    }

    public void liveStopped() {
    }

    class CustomEventCallback
    extends MMEventCallback {
        CustomEventCallback() {
        }

        public void onPropertiesChanged() {
            MMMainFrame.this.refreshGUI();
        }

        public void onConfigGroupChanged(String groupName, String newConfig) {
            if (MMMainFrame.this.configPanel != null) {
                MMMainFrame.this.configPanel.refreshGroup(groupName);
            }
            if (MMMainFrame.this.acquisitionInfoPanel != null) {
                MMMainFrame.this.acquisitionInfoPanel.refresh();
            }
        }

        public void onExposureChanged(String deviceName, double exposure) {
            if (MMMainFrame.this.cameraPanel != null && StringUtil.equals((String)deviceName, (String)MMMainFrame.this.cameraPanel.getCameraName())) {
                MMMainFrame.this.cameraPanel.onExposureChanged(exposure);
                if (MMMainFrame.this.pluginsPanel != null) {
                    MMMainFrame.this.pluginsPanel.onExposureChanged(exposure);
                }
            }
            if (MMMainFrame.this.acquisitionInfoPanel != null) {
                MMMainFrame.this.acquisitionInfoPanel.refresh();
            }
        }

        public void onPropertyChanged(String deviceName, String propName, String propValue) {
            if (MMMainFrame.this.cameraPanel != null && StringUtil.equals((String)deviceName, (String)MMMainFrame.this.cameraPanel.getCameraName()) && propName.equals(MMCoreJ.getG_Keyword_Binning())) {
                MMMainFrame.this.cameraPanel.onBinningChanged(propValue);
            }
            if (MMMainFrame.this.acquisitionInfoPanel != null) {
                MMMainFrame.this.acquisitionInfoPanel.refresh();
            }
            if (MMMainFrame.this.pluginsPanel != null) {
                MMMainFrame.this.pluginsPanel.onCorePropertyChanged(deviceName, propName, propValue);
            }
        }

        public void onStagePositionChanged(String deviceName, double pos) {
            StageMover.onStagePositionChanged(deviceName, pos);
            if (MMMainFrame.this.acquisitionInfoPanel != null) {
                MMMainFrame.this.acquisitionInfoPanel.refresh();
            }
        }

        public void onXYStagePositionChanged(String deviceName, double xPos, double yPos) {
            StageMover.onXYStagePositionChanged(deviceName, xPos, yPos);
            if (MMMainFrame.this.acquisitionInfoPanel != null) {
                MMMainFrame.this.acquisitionInfoPanel.refresh();
            }
        }

        public void onSystemConfigurationLoaded() {
            if (MMMainFrame.this.pluginsPanel != null) {
                MMMainFrame.this.pluginsPanel.onSystemConfigurationLoaded();
            }
            if (MMMainFrame.this.acquisitionInfoPanel != null) {
                MMMainFrame.this.acquisitionInfoPanel.refresh();
            }
        }
    }
}

