/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import java.util.Iterator;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.EdgeSweep;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.collide.PolygonPolygonCollider;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.shapes.Line;
import net.phys2d.raw.shapes.Polygon;

public class PolygonCircleCollider
extends PolygonPolygonCollider {
    @Override
    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        Polygon polyA = (Polygon)bodyA.getShape();
        Circle circle = (Circle)bodyB.getShape();
        Vector2f[] vertsA = polyA.getVertices(bodyA.getPosition(), bodyA.getRotation());
        Vector2f centroidA = new Vector2f(polyA.getCentroid());
        centroidA.add(bodyA.getPosition());
        Iterator<EdgeSweep.EdgePairs.EdgePair> collPairs = this.getCollisionCandidates(vertsA, centroidA, circle.getRadius(), bodyB.getPosition());
        int noContacts = 0;
        while (collPairs.hasNext()) {
            float r2;
            EdgeSweep.EdgePairs.EdgePair pair = collPairs.next();
            if (noContacts >= contacts.length) {
                return contacts.length;
            }
            Vector2f lineStartA = vertsA[pair.a];
            Vector2f lineEndA = vertsA[(pair.a + 1) % vertsA.length];
            Line line = new Line(lineStartA, lineEndA);
            float dis2 = line.distanceSquared(bodyB.getPosition());
            if (!(dis2 < (r2 = circle.getRadius() * circle.getRadius()))) continue;
            Vector2f pt = new Vector2f();
            line.getClosestPoint(bodyB.getPosition(), pt);
            Vector2f normal = new Vector2f(bodyB.getPosition());
            normal.sub(pt);
            float sep = circle.getRadius() - normal.length();
            normal.normalise();
            contacts[noContacts].setSeparation(-sep);
            contacts[noContacts].setPosition(pt);
            contacts[noContacts].setNormal(normal);
            contacts[noContacts].setFeature(new FeaturePair());
            ++noContacts;
        }
        return noContacts;
    }

    protected Iterator<EdgeSweep.EdgePairs.EdgePair> getCollisionCandidates(Vector2f[] vertsA, ROVector2f centroid, float radius, ROVector2f circlePos) {
        Vector2f sweepDir = new Vector2f(centroid);
        sweepDir.sub(circlePos);
        sweepDir.normalise();
        EdgeSweep sweep = new EdgeSweep(sweepDir);
        sweep.addVerticesToSweep(true, vertsA);
        float circProj = circlePos.dot(sweepDir);
        sweep.insert(0, false, -radius + circProj);
        sweep.insert(0, false, radius + circProj);
        return sweep.getOverlappingEdges();
    }
}

