/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class LockScrollHelperOverlay
extends Overlay {
    boolean lockingPan = false;
    Font absoluteFont = new Font("Arial", 1, 15);

    public LockScrollHelperOverlay() {
        super("Lock Scroll Helper");
        this.setPriority(Overlay.OverlayPriority.IMAGE_NORMAL);
    }

    void drawAbsoluteString(String string, int x, int y, Graphics2D g, IcyCanvas2D canvas) {
        AffineTransform transform = g.getTransform();
        g.transform(canvas.getInverseTransform());
        g.setFont(this.absoluteFont);
        g.drawString(string, x, y);
        g.setTransform(transform);
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (canvas instanceof IcyCanvas2D) {
            if (this.lockingPan) {
                g.setColor(Color.red);
                this.drawAbsoluteString("E: Mouse pan disabled (use numpad arrow keys)", 150, 20, g, (IcyCanvas2D)canvas);
            } else {
                g.setColor(Color.gray);
                this.drawAbsoluteString("E: Mouse pan enabled", 150, 20, g, (IcyCanvas2D)canvas);
            }
        }
    }

    public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (e.getKeyChar() == 'e' || e.getKeyChar() == 'E') {
            this.lockingPan = !this.lockingPan;
            e.consume();
            canvas.getSequence().overlayChanged((Overlay)this);
        }
    }

    public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (this.lockingPan) {
            e.consume();
        }
    }
}

