/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import flanagan.analysis.Stat;
import icy.file.xls.XlsManager;
import icy.gui.dialog.ActionDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jxl.format.Colour;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import plugins.fab.MiceProfiler.Animal;
import plugins.fab.MiceProfiler.EventCriteria;
import plugins.fab.MiceProfiler.EventTimeLine;
import plugins.fab.MiceProfiler.TimeLineCategory;

public class MiceProfilerLabelAnalyserInternal
implements SwimmingPoolListener,
ActionListener {
    JPanel mainPanel = GuiUtil.generatePanel();
    IcyFrame icyFrame = GuiUtil.generateTitleFrame((String)"Label Analyser", (JPanel)this.mainPanel, (Dimension)new Dimension(0, 0), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    ArrayList<EventSelector> eventSelectorList = null;
    JFreeChart chart;
    XYSeriesCollection xyDataset = new XYSeriesCollection();
    YIntervalSeriesCollection yintervalseriescollection = new YIntervalSeriesCollection();
    JTextField binSizeTextField = new JTextField("150");
    JTextField fpsTextField = new JTextField("15");
    JTextField totalTimeTextField = new JTextField("7200");
    ArrayList<AnimalPoolSelector> animalList = new ArrayList();
    IcyFrame graphFrame = new IcyFrame("graph", true, true, true, true);
    JCheckBoxMenuItem displayLegendCheckBoxMenuItem = new JCheckBoxMenuItem("display Legend", true);
    JMenuItem extractDataToProbabilityGridMenuItem = new JMenuItem("Compute decision graph script to console");
    JTextField extractDataToProbabilityTimeValue = new JTextField("150");
    JMenuItem extractCurrentDataGraphToExcelMenuItem = new JMenuItem("Export current graph to xls");
    JMenuItem extractCurrentDataGraphWithAllLabelDensityToExcelMenuItem = new JMenuItem("Export graphs to xls (one per label-density)");
    JMenuItem extractAllDataToGraphAndExcelMenuItem = new JMenuItem("Export all datas (in pools) to xls");

    public MiceProfilerLabelAnalyserInternal() {
        this.animalList.clear();
        ArrayList liste = Icy.getMainInterface().getSwimmingPool().getObjects();
        for (SwimmingObject so : liste) {
            if (!(so.getObject() instanceof Animal)) continue;
            this.animalList.add(new AnimalPoolSelector((Animal)so.getObject()));
        }
        if (this.animalList.size() == 0) {
            MessageDialog.showDialog((String)"No animal loaded, please run VideoLabelMaker first.", (int)1);
            return;
        }
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)this);
        this.chart = ChartFactory.createXYLineChart((String)"", (String)"t", (String)"y", (XYDataset)this.yintervalseriescollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 20.0));
        xyplot.setBackgroundPaint((Paint)Color.lightGray);
        xyplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xyplot.setDomainGridlinePaint((Paint)Color.white);
        xyplot.setRangeGridlinePaint((Paint)Color.white);
        DeviationRenderer deviationrenderer = new DeviationRenderer(true, false);
        for (int i = 0; i < 100; ++i) {
            deviationrenderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f, 1, 1));
            deviationrenderer.setSeriesStroke(i + 1, (Stroke)new BasicStroke(3.0f, 1, 1));
            deviationrenderer.setSeriesFillPaint(0, (Paint)new Color(255, 200, 200));
            deviationrenderer.setSeriesFillPaint(1, (Paint)new Color(200, 200, 255));
            deviationrenderer.setSeriesFillPaint(3, (Paint)new Color(200, 255, 200));
            deviationrenderer.setSeriesFillPaint(2, (Paint)new Color(255, 255, 200));
        }
        xyplot.setRenderer((XYItemRenderer)deviationrenderer);
        this.refreshData();
        this.icyFrame.addToDesktopPane();
        this.icyFrame.pack();
        this.icyFrame.setSize(800, 600);
        this.icyFrame.center();
        this.icyFrame.toFront();
        this.icyFrame.setVisible(true);
        this.graphFrame.addToDesktopPane();
        this.graphFrame.setVisible(true);
        this.icyFrame.toFront();
        this.extractCurrentDataGraphToExcelMenuItem.addActionListener(this);
        this.extractAllDataToGraphAndExcelMenuItem.addActionListener(this);
        this.extractDataToProbabilityGridMenuItem.addActionListener(this);
        this.extractCurrentDataGraphWithAllLabelDensityToExcelMenuItem.addActionListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu menuExport = new JMenu("Export");
        menuExport.add(this.extractCurrentDataGraphToExcelMenuItem);
        menuExport.add(this.extractAllDataToGraphAndExcelMenuItem);
        menuExport.add(this.extractDataToProbabilityGridMenuItem);
        menuExport.add(this.extractCurrentDataGraphWithAllLabelDensityToExcelMenuItem);
        menuBar.add(menuExport);
        this.icyFrame.setJMenuBar(menuBar);
    }

    public void run() {
    }

    void refreshGraph(boolean xlsExport, String file) {
        XlsManager xls = null;
        int cursorX = 0;
        int cursorY = 1;
        if (xlsExport) {
            String saveFileName = file;
            if (file == null && (saveFileName = SaveDialog.chooseFile((String)"Export current graph to xls file", (String)System.getProperty("user.home"), (String)"outputGraph.xls", (String)".xls")) == null) {
                return;
            }
            try {
                xls = new XlsManager(new File(saveFileName));
                xls.createNewPage("Mice profiler graph export");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int binSize = Integer.parseInt(this.binSizeTextField.getText());
        int endFrame = Integer.parseInt(this.totalTimeTextField.getText());
        float fps = Float.parseFloat(this.fpsTextField.getText());
        this.xyDataset.removeAllSeries();
        this.yintervalseriescollection.removeAllSeries();
        for (EventSelector eventSelector : this.eventSelectorList) {
            for (AnimalPoolSelector animalSelector : this.animalList) {
                String titreSerie;
                XYSeries seriesXY;
                double value;
                int t;
                YIntervalSeries yintervalseries;
                EventTimeLine eventTimeLine;
                if (!animalSelector.noPool.isSelected() || !animalSelector.enable.isSelected()) continue;
                if (eventSelector.nbEventCheckBox.isSelected()) {
                    eventTimeLine = animalSelector.animal.eventTimeLineList.get(eventSelector.eventNumber);
                    String titreSerie2 = animalSelector.animal.animalName + " np Event Nb" + eventTimeLine.criteriaName;
                    XYSeries seriesXY2 = new XYSeries((Comparable)((Object)titreSerie2));
                    if (xlsExport) {
                        xls.setLabel(++cursorX, 0, titreSerie2);
                        cursorY = 1;
                    }
                    yintervalseries = new YIntervalSeries((Comparable)((Object)(animalSelector.animal.animalName + " np Event Nb" + eventTimeLine.criteriaName)));
                    for (t = 0; t < endFrame; t += binSize) {
                        value = eventTimeLine.getNbEvent(t, t + binSize - 1);
                        yintervalseries.add((double)((float)t / fps), value, value, value);
                        if (!xlsExport) continue;
                        xls.setNumber(0, cursorY, (double)((float)t / fps));
                        xls.setNumber(cursorX, cursorY, value);
                        ++cursorY;
                    }
                    this.yintervalseriescollection.addSeries(yintervalseries);
                }
                if (eventSelector.lengthCheckBox.isSelected()) {
                    eventTimeLine = animalSelector.animal.eventTimeLineList.get(eventSelector.eventNumber);
                    seriesXY = new XYSeries((Comparable)((Object)(animalSelector.animal.animalName + " np Event l" + eventTimeLine.criteriaName)));
                    titreSerie = animalSelector.animal.animalName + " np Event l" + eventTimeLine.criteriaName;
                    yintervalseries = new YIntervalSeries((Comparable)((Object)titreSerie));
                    if (xlsExport) {
                        xls.setLabel(++cursorX, 0, titreSerie);
                        cursorY = 1;
                    }
                    for (t = 0; t < endFrame; t += binSize) {
                        value = eventTimeLine.getLengthEvent(t, t + binSize - 1);
                        yintervalseries.add((double)((float)t / fps), value, value, value);
                        if (!xlsExport) continue;
                        xls.setNumber(0, cursorY, (double)((float)t / fps));
                        xls.setNumber(cursorX, cursorY, value);
                        ++cursorY;
                    }
                    this.yintervalseriescollection.addSeries(yintervalseries);
                }
                if (eventSelector.displayDiscreteValueCheckBox.isSelected()) {
                    eventTimeLine = animalSelector.animal.eventTimeLineList.get(eventSelector.eventNumber);
                    seriesXY = new XYSeries((Comparable)((Object)(animalSelector.animal.animalName + " dv Event " + eventTimeLine.criteriaName)));
                    titreSerie = animalSelector.animal.animalName + " dv Event " + eventTimeLine.criteriaName;
                    yintervalseries = new YIntervalSeries((Comparable)((Object)titreSerie));
                    if (xlsExport) {
                        xls.setLabel(++cursorX, 0, titreSerie);
                        cursorY = 1;
                    }
                    for (t = 0; t < endFrame; t += binSize) {
                        value = eventTimeLine.getMeanValue(t, t + binSize - 1);
                        yintervalseries.add((double)((float)t / fps), value, value, value);
                        if (!xlsExport) continue;
                        xls.setNumber(0, cursorY, (double)((float)t / fps));
                        xls.setNumber(cursorX, cursorY, value);
                        ++cursorY;
                    }
                    this.yintervalseriescollection.addSeries(yintervalseries);
                }
                if (!eventSelector.densityCheckBox.isSelected()) continue;
                eventTimeLine = animalSelector.animal.eventTimeLineList.get(eventSelector.eventNumber);
                seriesXY = new XYSeries((Comparable)((Object)(animalSelector.animal.animalName + " dv Density " + eventTimeLine.criteriaName)));
                titreSerie = animalSelector.animal.animalName + " dv Density " + eventTimeLine.criteriaName;
                yintervalseries = new YIntervalSeries((Comparable)((Object)titreSerie));
                if (xlsExport) {
                    xls.setLabel(++cursorX, 0, titreSerie);
                    cursorY = 1;
                }
                for (t = 0; t < endFrame; t += binSize) {
                    value = eventTimeLine.getDensity(t, t + binSize - 1);
                    yintervalseries.add((double)((float)t / fps), value, value, value);
                    if (!xlsExport) continue;
                    xls.setNumber(0, cursorY, (double)((float)t / fps));
                    xls.setNumber(cursorX, cursorY, value);
                    ++cursorY;
                }
                this.yintervalseriescollection.addSeries(yintervalseries);
            }
        }
        this.updateGraphSeriesForPool(Criteria.NB_EVENT, 1, endFrame, binSize, xls, xlsExport);
        this.updateGraphSeriesForPool(Criteria.LENGTH_EVENT, 1, endFrame, binSize, xls, xlsExport);
        this.updateGraphSeriesForPool(Criteria.DISCRETE_VALUE, 1, endFrame, binSize, xls, xlsExport);
        this.updateGraphSeriesForPool(Criteria.DENSITY_VALUE, 1, endFrame, binSize, xls, xlsExport);
        this.updateGraphSeriesForPool(Criteria.NB_EVENT, 2, endFrame, binSize, xls, xlsExport);
        this.updateGraphSeriesForPool(Criteria.LENGTH_EVENT, 2, endFrame, binSize, xls, xlsExport);
        this.updateGraphSeriesForPool(Criteria.DISCRETE_VALUE, 2, endFrame, binSize, xls, xlsExport);
        this.updateGraphSeriesForPool(Criteria.DENSITY_VALUE, 2, endFrame, binSize, xls, xlsExport);
        if (xlsExport) {
            xls.SaveAndClose();
        }
    }

    void updateGraphSeriesForPool(Criteria criteria, int pool, int endFrame, int binSize, XlsManager xls, boolean xlsExport) {
        int cursorX = 1;
        int cursorY = 0;
        float fps = Float.parseFloat(this.fpsTextField.getText());
        boolean process = false;
        for (AnimalPoolSelector animalSelector : this.animalList) {
            if ((pool != 1 || !animalSelector.pool1.isSelected()) && (pool != 2 || !animalSelector.pool2.isSelected())) continue;
            process = true;
        }
        if (!process) {
            return;
        }
        for (EventSelector eventSelector : this.eventSelectorList) {
            if (!(criteria == Criteria.NB_EVENT && eventSelector.nbEventCheckBox.isSelected() || criteria == Criteria.LENGTH_EVENT && eventSelector.lengthCheckBox.isSelected() || criteria == Criteria.DISCRETE_VALUE && eventSelector.displayDiscreteValueCheckBox.isSelected()) && (criteria != Criteria.DENSITY_VALUE || !eventSelector.densityCheckBox.isSelected())) continue;
            String chaine = "p" + pool + " " + criteria.toString();
            chaine = chaine + this.animalList.get((int)0).animal.eventTimeLineList.get((int)eventSelector.eventNumber).criteriaName;
            XYSeries seriesXY = new XYSeries((Comparable)((Object)chaine));
            YIntervalSeries yintervalseries = new YIntervalSeries((Comparable)((Object)chaine));
            if (xlsExport) {
                xls.createNewPage(chaine);
                cursorX = 1;
            }
            for (int t = 0; t < endFrame; t += binSize) {
                if (xlsExport) {
                    xls.setLabel(cursorX, cursorY, "" + t + "-" + (t + binSize));
                    ++cursorY;
                    ++cursorY;
                }
                ArrayList<Double> listResultat = new ArrayList<Double>();
                for (AnimalPoolSelector animalSelector : this.animalList) {
                    if ((pool != 1 || !animalSelector.pool1.isSelected()) && (pool != 2 || !animalSelector.pool2.isSelected()) || !animalSelector.enable.isSelected()) continue;
                    EventTimeLine eventTimeLine = animalSelector.animal.eventTimeLineList.get(eventSelector.eventNumber);
                    if (criteria == Criteria.NB_EVENT) {
                        listResultat.add(eventTimeLine.getNbEvent(t, t + binSize - 1));
                        if (xlsExport) {
                            xls.setNumber(cursorX, cursorY, eventTimeLine.getNbEvent(t, t + binSize - 1));
                            ++cursorY;
                        }
                    }
                    if (criteria == Criteria.LENGTH_EVENT) {
                        listResultat.add(eventTimeLine.getLengthEvent(t, t + binSize - 1));
                        if (xlsExport) {
                            xls.setNumber(cursorX, cursorY, eventTimeLine.getLengthEvent(t, t + binSize - 1));
                            ++cursorY;
                        }
                    }
                    if (criteria == Criteria.DISCRETE_VALUE) {
                        listResultat.add(eventTimeLine.getMeanValue(t, t + binSize - 1));
                        if (xlsExport) {
                            xls.setNumber(cursorX, cursorY, eventTimeLine.getMeanValue(t, t + binSize - 1));
                            ++cursorY;
                        }
                    }
                    if (criteria != Criteria.DENSITY_VALUE) continue;
                    listResultat.add(eventTimeLine.getDensity(t, t + binSize - 1));
                    if (!xlsExport) continue;
                    xls.setNumber(cursorX, cursorY, eventTimeLine.getDensity(t, t + binSize - 1));
                    ++cursorY;
                }
                if (listResultat.size() != 0) {
                    double[] resultatTab2 = new double[listResultat.size()];
                    for (int i = 0; i < listResultat.size(); ++i) {
                        resultatTab2[i] = (Double)listResultat.get(i);
                    }
                    double error = Stat.standardDeviation((double[])resultatTab2);
                    double mean = Stat.mean((double[])resultatTab2);
                    yintervalseries.add((double)((float)t / fps), mean, mean - (error /= Math.sqrt(listResultat.size() - 1)), mean + error);
                    if (xlsExport) {
                        xls.setNumber(cursorX, ++cursorY, mean);
                    }
                } else {
                    yintervalseries.add((double)((float)t / fps), 0.0, 0.0, 0.0);
                }
                ++cursorX;
                cursorY = 0;
            }
            this.xyDataset.addSeries(seriesXY);
            this.yintervalseriescollection.addSeries(yintervalseries);
        }
    }

    private void refreshData() {
        this.mainPanel.removeAll();
        JPanel animalPoolListPanel = GuiUtil.generatePanel((String)"Animal pool List");
        JPanel criteriaListPanel = GuiUtil.generatePanel((String)"criteria List");
        ArrayList liste = Icy.getMainInterface().getSwimmingPool().getObjects();
        this.animalList.clear();
        Animal animalToGetCriteria = null;
        for (SwimmingObject so : liste) {
            if (!(so.getObject() instanceof Animal)) continue;
            this.animalList.add(new AnimalPoolSelector((Animal)so.getObject()));
            animalToGetCriteria = (Animal)so.getObject();
        }
        if (animalToGetCriteria == null) {
            return;
        }
        for (AnimalPoolSelector animalSelector : this.animalList) {
            animalPoolListPanel.add(animalSelector.panel);
        }
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Bin Size ( nb frames )"), this.binSizeTextField, new JLabel("Total time to compute ( nb frames )"), this.totalTimeTextField}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("time window forward:"), this.extractDataToProbabilityTimeValue}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("FPS:"), this.fpsTextField}));
        this.eventSelectorList = new ArrayList();
        for (EventTimeLine et : animalToGetCriteria.eventTimeLineList) {
            EventSelector eventSelector = new EventSelector(animalToGetCriteria.eventTimeLineList.indexOf(et), et);
            this.eventSelectorList.add(eventSelector);
            criteriaListPanel.add(eventSelector.panel);
        }
        JPanel parameterPanel = new JPanel(new BorderLayout());
        JScrollPane animalPoolListScrollPane = new JScrollPane(animalPoolListPanel, 22, 32);
        JScrollPane criteriaListScrollPane = new JScrollPane(criteriaListPanel, 22, 32);
        parameterPanel.add((Component)animalPoolListScrollPane, "West");
        parameterPanel.add((Component)criteriaListScrollPane, "Center");
        this.mainPanel.add(parameterPanel);
        this.graphFrame.getContentPane().add((Component)new ChartPanel(this.chart, 700, 200, 700, 200, 700, 700, false, false, true, true, true, true));
        this.graphFrame.pack();
        this.refreshGraph(false, "");
        this.mainPanel.updateUI();
    }

    public void swimmingPoolChangeEvent(SwimmingPoolEvent swimmingPoolEvent) {
        this.refreshData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refreshGraph(false, "");
        if (e.getSource() == this.extractCurrentDataGraphToExcelMenuItem) {
            this.extractCurrentDataGraphToExcel();
        }
        if (e.getSource() == this.extractAllDataToGraphAndExcelMenuItem) {
            this.exportAllData();
        }
        if (e.getSource() == this.extractDataToProbabilityGridMenuItem) {
            this.extractDataToProbabilityGrid2();
        }
        if (e.getSource() == this.extractCurrentDataGraphWithAllLabelDensityToExcelMenuItem) {
            this.extractDataGraphWithAllLabelDensityToExcel();
        }
    }

    private void extractDataGraphWithAllLabelDensityToExcel() {
        String saveFileName = SaveDialog.chooseFile((String)"Save xls file", (String)"", (String)"Mice Profiler - ");
        if (saveFileName == null) {
            return;
        }
        for (EventSelector eventSelector : this.eventSelectorList) {
            for (EventSelector eventSelector2 : this.eventSelectorList) {
                eventSelector2.densityCheckBox.setSelected(false);
            }
            eventSelector.densityCheckBox.setSelected(true);
            String eventLabel = eventSelector.criteriaLabel.getText().replaceAll("[^a-zA-Z0-9\\._]+", "_");
            String fileName = saveFileName + " - " + eventLabel + ".xls";
            this.refreshGraph(true, fileName);
        }
    }

    private void extractCurrentDataGraphToExcel() {
        this.refreshGraph(true, null);
    }

    private void extractDataToProbabilityGrid2() {
        float stddevPropose;
        float probaProposee;
        int nbEventTarget;
        float[] tabProba;
        int eventNumberSource;
        System.out.println("export version nov 2010");
        int timeWindow = Integer.parseInt(this.extractDataToProbabilityTimeValue.getText());
        int offsetY = 3;
        boolean offsetX = true;
        ActionDialog actionDialog = new ActionDialog("Select parameters for tansition graph.");
        JPanel mainPanel = new JPanel();
        actionDialog.setPreferredSize(new Dimension(400, 400));
        actionDialog.getMainPanel().add(new JScrollPane(mainPanel));
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        this.animalList.get((int)0).animal.eventTimeLineList.size();
        JTextField minProbability = new JTextField("0.3");
        mainPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Min probability: "), minProbability}));
        JTextField fpsTextField = new JTextField("15");
        mainPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("FPS: "), fpsTextField}));
        JTextField maxNumberOfCandidateTextField = new JTextField("4");
        mainPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Max number of ancestor: "), maxNumberOfCandidateTextField}));
        JCheckBox forceLocation = new JCheckBox("Force the location of the event in the graph (circular rendering)", false);
        mainPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{forceLocation}));
        HashMap<Integer, JCheckBox> selectedEventHashMap = new HashMap<Integer, JCheckBox>();
        for (EventTimeLine event : this.animalList.get((int)0).animal.eventTimeLineList) {
            JCheckBox booleanField = new JCheckBox(event.criteriaName, true);
            mainPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{booleanField}));
            int index = this.animalList.get((int)0).animal.eventTimeLineList.indexOf(event);
            selectedEventHashMap.put(index, booleanField);
            if (index == 1) {
                booleanField.setSelected(false);
            }
            if (index >= 7 && index <= 10) {
                booleanField.setSelected(false);
            }
            if (index >= 13 && index <= 20) {
                booleanField.setSelected(false);
            }
            if (index < 27) continue;
            booleanField.setSelected(false);
        }
        actionDialog.pack();
        actionDialog.setLocationRelativeTo(null);
        actionDialog.setVisible(true);
        if (actionDialog.isCanceled()) {
            return;
        }
        float fps = Float.parseFloat(fpsTextField.getText());
        int MAX_NUMBER_OF_CANDIDATE = Integer.parseInt(maxNumberOfCandidateTextField.getText());
        System.out.println("WARNING:");
        System.out.println("This output consider all the loaded animal in the Label Analyser as coming from the same pool.");
        System.out.println("i.e. only 1 pool is considered.");
        System.out.println("version Jan 2013. p>0.1 instead of p>0.3");
        int nbTotalDeCritere = this.animalList.get((int)0).animal.eventTimeLineList.size();
        float[][][] poolProba0_4 = new float[this.animalList.size()][nbTotalDeCritere][nbTotalDeCritere];
        float[][][] poolProba4_8 = new float[this.animalList.size()][nbTotalDeCritere][nbTotalDeCritere];
        for (int animalNumber = 0; animalNumber < this.animalList.size(); ++animalNumber) {
            Animal animal = this.animalList.get((int)animalNumber).animal;
            int FENETRE_RECHERCHE_FRAME = (int)(fps * 3.0f);
            for (int eventNumberSource2 = 0; eventNumberSource2 < animal.eventTimeLineList.size(); ++eventNumberSource2) {
                for (int eventNumberTarget = 0; eventNumberTarget < animal.eventTimeLineList.size(); ++eventNumberTarget) {
                    EventTimeLine eventTimeLineSource = animal.eventTimeLineList.get(eventNumberSource2);
                    EventTimeLine eventTimeLineTarget = animal.eventTimeLineList.get(eventNumberTarget);
                    float nbEventSource04 = 0.0f;
                    float nbEventTarget04 = 0.0f;
                    float nbPassageSourceTargetOk04 = 0.0f;
                    float nbPassageTargetSourceOk04 = 0.0f;
                    block4: for (EventCriteria eventCriteriaSource : eventTimeLineSource.eventList) {
                        if (eventCriteriaSource.startFrame > 3600) continue;
                        nbEventSource04 += 1.0f;
                        for (EventCriteria eventCriteriaTarget : eventTimeLineTarget.eventList) {
                            if (eventCriteriaTarget.startFrame > 3600 || eventCriteriaTarget.startFrame < eventCriteriaSource.endFrame || eventCriteriaTarget.startFrame > eventCriteriaSource.endFrame + FENETRE_RECHERCHE_FRAME) continue;
                            nbPassageSourceTargetOk04 += 1.0f;
                            continue block4;
                        }
                    }
                    block6: for (EventCriteria eventCriteriaTarget : eventTimeLineTarget.eventList) {
                        if (eventCriteriaTarget.startFrame > 3600) continue;
                        nbEventTarget04 += 1.0f;
                        for (EventCriteria eventCriteriaSource : eventTimeLineSource.eventList) {
                            if (eventCriteriaSource.startFrame > 3600 || eventCriteriaTarget.startFrame < eventCriteriaSource.endFrame || eventCriteriaTarget.startFrame > eventCriteriaSource.endFrame + FENETRE_RECHERCHE_FRAME) continue;
                            nbPassageTargetSourceOk04 += 1.0f;
                            continue block6;
                        }
                    }
                    float probaStoT04 = nbPassageSourceTargetOk04 / nbEventSource04;
                    float probaTtoS04 = nbPassageTargetSourceOk04 / nbEventTarget04;
                    float proba2Way04 = probaStoT04 * probaTtoS04;
                    float nbEventSource48 = 0.0f;
                    float nbEventTarget48 = 0.0f;
                    float nbPassageSourceTargetOk48 = 0.0f;
                    float nbPassageTargetSourceOk48 = 0.0f;
                    block8: for (EventCriteria eventCriteriaSource : eventTimeLineSource.eventList) {
                        if (eventCriteriaSource.startFrame < 3600) continue;
                        nbEventSource48 += 1.0f;
                        for (EventCriteria eventCriteriaTarget : eventTimeLineTarget.eventList) {
                            if (eventCriteriaTarget.startFrame < 3600 || eventCriteriaTarget.startFrame < eventCriteriaSource.endFrame || eventCriteriaTarget.startFrame > eventCriteriaSource.endFrame + FENETRE_RECHERCHE_FRAME) continue;
                            nbPassageSourceTargetOk48 += 1.0f;
                            continue block8;
                        }
                    }
                    block10: for (EventCriteria eventCriteriaTarget : eventTimeLineTarget.eventList) {
                        if (eventCriteriaTarget.startFrame < 3600) continue;
                        nbEventTarget48 += 1.0f;
                        for (EventCriteria eventCriteriaSource : eventTimeLineSource.eventList) {
                            if (eventCriteriaSource.startFrame < 3600 || eventCriteriaTarget.startFrame < eventCriteriaSource.endFrame || eventCriteriaTarget.startFrame > eventCriteriaSource.endFrame + FENETRE_RECHERCHE_FRAME) continue;
                            nbPassageTargetSourceOk48 += 1.0f;
                            continue block10;
                        }
                    }
                    float probaStoT48 = nbPassageSourceTargetOk48 / nbEventSource48;
                    float probaTtoS48 = nbPassageTargetSourceOk48 / nbEventTarget48;
                    float proba2Way48 = probaStoT48 * probaTtoS48;
                    if (eventNumberSource2 == 9 || eventNumberSource2 == 10 || eventNumberTarget == 9 || eventNumberTarget == 10) continue;
                    poolProba0_4[animalNumber][eventNumberSource2][eventNumberTarget] = proba2Way04;
                    poolProba4_8[animalNumber][eventNumberSource2][eventNumberTarget] = proba2Way48;
                }
            }
        }
        float[][] meanAnimalProba0_4 = new float[nbTotalDeCritere][nbTotalDeCritere];
        float[][] stddevAnimalProba0_4 = new float[nbTotalDeCritere][nbTotalDeCritere];
        float[][] meanAnimalProba4_8 = new float[nbTotalDeCritere][nbTotalDeCritere];
        float[][] stddevAnimalProba4_8 = new float[nbTotalDeCritere][nbTotalDeCritere];
        for (eventNumberSource = 0; eventNumberSource < nbTotalDeCritere; ++eventNumberSource) {
            for (int eventNumberTarget = 0; eventNumberTarget < nbTotalDeCritere; ++eventNumberTarget) {
                tabProba = new float[this.animalList.size()];
                for (int animalNumber = 0; animalNumber < this.animalList.size(); ++animalNumber) {
                    tabProba[animalNumber] = poolProba0_4[animalNumber][eventNumberSource][eventNumberTarget];
                    float[] fArray = meanAnimalProba0_4[eventNumberSource];
                    int n = eventNumberTarget;
                    fArray[n] = fArray[n] + poolProba0_4[animalNumber][eventNumberSource][eventNumberTarget];
                }
                float[] fArray = meanAnimalProba0_4[eventNumberSource];
                int n = eventNumberTarget;
                fArray[n] = fArray[n] / (float)this.animalList.size();
                stddevAnimalProba0_4[eventNumberSource][eventNumberTarget] = Stat.standardDeviation((float[])tabProba);
            }
        }
        for (eventNumberSource = 0; eventNumberSource < nbTotalDeCritere; ++eventNumberSource) {
            for (int eventNumberTarget = 0; eventNumberTarget < nbTotalDeCritere; ++eventNumberTarget) {
                tabProba = new float[this.animalList.size()];
                for (int animalNumber = 0; animalNumber < this.animalList.size(); ++animalNumber) {
                    tabProba[animalNumber] = poolProba4_8[animalNumber][eventNumberSource][eventNumberTarget];
                    float[] fArray = meanAnimalProba4_8[eventNumberSource];
                    int n = eventNumberTarget;
                    fArray[n] = fArray[n] + poolProba4_8[animalNumber][eventNumberSource][eventNumberTarget];
                }
                float[] fArray = meanAnimalProba4_8[eventNumberSource];
                int n = eventNumberTarget;
                fArray[n] = fArray[n] / (float)this.animalList.size();
                stddevAnimalProba4_8[eventNumberSource][eventNumberTarget] = Stat.standardDeviation((float[])tabProba);
            }
        }
        ArrayList resultatParSource0_4 = new ArrayList();
        ArrayList resultatParSource4_8 = new ArrayList();
        for (nbEventTarget = 0; nbEventTarget < nbTotalDeCritere; ++nbEventTarget) {
            ArrayList<EventResult> eventResultList = new ArrayList<EventResult>();
            for (int nbEventSource = 0; nbEventSource < nbTotalDeCritere; ++nbEventSource) {
                JCheckBox eTarget = (JCheckBox)selectedEventHashMap.get(nbEventTarget);
                JCheckBox eSource = (JCheckBox)selectedEventHashMap.get(nbEventSource);
                if (!eTarget.isSelected() || !eSource.isSelected()) continue;
                probaProposee = meanAnimalProba0_4[nbEventSource][nbEventTarget];
                stddevPropose = stddevAnimalProba0_4[nbEventSource][nbEventTarget];
                ArrayList eventResultListClone = (ArrayList)eventResultList.clone();
                for (EventResult resultClient : eventResultListClone) {
                    if (!(resultClient.proba < probaProposee)) continue;
                    eventResultList.remove(resultClient);
                    break;
                }
                if (eventResultList.size() >= MAX_NUMBER_OF_CANDIDATE) continue;
                EventResult result = new EventResult(nbEventSource, nbEventTarget, probaProposee, stddevPropose, "red");
                eventResultList.add(result);
            }
            resultatParSource0_4.add(eventResultList);
        }
        for (nbEventTarget = 0; nbEventTarget < nbTotalDeCritere; ++nbEventTarget) {
            ArrayList<Object> eventResultList = new ArrayList<Object>();
            for (int nbEventSource = 0; nbEventSource < nbTotalDeCritere; ++nbEventSource) {
                JCheckBox eTarget = (JCheckBox)selectedEventHashMap.get(nbEventTarget);
                JCheckBox eSource = (JCheckBox)selectedEventHashMap.get(nbEventSource);
                if (!eTarget.isSelected() || !eSource.isSelected()) continue;
                probaProposee = meanAnimalProba4_8[nbEventSource][nbEventTarget];
                stddevPropose = stddevAnimalProba4_8[nbEventSource][nbEventTarget];
                ArrayList eventResultListClone = (ArrayList)eventResultList.clone();
                for (EventResult resultClient : eventResultListClone) {
                    if (!(resultClient.proba < probaProposee)) continue;
                    eventResultList.remove(resultClient);
                    break;
                }
                if (eventResultList.size() >= MAX_NUMBER_OF_CANDIDATE) continue;
                EventResult result = new EventResult(nbEventSource, nbEventTarget, probaProposee, stddevPropose, "green");
                eventResultList.add(result);
            }
            resultatParSource4_8.add(eventResultList);
        }
        boolean FORCE_LOCATION = forceLocation.isSelected();
        System.out.println("Put the following script in GraphViz:");
        if (FORCE_LOCATION) {
            System.out.println("/* @command = neato **/");
        }
        System.out.println("digraph  {");
        System.out.println("splines=true;");
        if (FORCE_LOCATION) {
            double x = 0.0;
            double y = 0.0;
            double angle = 0.0;
            for (int eventIndex = 0; eventIndex < nbTotalDeCritere; ++eventIndex) {
                JCheckBox eventBox = (JCheckBox)selectedEventHashMap.get(eventIndex);
                if (!eventBox.isSelected()) continue;
                x = 300.0 + Math.cos(angle) * 300.0;
                y = 300.0 + Math.sin(angle) * 300.0;
                String criteriaName = this.animalList.get((int)0).animal.eventTimeLineList.get((int)eventIndex).criteriaName;
                String result = "\"" + criteriaName + "\"";
                result = result + "[";
                result = result + " pos=\"" + x + "," + y + "!\" ";
                result = result + " shape=\"box\" ";
                result = result + " width=\"2\" ";
                result = result + "]";
                System.out.println(result);
                angle += 0.4487989505128276;
            }
        }
        for (int sourceList = 0; sourceList < nbTotalDeCritere; ++sourceList) {
            ArrayList eventResultList0_4 = (ArrayList)resultatParSource0_4.get(sourceList);
            ArrayList eventResultList4_8 = (ArrayList)resultatParSource4_8.get(sourceList);
            ArrayList<EventResult> finalResult = this.createCommonList(eventResultList0_4, eventResultList4_8);
            for (EventResult eventResult : finalResult) {
                if (!eventResult.enable || !(eventResult.proba >= 0.1f)) continue;
                System.out.println(eventResult);
            }
        }
        System.out.println("}");
    }

    ArrayList<EventResult> createCommonList(ArrayList<EventResult> eventResultList0_4, ArrayList<EventResult> eventResultList4_8) {
        ArrayList<EventResult> finalResult = new ArrayList<EventResult>();
        for (EventResult eventResult0_4 : eventResultList0_4) {
            finalResult.add(eventResult0_4);
        }
        for (EventResult eventResult4_8 : eventResultList4_8) {
            finalResult.add(eventResult4_8);
        }
        for (EventResult eventResultA : finalResult) {
            for (EventResult eventResultB : finalResult) {
                if (eventResultA == eventResultB || !eventResultA.enable || !eventResultB.enable || eventResultA.eventSource != eventResultB.eventSource || eventResultA.eventTarget != eventResultB.eventTarget || !this.checkIfProbaOverlap(eventResultA, eventResultB)) continue;
                eventResultA.proba = (eventResultA.proba + eventResultB.proba) / 2.0f;
                eventResultB.enable = false;
                eventResultA.color = "black";
            }
        }
        return finalResult;
    }

    private boolean checkIfProbaOverlap(EventResult eventResultA, EventResult eventResultB) {
        float sigma = 1.0f;
        float borneMinA = eventResultA.proba - eventResultA.stddev * sigma;
        float borneMaxA = eventResultA.proba + eventResultA.stddev * sigma;
        float borneMinB = eventResultB.proba - eventResultB.stddev * sigma;
        float borneMaxB = eventResultB.proba + eventResultB.stddev * sigma;
        if (borneMinA > borneMinB && borneMinA < borneMaxB) {
            return true;
        }
        return borneMaxA > borneMinB && borneMaxA < borneMaxB;
    }

    public static String keepFirstChars(String s) {
        int MAXSIZE = 20;
        if (s.length() > MAXSIZE) {
            s = s.substring(0, MAXSIZE);
        }
        return s;
    }

    void exportAllData() {
        System.out.println("export all data in pool to excel.");
        JTextField startTextField = new JTextField("0");
        JTextField endTextField = new JTextField("8");
        ActionDialog actionDialog = new ActionDialog("Select range (in minutes)");
        actionDialog.getMainPanel().setLayout(new BoxLayout(actionDialog.getMainPanel(), 3));
        actionDialog.getMainPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("start (minutes)"), startTextField}));
        actionDialog.getMainPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("end (minutes)"), endTextField}));
        actionDialog.pack();
        actionDialog.setLocationRelativeTo(null);
        actionDialog.setVisible(true);
        if (actionDialog.isCanceled()) {
            return;
        }
        float startMinute = Float.parseFloat(startTextField.getText());
        float endMinute = Float.parseFloat(endTextField.getText());
        String saveFileName = SaveDialog.chooseFile((String)"Save xls file", (String)"", (String)"Mice Profiler - all data", (String)".xls");
        if (saveFileName == null) {
            return;
        }
        XlsManager xls = null;
        try {
            xls = new XlsManager(saveFileName);
            xls.createNewPage("Data in pool");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        xls.createNewPage("Results");
        int cursorY = 0;
        for (EventSelector eventSelector : this.eventSelectorList) {
            String eventTitle = this.animalList.get((int)0).animal.eventTimeLineList.get((int)eventSelector.eventNumber).criteriaName;
            xls.setLabel(0, cursorY, "Event #" + eventSelector.eventNumber, Colour.YELLOW);
            xls.setLabel(0, ++cursorY, eventTitle);
            cursorY += 2;
            cursorY = this.exportXLSPool(1, eventSelector, cursorY, xls, startMinute, endMinute);
            cursorY += 3;
            cursorY = this.exportXLSPool(2, eventSelector, cursorY, xls, startMinute, endMinute);
            cursorY += 4;
        }
        xls.SaveAndClose();
    }

    int exportXLSPool(int pool, EventSelector eventSelector, int cursorY, XlsManager xls, float startMinute, float endMinute) {
        float halfMinute = (endMinute + startMinute) / 2.0f;
        xls.setLabel(0, cursorY, "p" + pool);
        xls.setLabel(1, cursorY, "nb event from " + startMinute + " to " + halfMinute + " minutes");
        xls.setLabel(2, cursorY, "nb event from " + halfMinute + " to " + endMinute + " minutes");
        xls.setLabel(3, cursorY, "nb event from " + startMinute + " to " + endMinute + " minutes");
        xls.setLabel(4, cursorY, "length of event from " + startMinute + " to " + halfMinute + " minutes");
        xls.setLabel(5, cursorY, "length of event from " + halfMinute + " to " + endMinute + " minutes");
        xls.setLabel(6, cursorY, "length of event from " + startMinute + " to " + endMinute + " minutes");
        float fps = Float.parseFloat(this.fpsTextField.getText());
        ++cursorY;
        for (AnimalPoolSelector animalSelector : this.animalList) {
            if ((pool != 1 || !animalSelector.pool1.isSelected()) && (pool != 2 || !animalSelector.pool2.isSelected()) || !animalSelector.enable.isSelected()) continue;
            xls.setLabel(0, cursorY, animalSelector.animal.animalName);
            Animal animal = animalSelector.animal;
            EventTimeLine eventTimeLine = animal.eventTimeLineList.get(eventSelector.eventNumber);
            int nb = 0;
            int length = 0;
            int maxTime = (int)(halfMinute * 60.0f * fps);
            int minTime = (int)(startMinute * 60.0f * fps);
            for (EventCriteria event : eventTimeLine.eventList) {
                if (event.startFrame >= maxTime || event.startFrame < minTime) continue;
                ++nb;
                length += event.getLength();
            }
            xls.setNumber(1, cursorY, (double)nb);
            xls.setNumber(4, cursorY, (double)length);
            nb = 0;
            length = 0;
            int minTime2 = (int)((double)halfMinute * 60.0 * (double)fps);
            int maxTime2 = (int)(endMinute * 60.0f * fps);
            for (EventCriteria event : eventTimeLine.eventList) {
                if (event.startFrame >= maxTime2 || event.startFrame <= minTime2) continue;
                ++nb;
                length += event.getLength();
            }
            xls.setNumber(2, cursorY, (double)nb);
            xls.setNumber(5, cursorY, (double)length);
            nb = 0;
            length = 0;
            minTime2 = (int)((double)startMinute * 60.0 * (double)fps);
            maxTime2 = (int)(endMinute * 60.0f * fps);
            for (EventCriteria event : eventTimeLine.eventList) {
                if (event.startFrame >= maxTime2 || event.startFrame <= minTime2) continue;
                ++nb;
                length += event.getLength();
            }
            xls.setNumber(3, cursorY, (double)nb);
            xls.setNumber(6, cursorY, (double)length);
            ++cursorY;
        }
        return cursorY;
    }

    class AnimalPoolSelector
    implements ActionListener {
        JPanel panel = GuiUtil.generatePanelWithoutBorder();
        Animal animal;
        JCheckBox enable = new JCheckBox("Enable", true);
        JRadioButton pool1 = new JRadioButton("Pool 1");
        JRadioButton pool2 = new JRadioButton("Pool 2");
        JRadioButton noPool = new JRadioButton("no pool", true);
        ButtonGroup poolGroup = new ButtonGroup();
        ButtonGroup carecterizationGroup = new ButtonGroup();

        public AnimalPoolSelector(Animal animal) {
            this.animal = animal;
            this.enable.addActionListener(this);
            this.pool1.addActionListener(this);
            this.pool2.addActionListener(this);
            this.noPool.addActionListener(this);
            this.poolGroup.add(this.pool1);
            this.poolGroup.add(this.pool2);
            this.poolGroup.add(this.noPool);
            int maxSizeString = animal.animalName.length();
            if (maxSizeString > 5) {
                maxSizeString = 5;
            }
            this.enable.setText(animal.animalName.substring(0, maxSizeString));
            this.enable.setToolTipText(animal.animalName);
            this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.enable, this.pool1, this.pool2, this.noPool}));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MiceProfilerLabelAnalyserInternal.this.refreshGraph(false, "");
        }
    }

    class EventSelector
    implements ActionListener {
        JPanel panel = GuiUtil.generatePanelWithoutBorder();
        int eventNumber;
        JCheckBox nbEventCheckBox = new JCheckBox("nb Event");
        JCheckBox lengthCheckBox = new JCheckBox("length");
        JCheckBox densityCheckBox = new JCheckBox("density");
        JLabel criteriaLabel;
        JCheckBox displayDiscreteValueCheckBox = new JCheckBox("discrete Value");

        public EventSelector(int eventNumber, EventTimeLine e) {
            this.eventNumber = eventNumber;
            int maxSizeString = e.criteriaName.length();
            if (maxSizeString > 40) {
                maxSizeString = 40;
            }
            this.criteriaLabel = new JLabel(e.criteriaName.substring(0, maxSizeString));
            this.criteriaLabel.setToolTipText(e.criteriaName);
            if (e.timeLineCategory == TimeLineCategory.USE_BOOLEAN_EVENT) {
                this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.criteriaLabel, this.densityCheckBox, this.nbEventCheckBox, this.lengthCheckBox}));
            }
            if (e.timeLineCategory == TimeLineCategory.USE_DISCRETE_EVENT) {
                this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.criteriaLabel, this.displayDiscreteValueCheckBox}));
            }
            this.densityCheckBox.addActionListener(this);
            this.nbEventCheckBox.addActionListener(this);
            this.lengthCheckBox.addActionListener(this);
            this.displayDiscreteValueCheckBox.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MiceProfilerLabelAnalyserInternal.this.refreshGraph(false, "");
        }
    }

    static enum Criteria {
        NB_EVENT,
        LENGTH_EVENT,
        DISCRETE_VALUE,
        DENSITY_VALUE;

    }

    class EventResult {
        boolean enable = true;
        float stddev;
        int eventSource;
        int eventTarget;
        float proba;
        String color;

        public EventResult(int eventSource, int eventTarget, float proba, float stddev, String color) {
            this.eventSource = eventSource;
            this.eventTarget = eventTarget;
            this.stddev = stddev;
            this.proba = proba;
            this.color = color;
        }

        public String toString() {
            String result = "";
            result = result + "\"" + MiceProfilerLabelAnalyserInternal.keepFirstChars(MiceProfilerLabelAnalyserInternal.this.animalList.get((int)0).animal.eventTimeLineList.get((int)this.eventSource).criteriaName) + "\"";
            result = result + "->";
            result = result + "\"" + MiceProfilerLabelAnalyserInternal.keepFirstChars(MiceProfilerLabelAnalyserInternal.this.animalList.get((int)0).animal.eventTimeLineList.get((int)this.eventTarget).criteriaName) + "\"";
            result = result + " ";
            result = result + "[ ";
            result = result + "color=\"" + this.color + "\"";
            result = result + " style=\"setlinewidth(" + this.proba * 5.0f + ")\"]";
            result = result + ";";
            return result;
        }

        public String getEvents() {
            String result = "";
            result = result + "\"" + MiceProfilerLabelAnalyserInternal.keepFirstChars(MiceProfilerLabelAnalyserInternal.this.animalList.get((int)0).animal.eventTimeLineList.get((int)this.eventSource).criteriaName) + "\"";
            result = result + ";";
            result = result + "\"" + MiceProfilerLabelAnalyserInternal.keepFirstChars(MiceProfilerLabelAnalyserInternal.this.animalList.get((int)0).animal.eventTimeLineList.get((int)this.eventTarget).criteriaName) + "\"";
            result = result + ";";
            return result;
        }
    }

    class ProbaResult {
        float stddev;
        float proba;
        int startFrame;

        public ProbaResult(float proba, float stddev, int startFrame) {
            this.stddev = stddev;
            this.proba = proba;
            this.startFrame = startFrame;
        }
    }
}

