/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public class SpringyAngleJoint
implements Joint {
    private Vector2f anchor1;
    private Vector2f anchor2;
    private Body body1;
    private Body body2;
    private float compressConstant;
    private float originalAngle;

    public SpringyAngleJoint(Body body1, Body body2, Vector2f anchor1, Vector2f anchor2, float compressConstant, float originalAngle) {
        this.body1 = body1;
        this.body2 = body2;
        this.anchor1 = anchor1;
        this.anchor2 = anchor2;
        this.compressConstant = compressConstant;
        this.originalAngle = originalAngle;
    }

    @Override
    public void applyImpulse() {
    }

    @Override
    public Body getBody1() {
        return this.body1;
    }

    @Override
    public Body getBody2() {
        return this.body2;
    }

    @Override
    public void preStep(float invDT) {
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        Vector2f r1 = MathUtil.mul(rot1, this.anchor1);
        Vector2f r2 = MathUtil.mul(rot2, this.anchor2);
        Vector2f p1 = new Vector2f(this.body1.getPosition());
        p1.add(r1);
        Vector2f p2 = new Vector2f(this.body2.getPosition());
        p2.add(r2);
        Vector2f dp = new Vector2f(p2);
        dp.sub(p1);
        float length = dp.length();
        Vector2f V = new Vector2f((float)Math.cos(this.originalAngle + this.body1.getRotation()), (float)Math.sin(this.originalAngle + this.body1.getRotation()));
        Vector2f ndp = new Vector2f(dp);
        ndp.normalise();
        float torq = (float)Math.asin(MathUtil.cross(ndp, V)) * this.compressConstant / invDT;
        float P = torq / length;
        Vector2f n = new Vector2f(ndp.y, -ndp.x);
        Vector2f impulse = new Vector2f(n);
        impulse.scale(P);
        if (!this.body1.isStatic()) {
            Vector2f accum1 = new Vector2f(impulse);
            accum1.scale(this.body1.getInvMass());
            this.body1.adjustVelocity(accum1);
            this.body1.adjustAngularVelocity(this.body1.getInvI() * MathUtil.cross(dp, impulse));
        }
        if (!this.body2.isStatic()) {
            Vector2f accum2 = new Vector2f(impulse);
            accum2.scale(-this.body2.getInvMass());
            this.body2.adjustVelocity(accum2);
            this.body2.adjustAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(r2, impulse)));
        }
    }

    @Override
    public void setRelaxation(float relaxation) {
    }
}

