/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public class DistanceJoint
implements Joint {
    protected float accumulatedImpulse;
    protected Vector2f anchor1;
    protected Vector2f anchor2;
    protected float bias;
    protected Body body1;
    protected Body body2;
    private float distant;
    protected Vector2f dp;
    protected Matrix2f M;
    protected Vector2f r1;
    protected Vector2f r2;
    protected float sc;

    public DistanceJoint(Body body1, Body body2, Vector2f anchor1, Vector2f anchor2, float distant) {
        this.body1 = body1;
        this.body2 = body2;
        this.anchor1 = anchor1;
        this.anchor2 = anchor2;
        this.distant = distant * distant;
    }

    @Override
    public void applyImpulse() {
        Vector2f dv = new Vector2f(this.body2.getVelocity());
        dv.add(MathUtil.cross(this.body2.getAngularVelocity(), this.r2));
        dv.sub(this.body1.getVelocity());
        dv.sub(MathUtil.cross(this.body1.getAngularVelocity(), this.r1));
        float ju = -dv.dot(this.dp) + this.bias;
        float p = ju / this.sc;
        Vector2f impulse = new Vector2f(this.dp);
        impulse.scale(p);
        if (!this.body1.isStatic()) {
            Vector2f accum1 = new Vector2f(impulse);
            accum1.scale(-this.body1.getInvMass());
            this.body1.adjustVelocity(accum1);
            this.body1.adjustAngularVelocity(-(this.body1.getInvI() * MathUtil.cross(this.r1, impulse)));
        }
        if (!this.body2.isStatic()) {
            Vector2f accum2 = new Vector2f(impulse);
            accum2.scale(this.body2.getInvMass());
            this.body2.adjustVelocity(accum2);
            this.body2.adjustAngularVelocity(this.body2.getInvI() * MathUtil.cross(this.r2, impulse));
        }
        this.accumulatedImpulse += p;
    }

    public Vector2f getAnchor1() {
        return this.anchor1;
    }

    public Vector2f getAnchor2() {
        return this.anchor2;
    }

    @Override
    public Body getBody1() {
        return this.body1;
    }

    @Override
    public Body getBody2() {
        return this.body2;
    }

    @Override
    public void preStep(float invDT) {
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        this.r1 = MathUtil.mul(rot1, this.anchor1);
        this.r2 = MathUtil.mul(rot2, this.anchor2);
        Matrix2f K1 = new Matrix2f();
        K1.col1.x = this.body1.getInvMass() + this.body2.getInvMass();
        K1.col2.x = 0.0f;
        K1.col1.y = 0.0f;
        K1.col2.y = this.body1.getInvMass() + this.body2.getInvMass();
        Matrix2f K2 = new Matrix2f();
        K2.col1.x = this.body1.getInvI() * this.r1.y * this.r1.y;
        K2.col2.x = -this.body1.getInvI() * this.r1.x * this.r1.y;
        K2.col1.y = -this.body1.getInvI() * this.r1.x * this.r1.y;
        K2.col2.y = this.body1.getInvI() * this.r1.x * this.r1.x;
        Matrix2f K3 = new Matrix2f();
        K3.col1.x = this.body2.getInvI() * this.r2.y * this.r2.y;
        K3.col2.x = -this.body2.getInvI() * this.r2.x * this.r2.y;
        K3.col1.y = -this.body2.getInvI() * this.r2.x * this.r2.y;
        K3.col2.y = this.body2.getInvI() * this.r2.x * this.r2.x;
        Matrix2f K = MathUtil.add(MathUtil.add(K1, K2), K3);
        Vector2f p1 = new Vector2f(this.body1.getPosition());
        p1.add(this.r1);
        Vector2f p2 = new Vector2f(this.body2.getPosition());
        p2.add(this.r2);
        this.dp = new Vector2f(p2);
        this.dp.sub(p1);
        float biasFactor = 0.3f;
        this.bias = biasFactor * (-this.dp.lengthSquared() + this.distant);
        this.dp.normalise();
        this.sc = MathUtil.mul(K, this.dp).dot(this.dp);
        Vector2f impulse = new Vector2f(this.dp);
        impulse.scale(this.accumulatedImpulse);
        if (!this.body1.isStatic()) {
            Vector2f accum1 = new Vector2f(impulse);
            accum1.scale(-this.body1.getInvMass());
            this.body1.adjustVelocity(accum1);
            this.body1.adjustAngularVelocity(-(this.body1.getInvI() * MathUtil.cross(this.r1, impulse)));
        }
        if (!this.body2.isStatic()) {
            Vector2f accum2 = new Vector2f(impulse);
            accum2.scale(this.body2.getInvMass());
            this.body2.adjustVelocity(accum2);
            this.body2.adjustAngularVelocity(this.body2.getInvI() * MathUtil.cross(this.r2, impulse));
        }
    }

    @Override
    public void setRelaxation(float relaxation) {
    }
}

