/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.Vector2f;
import net.phys2d.raw.BasicJoint;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public strictfp class FixedJoint
implements Joint {
    public static int NEXT_ID = 0;
    private Body body1;
    private Body body2;
    private int id = NEXT_ID++;
    private BasicJoint joint1;
    private BasicJoint joint2;

    public FixedJoint(Body b1, Body b2) {
        this.set(b1, b2);
    }

    @Override
    public void setRelaxation(float relaxation) {
        this.joint1.setRelaxation(relaxation);
        this.joint2.setRelaxation(relaxation);
    }

    @Override
    public Body getBody1() {
        return this.body1;
    }

    @Override
    public Body getBody2() {
        return this.body2;
    }

    public void set(Body b1, Body b2) {
        this.body1 = b1;
        this.body2 = b2;
        this.joint1 = new BasicJoint(b1, b2, new Vector2f(b1.getPosition()));
        this.joint2 = new BasicJoint(b2, b1, new Vector2f(b2.getPosition()));
    }

    @Override
    public void preStep(float invDT) {
        this.joint1.preStep(invDT);
        this.joint2.preStep(invDT);
    }

    @Override
    public void applyImpulse() {
        this.joint1.applyImpulse();
        this.joint2.applyImpulse();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other.getClass() == this.getClass()) {
            return ((FixedJoint)other).id == this.id;
        }
        return false;
    }
}

