/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Line;

public strictfp class LineBoxCollider
implements Collider {
    private static LineBoxCollider single = new LineBoxCollider();

    public static LineBoxCollider create() {
        return single;
    }

    private float getProp(Vector2f src, Vector2f den) {
        if (den.getX() == 0.0f && den.getY() == 0.0f) {
            return 0.0f;
        }
        if (den.getX() != 0.0f) {
            return src.getX() / den.getX();
        }
        return src.getY() / den.getY();
    }

    @Override
    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        int numContacts = 0;
        Line line = (Line)bodyA.getShape();
        Box box = (Box)bodyB.getShape();
        Vector2f lineVec = new Vector2f(line.getDX(), line.getDY());
        lineVec.normalise();
        Vector2f axis = new Vector2f(-line.getDY(), line.getDX());
        axis.normalise();
        Vector2f res = new Vector2f();
        line.getStart().projectOntoUnit(axis, res);
        float linePos = this.getProp(res, axis);
        Vector2f c = MathUtil.sub(bodyB.getPosition(), bodyA.getPosition());
        c.projectOntoUnit(axis, res);
        float centre = this.getProp(res, axis);
        Vector2f[] pts = box.getPoints(bodyB.getPosition(), bodyB.getRotation());
        float[] tangent = new float[4];
        float[] proj = new float[4];
        int outOfRange = 0;
        for (int i = 0; i < 4; ++i) {
            pts[i].sub(bodyA.getPosition());
            pts[i].projectOntoUnit(axis, res);
            tangent[i] = this.getProp(res, axis);
            pts[i].projectOntoUnit(lineVec, res);
            proj[i] = this.getProp(res, new Vector2f(line.getDX(), line.getDY()));
            if (!(proj[i] >= 1.0f) && !(proj[i] <= 0.0f)) continue;
            ++outOfRange;
        }
        if (outOfRange == 4) {
            return 0;
        }
        Vector2f normal = new Vector2f(axis);
        if (centre < linePos) {
            if (!line.blocksInnerEdge()) {
                return 0;
            }
            normal.scale(-1.0f);
            for (int i = 0; i < 4; ++i) {
                Vector2f pos;
                float right;
                float left;
                Line rightLine;
                Line leftLine;
                Vector2f onAxis;
                if (!(tangent[i] > linePos)) continue;
                if (proj[i] < 0.0f) {
                    onAxis = new Vector2f();
                    leftLine = new Line(this.getPt(pts, i - 1), pts[i]);
                    rightLine = new Line(this.getPt(pts, i + 1), pts[i]);
                    leftLine.getClosestPoint(line.getStart(), res);
                    res.projectOntoUnit(axis, onAxis);
                    left = this.getProp(onAxis, axis);
                    rightLine.getClosestPoint(line.getStart(), res);
                    res.projectOntoUnit(axis, onAxis);
                    right = this.getProp(onAxis, axis);
                    if (!(left > 0.0f) || !(right > 0.0f)) continue;
                    pos = new Vector2f(bodyA.getPosition());
                    pos.add(line.getStart());
                    this.resolveEndPointCollision(pos, bodyA, bodyB, normal, leftLine, rightLine, contacts[numContacts], i);
                    ++numContacts;
                    continue;
                }
                if (proj[i] > 1.0f) {
                    onAxis = new Vector2f();
                    leftLine = new Line(this.getPt(pts, i - 1), pts[i]);
                    rightLine = new Line(this.getPt(pts, i + 1), pts[i]);
                    leftLine.getClosestPoint(line.getEnd(), res);
                    res.projectOntoUnit(axis, onAxis);
                    left = this.getProp(onAxis, axis);
                    rightLine.getClosestPoint(line.getEnd(), res);
                    res.projectOntoUnit(axis, onAxis);
                    right = this.getProp(onAxis, axis);
                    if (!(left > 0.0f) || !(right > 0.0f)) continue;
                    pos = new Vector2f(bodyA.getPosition());
                    pos.add(line.getEnd());
                    this.resolveEndPointCollision(pos, bodyA, bodyB, normal, leftLine, rightLine, contacts[numContacts], i);
                    ++numContacts;
                    continue;
                }
                pts[i].projectOntoUnit(lineVec, res);
                res.add(bodyA.getPosition());
                contacts[numContacts].setSeparation(-(tangent[i] - linePos));
                contacts[numContacts].setPosition(new Vector2f(res));
                contacts[numContacts].setNormal(normal);
                contacts[numContacts].setFeature(new FeaturePair(i));
                ++numContacts;
            }
        } else {
            if (!line.blocksOuterEdge()) {
                return 0;
            }
            for (int i = 0; i < 4; ++i) {
                Vector2f pos;
                float right;
                float left;
                Line rightLine;
                Line leftLine;
                Vector2f onAxis;
                if (!(tangent[i] < linePos)) continue;
                if (proj[i] < 0.0f) {
                    onAxis = new Vector2f();
                    leftLine = new Line(this.getPt(pts, i - 1), pts[i]);
                    rightLine = new Line(this.getPt(pts, i + 1), pts[i]);
                    leftLine.getClosestPoint(line.getStart(), res);
                    res.projectOntoUnit(axis, onAxis);
                    left = this.getProp(onAxis, axis);
                    rightLine.getClosestPoint(line.getStart(), res);
                    res.projectOntoUnit(axis, onAxis);
                    right = this.getProp(onAxis, axis);
                    if (!(left < 0.0f) || !(right < 0.0f)) continue;
                    pos = new Vector2f(bodyA.getPosition());
                    pos.add(line.getStart());
                    this.resolveEndPointCollision(pos, bodyA, bodyB, normal, leftLine, rightLine, contacts[numContacts], i);
                    ++numContacts;
                    continue;
                }
                if (proj[i] > 1.0f) {
                    onAxis = new Vector2f();
                    leftLine = new Line(this.getPt(pts, i - 1), pts[i]);
                    rightLine = new Line(this.getPt(pts, i + 1), pts[i]);
                    leftLine.getClosestPoint(line.getEnd(), res);
                    res.projectOntoUnit(axis, onAxis);
                    left = this.getProp(onAxis, axis);
                    rightLine.getClosestPoint(line.getEnd(), res);
                    res.projectOntoUnit(axis, onAxis);
                    right = this.getProp(onAxis, axis);
                    if (!(left < 0.0f) || !(right < 0.0f)) continue;
                    pos = new Vector2f(bodyA.getPosition());
                    pos.add(line.getEnd());
                    this.resolveEndPointCollision(pos, bodyA, bodyB, normal, leftLine, rightLine, contacts[numContacts], i);
                    ++numContacts;
                    continue;
                }
                pts[i].projectOntoUnit(lineVec, res);
                res.add(bodyA.getPosition());
                contacts[numContacts].setSeparation(-(linePos - tangent[i]));
                contacts[numContacts].setPosition(new Vector2f(res));
                contacts[numContacts].setNormal(normal);
                contacts[numContacts].setFeature(new FeaturePair());
                ++numContacts;
            }
        }
        if (numContacts > 2) {
            throw new RuntimeException("LineBoxCollision: > 2 contacts");
        }
        return numContacts;
    }

    private void resolveEndPointCollision(Vector2f pos, Body bodyA, Body bodyB, Vector2f norm, Line leftLine, Line rightLine, Contact contact, int i) {
        Vector2f start = new Vector2f(pos);
        Vector2f end = new Vector2f(start);
        end.add(norm);
        rightLine.move(bodyA.getPosition());
        leftLine.move(bodyA.getPosition());
        Line normLine = new Line(start, end);
        Vector2f rightPoint = normLine.intersect(rightLine);
        Vector2f leftPoint = normLine.intersect(leftLine);
        float dis1 = Float.MAX_VALUE;
        if (rightPoint != null) {
            dis1 = rightPoint.distance(start) - norm.length();
        }
        float dis2 = Float.MAX_VALUE;
        if (leftPoint != null) {
            dis2 = leftPoint.distance(start) - norm.length();
        }
        norm.normalise();
        float dis = Math.min(dis1, dis2);
        contact.setSeparation(-dis);
        contact.setPosition(pos);
        contact.setNormal(norm);
        contact.setFeature(new FeaturePair(i));
    }

    private Vector2f getPt(Vector2f[] pts, int index) {
        if (index < 0) {
            index += pts.length;
        }
        if (index >= pts.length) {
            index -= pts.length;
        }
        return pts[index];
    }
}

