/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import java.util.Iterator;
import net.phys2d.math.MathUtil;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.EdgeSweep;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.collide.Intersection;
import net.phys2d.raw.collide.IntersectionGatherer;
import net.phys2d.raw.collide.PenetrationSweep;
import net.phys2d.raw.shapes.Polygon;

public class PolygonPolygonCollider
implements Collider {
    @Override
    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        Polygon polyA = (Polygon)bodyA.getShape();
        Polygon polyB = (Polygon)bodyB.getShape();
        Vector2f[] vertsA = polyA.getVertices(bodyA.getPosition(), bodyA.getRotation());
        Vector2f[] vertsB = polyB.getVertices(bodyB.getPosition(), bodyB.getRotation());
        Vector2f centroidA = new Vector2f(polyA.getCentroid());
        centroidA.add(bodyA.getPosition());
        Vector2f centroidB = new Vector2f(polyB.getCentroid());
        centroidB.add(bodyB.getPosition());
        Iterator<EdgeSweep.EdgePairs.EdgePair> collEdgeCands = this.getCollisionCandidates(vertsA, vertsB, centroidA, centroidB);
        Intersection[][] intersections = this.getIntersectionPairs(vertsA, vertsB, collEdgeCands);
        return this.populateContacts(contacts, vertsA, vertsB, intersections);
    }

    public Intersection[][] getIntersectionPairs(Vector2f[] vertsA, Vector2f[] vertsB, Iterator<EdgeSweep.EdgePairs.EdgePair> collEdgeCands) {
        if (!collEdgeCands.hasNext()) {
            return new Intersection[0][2];
        }
        IntersectionGatherer fpl = new IntersectionGatherer(vertsA, vertsB);
        while (collEdgeCands.hasNext()) {
            EdgeSweep.EdgePairs.EdgePair pair = collEdgeCands.next();
            fpl.intersect(pair.a, pair.b);
        }
        return fpl.getIntersectionPairs();
    }

    public int populateContacts(Contact[] contacts, Vector2f[] vertsA, Vector2f[] vertsB, Intersection[][] intersections) {
        if (intersections.length == 0) {
            return 0;
        }
        int noContacts = 0;
        for (int i = 0; i < intersections.length; ++i) {
            if (noContacts >= contacts.length) {
                return contacts.length;
            }
            if (intersections[i].length == 2 && noContacts < contacts.length - 1) {
                this.setContactPair(contacts[noContacts], contacts[noContacts + 1], intersections[i][0], intersections[i][1], vertsA, vertsB);
                noContacts += 2;
                continue;
            }
            if (intersections[i].length != 1) continue;
            this.setContact(contacts[noContacts], intersections[i][0], vertsA, vertsB);
            ++noContacts;
        }
        return noContacts;
    }

    public void setContact(Contact contact, Intersection intersection, Vector2f[] vertsA, Vector2f[] vertsB) {
        Vector2f startA = vertsA[intersection.edgeA];
        Vector2f endA = vertsA[(intersection.edgeA + 1) % vertsA.length];
        Vector2f startB = vertsB[intersection.edgeB];
        Vector2f endB = vertsB[(intersection.edgeB + 1) % vertsB.length];
        Vector2f normal = MathUtil.getNormal(startA, endA);
        normal.sub(MathUtil.getNormal(startB, endB));
        normal.normalise();
        contact.setNormal(normal);
        contact.setSeparation(0.0f);
        contact.setFeature(new FeaturePair(intersection.edgeA, intersection.edgeB, 0, 0));
        contact.setPosition(intersection.position);
    }

    public void setContactPair(Contact contact1, Contact contact2, Intersection in, Intersection out, Vector2f[] vertsA, Vector2f[] vertsB) {
        Vector2f entryPoint = in.position;
        Vector2f exitPoint = out.position;
        Vector2f normal = MathUtil.getNormal(entryPoint, exitPoint);
        FeaturePair feature = new FeaturePair(in.edgeA, in.edgeB, out.edgeA, out.edgeB);
        float separation = -PenetrationSweep.getPenetrationDepth(in, out, normal, vertsA, vertsB);
        contact1.setSeparation(separation /= 2.0f);
        contact1.setNormal(normal);
        contact1.setPosition(entryPoint);
        contact1.setFeature(feature);
        contact2.setSeparation(separation);
        contact2.setNormal(normal);
        contact2.setPosition(exitPoint);
        contact2.setFeature(feature);
    }

    public Iterator<EdgeSweep.EdgePairs.EdgePair> getCollisionCandidates(EdgeSweep sweep, Vector2f[] vertsA, Vector2f[] vertsB) {
        sweep.addVerticesToSweep(true, vertsA);
        sweep.addVerticesToSweep(false, vertsB);
        return sweep.getOverlappingEdges();
    }

    public Iterator<EdgeSweep.EdgePairs.EdgePair> getCollisionCandidates(Vector2f[] vertsA, Vector2f[] vertsB, Vector2f sweepDirStart, Vector2f sweepDirEnd) {
        Vector2f sweepDir = new Vector2f(sweepDirEnd);
        sweepDir.sub(sweepDirStart);
        return this.getCollisionCandidates(new EdgeSweep(sweepDir), vertsA, vertsB);
    }
}

