/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public class AngleJoint
implements Joint {
    private float rotateA;
    private float rotateB;
    private Body body1;
    private Body body2;
    private Vector2f anchor1;
    private Vector2f anchor2;
    private float accumulateImpulse;
    private float restituteAngular;
    private int bounceSide;
    private float dlength2;
    private float K;
    private Vector2f ndp;
    private Vector2f dp;
    private Vector2f n;
    private final int BOUNCE_LOWER = -1;
    private final int BOUNCE_NONE = 0;
    private final int BOUNCE_HIGHER = 1;
    float restitution;
    private Vector2f R;

    public AngleJoint(Body body1, Body body2, Vector2f anchor1, Vector2f anchor2, float rotateA, float rotateB) {
        this(body1, body2, anchor1, anchor2, rotateA, rotateB, 0.0f);
    }

    public AngleJoint(Body body1, Body body2, Vector2f anchor1, Vector2f anchor2, float rotateA, float rotateB, float restitution) {
        this.body1 = body1;
        this.body2 = body2;
        this.rotateA = rotateA;
        this.rotateB = rotateB;
        this.anchor1 = anchor1;
        this.anchor2 = anchor2;
        this.restitution = restitution;
    }

    @Override
    public void applyImpulse() {
        float newImpulse;
        if (this.bounceSide == 0) {
            return;
        }
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        Vector2f r1 = MathUtil.mul(rot1, this.anchor1);
        Vector2f r2 = MathUtil.mul(rot2, this.anchor2);
        Vector2f relativeVelocity = new Vector2f(this.body2.getVelocity());
        relativeVelocity.add(MathUtil.cross(r2, this.body2.getAngularVelocity()));
        relativeVelocity.sub(this.body1.getVelocity());
        relativeVelocity.sub(MathUtil.cross(r1, this.body1.getAngularVelocity()));
        float rv = MathUtil.cross(this.dp, relativeVelocity) / this.dlength2 - this.body1.getAngularVelocity();
        rv = this.restituteAngular - rv;
        float p = rv / this.K;
        float oldImpulse = this.accumulateImpulse;
        if (this.bounceSide == 1) {
            newImpulse = this.accumulateImpulse + p > 0.0f ? this.accumulateImpulse + p : 0.0f;
            p = newImpulse - oldImpulse;
        } else {
            newImpulse = this.accumulateImpulse + p < 0.0f ? this.accumulateImpulse + p : 0.0f;
            p = newImpulse - oldImpulse;
        }
        this.accumulateImpulse = newImpulse;
        Vector2f impulse = new Vector2f(this.n);
        impulse.scale(p);
        if (!this.body1.isStatic()) {
            Vector2f accum1 = new Vector2f(impulse);
            accum1.scale(this.body1.getInvMass());
            this.body1.adjustVelocity(accum1);
            this.body1.adjustAngularVelocity(this.body1.getInvI() * MathUtil.cross(this.R, impulse));
        }
        if (!this.body2.isStatic()) {
            Vector2f accum2 = new Vector2f(impulse);
            accum2.scale(-this.body2.getInvMass());
            this.body2.adjustVelocity(accum2);
            this.body2.adjustAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(r2, impulse)));
        }
    }

    @Override
    public Body getBody1() {
        return this.body1;
    }

    @Override
    public Body getBody2() {
        return this.body2;
    }

    @Override
    public void preStep(float invDT) {
        float biasFactor = 0.005f;
        float biasImpulse = 0.0f;
        float RA = this.body1.getRotation() + this.rotateA;
        float RB = this.body1.getRotation() + this.rotateB;
        Vector2f VA = new Vector2f((float)Math.cos(RA), (float)Math.sin(RA));
        Vector2f VB = new Vector2f((float)Math.cos(RB), (float)Math.sin(RB));
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        Vector2f r1 = MathUtil.mul(rot1, this.anchor1);
        Vector2f r2 = MathUtil.mul(rot2, this.anchor2);
        Vector2f p1 = new Vector2f(this.body1.getPosition());
        p1.add(r1);
        Vector2f p2 = new Vector2f(this.body2.getPosition());
        p2.add(r2);
        this.dp = new Vector2f(p2);
        this.dp.sub(p1);
        this.dlength2 = this.dp.lengthSquared();
        this.ndp = new Vector2f(this.dp);
        this.ndp.normalise();
        this.R = new Vector2f(r1);
        this.R.add(this.dp);
        Vector2f relativeVelocity = new Vector2f(this.body2.getVelocity());
        relativeVelocity.add(MathUtil.cross(r2, this.body2.getAngularVelocity()));
        relativeVelocity.sub(this.body1.getVelocity());
        relativeVelocity.sub(MathUtil.cross(r1, this.body1.getAngularVelocity()));
        this.n = new Vector2f(-this.ndp.y, this.ndp.x);
        Vector2f v1 = new Vector2f(this.n);
        v1.scale(-this.body2.getInvMass() - this.body1.getInvMass());
        Vector2f v2 = MathUtil.cross(MathUtil.cross(r2, this.n), r2);
        v2.scale(-this.body2.getInvI());
        Vector2f v3 = MathUtil.cross(MathUtil.cross(this.R, this.n), r1);
        v3.scale(-this.body1.getInvI());
        Vector2f K1 = new Vector2f(v1);
        K1.add(v2);
        K1.add(v3);
        this.K = MathUtil.cross(this.dp, K1) / this.dlength2 - MathUtil.cross(this.R, this.n) * this.body1.getInvI();
        this.restituteAngular = -this.restitution * (MathUtil.cross(this.dp, relativeVelocity) / this.dlength2 - this.body1.getAngularVelocity());
        if (MathUtil.cross(this.ndp, VA) > 0.0f) {
            if (this.bounceSide != -1) {
                this.accumulateImpulse = 0.0f;
            }
            biasImpulse = biasFactor * MathUtil.cross(this.ndp, VA) * invDT;
            this.bounceSide = -1;
            if (this.restituteAngular < 0.0f) {
                this.restituteAngular = 0.0f;
            }
        } else if (MathUtil.cross(VB, this.ndp) > 0.0f) {
            if (this.bounceSide != 1) {
                this.accumulateImpulse = 0.0f;
            }
            biasImpulse = -biasFactor * MathUtil.cross(VB, this.ndp) * invDT;
            this.bounceSide = 1;
            if (this.restituteAngular > 0.0f) {
                this.restituteAngular = 0.0f;
            }
        } else {
            this.accumulateImpulse = 0.0f;
            biasImpulse = 0.0f;
            this.bounceSide = 0;
        }
        this.restituteAngular += biasImpulse;
        Vector2f impulse = new Vector2f(this.n);
        impulse.scale(this.accumulateImpulse);
        if (!this.body1.isStatic()) {
            Vector2f accum1 = new Vector2f(impulse);
            accum1.scale(this.body1.getInvMass());
            this.body1.adjustVelocity(accum1);
            this.body1.adjustAngularVelocity(this.body1.getInvI() * MathUtil.cross(this.R, impulse));
        }
        if (!this.body2.isStatic()) {
            Vector2f accum2 = new Vector2f(impulse);
            accum2.scale(-this.body2.getInvMass());
            this.body2.adjustVelocity(accum2);
            this.body2.adjustAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(r2, impulse)));
        }
    }

    @Override
    public void setRelaxation(float relaxation) {
    }

    public float getRotateA() {
        return this.rotateA;
    }

    public float getRotateB() {
        return this.rotateB;
    }

    public Vector2f getAnchor1() {
        return this.anchor1;
    }

    public Vector2f getAnchor2() {
        return this.anchor2;
    }
}

