/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import java.util.Objects;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.collide.Intersection;

public class PenetrationSweep {
    private Vector2f normal;
    private Vector2f sweepDir;
    private float startDist;
    private float endDist;

    public PenetrationSweep(Vector2f normal, Vector2f sweepDir, Vector2f intersectionStart, Vector2f intersectionEnd) {
        this.normal = normal;
        this.sweepDir = sweepDir;
        this.startDist = intersectionStart.dot(sweepDir);
        this.endDist = intersectionEnd.dot(sweepDir);
    }

    public static float getPenetrationDepth(Intersection in, Intersection out, Vector2f normal, Vector2f[] vertsA, Vector2f[] vertsB) {
        float lowerBound;
        PenetrationSweep ps;
        Vector2f sweepdir = new Vector2f(out.position);
        sweepdir.sub(in.position);
        PenetrationSweep penetrationSweep = ps = new PenetrationSweep(normal, sweepdir, in.position, out.position);
        Objects.requireNonNull(penetrationSweep);
        ContourWalker walkerA = penetrationSweep.new ContourWalker(vertsA, in.edgeA, out.edgeA, false);
        PenetrationSweep penetrationSweep2 = ps;
        Objects.requireNonNull(penetrationSweep2);
        ContourWalker walkerB = penetrationSweep2.new ContourWalker(vertsB, (out.edgeB + 1) % vertsB.length, (in.edgeB + 1) % vertsB.length, true);
        float penetration = 0.0f;
        float upperBound = lowerBound = in.position.dot(normal);
        while (walkerA.hasNext() || walkerB.hasNext()) {
            if (walkerA.hasNext() && (walkerA.getNextDistance() < walkerB.getNextDistance() || !walkerB.hasNext())) {
                walkerA.next();
                if (walkerA.getDistance() < ps.startDist || walkerA.getDistance() > ps.endDist) continue;
                upperBound = walkerA.getPenetration();
                lowerBound = walkerB.getPenetration(walkerA.getDistance());
            } else {
                walkerB.next();
                if (walkerB.getDistance() < ps.startDist || walkerB.getDistance() > ps.endDist) continue;
                upperBound = walkerA.getPenetration(walkerB.getDistance());
                lowerBound = walkerB.getPenetration();
            }
            penetration = Math.max(penetration, upperBound - lowerBound);
        }
        return penetration;
    }

    public class ContourWalker {
        private Vector2f[] verts;
        private int currentVert;
        private int firstVert;
        private int lastVert;
        private boolean isBackwards;
        private float distance;
        private float nextDistance;
        private float penetration;
        private float penetrationDelta;

        public ContourWalker(Vector2f[] verts, int firstVert, int lastVert, boolean isBackwards) {
            if (firstVert < 0 || lastVert < 0) {
                throw new IllegalArgumentException("Vertex numbers cannot be negative.");
            }
            if (firstVert > verts.length || lastVert > verts.length) {
                throw new IllegalArgumentException("The given vertex array doesn't include the first or the last vertex.");
            }
            this.isBackwards = isBackwards;
            this.verts = verts;
            this.firstVert = firstVert;
            this.lastVert = lastVert;
            this.currentVert = isBackwards ? lastVert : firstVert;
            this.distance = verts[this.currentVert].dot(PenetrationSweep.this.sweepDir);
            this.penetration = verts[this.currentVert].dot(PenetrationSweep.this.normal);
            this.calculateNextValues();
        }

        public float getDistance() {
            return this.distance;
        }

        public float getNextDistance() {
            if (this.distance < PenetrationSweep.this.startDist) {
                return Math.min(this.nextDistance, PenetrationSweep.this.startDist);
            }
            if (this.distance < PenetrationSweep.this.endDist) {
                return Math.min(this.nextDistance, PenetrationSweep.this.endDist);
            }
            return this.nextDistance;
        }

        public float getPenetration() {
            return this.penetration;
        }

        public float getPenetration(float distance) {
            return this.penetration + this.penetrationDelta * (distance - this.distance);
        }

        public void next() {
            if (!this.hasNext()) {
                return;
            }
            if (this.distance < PenetrationSweep.this.startDist && this.nextDistance > PenetrationSweep.this.startDist) {
                this.penetration = this.getPenetration(PenetrationSweep.this.startDist);
                this.distance = PenetrationSweep.this.startDist;
                return;
            }
            if (this.distance < PenetrationSweep.this.endDist && this.nextDistance > PenetrationSweep.this.endDist) {
                this.penetration = this.getPenetration(PenetrationSweep.this.endDist);
                this.distance = PenetrationSweep.this.endDist;
                return;
            }
            this.currentVert = this.isBackwards ? (this.currentVert - 1 + this.verts.length) % this.verts.length : (this.currentVert + 1) % this.verts.length;
            this.distance = this.verts[this.currentVert].dot(PenetrationSweep.this.sweepDir);
            this.penetration = this.verts[this.currentVert].dot(PenetrationSweep.this.normal);
            this.calculateNextValues();
        }

        private void calculateNextValues() {
            int nextVert = this.isBackwards ? this.currentVert - 1 : this.currentVert + 1;
            nextVert = (nextVert + this.verts.length) % this.verts.length;
            this.nextDistance = this.verts[nextVert].dot(PenetrationSweep.this.sweepDir);
            this.penetrationDelta = this.verts[nextVert].dot(PenetrationSweep.this.normal) - this.penetration;
            if (this.nextDistance == this.distance) {
                this.penetration += this.penetrationDelta;
                this.penetrationDelta = 0.0f;
            } else {
                this.penetrationDelta /= this.nextDistance - this.distance;
            }
        }

        public boolean hasNext() {
            if (this.distance < PenetrationSweep.this.startDist && this.nextDistance > PenetrationSweep.this.startDist) {
                return true;
            }
            if (this.distance < PenetrationSweep.this.endDist && this.nextDistance > PenetrationSweep.this.endDist) {
                return true;
            }
            int x = this.isBackwards ? this.lastVert - this.currentVert : this.currentVert - this.firstVert;
            x = (x + this.verts.length) % this.verts.length;
            x = (this.lastVert - this.firstVert + this.verts.length) % this.verts.length - x;
            return x > 0;
        }

        public void reverse() {
            this.isBackwards = !this.isBackwards;
            this.calculateNextValues();
        }
    }
}

