/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.shapes;

import net.phys2d.math.MathUtil;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.AABox;
import net.phys2d.raw.shapes.DynamicShape;
import net.phys2d.raw.shapes.Polygon;

public class ConvexPolygon
extends Polygon
implements DynamicShape {
    public ConvexPolygon(ROVector2f[] vertices) {
        if (vertices.length < 3) {
            throw new IllegalArgumentException("A polygon can not have fewer than 3 edges!");
        }
        this.vertices = new Vector2f[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            this.vertices[i] = new Vector2f(vertices[i]);
        }
        if (!super.isConvex()) {
            throw new IllegalArgumentException("The supplied vertices do not represent a convex polygon!");
        }
        float r = this.computeBoundingCircleRadius();
        this.bounds = new AABox(r * 2.0f, r * 2.0f);
        this.area = this.computeArea();
        this.centroid = this.computeCentroid();
    }

    @Override
    public boolean isConvex() {
        return true;
    }

    public boolean contains(Vector2f p) {
        int l = this.vertices.length;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f x = this.vertices[i];
            Vector2f y = this.vertices[(i + 1) % l];
            Vector2f z = p;
            if (!((z.x - x.x) * (y.y - x.y) - (y.x - x.x) * (z.y - x.y) >= 0.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ROVector2f getNearestPoint(ROVector2f p) {
        Vector2f normal;
        float r = Float.MAX_VALUE;
        int m = -1;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f v = new Vector2f(this.vertices[i]);
            v.sub(p);
            float l = v.x * v.x + v.y * v.y;
            if (!(l < r)) continue;
            r = l;
            m = i;
        }
        int length = this.vertices.length;
        Vector2f pm = new Vector2f(p);
        pm.sub(this.vertices[m]);
        Vector2f l1 = new Vector2f(this.vertices[(m - 1 + length) % length]);
        l1.sub(this.vertices[m]);
        Vector2f l2 = new Vector2f(this.vertices[(m + 1) % length]);
        l2.sub(this.vertices[m]);
        if (pm.dot(l1) > 0.0f) {
            normal = MathUtil.getNormal(this.vertices[(m - 1 + length) % length], this.vertices[m]);
        } else if (pm.dot(l2) > 0.0f) {
            normal = MathUtil.getNormal(this.vertices[m], this.vertices[(m + 1) % length]);
        } else {
            return this.vertices[m];
        }
        normal.scale(-pm.dot(normal));
        normal.add(p);
        return normal;
    }

    @Override
    public float getSurfaceFactor() {
        return this.getArea();
    }
}

