/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.type.point.Point5D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import plugins.fab.MiceProfiler.MAnchor2D;

public class ManualHelper
extends Overlay
implements SequenceListener {
    ArrayList<MAnchor2D> activeAnchorList = new ArrayList();
    ArrayList<MAnchor2D> controlPointList = new ArrayList();
    HashMap<Integer, MAnchor2D> time2controlPointMap = new HashMap();
    Color color;
    int previousTPosition = -1;
    MODE currentMode = MODE.NO_ACTION_MODE;
    int mouseNumber;
    Font absoluteFont = new Font("Arial", 1, 15);
    int switchModeKeyCode;
    static ArrayList<ManualHelper> manualHelperList = new ArrayList();
    Sequence sequence;
    double lastFrameUpdate = 0.0;

    public ManualHelper(String name, Color color, int mouseNumber, Sequence sequence) {
        super(name);
        this.sequence = sequence;
        sequence.addListener((SequenceListener)this);
        this.color = color;
        this.mouseNumber = mouseNumber;
        if (mouseNumber < 10) {
            this.switchModeKeyCode = mouseNumber + 48;
        }
        manualHelperList.add(this);
        this.setPriority(Overlay.OverlayPriority.TEXT_NORMAL);
    }

    void setControlPoint(double x, double y, int t) {
        MAnchor2D a = this.time2controlPointMap.get(t);
        if (a == null) {
            a = new MAnchor2D(x, y);
            this.time2controlPointMap.put(t, a);
        } else {
            a.setPosition(x, y);
        }
    }

    MAnchor2D getControlPoint(int t) {
        return this.time2controlPointMap.get(t);
    }

    void drawAbsoluteString(String string, int x, int y, Graphics2D g, IcyCanvas2D canvas) {
        AffineTransform transform = g.getTransform();
        g.transform(canvas.getInverseTransform());
        g.setFont(this.absoluteFont);
        g.drawString(string, x, y);
        g.setTransform(transform);
    }

    public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (e.getKeyCode() == this.switchModeKeyCode) {
            if (this.currentMode == MODE.NO_ACTION_MODE) {
                this.currentMode = MODE.RECORD_MODE;
                for (ManualHelper m : manualHelperList) {
                    if (m == this) continue;
                    m.setMode(MODE.NO_ACTION_MODE);
                }
            } else {
                this.currentMode = MODE.NO_ACTION_MODE;
            }
            e.consume();
            canvas.getSequence().overlayChanged((Overlay)this);
        }
    }

    private void advanceOneFrame(IcyCanvas canvas) {
        if ((double)System.currentTimeMillis() - this.lastFrameUpdate > 200.0) {
            this.lastFrameUpdate = System.currentTimeMillis();
            canvas.getSequence().getFirstViewer().setPositionT(canvas.getSequence().getFirstViewer().getPositionT() + 1);
        }
    }

    public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!(canvas instanceof IcyCanvas2D)) {
            return;
        }
        if (this.currentMode == MODE.RECORD_MODE) {
            this.updatePoint(imagePoint.getX(), imagePoint.getY(), (int)imagePoint.getT());
            e.consume();
            this.advanceOneFrame(canvas);
        }
    }

    public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!(canvas instanceof IcyCanvas2D)) {
            return;
        }
        if (this.currentMode == MODE.RECORD_MODE) {
            this.updatePoint(imagePoint.getX(), imagePoint.getY(), (int)imagePoint.getT());
            e.consume();
            this.advanceOneFrame(canvas);
        }
    }

    private void updatePoint(double x, double y, int t) {
        this.setControlPoint(x, y, t);
    }

    private void setMode(MODE mode) {
        this.currentMode = mode;
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (!(canvas instanceof IcyCanvas2D)) {
            return;
        }
        g.setColor(this.color);
        String modeString = "";
        switch (this.currentMode) {
            case NO_ACTION_MODE: {
                modeString = "Play mode";
                break;
            }
            case RECORD_MODE: {
                modeString = "Record mode";
            }
        }
        this.drawAbsoluteString(this.mouseNumber + " : " + modeString, 20, 20 * this.mouseNumber, g, (IcyCanvas2D)canvas);
        int currentT = canvas.getPositionT();
        int timeWindow = 10;
        for (int t = currentT - timeWindow; t < currentT + timeWindow; ++t) {
            MAnchor2D a1 = this.getControlPoint(t);
            MAnchor2D a2 = this.getControlPoint(t + 1);
            if (a1 == null || a2 == null) continue;
            Line2D.Double line = new Line2D.Double(a1.getPosition(), a2.getPosition());
            g.draw(line);
        }
        MAnchor2D a = this.getControlPoint(currentT);
        if (a != null) {
            Ellipse2D.Double ellipse = new Ellipse2D.Double(a.getPositionX() - 3.0, a.getPositionY() - 3.0, 7.0, 7.0);
            g.fill(ellipse);
        }
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        manualHelperList.remove((Object)this);
    }

    static enum MODE {
        NO_ACTION_MODE,
        RECORD_MODE;

    }
}

