package plugins.lagache.colocTrack;

import java.util.ArrayList;
import java.util.List;

import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;


class ColocDetectionPairResult
{
	Detection a;
	Detection b;
	TrackSegment trackB;
	TrackSegment trackA;
	double distance;
	
	public ColocDetectionPairResult( Detection a, Detection b , TrackSegment ta , TrackSegment tb, double distance) {
		this.a = a;
		this.b = b;
		this.trackA = ta;
		this.trackB = tb;
		this.distance = distance;
	}
	
		
	

	
public static ArrayList<ColocDetectionPairResult> appDetectConstruction(List<DetectionAndTrack> DT1,List<DetectionAndTrack> DT2)
{
	ArrayList<ColocDetectionPairResult> liste_retour = new ArrayList<ColocDetectionPairResult>();
	
	if (DT1.isEmpty()||DT2.isEmpty()){}else{
	int nbdeta=DT1.size();
	int nbdetb=DT2.size();
	double x_a,y_a,x_b,y_b,z_a,z_b;
	for (int p2 = 0; p2 < nbdetb; p2++) {			
		Detection d2 = DT2.get(p2).d;
		if (d2==null){}else
		{
		double min_dist=-1;int indice = -1;			
		x_b=d2.getX();y_b=d2.getY();z_b=d2.getZ();
		
		Detection d1=DT1.get(0).d;
		if (d1==null){}
		else{x_a=d1.getX();y_a=d1.getY();z_a=d1.getZ();		
		if ((z_a<0) || (z_b<0)){
			min_dist=Math.sqrt(Math.pow(x_a-x_b, 2)+Math.pow(y_a-y_b, 2));
		}
		else{min_dist=Math.sqrt(Math.pow(x_a-x_b, 2)+Math.pow(y_a-y_b, 2)+Math.pow(z_a-z_b, 2));}
		indice = 0;}
		for (int p = 1; p < nbdeta; p++) {
		d1=DT1.get(p).d;
		if (d1==null){}
		else{
		x_a=d1.getX();y_a=d1.getY();z_a=d1.getZ();
		double temp;
		if ((z_a<0) || (z_b<0)){temp = Math.sqrt(Math.pow(x_a-x_b, 2)+Math.pow(y_a-y_b, 2));}
		else {temp = Math.sqrt(Math.pow(x_a-x_b, 2)+Math.pow(y_a-y_b, 2)+Math.pow(z_a-z_b, 2));}
		if (temp<min_dist)
			{min_dist=temp;indice=p;}
		}}
		if (indice>-1){
		ColocDetectionPairResult CDPR = new ColocDetectionPairResult(DT1.get(indice).d, DT2.get(p2).d,DT1.get(indice).ts,DT2.get(p2).ts, min_dist);
		liste_retour.add(CDPR);}
		}}
		
		}
	return liste_retour;
}

public static ArrayList<ColocDetectionPairResult> appDetectSelectManual(ArrayList<ColocDetectionPairResult> liste_app_detect,double dist_max)
{ArrayList<ColocDetectionPairResult> liste_retour = new ArrayList<ColocDetectionPairResult>();
for (ColocDetectionPairResult CDPR:liste_app_detect)
{
	if (CDPR.distance<=dist_max)
	{
		liste_retour.add(CDPR);
	}
}	
return liste_retour;
}

	
}