package plugins.lagache.colocTrack;

import icy.file.FileUtil;
import icy.gui.util.GuiUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.type.collection.array.ArrayUtil;
import icy.util.XLSUtil;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;

public class TrackProcessorColocalizer extends PluginTrackManagerProcessor implements ActionListener , SequenceListener {
		
	JButton setTrackSetA = new JButton("");
	JButton setTrackSetB = new JButton("");
	JButton setROIButton = new JButton("");
	//JCheckBox manual = new JCheckBox("Fixed radius of search");
	JTextField value = new JTextField("5");
	
	JButton exportToXLSButton = new JButton("export results to excel");
	
		
	//ArrayList<ROI> selectedROIList = new ArrayList<ROI>();
	ArrayList<TrackSegment> trackSegmentSetA = new ArrayList<TrackSegment>();
	ArrayList<TrackSegment> trackSegmentSetB = new ArrayList<TrackSegment>();
	
	HashMap<Integer, ArrayList<ColocDetectionPairResult>> cdprHashMap = new HashMap<Integer, ArrayList<ColocDetectionPairResult>>();
	HashMap<TrackSegment, TrackInteractWithTrack> tiwtHashMap = new HashMap<TrackSegment, TrackInteractWithTrack>();
	
	double[] results = null;
	
	public TrackProcessorColocalizer() {

		setName("Track Colocolizer");
		panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
		
		
		panel.add( GuiUtil.createLineBoxPanel( setTrackSetA , setTrackSetB ) );
		panel.add( GuiUtil.createCenteredBoldLabel("Search distance for colocalized tracks"));
		panel.add(GuiUtil.createLineBoxPanel(value));
		panel.add( GuiUtil.createLineBoxPanel( exportToXLSButton ) );

		setTrackSetA.addActionListener( this );
		setTrackSetB.addActionListener( this );
		
		exportToXLSButton.addActionListener( this );
		refreshDisplay();
		
	}
		
	@Override
	public void actionPerformed(ActionEvent e) {
		
		if ( e.getSource() == setTrackSetA )
		{
			trackSegmentSetA.clear();
	        for (TrackGroup group : trackPool.getTrackGroupList())
	        {
	            for (TrackSegment trackSegment : group.getTrackSegmentList())
	            {
	            	if ( trackSegment.isAllDetectionSelected() )
	            	{
	            		trackSegmentSetA.add( trackSegment );	
	            	}
	            }
	        }
		}

		if ( e.getSource() == setTrackSetB )
		{
			trackSegmentSetB.clear();
	        for (TrackGroup group : trackPool.getTrackGroupList())
	        {
	            for (TrackSegment trackSegment : group.getTrackSegmentList())
	            {
	            	if ( trackSegment.isAllDetectionSelected() )
	            	{
	            		trackSegmentSetB.add( trackSegment );	
	            	}
	            }
	        }
		}		
						
		if ( e.getSource() == exportToXLSButton )
		{			
			exportToXLS();
			
		}

		refreshDisplay();
		
	}


	
	
	private void exportToXLS() {

		int row = 0;		
		WritableWorkbook WW = null;
		WritableSheet WS = null;					
			JFileChooser chooser = new JFileChooser();chooser.setDialogTitle("Select xls file.");
			int returnVal = chooser.showOpenDialog(null);
			if(returnVal != JFileChooser.APPROVE_OPTION) return;
			File file = chooser.getSelectedFile();
			try {				
				if (!FileUtil.getFileExtension(file.getPath(), false)
						.equalsIgnoreCase("xls"))
					file = new File(file.getPath() + ".xls");
				WW = XLSUtil.loadWorkbookForWrite(file); 
				}							
			 catch (Exception e) {
				e.printStackTrace();
				return;}
			
			WS  = XLSUtil.createNewPage(WW, "Interactions");
			XLSUtil.setCellString(WS, 0, 0, "Date of XLS page:");
			row++;
			XLSUtil.setCellString(WS, 0, row, new Date().toString());			
			row++;
		int cursorY = 0;
		XLSUtil.setCellString(WS, 0 , cursorY, "track A #");
		XLSUtil.setCellString(WS, 1, cursorY, "ini. t of A");
		XLSUtil.setCellString(WS,2 , cursorY, "final. t of A");
		XLSUtil.setCellString(WS,3 , cursorY, "duration of A");
		XLSUtil.setCellString(WS,4 , cursorY, "nb of coloc.");
		XLSUtil.setCellString(WS,5 , cursorY, "track B #");
		XLSUtil.setCellString(WS,6, cursorY, "ini. t of B");
		XLSUtil.setCellString(WS,7 , cursorY, "final. t of B");
		XLSUtil.setCellString(WS,8 , cursorY, "duration of B");
		XLSUtil.setCellString(WS, 9, cursorY, "ini. t of interact.");
		XLSUtil.setCellString(WS,10 , cursorY, "final. t of interact.");
		XLSUtil.setCellString(WS, 11 , cursorY, "duration of interact.");		
		XLSUtil.setCellString(WS,12 , cursorY, "ratio");
		
		for ( TrackSegment tsA : tiwtHashMap.keySet() )//key=temps t			
		{	
			cursorY++;
			//parcourir la liste des tracks B interagissant avec A
			TrackInteractWithTrack tiwt=tiwtHashMap.get(tsA);
			XLSUtil.setCellNumber(WS,0 , cursorY, trackSegmentSetA.indexOf( tsA ) );
			XLSUtil.setCellNumber(WS,1 , cursorY, tsA.getFirstDetection().getT());
			XLSUtil.setCellNumber(WS,2 , cursorY, tsA.getLastDetection().getT());
			XLSUtil.setCellNumber(WS,3 , cursorY, tsA.getLastDetection().getT()-tsA.getFirstDetection().getT());
			XLSUtil.setCellNumber(WS,4 , cursorY, tiwt.tsAssociatedList.size());
													
			if (tiwt.tsAssociatedList==null) {continue;}
			else{
				int cursorX=5;
				for (TrackSegment tsB :tiwt.tsAssociatedList)
				{										
					XLSUtil.setCellNumber(WS,cursorX , cursorY, trackSegmentSetB.indexOf( tsB ) );cursorX++;															
					XLSUtil.setCellNumber(WS,cursorX , cursorY, tsB.getFirstDetection().getT());cursorX++;					
					XLSUtil.setCellNumber(WS,cursorX , cursorY, tsB.getLastDetection().getT());cursorX++;
					XLSUtil.setCellNumber(WS,cursorX , cursorY, tsB.getLastDetection().getT()-tsB.getFirstDetection().getT()+1);cursorX++;
					int last = tiwt.tsAssociatedListHM.get(tsB).size();
					Collections.sort(tiwt.tsAssociatedListHM.get(tsB));
					//xls.setNumber(cursorX , cursorY, Math.min(tiwt.tsAssociatedListHM.get(tsB).get(0),tiwt.tsAssociatedListHM.get(tsB).get(last-1)));cursorX++;
					XLSUtil.setCellNumber(WS,cursorX , cursorY, tiwt.tsAssociatedListHM.get(tsB).get(0));cursorX++;
					XLSUtil.setCellNumber(WS,cursorX , cursorY, tiwt.tsAssociatedListHM.get(tsB).get(last-1));cursorX++;
					double ratio = (double) (tiwt.tsAssociatedListHM.get(tsB).size())/(tiwt.tsAssociatedListHM.get(tsB).get(last-1)-tiwt.tsAssociatedListHM.get(tsB).get(0)+1);
					XLSUtil.setCellNumber(WS,cursorX , cursorY, tiwt.tsAssociatedListHM.get(tsB).get(last-1)-tiwt.tsAssociatedListHM.get(tsB).get(0)+1);cursorX++;
					XLSUtil.setCellNumber(WS,cursorX , cursorY, ratio);cursorX++;
					
				}
			}						
			}
		

		/////////////////////////////////////////////////////////////////
		//export des intensit�s dans une seconde page
		WritableSheet WS2  = XLSUtil.createNewPage(WW, "Intensities Single Track A");
		WritableSheet WS3  = XLSUtil.createNewPage(WW, "Intensities Single Track A (2)");
		WritableSheet WS4  = XLSUtil.createNewPage(WW, "Intensities Single Track A (3)");
		double diskRadius = 3.0;		
		int timeClip = 5;				
		int cntTrack = 1;
		XLSUtil.setCellString(WS2,0, 0, "time");
		XLSUtil.setCellString(WS3,0, 0, "time");
		XLSUtil.setCellString(WS4,0, 0, "time");
////////////////////////////////////////////////////////////////////////////////
for ( TrackSegment tsA : tiwtHashMap.keySet() )//key=temps t			
{	//parcourir la liste des tracks B interagissant avec A pour tester single
	TrackInteractWithTrack tiwt=tiwtHashMap.get(tsA);
	int s = tiwt.tsAssociatedList.size();
	if (s==0) {		
		TrackGroup group = tsA.getOwnerTrackGroup();
		Sequence sequenceA  = group.getSequence();
		TrackAnalysisDisk analysis;
		analysis = new TrackAnalysisDisk(tsA, sequenceA, group.getTrackSegmentList().indexOf(tsA)+"#"+ group.getDescription());
		if (cntTrack<251){XLSUtil.setCellString(WS2,cntTrack, 0, analysis.description);}
		if (cntTrack>250){if (cntTrack<501){XLSUtil.setCellString(WS3,cntTrack-250, 0, analysis.description);}}
		if (cntTrack>500){XLSUtil.setCellString(WS4,cntTrack-500, 0, analysis.description);}		
		int cnt = 0;
		for (int t = Math.max(0, tsA.getFirstDetection().getT()-timeClip); t <= Math.min(sequenceA.getSizeT()-1, tsA.getLastDetection().getT()+timeClip); t++){					 					
			double[][][] imageTab = new double[sequenceA.getSizeZ()][sequenceA.getSizeC()][];		
		for (int z = 0; z < sequenceA.getSizeZ(); z++)
			for (int c = 0; c < sequenceA.getSizeC(); c++)
				imageTab[z][c] = (double[]) ArrayUtil.arrayToDoubleArray(sequenceA.getImage(t, z, c).getDataXY(0), sequenceA.isSignedDataType());	
				analysis.fillAveragingSeriesAtT(t,timeClip, imageTab, diskRadius);							
		//on fait ensuite l'ecriture excel
				if (cntTrack<251){		
		XLSUtil.setCellNumber(WS2,0, t+1, t);
		XLSUtil.setCellNumber(WS2,cntTrack, t+1, analysis.meanIntensity[0].getY(cnt).doubleValue());}
				if (cntTrack>250){if(cntTrack<501){
					XLSUtil.setCellNumber(WS3,0, t+1, t);
					XLSUtil.setCellNumber(WS3,cntTrack-250, t+1, analysis.meanIntensity[0].getY(cnt).doubleValue());}}									
		if (cntTrack>500){
			XLSUtil.setCellNumber(WS4,0, t+1, t);
			XLSUtil.setCellNumber(WS4,cntTrack-500, t+1, analysis.meanIntensity[0].getY(cnt).doubleValue());}					
		cnt++;}
		cntTrack++;}
}

/////////////////////////////////////////////////////////////////
//export des intensit�s couplées dans une troisieme page
WritableSheet WS5  = XLSUtil.createNewPage(WW, "Intensities Coloc Track A");
WritableSheet WS6  = XLSUtil.createNewPage(WW, "Intensities Coloc Track A (2)");
WritableSheet WS7  = XLSUtil.createNewPage(WW, "Intensities Coloc Track A (3)");
int cntTrackbis = 1;
XLSUtil.setCellString(WS5,0, 0, "time");
XLSUtil.setCellString(WS6,0, 0, "time");
XLSUtil.setCellString(WS7,0, 0, "time");
////////////////////////////////////////////////////////////////////////////////
for ( TrackSegment tsA : tiwtHashMap.keySet() )//key=temps t			
{	
//parcourir la liste des tracks B interagissant avec A pour tester single
TrackInteractWithTrack tiwt=tiwtHashMap.get(tsA);
if (tiwt.tsAssociatedList.size()>0.1){		
TrackGroup group = tsA.getOwnerTrackGroup();
Sequence sequenceA  = group.getSequence();
TrackAnalysisDisk analysis;
analysis = new TrackAnalysisDisk(tsA, sequenceA, group.getTrackSegmentList().indexOf(tsA)+"#"+ group.getDescription());
if (cntTrackbis<251){XLSUtil.setCellString(WS5,cntTrackbis, 0, analysis.description);}
if (cntTrackbis>250){if(cntTrackbis<501){XLSUtil.setCellString(WS6,cntTrackbis-250, 0, analysis.description);}}
if (cntTrackbis>500){XLSUtil.setCellString(WS7,cntTrackbis-500, 0, analysis.description);}		

int cnt = 0;
for (int t = Math.max(0, tsA.getFirstDetection().getT()-timeClip); t <= Math.min(sequenceA.getSizeT()-1, tsA.getLastDetection().getT()+timeClip); t++){					 					
double[][][] imageTab = new double[sequenceA.getSizeZ()][sequenceA.getSizeC()][];		
for (int z = 0; z < sequenceA.getSizeZ(); z++)
for (int c = 0; c < sequenceA.getSizeC(); c++)
imageTab[z][c] = (double[]) ArrayUtil.arrayToDoubleArray(sequenceA.getImage(t, z, c).getDataXY(0), sequenceA.isSignedDataType());	
analysis.fillAveragingSeriesAtT(t,timeClip, imageTab, diskRadius);							
//on fait ensuite l'ecriture excel
if (cntTrackbis<251){		
	XLSUtil.setCellNumber(WS5,0, t+1, t);
	XLSUtil.setCellNumber(WS5,cntTrackbis, t+1, analysis.meanIntensity[0].getY(cnt).doubleValue());}
			if (cntTrackbis>250){if(cntTrackbis<501){
				XLSUtil.setCellNumber(WS6,0, t+1, t);
				XLSUtil.setCellNumber(WS6,cntTrackbis-250, t+1, analysis.meanIntensity[0].getY(cnt).doubleValue());}}									
	if (cntTrackbis>500){
		XLSUtil.setCellNumber(WS7,0, t+1, t);
		XLSUtil.setCellNumber(WS7,cntTrackbis-500, t+1, analysis.meanIntensity[0].getY(cnt).doubleValue());}
cnt++;}
cntTrackbis++;
//parcourir la liste des tracks B interagissant avec A
for (TrackSegment tsB :tiwt.tsAssociatedList)
{										
TrackGroup groupB = tsB.getOwnerTrackGroup();
Sequence sequenceB  = groupB.getSequence();
TrackAnalysisDisk analysisB;
analysisB = new TrackAnalysisDisk(tsB, sequenceB, groupB.getTrackSegmentList().indexOf(tsB)+"#"+ groupB.getDescription());
if (cntTrackbis<251){XLSUtil.setCellString(WS5,cntTrackbis, 0, analysisB.description);}
if (cntTrackbis>250){if(cntTrackbis<501){XLSUtil.setCellString(WS6,cntTrackbis-250, 0, analysisB.description);}}
if (cntTrackbis>500){XLSUtil.setCellString(WS7,cntTrackbis-500, 0, analysisB.description);}		

int cntB=0;
for (int t = Math.max(0, tsB.getFirstDetection().getT()-timeClip); t <= Math.min(sequenceB.getSizeT()-1, tsB.getLastDetection().getT()+timeClip); t++){					 					
double[][][] imageTab = new double[sequenceB.getSizeZ()][sequenceB.getSizeC()][];
for (int z = 0; z < sequenceB.getSizeZ(); z++)
for (int c = 0; c < sequenceB.getSizeC(); c++)
imageTab[z][c] = (double[]) ArrayUtil.arrayToDoubleArray(sequenceB.getImage(t, z, c).getDataXY(0), sequenceB.isSignedDataType());						
analysisB.fillAveragingSeriesAtT(t,timeClip, imageTab, diskRadius);							
//on fait ensuite l'ecriture excel
if (cntTrackbis<251){		
	XLSUtil.setCellNumber(WS5,0, t+1, t);
	XLSUtil.setCellNumber(WS5,cntTrackbis, t+1, analysisB.meanIntensity[0].getY(cntB).doubleValue());}
			if (cntTrackbis>250){if(cntTrackbis<501){
				XLSUtil.setCellNumber(WS6,0, t+1, t);
				XLSUtil.setCellNumber(WS6,cntTrackbis-250, t+1, analysisB.meanIntensity[0].getY(cntB).doubleValue());}}									
	if (cntTrackbis>500){
		XLSUtil.setCellNumber(WS7,0, t+1, t);
		XLSUtil.setCellNumber(WS7,cntTrackbis-500, t+1, analysisB.meanIntensity[0].getY(cntB).doubleValue());}
cntB++;
}
cntTrackbis++;
}}}	
		//save and close  
		try {
			XLSUtil.saveAndClose(WW);
		} catch (WriteException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();}						
	}



	private void refreshDisplay() {
				
		
		if ( trackSegmentSetA.size() == 0 )
		{			
			setTrackSetA.setText( "Put current selection in track set A" );			
		}
		else
		{
			setTrackSetA.setText( "Track selected in set A : " + trackSegmentSetA.size() );			
		}

		if ( trackSegmentSetB.size() == 0 )
		{
			setTrackSetB.setText( "Put current selection in track set B" );			
		}
		else
		{
			setTrackSetB.setText( "Track selected in set B : " + trackSegmentSetB.size() );			
		}
				
	}


	@Override
	public void Close() {

		trackSegmentSetA.clear();		
		trackSegmentSetB.clear();
		
	}

	@Override
	public void Compute() {		
			 
		if ( trackPool.getDisplaySequence() == null )
		           return;
		       
		       trackPool.getDisplaySequence().removeListener( this );
		       
		       Sequence displaySequence = trackPool.getDisplaySequence();
		       if ( displaySequence != null )
		       {
		           trackPool.getDisplaySequence().addListener( this );
		       }
		       
		   	
		       if ( isEnabled() && trackSegmentSetA.size() > 0 && trackSegmentSetB.size() > 0)
		       {		    			    
		    	   
					cdprHashMap.clear();	
					tiwtHashMap.clear();					
					
					for ( int t = 0 ; t < trackPool.getTrackManager().getDisplaySequence().getSizeT() ; t++ )
					{
								
						
						ArrayList<DetectionAndTrack> dSetA = new ArrayList<DetectionAndTrack>();
						for ( TrackSegment tsA : trackSegmentSetA )
						{							
							dSetA.add( new DetectionAndTrack ( tsA, tsA.getDetectionAtTime( t ) ) );
						}

						ArrayList<DetectionAndTrack> dSetB = new ArrayList<DetectionAndTrack>();
						for ( TrackSegment tsB : trackSegmentSetB )
						{
							dSetB.add( new DetectionAndTrack ( tsB, tsB.getDetectionAtTime( t ) ) );
						}
						double max_radius = Double.parseDouble(value.getText());
						ArrayList<ColocDetectionPairResult> cdprList  = new ArrayList<ColocDetectionPairResult>();
						ArrayList<ColocDetectionPairResult> cdprList0 = ColocDetectionPairResult.appDetectConstruction(dSetA,dSetB);
						cdprList = ColocDetectionPairResult.appDetectSelectManual(cdprList0, max_radius);

						cdprHashMap.put( t , cdprList );						
					}
			
			// compute result
			
			for ( TrackSegment tsA : trackSegmentSetA )
			{				
				TrackInteractWithTrack tiwt = new TrackInteractWithTrack( tsA );								
				
				for ( Integer key : cdprHashMap.keySet() )//key=temps t 
				{
					ArrayList<ColocDetectionPairResult> cdprList = cdprHashMap.get( key );
					
					for ( ColocDetectionPairResult cdpr : cdprList )
					{
						if ( cdpr.trackA == tsA )
						{
							
							tiwt.addAssociatedTrack( cdpr.trackB,key );
						}
					}
					
				}
				tiwtHashMap.put(tsA, tiwt);								
			}			
			}
	}
			
	
	
	@Override
	public void sequenceChanged(SequenceEvent sequenceEvent) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public void displaySequenceChanged() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void sequenceClosed(Sequence arg0) {
		// TODO Auto-generated method stub
		
	}
	
}
