/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.collection.CollectionUtil;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;
import plugins.stef.roi.bloc.RoiBlocks;

public class SortROI
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected final VarROIArray roiSet = new VarROIArray("ROI(s)", null);
    protected final VarSequence sequence = new VarSequence("Sequence", null);
    protected final VarString descriptors = new VarString("Sort on", "");
    protected final VarBoolean reverse = new VarBoolean("Reverse", Boolean.FALSE);
    protected final VarROIArray output = new VarROIArray("Sorted ROI(s)");

    public void run() {
        try {
            List<ROI> result = SortROI.SortROIs(CollectionUtil.asList((Object[])((ROI[])this.roiSet.getValue())), (Sequence)this.sequence.getValue(), (String)this.descriptors.getValue(), (Boolean)this.reverse.getValue());
            this.output.setValue((Object)result.toArray(new ROI[result.size()]));
        }
        catch (IllegalArgumentException e) {
            throw new VarException((Var)this.descriptors, e.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        ArrayList roiDescriptors = new ArrayList(ROIDescriptor.getDescriptors().keySet());
        ArrayList<String> descriptorsId = new ArrayList<String>();
        String sizeDescriptorId = null;
        for (ROIDescriptor descriptor : roiDescriptors) {
            String id = descriptor.getId();
            if (StringUtil.equals((String)"Interior", (String)id)) {
                sizeDescriptorId = id;
            }
            descriptorsId.add(id);
        }
        Collections.sort(descriptorsId);
        this.descriptors.setDefaultEditorModel((VarEditorModel)new ValueSelectionModel((Object[])descriptorsId.toArray(new String[descriptorsId.size()]), (Object)sizeDescriptorId, false));
        inputMap.add("roi", (Var)this.roiSet);
        inputMap.add("sequence", (Var)this.sequence);
        inputMap.add("descriptors", (Var)this.descriptors);
        inputMap.add("reverse", (Var)this.reverse);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("out", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }

    public static List<ROI> SortROIs(Collection<ROI> rois, Sequence sequence, String descriptorId, boolean reverse) throws IllegalArgumentException {
        ArrayList<ValuedROI> result = new ArrayList<ValuedROI>();
        ROIDescriptor roiDescriptor = ROIDescriptor.getDescriptor(ROIDescriptor.getDescriptors().keySet(), (String)descriptorId);
        if (roiDescriptor == null) {
            throw new IllegalArgumentException("Cannot found '" + descriptorId + "' ROI descriptor !");
        }
        for (ROI roi : rois) {
            if (roi == null) continue;
            try {
                result.add(new ValuedROI(roi, roiDescriptor.compute(roi, sequence), reverse));
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false, (boolean)true);
                result.add(new ValuedROI(roi, null, reverse));
            }
        }
        Collections.sort(result);
        ArrayList<ROI> resultROI = new ArrayList<ROI>();
        for (ValuedROI vr : result) {
            resultROI.add(vr.roi);
        }
        return resultROI;
    }

    static class ValuedROI
    implements Comparable<ValuedROI> {
        ROI roi;
        Number value;
        int sortFactor;

        public ValuedROI(ROI roi, Object value, boolean reverse) {
            this.roi = roi;
            this.value = value instanceof Number ? (Number)((Number)value) : (Number)null;
            this.sortFactor = reverse ? -1 : 1;
        }

        @Override
        public int compareTo(ValuedROI vr) {
            double v2;
            if (vr.value == this.value) {
                return 0;
            }
            if (this.value == null) {
                return -1 * this.sortFactor;
            }
            if (vr.value == null) {
                return 1 * this.sortFactor;
            }
            double v1 = this.value.doubleValue();
            if (v1 < (v2 = vr.value.doubleValue())) {
                return -1 * this.sortFactor;
            }
            if (v1 > v2) {
                return 1 * this.sortFactor;
            }
            return 0;
        }
    }
}

