/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;

public class AnalyzeReader
extends FormatReader {
    private static final int MAGIC = 348;
    private int pixelOffset;
    private transient RandomAccessInputStream pixelFile;
    private String pixelsFilename;

    public AnalyzeReader() {
        super("Analyze 7.5", new String[]{"img", "hdr"});
        this.domains = new String[]{"Medical Imaging"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .img file and one similarly-named .hdr file";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!open) {
            return false;
        }
        String headerFile = AnalyzeReader.checkSuffix(name, "hdr") ? name : null;
        String extension = name.substring(name.lastIndexOf(".") + 1);
        name = name.substring(0, name.lastIndexOf("."));
        if (extension.equals("img")) {
            extension = "hdr";
        } else if (extension.equals("IMG")) {
            extension = "HDR";
        } else if (extension.equals("hdr")) {
            extension = "img";
        } else if (extension.equals("HDR")) {
            extension = "IMG";
        }
        if (extension.equalsIgnoreCase("hdr")) {
            headerFile = name + "." + extension;
        }
        boolean validHeader = false;
        try (RandomAccessInputStream headerStream = new RandomAccessInputStream(headerFile);){
            validHeader = this.isThisType(headerStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Location(name + "." + extension).exists() && validHeader;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        stream.order(true);
        int checkLittleEndian = stream.readInt();
        stream.seek(stream.getFilePointer() - 4L);
        stream.order(false);
        int checkBigEndian = stream.readInt();
        return checkLittleEndian == 348 || checkBigEndian == 348;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int planeSize = FormatTools.getPlaneSize(this);
        this.pixelFile.seek(this.pixelOffset + no * planeSize);
        this.readPlane(this.pixelFile, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.currentId;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.currentId;
            stringArray = stringArray3;
            stringArray3[1] = this.pixelsFilename;
        }
        return stringArray;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.pixelFile != null) {
            this.pixelFile.close();
        }
        if (!fileOnly) {
            this.pixelOffset = 0;
            this.pixelFile = null;
            this.pixelsFilename = null;
        }
    }

    @Override
    public void reopenFile() throws IOException {
        super.reopenFile();
        if (this.pixelFile == null) {
            this.pixelFile = new RandomAccessInputStream(this.pixelsFilename);
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (id.endsWith(".img")) {
            LOGGER.info("Looking for header file");
            String header = id.substring(0, id.lastIndexOf(".")) + ".hdr";
            if (new Location(header).exists()) {
                this.setId(header);
                return;
            }
            throw new FormatException("Header file not found.");
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.pixelsFilename = id.substring(0, id.lastIndexOf(".")) + ".img";
        this.pixelFile = new RandomAccessInputStream(this.pixelsFilename);
        LOGGER.info("Reading header");
        int fileSize = this.in.readInt();
        boolean little = (long)fileSize != this.in.length();
        this.in.order(little);
        this.pixelFile.order(little);
        this.in.skipBytes(10);
        String imageName = this.in.readString(18);
        this.in.skipBytes(8);
        short ndims = this.in.readShort();
        short x = this.in.readShort();
        short y = this.in.readShort();
        short z = this.in.readShort();
        short t = this.in.readShort();
        this.in.skipBytes(20);
        short dataType = this.in.readShort();
        short nBitsPerPixel = this.in.readShort();
        String description = null;
        double voxelWidth = 0.0;
        double voxelHeight = 0.0;
        double sliceThickness = 0.0;
        double deltaT = 0.0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.skipBytes(6);
            voxelWidth = this.in.readFloat();
            voxelHeight = this.in.readFloat();
            sliceThickness = this.in.readFloat();
            deltaT = this.in.readFloat();
            this.in.skipBytes(12);
            this.pixelOffset = (int)this.in.readFloat();
            this.in.skipBytes(12);
            float calibratedMax = this.in.readFloat();
            float calibratedMin = this.in.readFloat();
            float compressed = this.in.readFloat();
            float verified = this.in.readFloat();
            float pixelMax = this.in.readFloat();
            float pixelMin = this.in.readFloat();
            description = this.in.readString(80);
            String auxFile = this.in.readString(24);
            char orient = (char)this.in.readByte();
            String originator = this.in.readString(10);
            String generated = this.in.readString(10);
            String scannum = this.in.readString(10);
            String patientID = this.in.readString(10);
            String expDate = this.in.readString(10);
            String expTime = this.in.readString(10);
            this.in.skipBytes(3);
            int views = this.in.readInt();
            int volsAdded = this.in.readInt();
            int startField = this.in.readInt();
            int fieldSkip = this.in.readInt();
            int omax = this.in.readInt();
            int omin = this.in.readInt();
            int smax = this.in.readInt();
            int smin = this.in.readInt();
            this.addGlobalMeta("Database name", imageName);
            this.addGlobalMeta("Number of dimensions", (int)ndims);
            this.addGlobalMeta("Data type", (int)dataType);
            this.addGlobalMeta("Number of bits per pixel", (int)nBitsPerPixel);
            this.addGlobalMeta("Voxel width", voxelWidth);
            this.addGlobalMeta("Voxel height", voxelHeight);
            this.addGlobalMeta("Slice thickness", sliceThickness);
            this.addGlobalMeta("Exposure time", deltaT);
            this.addGlobalMeta("Pixel offset", this.pixelOffset);
            this.addGlobalMeta("Calibrated maximum", calibratedMax);
            this.addGlobalMeta("Calibrated minimum", calibratedMin);
            this.addGlobalMeta("Compressed", compressed);
            this.addGlobalMeta("Verified", verified);
            this.addGlobalMeta("Pixel maximum", pixelMax);
            this.addGlobalMeta("Pixel minimum", pixelMin);
            this.addGlobalMeta("Description", description);
            this.addGlobalMeta("Auxiliary file", auxFile);
            this.addGlobalMeta("Orientation", orient);
            this.addGlobalMeta("Originator", originator);
            this.addGlobalMeta("Generated", generated);
            this.addGlobalMeta("Scan Number", scannum);
            this.addGlobalMeta("Patient ID", patientID);
            this.addGlobalMeta("Acquisition Date", expDate);
            this.addGlobalMeta("Acquisition Time", expTime);
        } else {
            this.in.skipBytes(34);
            this.pixelOffset = (int)this.in.readFloat();
        }
        LOGGER.info("Populating core metadata");
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.littleEndian = little;
        m3.sizeX = x;
        m3.sizeY = y;
        m3.sizeZ = z;
        m3.sizeT = t;
        m3.sizeC = 1;
        if (this.getSizeZ() == 0) {
            m3.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            m3.sizeT = 1;
        }
        m3.imageCount = this.getSizeZ() * this.getSizeT();
        m3.rgb = false;
        m3.interleaved = false;
        m3.indexed = false;
        m3.dimensionOrder = "XYZTC";
        switch (dataType) {
            case 1: 
            case 2: {
                m3.pixelType = 1;
                break;
            }
            case 4: {
                m3.pixelType = 2;
                break;
            }
            case 8: {
                m3.pixelType = 4;
                break;
            }
            case 16: {
                m3.pixelType = 6;
                break;
            }
            case 64: {
                m3.pixelType = 7;
                break;
            }
            case 128: {
                m3.pixelType = 1;
                m3.sizeC = 3;
                m3.rgb = true;
                m3.interleaved = true;
                m3.dimensionOrder = "XYCZT";
            }
            default: {
                throw new FormatException("Unsupported data type: " + dataType);
            }
        }
        LOGGER.info("Populating MetadataStore");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(imageName, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(description, 0);
            Length sizeX = FormatTools.getPhysicalSizeX((Double)voxelWidth, UNITS.MILLIMETER);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)voxelHeight, UNITS.MILLIMETER);
            Length sizeZ = FormatTools.getPhysicalSizeZ((Double)sliceThickness, UNITS.MILLIMETER);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
            store.setPixelsTimeIncrement(new Time(deltaT, UNITS.MILLISECOND), 0);
        }
    }
}

