/*
 * Decompiled with CFR 0.152.
 */
package icy.file;

import icy.network.NetworkUtil;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static final char separatorChar = '/';
    public static final String separator = "/";
    public static final String APPLICATION_DIRECTORY = FileUtil.getApplicationDirectory();

    public static String cleanPath(String filePath) {
        String result = filePath;
        if (result != null) {
            if (result.length() >= 2) {
                result = String.valueOf(result.substring(0, 2)) + result.substring(2).replaceAll(":", "_");
            }
            result = result.replaceAll("!", "_");
            result = result.replaceAll("#", "_");
        }
        return result;
    }

    public static String getGenericPath(String path) {
        if (path != null) {
            return path.replace('\\', '/');
        }
        return null;
    }

    public static String getTempDirectory() {
        String result = FileUtil.getGenericPath(SystemUtil.getProperty("java.io.tmpdir"));
        int len = result.length();
        if (len > 1 && result.charAt(len - 1) == '/') {
            return result.substring(0, len - 1);
        }
        return result;
    }

    public static String setExtension(String path, String extension) {
        String finalPath = FileUtil.getGenericPath(path);
        if (StringUtil.isEmpty(finalPath)) {
            return "";
        }
        int len = finalPath.length();
        String result = finalPath;
        int dotIndex = result.lastIndexOf(".");
        if (!(dotIndex < 0 || len - dotIndex > 5 || dotIndex + 1 != len && Character.isDigit(result.charAt(dotIndex + 1)))) {
            result = result.substring(0, dotIndex);
        }
        if (extension != null) {
            result = String.valueOf(result) + extension;
        }
        return result;
    }

    public static void ensureParentDirExist(String filename) {
        FileUtil.ensureParentDirExist(new File(FileUtil.getGenericPath(filename)));
    }

    public static boolean ensureParentDirExist(File file) {
        String dir = file.getParent();
        if (dir != null) {
            return FileUtil.createDir(dir);
        }
        return true;
    }

    public static boolean createDir(String dirname) {
        return FileUtil.createDir(new File(FileUtil.getGenericPath(dirname)));
    }

    public static boolean createDir(File dir) {
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    public static File createFile(String filename) {
        return FileUtil.createFile(new File(FileUtil.getGenericPath(filename)));
    }

    public static File createFile(File file) {
        if (!file.exists()) {
            FileUtil.ensureParentDirExist(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                System.err.println("Error: can't create file '" + file.getAbsolutePath() + "':");
                IcyExceptionHandler.showErrorMessage(e, false);
                return null;
            }
        }
        return file;
    }

    public static File[] toFiles(String[] paths) {
        File[] result = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            result[i] = new File(paths[i]);
            ++i;
        }
        return result;
    }

    public static List<File> toFiles(List<String> paths) {
        ArrayList<File> result = new ArrayList<File>(paths.size());
        for (String path : paths) {
            result.add(new File(path));
        }
        return result;
    }

    public static String[] toPaths(File[] files) {
        String[] result = new String[files.length];
        int i = 0;
        while (i < files.length) {
            result[i] = FileUtil.getGenericPath(files[i].getAbsolutePath());
            ++i;
        }
        return result;
    }

    public static List<String> toPaths(List<File> files) {
        ArrayList<String> result = new ArrayList<String>(files.size());
        for (File file : files) {
            result.add(FileUtil.getGenericPath(file.getAbsolutePath()));
        }
        return result;
    }

    public static boolean createLink(String path, String target) {
        String finalPath = FileUtil.getGenericPath(path);
        FileUtil.ensureParentDirExist(finalPath);
        if (SystemUtil.isLinkSupported()) {
            Process process = SystemUtil.exec("ln -s " + target + " " + finalPath);
            if (process == null) {
                return false;
            }
            try {
                return process.waitFor() == 0;
            }
            catch (InterruptedException e) {
                System.err.println("FileUtil.createLink(" + path + ", " + target + ") error :");
                IcyExceptionHandler.showErrorMessage(e, false);
                return false;
            }
        }
        return FileUtil.copy(target, finalPath, true, false, false);
    }

    public static byte[] load(String path, boolean displayError) {
        return FileUtil.load(new File(FileUtil.getGenericPath(path)), displayError);
    }

    public static byte[] load(File file, boolean displayError) {
        return NetworkUtil.download(file, null, displayError);
    }

    public static boolean save(String path, byte[] data, boolean displayError) {
        return FileUtil.save(new File(FileUtil.getGenericPath(path)), data, displayError);
    }

    public static boolean save(File file, byte[] data, boolean displayError) {
        File f = FileUtil.createFile(file);
        if (f != null) {
            try {
                FileOutputStream out = new FileOutputStream(f);
                out.write(data, 0, data.length);
                out.close();
            }
            catch (Exception e) {
                if (displayError) {
                    System.err.println(e.getMessage());
                }
                f.delete();
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getApplicationDirectory() {
        String result;
        try {
            File f = new File(FileUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            result = f.isDirectory() ? f.getAbsolutePath() : f.getParentFile().getAbsolutePath();
        }
        catch (Exception e1) {
            try {
                result = new File(ClassLoader.getSystemClassLoader().getResource(".").toURI()).getAbsolutePath();
            }
            catch (Exception e2) {
                result = new File(System.getProperty("user.dir")).getAbsolutePath();
            }
        }
        try {
            result = URLDecoder.decode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return FileUtil.getGenericPath(result);
    }

    @Deprecated
    public static String getCurrentDirectory() {
        return FileUtil.getApplicationDirectory();
    }

    public static String getDrive(String path) {
        File f;
        File fp = new File(path);
        while ((fp = (f = fp).getParentFile()) != null) {
        }
        return f.getAbsolutePath();
    }

    public static String getDirectory(String path, boolean wantSeparator) {
        String finalPath = FileUtil.getGenericPath(path);
        if (!StringUtil.isEmpty(finalPath)) {
            int index = finalPath.lastIndexOf(47);
            if (index != -1) {
                return finalPath.substring(0, index + (wantSeparator ? 1 : 0));
            }
            index = finalPath.lastIndexOf(58);
            if (index != -1) {
                return finalPath.substring(0, index + 1);
            }
        }
        return "";
    }

    public static String getDirectory(String path) {
        return FileUtil.getDirectory(path, true);
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(path, true);
    }

    public static String getFileName(String path, boolean withExtension) {
        String finalPath = FileUtil.getGenericPath(path);
        if (StringUtil.isEmpty(finalPath)) {
            return "";
        }
        int index = finalPath.lastIndexOf(47);
        String fileName = index != -1 ? finalPath.substring(index + 1) : ((index = finalPath.lastIndexOf(58)) != -1 ? finalPath.substring(index + 1) : finalPath);
        if (withExtension) {
            return fileName;
        }
        index = fileName.lastIndexOf(46);
        if (index == 0) {
            return "";
        }
        if (index != -1) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getFileExtension(String path, boolean withDot) {
        String finalPath = FileUtil.getGenericPath(path);
        if (StringUtil.isEmpty(finalPath)) {
            return "";
        }
        int indexSep = finalPath.lastIndexOf(47);
        int indexDot = finalPath.lastIndexOf(46);
        if (indexDot == -1 || indexDot < indexSep) {
            return "";
        }
        if (withDot) {
            return finalPath.substring(indexDot);
        }
        return finalPath.substring(indexDot + 1);
    }

    public static boolean rename(String src, String dst, boolean force) {
        return FileUtil.rename(new File(FileUtil.getGenericPath(src)), new File(FileUtil.getGenericPath(dst)), force);
    }

    @Deprecated
    public static boolean rename(String src, String dst, boolean force, boolean wantHidden) {
        return FileUtil.rename(src, dst, force);
    }

    public static boolean rename(File src, File dst, boolean force) {
        if (src.exists()) {
            if (dst.exists()) {
                if (force) {
                    if (!FileUtil.delete(dst, true)) {
                        System.err.println("Cannot rename '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
                        System.err.println("Reason: destination cannot be overwritten.");
                        System.err.println("Make sure it is not locked by another program (e.g. Eclipse)");
                        System.err.println("Also check that you have the rights to do this operation.");
                        return false;
                    }
                } else {
                    System.err.println("Cannot rename '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
                    System.err.println("The destination already exists.");
                    System.err.println("Use the 'force' flag to force the operation.");
                    return false;
                }
            }
            FileUtil.ensureParentDirExist(dst);
            if (!src.setWritable(true, false)) {
                src.setWritable(true, true);
            }
            long start = System.currentTimeMillis();
            boolean done = src.renameTo(dst);
            while (!done && System.currentTimeMillis() - start < 10000L) {
                System.gc();
                ThreadUtil.sleep(1000);
                if (!src.setWritable(true, false)) {
                    src.setWritable(true, true);
                }
                done = src.renameTo(dst);
            }
            if (!done) {
                System.err.println("Cannot rename '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
                System.err.println("Check that the source file is not locked.");
                return false;
            }
            return true;
        }
        System.err.println("Cannot rename '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
        System.err.println("Input file '" + src.getAbsolutePath() + "' not found !");
        return false;
    }

    @Deprecated
    public static boolean rename(File src, File dst, boolean force, boolean wantHidden) {
        return FileUtil.rename(src, dst, force);
    }

    @Deprecated
    public static boolean move(String src, String dst, boolean force) {
        return FileUtil.rename(src, dst, force);
    }

    @Deprecated
    public static boolean move(String src, String dst, boolean force, boolean wantHidden) {
        return FileUtil.move(src, dst, force);
    }

    @Deprecated
    public static boolean move(File src, File dst, boolean force) {
        return FileUtil.rename(src, dst, force);
    }

    @Deprecated
    public static boolean move(File src, File dst, boolean force, boolean wantHidden) {
        return FileUtil.move(src, dst, force);
    }

    public static boolean copy(String src, String dst, boolean force, boolean recursive) {
        return FileUtil.copy(new File(FileUtil.getGenericPath(src)), new File(FileUtil.getGenericPath(dst)), force, recursive);
    }

    @Deprecated
    public static boolean copy(String src, String dst, boolean force, boolean wantHidden, boolean recursive) {
        return FileUtil.copy(src, dst, force, recursive);
    }

    public static boolean copy(File src, File dst, boolean force, boolean recursive) {
        return FileUtil.copy_(src, dst, force, recursive, false);
    }

    @Deprecated
    public static boolean copy(File src, File dst, boolean force, boolean wantHidden, boolean recursive) {
        return FileUtil.copy(src, dst, force, recursive);
    }

    private static boolean copy_(File src, File dst, boolean force, boolean recursive, boolean inRecurse) {
        if (src.isDirectory()) {
            if (inRecurse && !recursive) {
                return true;
            }
            FileUtil.createDir(dst);
            boolean result = true;
            String[] files = src.list();
            int i = 0;
            while (i < files.length) {
                result &= FileUtil.copy_(new File(src, files[i]), new File(dst, files[i]), force, recursive, true);
                ++i;
            }
            return result;
        }
        if (src.exists()) {
            boolean lnk;
            if (dst.exists()) {
                if (force) {
                    if (!FileUtil.delete(dst, true)) {
                        System.err.println("Cannot copy '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
                        System.err.println("Reason : destination cannot be overwritten.");
                        System.err.println("Make sure it is not locked by another program (e.g. Eclipse)");
                        System.err.println("Also check that you have the rights to do this operation.");
                        return false;
                    }
                } else {
                    System.err.println("Cannot copy '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
                    System.err.println("The destination already exists.");
                    System.err.println("Use the 'force' flag to force file copy.");
                    return false;
                }
            }
            try {
                lnk = FileUtil.isLink(src);
            }
            catch (IOException e) {
                lnk = false;
            }
            if (lnk && SystemUtil.isLinkSupported()) {
                Process process = SystemUtil.exec("cp -pRP " + src.getPath() + " " + dst.getPath());
                int res = 1;
                if (process != null) {
                    try {
                        res = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (res != 0) {
                    System.err.println("FileUtil.copy(...) error while creating link '" + src.getPath() + "' to '" + dst.getPath() + "'");
                    if (process != null) {
                        BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        try {
                            System.err.println(stderr.readLine());
                            if (stderr.ready()) {
                                System.err.println(stderr.readLine());
                            }
                        }
                        catch (IOException iOException) {}
                    } else if (res == 1) {
                        System.err.println("Process interrupted.");
                    }
                    return false;
                }
                return true;
            }
            byte[] data = FileUtil.load(src, true);
            if (data != null) {
                if (FileUtil.save(dst, data, true)) {
                    dst.setLastModified(src.lastModified());
                    return true;
                }
                return false;
            }
            System.err.println("Cannot copy '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
            System.err.println("Input file '" + src.getAbsolutePath() + "' data cannot be loaded !");
            return false;
        }
        System.err.println("Cannot copy '" + src.getAbsolutePath() + "' to '" + dst.getAbsolutePath() + "'");
        System.err.println("Input file '" + src.getAbsolutePath() + "' not found !");
        return false;
    }

    public static String backup(String filename) {
        int postfix = 0;
        String backupName = String.valueOf(filename) + ".bak";
        while (FileUtil.exists(backupName)) {
            backupName = String.valueOf(filename) + "_" + StringUtil.toString(postfix, 3) + ".bak";
            ++postfix;
        }
        if (FileUtil.copy(filename, backupName, true, false)) {
            return backupName;
        }
        return null;
    }

    public static File[] explode(File[] files, FileFilter filter, boolean recursive, boolean wantHidden) {
        ArrayList<File> result = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.getFiles(file, filter, recursive, true, false, wantHidden, result);
            } else {
                result.add(file);
            }
            ++n2;
        }
        return result.toArray(new File[result.size()]);
    }

    @Deprecated
    public static List<File> explode(List<File> files, boolean recursive, boolean wantHidden) {
        return FileUtil.explode(files, null, recursive, wantHidden);
    }

    public static List<File> explode(List<File> files, FileFilter filter, boolean recursive, boolean wantHidden) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtil.getFiles(file, filter, recursive, true, false, wantHidden, result);
                continue;
            }
            result.add(file);
        }
        return result;
    }

    private static void getFiles(File folder, String extension, boolean ignoreExtensionCase, boolean recursive, List<File> list) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (recursive) {
                        FileUtil.getFiles(file, extension, ignoreExtensionCase, recursive, list);
                    }
                } else if (extension != null) {
                    String fileExt = FileUtil.getFileExtension(file.getAbsolutePath(), false);
                    if (ignoreExtensionCase) {
                        if (extension.equalsIgnoreCase(fileExt)) {
                            list.add(file);
                        }
                    } else if (extension.equals(fileExt)) {
                        list.add(file);
                    }
                } else {
                    list.add(file);
                }
                ++n2;
            }
        }
    }

    public static File[] getFiles(File folder, String extension, boolean ignoreExtensionCase, boolean recursive) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.getFiles(folder, extension, ignoreExtensionCase, recursive, result);
        return result.toArray(new File[result.size()]);
    }

    public static String[] getFiles(String folder, String extension, boolean ignoreExtensionCase, boolean recursive) {
        File[] files = FileUtil.getFiles(new File(FileUtil.getGenericPath(folder)), extension, ignoreExtensionCase, recursive);
        String[] result = new String[files.length];
        int i = 0;
        while (i < files.length) {
            result[i] = files[i].getPath();
            ++i;
        }
        return result;
    }

    private static void getFiles(File f, FileFilter filter, boolean recursive, boolean wantFile, boolean wantDirectory, boolean wantHidden, List<File> list) {
        File[] files = f.listFiles(filter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isHidden() || wantHidden) {
                    if (file.isDirectory()) {
                        if (wantDirectory) {
                            list.add(file);
                        }
                        if (recursive) {
                            FileUtil.getFiles(file, filter, recursive, wantFile, wantDirectory, wantHidden, list);
                        }
                    } else if (wantFile) {
                        list.add(file);
                    }
                }
                ++n2;
            }
        }
    }

    public static File[] getDirectories(File file, FileFilter filter, boolean recursive, boolean wantHidden) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.getFiles(file, filter, recursive, false, true, wantHidden, result);
        return result.toArray(new File[result.size()]);
    }

    public static File[] getFiles(File directory, FileFilter filter, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.getFiles(directory, filter, recursive, true, wantDirectory, wantHidden, result);
        return result.toArray(new File[result.size()]);
    }

    public static String[] getFiles(String directory, FileFilter filter, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        File[] files = FileUtil.getFiles(new File(FileUtil.getGenericPath(directory)), filter, recursive, wantDirectory, wantHidden);
        String[] result = new String[files.length];
        int i = 0;
        while (i < files.length) {
            result[i] = files[i].getPath();
            ++i;
        }
        return result;
    }

    @Deprecated
    public static ArrayList<File> getFileList(String path, FileFilter filter, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.getFiles(new File(FileUtil.getGenericPath(path)), filter, recursive, true, wantDirectory, wantHidden, result);
        return result;
    }

    @Deprecated
    public static ArrayList<File> getFileList(File file, FileFilter filter, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.getFiles(file, filter, recursive, true, wantDirectory, wantHidden, result);
        return result;
    }

    @Deprecated
    public static ArrayList<File> getFileList(String path, FileFilter filter, boolean recursive, boolean wantHidden) {
        return FileUtil.getFileList(path, filter, recursive, false, wantHidden);
    }

    @Deprecated
    public static ArrayList<File> getFileList(File file, FileFilter filter, boolean recursive, boolean wantHidden) {
        return FileUtil.getFileList(file, filter, recursive, false, wantHidden);
    }

    @Deprecated
    public static ArrayList<File> getFileList(String path, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        return FileUtil.getFileList(new File(FileUtil.getGenericPath(path)), null, recursive, wantDirectory, wantHidden);
    }

    @Deprecated
    public static ArrayList<File> getFileList(File file, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        return FileUtil.getFileList(file, null, recursive, wantDirectory, wantHidden);
    }

    @Deprecated
    public static ArrayList<File> getFileList(File file, boolean recursive, boolean wantHidden) {
        return FileUtil.getFileList(file, recursive, false, wantHidden);
    }

    @Deprecated
    public static ArrayList<File> getFileList(String path, boolean recursive, boolean wantHidden) {
        return FileUtil.getFileList(path, recursive, false, wantHidden);
    }

    @Deprecated
    public static ArrayList<String> getFileListAsString(String path, FileFilter filter, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        ArrayList<File> files = FileUtil.getFileList(path, filter, recursive, wantDirectory, wantHidden);
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            result.add(file.getPath());
        }
        return result;
    }

    @Deprecated
    public static ArrayList<String> getFileListAsString(String path, boolean recursive, boolean wantDirectory, boolean wantHidden) {
        return FileUtil.getFileListAsString(path, null, recursive, wantDirectory, wantHidden);
    }

    @Deprecated
    public static ArrayList<String> getFileListAsString(String path, FileFilter filter, boolean recursive, boolean wantHidden) {
        return FileUtil.getFileListAsString(path, filter, recursive, false, wantHidden);
    }

    @Deprecated
    public static ArrayList<String> getFileListAsString(String path, boolean recursive, boolean wantHidden) {
        return FileUtil.getFileListAsString(path, recursive, false, wantHidden);
    }

    @Deprecated
    public static boolean exist(String path) {
        return FileUtil.exists(path);
    }

    public static boolean exists(String path) {
        return new File(FileUtil.getGenericPath(path)).exists();
    }

    public static boolean isDirectory(String path) {
        return new File(FileUtil.getGenericPath(path)).isDirectory();
    }

    public static boolean isLink(String path) throws IOException {
        return FileUtil.isLink(new File(FileUtil.getGenericPath(path)));
    }

    public static boolean isLink(File file) throws IOException {
        if (file == null) {
            return false;
        }
        File canon = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !canon.getCanonicalFile().getAbsolutePath().equalsIgnoreCase(canon.getAbsolutePath());
    }

    public static boolean delete(String path, boolean recursive) {
        return FileUtil.delete(new File(FileUtil.getGenericPath(path)), recursive);
    }

    public static boolean delete(File f, boolean recursive) {
        boolean result = true;
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        if (recursive) {
                            result &= FileUtil.delete(file, true);
                        }
                    } else {
                        result &= file.delete();
                    }
                    ++n2;
                }
            }
            result &= f.delete();
        } else if (f.exists()) {
            long start = System.currentTimeMillis();
            if (!f.setWritable(true, false)) {
                f.setWritable(true, true);
            }
            result = f.delete();
            while (!result && System.currentTimeMillis() - start < 10000L) {
                System.gc();
                ThreadUtil.sleep(1000);
                if (!f.setWritable(true, false)) {
                    f.setWritable(true, true);
                }
                result = f.delete();
            }
        }
        return result;
    }
}

