/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.lut;

import icy.canvas.IcyCanvas3D;
import icy.file.xml.XMLPersistent;
import icy.file.xml.XMLPersistentHelper;
import icy.gui.component.button.IcyButton;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.component.renderer.ColormapComboBoxRenderer;
import icy.gui.dialog.OpenDialog;
import icy.gui.dialog.SaveDialog;
import icy.gui.lut.ColormapViewer;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.IcyColorMapEvent;
import icy.image.colormap.IcyColorMapListener;
import icy.image.lut.LUT;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ColormapPanel
extends JPanel
implements IcyColorMapListener {
    private static final long serialVersionUID = -4042084504553770641L;
    private static final String DEFAULT_COLORMAP_DIR = "colormap";
    private static final String DEFAULT_COLORMAP_NAME = "colormap.xml";
    private final ColormapViewer colormapViewer;
    final IcyToggleButton rgbBtn;
    final IcyToggleButton grayBtn;
    final IcyToggleButton alphaBtn;
    final ButtonGroup colormapTypeBtnGrp;
    final JComboBox colormapComboBox;
    public final Viewer viewer;
    public final LUT.LUTChannel lutChannel;
    final IcyColorMap colormap;
    private boolean modifyingColormap;

    public ColormapPanel(Viewer viewer, LUT.LUTChannel lutChannel) {
        IcyColorMap defaultColormap;
        this.viewer = viewer;
        this.lutChannel = lutChannel;
        this.modifyingColormap = false;
        this.colormap = lutChannel.getColorMap();
        this.colormap.setName("Custom");
        this.colormapViewer = new ColormapViewer(lutChannel);
        this.rgbBtn = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_RGB_COLOR, false));
        this.rgbBtn.setToolTipText("Set colormap type to Color");
        this.rgbBtn.setFocusPainted(false);
        ComponentUtil.setFixedWidth(this.rgbBtn, 26);
        this.grayBtn = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_GRAY_COLOR, false));
        this.grayBtn.setToolTipText("Set colormap type to Gray");
        this.grayBtn.setFocusPainted(false);
        ComponentUtil.setFixedWidth(this.grayBtn, 26);
        this.alphaBtn = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_ALPHA_COLOR, false));
        this.alphaBtn.setToolTipText("Set colormap type to Alpha (transparency)");
        this.alphaBtn.setFocusPainted(false);
        ComponentUtil.setFixedWidth(this.alphaBtn, 26);
        this.colormapTypeBtnGrp = new ButtonGroup();
        this.colormapTypeBtnGrp.add(this.rgbBtn);
        this.colormapTypeBtnGrp.add(this.grayBtn);
        this.colormapTypeBtnGrp.add(this.alphaBtn);
        this.updateColormapType(this.colormap.getType());
        this.rgbBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColormapPanel.this.colormap.setType(IcyColorMap.IcyColorMapType.RGB);
            }
        });
        this.grayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColormapPanel.this.colormap.setType(IcyColorMap.IcyColorMapType.GRAY);
            }
        });
        this.alphaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColormapPanel.this.colormap.setType(IcyColorMap.IcyColorMapType.ALPHA);
            }
        });
        LUT defaultLUT = viewer.getSequence().getDefaultLUT();
        if (defaultLUT.isCompatible(lutChannel.getLut())) {
            defaultColormap = defaultLUT.getLutChannel(lutChannel.getChannel()).getColorMap();
            defaultColormap.setName("Default");
        } else {
            defaultColormap = new IcyColorMap("Default");
            defaultColormap.copyFrom(this.colormap);
        }
        this.updateSequenceColormap();
        List<IcyColorMap> colormaps = IcyColorMap.getAllColorMaps(true, true);
        colormaps.remove(defaultColormap);
        colormaps.add(0, defaultColormap);
        colormaps.add(this.colormap);
        this.colormapComboBox = new JComboBox<Object>(colormaps.toArray());
        this.colormapComboBox.setRenderer(new ColormapComboBoxRenderer(this.colormapComboBox));
        ComponentUtil.setFixedWidth(this.colormapComboBox, 96);
        this.colormapComboBox.setToolTipText("Select colormap model");
        this.colormapComboBox.setFocusable(false);
        this.colormapComboBox.setSelectedItem(this.colormap);
        this.colormapComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColormapPanel.this.setColorMap((IcyColorMap)ColormapPanel.this.colormapComboBox.getSelectedItem());
            }
        });
        IcyButton loadButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_OPEN));
        loadButton.setFlat(true);
        loadButton.setToolTipText("Load colormap from file");
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IcyColorMap map;
                String filename = OpenDialog.chooseFile("Load colormap...", ColormapPanel.DEFAULT_COLORMAP_DIR, ColormapPanel.DEFAULT_COLORMAP_NAME);
                if (filename != null && XMLPersistentHelper.loadFromXML((XMLPersistent)(map = new IcyColorMap()), filename)) {
                    ColormapPanel.this.setColorMap(map);
                }
            }
        });
        IcyButton saveButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_SAVE));
        saveButton.setFlat(true);
        saveButton.setToolTipText("Save colormap to file");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = SaveDialog.chooseFile("Save colormap...", ColormapPanel.DEFAULT_COLORMAP_DIR, ColormapPanel.DEFAULT_COLORMAP_NAME);
                if (filename != null) {
                    XMLPersistentHelper.saveToXML((XMLPersistent)ColormapPanel.this.colormap, filename);
                }
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        bottomPanel.add((Component)GuiUtil.createLineBoxPanel(this.rgbBtn, this.grayBtn, this.alphaBtn), "West");
        bottomPanel.add(Box.createGlue(), "Center");
        bottomPanel.add((Component)GuiUtil.createLineBoxPanel(this.colormapComboBox, new JSeparator(1), loadButton, Box.createHorizontalStrut(2), saveButton), "East");
        bottomPanel.validate();
        this.setLayout(new BorderLayout());
        this.add((Component)this.colormapViewer, "Center");
        this.add((Component)bottomPanel, "South");
        this.validate();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.colormap.addListener(this);
    }

    @Override
    public void removeNotify() {
        this.colormap.removeListener(this);
        super.removeNotify();
    }

    public ColormapViewer getColormapViewer() {
        return this.colormapViewer;
    }

    private void updateColormapType(IcyColorMap.IcyColorMapType type) {
        switch (type) {
            case RGB: {
                this.colormapTypeBtnGrp.setSelected(this.rgbBtn.getModel(), true);
                break;
            }
            case GRAY: {
                this.colormapTypeBtnGrp.setSelected(this.grayBtn.getModel(), true);
                break;
            }
            case ALPHA: {
                this.colormapTypeBtnGrp.setSelected(this.alphaBtn.getModel(), true);
            }
        }
    }

    public void setColorMap(IcyColorMap src) {
        block9: {
            if (this.colormap == src) {
                return;
            }
            this.modifyingColormap = true;
            try {
                if (this.viewer.getCanvas() instanceof IcyCanvas3D) {
                    boolean copyAlpha = !src.alpha.isAllSame();
                    this.colormap.beginUpdate();
                    try {
                        this.colormap.copyFrom(src, copyAlpha);
                        if (!copyAlpha) {
                            this.colormap.setAlphaToLinear3D();
                        }
                        break block9;
                    }
                    finally {
                        this.colormap.endUpdate();
                    }
                }
                this.colormap.copyFrom(src, true);
            }
            finally {
                this.modifyingColormap = false;
            }
        }
        this.colormapComboBox.setSelectedItem(this.colormap);
    }

    void updateSequenceColormap() {
        int ch;
        Sequence seq = this.viewer.getSequence();
        if (seq != null && (ch = this.lutChannel.getChannel()) < seq.getSizeC()) {
            seq.setColormap(ch, this.colormap, true);
        }
    }

    @Deprecated
    public void copyColorMap(IcyColorMap src) {
        this.setColorMap(src);
    }

    @Override
    public void colorMapChanged(IcyColorMapEvent e) {
        switch (e.getType()) {
            case TYPE_CHANGED: {
                this.updateColormapType(e.getColormap().getType());
                break;
            }
            case MAP_CHANGED: {
                if (!this.modifyingColormap) {
                    this.colormap.setName("Custom");
                }
                this.colormapComboBox.setSelectedItem(this.colormap);
                this.colormapComboBox.repaint();
            }
        }
        this.updateSequenceColormap();
    }
}

