/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.roi.ROI2D;
import icy.type.TypeUtil;
import icy.type.collection.array.DynamicArray;
import icy.type.point.Point2DUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BooleanMask2D
implements Cloneable {
    public Rectangle bounds;
    public boolean[] mask;

    private static int findStartPoint(int startOffset, boolean[] mask, boolean[] visitedMask) {
        int i = startOffset;
        while (i < mask.length) {
            if (mask[i] && !visitedMask[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static List<Point> insertPoints(List<Point> result, List<Point> source) {
        if (result.isEmpty()) {
            result.addAll(source);
            return result;
        }
        if (source.isEmpty()) {
            return result;
        }
        Point firstPointSource = source.get(0);
        Point lastPointSource = source.get(source.size() - 1);
        int len = result.size();
        int i = 0;
        while (i < len) {
            Point p = result.get(i);
            if (Point2DUtil.areConnected(p, firstPointSource)) {
                ArrayList<Point> newResult = new ArrayList<Point>(result.subList(0, i + 1));
                newResult.addAll(source);
                if (i + 1 < len) {
                    newResult.addAll(new ArrayList<Point>(result.subList(i + 1, len)));
                }
                return newResult;
            }
            if (Point2DUtil.areConnected(p, lastPointSource)) {
                ArrayList<Point> newResult = new ArrayList<Point>(result.subList(0, i + 1));
                Collections.reverse(source);
                newResult.addAll(source);
                if (i + 1 < len) {
                    newResult.addAll(new ArrayList<Point>(result.subList(i + 1, len)));
                }
                return newResult;
            }
            ++i;
        }
        return null;
    }

    private static List<Point> connect(List<Point> result, List<Point> source) {
        if (result.isEmpty()) {
            result.addAll(source);
            return result;
        }
        if (source.isEmpty()) {
            return result;
        }
        Point2D firstPointResult = result.get(0);
        Point2D lastPointResult = result.get(result.size() - 1);
        Point2D firstPointSource = source.get(0);
        Point2D lastPointSource = source.get(source.size() - 1);
        if (Point2DUtil.areConnected(firstPointSource, lastPointResult)) {
            result.addAll(source);
            return result;
        }
        if (Point2DUtil.areConnected(firstPointSource, firstPointResult)) {
            Collections.reverse(source);
            source.addAll(result);
            return source;
        }
        if (Point2DUtil.areConnected(lastPointSource, firstPointResult)) {
            source.addAll(result);
            return source;
        }
        if (Point2DUtil.areConnected(lastPointSource, lastPointResult)) {
            Collections.reverse(source);
            result.addAll(source);
            return result;
        }
        return null;
    }

    public static List<Point> getContourPoints(Rectangle bounds, boolean[] mask) {
        if (bounds.isEmpty()) {
            return new ArrayList<Point>(1);
        }
        ArrayList<Point> points = new ArrayList<Point>(mask.length / 16);
        int h = bounds.height;
        int w = bounds.width;
        int minx = bounds.x;
        int miny = bounds.y;
        int maxx = minx + (w - 1);
        int maxy = miny + (h - 1);
        boolean top = false;
        boolean bottom = false;
        boolean left = false;
        boolean right = false;
        int offset = 0;
        if (w == 1 && h == 1) {
            if (mask[0]) {
                points.add(new Point(minx, miny));
            }
        } else if (w == 1) {
            top = false;
            boolean current = mask[offset];
            bottom = mask[++offset];
            if (!(!current || top && bottom)) {
                points.add(new Point(minx, miny));
            }
            int y = miny + 1;
            while (y < maxy) {
                top = current;
                current = bottom;
                bottom = mask[++offset];
                if (!(!current || top && bottom)) {
                    points.add(new Point(minx, y));
                }
                ++y;
            }
            top = current;
            current = bottom;
            bottom = false;
            if (!(!current || top && bottom)) {
                points.add(new Point(minx, maxy));
            }
        } else if (h == 1) {
            left = false;
            boolean current = mask[offset];
            right = mask[++offset];
            if (!(!current || left && right)) {
                points.add(new Point(minx, miny));
            }
            int x = minx + 1;
            while (x < maxx) {
                left = current;
                current = right;
                right = mask[++offset];
                if (!(!current || left && right)) {
                    points.add(new Point(x, miny));
                }
                ++x;
            }
            left = current;
            current = right;
            right = false;
            if (!(!current || left && right)) {
                points.add(new Point(maxx, miny));
            }
        } else {
            top = false;
            left = false;
            boolean current = mask[offset];
            bottom = mask[offset + w];
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(minx, miny));
            }
            int x = minx + 1;
            while (x < maxx) {
                left = current;
                current = right;
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points.add(new Point(x, miny));
                }
                ++x;
            }
            left = current;
            current = right;
            bottom = mask[offset + w];
            right = false;
            ++offset;
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(maxx, miny));
            }
            int y = miny + 1;
            while (y < maxy) {
                left = false;
                current = mask[offset];
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points.add(new Point(minx, y));
                }
                int x2 = minx + 1;
                while (x2 < maxx) {
                    left = current;
                    current = right;
                    top = mask[offset - w];
                    bottom = mask[offset + w];
                    right = mask[++offset];
                    if (!(!current || top && left && right && bottom)) {
                        points.add(new Point(x2, y));
                    }
                    ++x2;
                }
                left = current;
                current = right;
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = false;
                ++offset;
                if (!(!current || top && left && right && bottom)) {
                    points.add(new Point(maxx, y));
                }
                ++y;
            }
            left = false;
            current = mask[offset];
            top = mask[offset - w];
            bottom = false;
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(minx, maxy));
            }
            x = minx + 1;
            while (x < maxx) {
                left = current;
                current = right;
                top = mask[offset - w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points.add(new Point(x, maxy));
                }
                ++x;
            }
            left = current;
            current = right;
            top = mask[offset - w];
            right = false;
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(maxx, maxy));
            }
        }
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask2D upscale(BooleanMask2D mask) throws InterruptedException {
        boolean[] srcMask;
        Rectangle srcBounds;
        BooleanMask2D booleanMask2D = mask;
        synchronized (booleanMask2D) {
            srcBounds = mask.bounds;
            srcMask = mask.mask;
        }
        int srcW = srcBounds.width;
        int srcH = srcBounds.height;
        boolean[] resMask = new boolean[srcW * srcH * 2 * 2];
        int offSrc = 0;
        int offRes = 0;
        int y = 0;
        while (y < srcH) {
            int x = 0;
            while (x < srcW) {
                boolean v;
                resMask[offRes + 0] = v = srcMask[offSrc++];
                resMask[offRes + 1] = v;
                resMask[offRes + srcW * 2 + 0] = v;
                resMask[offRes + srcW * 2 + 1] = v;
                offRes += 2;
                ++x;
            }
            if ((y & 0xF) == 15 && Thread.interrupted()) {
                throw new InterruptedException("BooleanMask.upscale(..) process interrupted.");
            }
            offRes += srcW * 2;
            ++y;
        }
        return new BooleanMask2D(new Rectangle(srcBounds.x * 2, srcBounds.y * 2, srcW * 2, srcH * 2), resMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDownscaleValues(BooleanMask2D mask) throws InterruptedException {
        boolean[] srcMask;
        Rectangle srcBounds;
        BooleanMask2D booleanMask2D = mask;
        synchronized (booleanMask2D) {
            srcBounds = mask.bounds;
            srcMask = mask.mask;
        }
        int resW = srcBounds.width / 2;
        int resH = srcBounds.height / 2;
        byte[] resMask = new byte[resW * resH];
        int offSrc = 0;
        int offRes = 0;
        int y = 0;
        while (y < resH) {
            int x = 0;
            while (x < resW) {
                int v = 0;
                if (srcMask[offSrc + 0]) {
                    v = (byte)(v + 1);
                }
                if (srcMask[offSrc + 1]) {
                    v = (byte)(v + 1);
                }
                if (srcMask[offSrc + resW * 2 + 0]) {
                    v = (byte)(v + 1);
                }
                if (srcMask[offSrc + resW * 2 + 1]) {
                    v = (byte)(v + 1);
                }
                resMask[offRes++] = v;
                offSrc += 2;
                ++x;
            }
            if ((y & 0xF) == 15 && Thread.interrupted()) {
                throw new InterruptedException("BooleanMask.getDownscaleValues(..) process interrupted.");
            }
            offSrc += resW * 2;
            if ((srcBounds.width & 1) == 1) {
                offSrc += 2;
            }
            ++y;
        }
        return resMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask2D downscale(BooleanMask2D mask, int nbPointForTrue) throws InterruptedException {
        Rectangle srcBounds;
        BooleanMask2D booleanMask2D = mask;
        synchronized (booleanMask2D) {
            srcBounds = mask.bounds;
        }
        int validPt = Math.min(Math.max(nbPointForTrue, 1), 4);
        int resW = srcBounds.width / 2;
        int resH = srcBounds.height / 2;
        byte[] valueMask = BooleanMask2D.getDownscaleValues(mask);
        boolean[] resMask = new boolean[resW * resH];
        int i = 0;
        while (i < valueMask.length) {
            resMask[i] = valueMask[i] >= validPt;
            ++i;
        }
        return new BooleanMask2D(new Rectangle(srcBounds.x / 2, srcBounds.y / 2, resW, resH), resMask);
    }

    public static BooleanMask2D downscale(BooleanMask2D mask) throws InterruptedException {
        return BooleanMask2D.downscale(mask, 2);
    }

    public static BooleanMask2D getUnion(List<BooleanMask2D> masks) throws InterruptedException {
        BooleanMask2D result = null;
        for (BooleanMask2D bm : masks) {
            result = result == null ? new BooleanMask2D(bm.bounds, bm.mask) : BooleanMask2D.getUnion(result, bm);
        }
        if (result == null) {
            result = new BooleanMask2D();
        }
        return result;
    }

    public static BooleanMask2D getUnion(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask2D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask2D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask2D)mask1.clone();
        }
        return BooleanMask2D.getUnion(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getUnion(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        Rectangle union = bounds1.union(bounds2);
        if (!union.isEmpty()) {
            int x;
            boolean[] mask = new boolean[union.width * union.height];
            int offDst = (bounds1.y - union.y) * union.width + (bounds1.x - union.x);
            int offSrc = 0;
            int y = 0;
            while (y < bounds1.height) {
                x = 0;
                while (x < bounds1.width) {
                    int n = offDst + x;
                    mask[n] = mask[n] | mask1[offSrc++];
                    ++x;
                }
                if ((y & 0xF) == 15 && Thread.interrupted()) {
                    throw new InterruptedException("BooleanMask.getUnion(..) process interrupted.");
                }
                offDst += union.width;
                ++y;
            }
            offDst = (bounds2.y - union.y) * union.width + (bounds2.x - union.x);
            offSrc = 0;
            y = 0;
            while (y < bounds2.height) {
                x = 0;
                while (x < bounds2.width) {
                    int n = offDst + x;
                    mask[n] = mask[n] | mask2[offSrc++];
                    ++x;
                }
                if ((y & 0xF) == 15 && Thread.interrupted()) {
                    throw new InterruptedException("BooleanMask.getUnion(..) process interrupted.");
                }
                offDst += union.width;
                ++y;
            }
            return new BooleanMask2D(union, mask);
        }
        return new BooleanMask2D();
    }

    public static BooleanMask2D getIntersection(List<BooleanMask2D> masks) throws InterruptedException {
        BooleanMask2D result = null;
        for (BooleanMask2D bm : masks) {
            result = result == null ? new BooleanMask2D(bm.bounds, bm.mask) : BooleanMask2D.getIntersection(result, bm);
        }
        if (result == null) {
            result = new BooleanMask2D();
        }
        return result;
    }

    public static BooleanMask2D getIntersection(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        if (mask1 == null || mask2 == null) {
            return new BooleanMask2D();
        }
        return BooleanMask2D.getIntersection(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getIntersection(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        Rectangle intersect = bounds1.intersection(bounds2);
        if (!intersect.isEmpty()) {
            boolean[] mask = new boolean[intersect.width * intersect.height];
            int off1 = (intersect.y - bounds1.y) * bounds1.width + (intersect.x - bounds1.x);
            int off2 = (intersect.y - bounds2.y) * bounds2.width + (intersect.x - bounds2.x);
            int off = 0;
            int y = 0;
            while (y < intersect.height) {
                int x = 0;
                while (x < intersect.width) {
                    mask[off++] = mask1[off1 + x] & mask2[off2 + x];
                    ++x;
                }
                if ((y & 0xF) == 15 && Thread.interrupted()) {
                    throw new InterruptedException("BooleanMask.getIntersection(..) process interrupted.");
                }
                off1 += bounds1.width;
                off2 += bounds2.width;
                ++y;
            }
            return new BooleanMask2D(intersect, mask);
        }
        return new BooleanMask2D();
    }

    public static BooleanMask2D getExclusiveUnion(List<BooleanMask2D> masks) throws InterruptedException {
        BooleanMask2D result = null;
        for (BooleanMask2D bm : masks) {
            result = result == null ? new BooleanMask2D(bm.bounds, bm.mask) : BooleanMask2D.getExclusiveUnion(result, bm);
        }
        if (result == null) {
            result = new BooleanMask2D();
        }
        return result;
    }

    public static BooleanMask2D getExclusiveUnion(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask2D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask2D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask2D)mask1.clone();
        }
        return BooleanMask2D.getExclusiveUnion(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getExclusiveUnion(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        Rectangle union = bounds1.union(bounds2);
        if (!union.isEmpty()) {
            int x;
            boolean[] mask = new boolean[union.width * union.height];
            int offDst = (bounds1.y - union.y) * union.width + (bounds1.x - union.x);
            int offSrc = 0;
            int y = 0;
            while (y < bounds1.height) {
                x = 0;
                while (x < bounds1.width) {
                    int n = offDst + x;
                    mask[n] = mask[n] ^ mask1[offSrc++];
                    ++x;
                }
                if ((y & 0xF) == 15 && Thread.interrupted()) {
                    throw new InterruptedException("BooleanMask.getExclusiveUnion(..) process interrupted.");
                }
                offDst += union.width;
                ++y;
            }
            offDst = (bounds2.y - union.y) * union.width + (bounds2.x - union.x);
            offSrc = 0;
            y = 0;
            while (y < bounds2.height) {
                x = 0;
                while (x < bounds2.width) {
                    int n = offDst + x;
                    mask[n] = mask[n] ^ mask2[offSrc++];
                    ++x;
                }
                if ((y & 0xF) == 15 && Thread.interrupted()) {
                    throw new InterruptedException("BooleanMask.getExclusiveUnion(..) process interrupted.");
                }
                offDst += union.width;
                ++y;
            }
            BooleanMask2D result = new BooleanMask2D(union, mask);
            result.optimizeBounds();
            return result;
        }
        return new BooleanMask2D();
    }

    public static BooleanMask2D getSubtraction(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        if (mask1 == null) {
            return new BooleanMask2D();
        }
        if (mask2 == null) {
            return (BooleanMask2D)mask1.clone();
        }
        return BooleanMask2D.getSubtraction(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getSubtraction(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        boolean[] mask = (boolean[])mask1.clone();
        Rectangle subtract = new Rectangle(bounds1);
        BooleanMask2D result = new BooleanMask2D(subtract, mask);
        Rectangle intersection = bounds1.intersection(bounds2);
        if (!intersection.isEmpty()) {
            int offDst = (intersection.y - subtract.y) * subtract.width + (intersection.x - subtract.x);
            int offSrc = (intersection.y - bounds2.y) * bounds2.width + (intersection.x - bounds2.x);
            int y = 0;
            while (y < intersection.height) {
                int x = 0;
                while (x < intersection.width) {
                    int n = offDst + x;
                    mask[n] = mask[n] & !mask2[offSrc + x];
                    ++x;
                }
                if ((y & 0xF) == 15 && Thread.interrupted()) {
                    throw new InterruptedException("BooleanMask.getSubtraction(..) process interrupted.");
                }
                offDst += subtract.width;
                offSrc += bounds2.width;
                ++y;
            }
            result.optimizeBounds();
        }
        return result;
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(List<BooleanMask2D> masks) throws InterruptedException {
        return BooleanMask2D.getUnion(masks);
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(ROI2D[] rois) throws InterruptedException {
        ArrayList<BooleanMask2D> masks = new ArrayList<BooleanMask2D>();
        ROI2D[] rOI2DArray = rois;
        int n = rois.length;
        int n2 = 0;
        while (n2 < n) {
            ROI2D roi = rOI2DArray[n2];
            masks.add(roi.getBooleanMask(true));
            ++n2;
        }
        return BooleanMask2D.getUnionBooleanMask(masks);
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(ArrayList<ROI2D> rois) throws InterruptedException {
        return BooleanMask2D.getUnionBooleanMask(rois.toArray(new ROI2D[rois.size()]));
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        return BooleanMask2D.getUnion(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        return BooleanMask2D.getUnion(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getIntersectionBooleanMask(List<BooleanMask2D> masks) throws InterruptedException {
        return BooleanMask2D.getIntersection(masks);
    }

    @Deprecated
    public static BooleanMask2D getIntersectionBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        return BooleanMask2D.getIntersection(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getIntersectionBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        return BooleanMask2D.getIntersection(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(ROI2D[] rois) throws InterruptedException {
        ArrayList<BooleanMask2D> masks = new ArrayList<BooleanMask2D>();
        ROI2D[] rOI2DArray = rois;
        int n = rois.length;
        int n2 = 0;
        while (n2 < n) {
            ROI2D roi = rOI2DArray[n2];
            masks.add(roi.getBooleanMask(true));
            ++n2;
        }
        return BooleanMask2D.getIntersectionBooleanMask(masks);
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(ArrayList<ROI2D> rois) throws InterruptedException {
        return BooleanMask2D.getIntersectBooleanMask(rois.toArray(new ROI2D[rois.size()]));
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        return BooleanMask2D.getIntersectionBooleanMask(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        return BooleanMask2D.getIntersectionBooleanMask(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(List<BooleanMask2D> masks) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnion(masks);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(ROI2D[] rois) throws InterruptedException {
        ArrayList<BooleanMask2D> masks = new ArrayList<BooleanMask2D>();
        ROI2D[] rOI2DArray = rois;
        int n = rois.length;
        int n2 = 0;
        while (n2 < n) {
            ROI2D roi = rOI2DArray[n2];
            masks.add(roi.getBooleanMask(true));
            ++n2;
        }
        return BooleanMask2D.getExclusiveUnion(masks);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(ArrayList<ROI2D> rois) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnionBooleanMask(rois.toArray(new ROI2D[rois.size()]));
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnion(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnion(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(ROI2D[] rois) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnionBooleanMask(rois);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(ArrayList<ROI2D> rois) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnionBooleanMask(rois);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnionBooleanMask(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnionBooleanMask(bounds1, mask1, bounds2, mask2);
    }

    public BooleanMask2D() {
        this(new Rectangle(), new boolean[0]);
    }

    public BooleanMask2D(Rectangle bounds, boolean[] mask) {
        this.bounds = bounds;
        this.mask = mask;
    }

    public BooleanMask2D(Point[] points) {
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle();
            this.mask = new boolean[0];
        } else {
            Point pt;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            Point[] pointArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                pt = pointArray[n2];
                int x = pt.x;
                int y = pt.y;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                ++n2;
            }
            this.bounds = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
            this.mask = new boolean[this.bounds.width * this.bounds.height];
            pointArray = points;
            n = points.length;
            n2 = 0;
            while (n2 < n) {
                pt = pointArray[n2];
                this.mask[(pt.y - minY) * this.bounds.width + (pt.x - minX)] = true;
                ++n2;
            }
        }
    }

    public BooleanMask2D(int[] points) {
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle();
            this.mask = new boolean[0];
        } else {
            int y;
            int x;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int i = 0;
            while (i < points.length) {
                x = points[i + 0];
                y = points[i + 1];
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                i += 2;
            }
            this.bounds = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
            this.mask = new boolean[this.bounds.width * this.bounds.height];
            i = 0;
            while (i < points.length) {
                x = points[i + 0];
                y = points[i + 1];
                this.mask[(y - minY) * this.bounds.width + (x - minX)] = true;
                i += 2;
            }
        }
    }

    public boolean isEmpty() {
        return this.bounds.isEmpty();
    }

    public boolean contains(int x, int y) {
        if (this.bounds.contains(x, y)) {
            return this.mask[x - this.bounds.x + (y - this.bounds.y) * this.bounds.width];
        }
        return false;
    }

    public boolean contains(BooleanMask2D booleanMask) {
        return this.contains(booleanMask.bounds, booleanMask.mask);
    }

    public boolean contains(Rectangle rect, boolean[] bmask) {
        Rectangle intersect = this.bounds.intersection(rect);
        if (intersect.equals(rect)) {
            int off1 = (intersect.y - this.bounds.y) * this.bounds.width + (intersect.x - this.bounds.x);
            int off2 = (intersect.y - rect.y) * rect.width + (intersect.x - rect.x);
            int y = 0;
            while (y < intersect.height) {
                int x = 0;
                while (x < intersect.width) {
                    if (bmask[off2 + x] && !this.mask[off1 + x]) {
                        return false;
                    }
                    ++x;
                }
                off1 += this.bounds.width;
                off2 += rect.width;
                ++y;
            }
            return true;
        }
        return false;
    }

    public boolean intersects(BooleanMask2D booleanMask) {
        return this.intersects(booleanMask.bounds, booleanMask.mask);
    }

    public boolean intersects(Rectangle rect, boolean[] bmask) {
        Rectangle intersect = this.bounds.intersection(rect);
        if (!intersect.isEmpty()) {
            int off1 = (intersect.y - this.bounds.y) * this.bounds.width + (intersect.x - this.bounds.x);
            int off2 = (intersect.y - rect.y) * rect.width + (intersect.x - rect.x);
            int y = 0;
            while (y < intersect.height) {
                int x = 0;
                while (x < intersect.width) {
                    if (this.mask[off1 + x] && bmask[off2 + x]) {
                        return true;
                    }
                    ++x;
                }
                off1 += this.bounds.width;
                off2 += rect.width;
                ++y;
            }
        }
        return false;
    }

    public int getNumberOfPoints() {
        int result = 0;
        int i = 0;
        while (i < this.mask.length) {
            if (!this.mask[i++]) continue;
            ++result;
        }
        return result;
    }

    public Point[] getPoints() throws InterruptedException {
        return TypeUtil.toPoint(this.getPointsAsIntArray());
    }

    public int[] getPointsAsIntArray() throws InterruptedException {
        if (this.bounds.isEmpty()) {
            return new int[0];
        }
        int[] points = new int[this.mask.length * 2];
        int maxx = this.bounds.x + this.bounds.width;
        int maxy = this.bounds.y + this.bounds.height;
        int pt = 0;
        int off = 0;
        int y = this.bounds.y;
        while (y < maxy) {
            int x = this.bounds.x;
            while (x < maxx) {
                if (this.mask[off++]) {
                    points[pt++] = x;
                    points[pt++] = y;
                }
                ++x;
            }
            if ((y & 0xF) == 15 && Thread.interrupted()) {
                throw new InterruptedException("BooleanMask.set(..) process interrupted.");
            }
            ++y;
        }
        int[] result = new int[pt];
        System.arraycopy(points, 0, result, 0, pt);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected List<Component> getComponentsPointsInternal() throws InterruptedException {
        ArrayList<Object> components = new ArrayList<Object>();
        int w = this.bounds.width;
        int minx = this.bounds.x;
        int miny = this.bounds.y;
        Object[] line0 = new Component[w + 2];
        Object[] line1 = new Component[w + 2];
        Arrays.fill(line0, null);
        Arrays.fill(line1, null);
        Object[] prevLine = line0;
        Object[] currLine = line1;
        int offset = 0;
        int y = 0;
        while (y < this.bounds.height) {
            void var14_17;
            Object topleft = null;
            Object left = null;
            boolean bl = false;
            while (var14_17 < w) {
                Object top = prevLine[var14_17 + true];
                if (this.mask[offset++]) {
                    if (topleft != null) {
                        if (left != null && left != topleft) {
                            ((Component)topleft).addComponent((Component)left);
                        }
                        left = topleft;
                    } else if (top != null) {
                        if (left != null && left != top) {
                            ((Component)top).addComponent((Component)left);
                        }
                        left = top;
                    } else if (left == null) {
                        left = new Component();
                        components.add(left);
                    }
                    ((Component)left).addPoint((int)(var14_17 + minx), y + miny);
                } else {
                    if (left != null && top != null && left != top) {
                        ((Component)top).addComponent((Component)left);
                    }
                    left = null;
                }
                topleft = top;
                currLine[var14_17 + true] = left;
                ++var14_17;
            }
            if ((y & 0xF) == 15 && Thread.interrupted()) {
                throw new InterruptedException("BooleanMask.getComponentsPointsInternal() process interrupted.");
            }
            Object[] objectArray = prevLine;
            prevLine = currLine;
            currLine = objectArray;
            ++y;
        }
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component component : components) {
            if (!component.isRoot()) continue;
            result.add(component);
        }
        return result;
    }

    public Point[][] getComponentsPoints(boolean sorted) throws InterruptedException {
        if (this.bounds.isEmpty()) {
            return new Point[0][0];
        }
        Comparator<Point> pointComparator = sorted ? new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                if (p1.y < p2.y) {
                    return -1;
                }
                if (p1.y > p2.y) {
                    return 1;
                }
                return 0;
            }
        } : null;
        int[][] cPoints = this.getComponentsPointsAsIntArray();
        Point[][] cResult = new Point[cPoints.length][];
        int i = 0;
        while (i < cPoints.length) {
            Point[] result = TypeUtil.toPoint(cPoints[i]);
            if (pointComparator != null) {
                Arrays.sort(result, pointComparator);
            }
            cResult[i] = result;
            ++i;
        }
        return cResult;
    }

    public int[][] getComponentsPointsAsIntArray() throws InterruptedException {
        if (this.bounds.isEmpty()) {
            return new int[0][0];
        }
        List<Component> components = this.getComponentsPointsInternal();
        int[][] result = new int[components.size()][];
        int i = 0;
        while (i < result.length) {
            result[i] = components.get(i).getAllPoints();
            ++i;
        }
        return result;
    }

    public BooleanMask2D[] getComponents() throws InterruptedException {
        if (this.bounds.isEmpty()) {
            return new BooleanMask2D[0];
        }
        int[][] componentsPoints = this.getComponentsPointsAsIntArray();
        ArrayList<BooleanMask2D> result = new ArrayList<BooleanMask2D>();
        int[][] nArray = componentsPoints;
        int n = componentsPoints.length;
        int n2 = 0;
        while (n2 < n) {
            int[] componentPoints = nArray[n2];
            result.add(new BooleanMask2D(componentPoints));
            ++n2;
        }
        return result.toArray(new BooleanMask2D[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Point> getConnectedContourPoints() throws InterruptedException {
        Rectangle contourBounds;
        boolean[] contourMask;
        int[] intArrayPoints = this.getContourPointsAsIntArray();
        ArrayList allPoints = new ArrayList();
        if (intArrayPoints.length == 0) {
            return new ArrayList<Point>(0);
        }
        BooleanMask2D booleanMask2D = this;
        synchronized (booleanMask2D) {
            contourMask = new boolean[this.mask.length];
            contourBounds = this.bounds;
        }
        int minx = contourBounds.x;
        int miny = contourBounds.y;
        int w = contourBounds.width;
        int i = 0;
        while (i < intArrayPoints.length) {
            contourMask[intArrayPoints[i + 0] - minx + (intArrayPoints[i + 1] - miny) * w] = true;
            i += 2;
        }
        int maxx = minx + (w - 1);
        int maxy = miny + (contourBounds.height - 1);
        boolean[] visitedMask = new boolean[contourMask.length];
        int startOffset = BooleanMask2D.findStartPoint(0, contourMask, visitedMask);
        while (startOffset != -1) {
            ArrayList<Point> points = new ArrayList<Point>(intArrayPoints.length / 2);
            int offset = startOffset;
            int x = offset % w + minx;
            int y = offset / w + miny;
            visitedMask[offset] = true;
            points.add(new Point(x, y));
            int scan = 0;
            int remain = 8;
            while (remain-- > 0) {
                switch (scan & 7) {
                    case 0: {
                        int tmpOff;
                        if (x >= maxx || !contourMask[tmpOff = offset + 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(++x, y));
                        scan = 6;
                        remain = 8;
                        break;
                    }
                    case 1: {
                        int tmpOff;
                        if (x >= maxx || y >= maxy || !contourMask[tmpOff = offset + w + 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(++x, ++y));
                        scan = 6;
                        remain = 8;
                        break;
                    }
                    case 2: {
                        int tmpOff;
                        if (y >= maxy || !contourMask[tmpOff = offset + w]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(x, ++y));
                        scan = 0;
                        remain = 8;
                        break;
                    }
                    case 3: {
                        int tmpOff;
                        if (x <= minx || y >= maxy || !contourMask[tmpOff = offset + w - 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(--x, ++y));
                        scan = 0;
                        remain = 8;
                        break;
                    }
                    case 4: {
                        int tmpOff;
                        if (x <= minx || !contourMask[tmpOff = offset - 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(--x, y));
                        scan = 2;
                        remain = 8;
                        break;
                    }
                    case 5: {
                        int tmpOff;
                        if (x <= minx || y <= miny || !contourMask[tmpOff = offset - (w + 1)]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(--x, --y));
                        scan = 2;
                        remain = 8;
                        break;
                    }
                    case 6: {
                        int tmpOff;
                        if (y <= miny || !contourMask[tmpOff = offset - w]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(x, --y));
                        scan = 4;
                        remain = 8;
                        break;
                    }
                    case 7: {
                        int tmpOff;
                        if (x >= maxx || y <= miny || !contourMask[tmpOff = offset - w + 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(++x, --y));
                        scan = 4;
                        remain = 8;
                    }
                }
                scan = scan + 1 & 7;
            }
            allPoints.add(points);
            startOffset = BooleanMask2D.findStartPoint(startOffset, contourMask, visitedMask);
        }
        List<Point> result = new ArrayList<Point>((Collection)allPoints.get(0));
        allPoints.remove(0);
        int i2 = 0;
        while (i2 < allPoints.size()) {
            List<Point> newResult = BooleanMask2D.connect(result, (List)allPoints.get(i2));
            if (newResult != null) {
                result = newResult;
                allPoints.remove(i2);
                i2 = 0;
                continue;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < allPoints.size()) {
            List<Point> newResult = BooleanMask2D.insertPoints(result, (List)allPoints.get(i2));
            if (newResult != null) {
                result = newResult;
                allPoints.remove(i2);
                i2 = 0;
                continue;
            }
            ++i2;
        }
        return result;
    }

    public Point[] getContourPoints() throws InterruptedException {
        return TypeUtil.toPoint(this.getContourPointsAsIntArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getContourPointsAsIntArray() throws InterruptedException {
        int y;
        Rectangle bounds;
        boolean[] mask;
        if (this.isEmpty()) {
            return new int[0];
        }
        BooleanMask2D booleanMask2D = this;
        synchronized (booleanMask2D) {
            mask = this.mask;
            bounds = this.bounds;
        }
        int[] points = new int[mask.length * 2];
        int h = bounds.height;
        int w = bounds.width;
        int maxx = bounds.x + (w - 1);
        int maxy = bounds.y + (h - 1);
        boolean top = false;
        boolean bottom = false;
        boolean left = false;
        boolean right = false;
        int offset = 0;
        int pt = 0;
        if (w <= 2 || h <= 2) {
            y = bounds.y;
            while (y <= maxy) {
                int x = bounds.x;
                while (x <= maxx) {
                    if (mask[offset++]) {
                        points[pt++] = x;
                        points[pt++] = y;
                    }
                    ++x;
                }
                ++y;
            }
        } else {
            top = false;
            left = false;
            boolean current = mask[offset];
            bottom = mask[offset + w];
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = bounds.x;
                points[pt++] = bounds.y;
            }
            int x = bounds.x + 1;
            while (x < maxx) {
                left = current;
                current = right;
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points[pt++] = x;
                    points[pt++] = bounds.y;
                }
                ++x;
            }
            left = current;
            current = right;
            bottom = mask[offset + w];
            right = false;
            ++offset;
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = maxx;
                points[pt++] = bounds.y;
            }
            y = bounds.y + 1;
            while (y < maxy) {
                if ((y & 0xF) == 15 && Thread.interrupted()) {
                    throw new InterruptedException("BooleanMask.getContourPointsAsIntArray() process interrupted.");
                }
                left = false;
                current = mask[offset];
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points[pt++] = bounds.x;
                    points[pt++] = y;
                }
                int x2 = bounds.x + 1;
                while (x2 < maxx) {
                    left = current;
                    current = right;
                    top = mask[offset - w];
                    bottom = mask[offset + w];
                    right = mask[++offset];
                    if (!(!current || top && left && right && bottom)) {
                        points[pt++] = x2;
                        points[pt++] = y;
                    }
                    ++x2;
                }
                left = current;
                current = right;
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = false;
                ++offset;
                if (!(!current || top && left && right && bottom)) {
                    points[pt++] = maxx;
                    points[pt++] = y;
                }
                ++y;
            }
            left = false;
            current = mask[offset];
            top = mask[offset - w];
            bottom = false;
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = bounds.x;
                points[pt++] = maxy;
            }
            x = bounds.x + 1;
            while (x < maxx) {
                left = current;
                current = right;
                top = mask[offset - w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points[pt++] = x;
                    points[pt++] = maxy;
                }
                ++x;
            }
            left = current;
            current = right;
            top = mask[offset - w];
            right = false;
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = maxx;
                points[pt++] = maxy;
            }
        }
        int[] result = new int[pt];
        System.arraycopy(points, 0, result, 0, pt);
        return result;
    }

    @Deprecated
    public Point[] getEdgePoints() throws InterruptedException {
        return TypeUtil.toPoint(this.getContourPointsAsIntArray());
    }

    public double getContourLength() throws InterruptedException {
        double perimeter = 0.0;
        int[] edge = this.getContourPointsAsIntArray();
        int baseX = this.bounds.x;
        int baseY = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        double sideEdges = 0.0;
        double cornerEdges = 0.0;
        int i = 0;
        while (i < edge.length) {
            boolean bottomRightConnected;
            boolean bottomConnected;
            boolean bottomLeftConnected;
            boolean rightConnected;
            boolean topRightConnected;
            boolean topConnected;
            boolean topLeftConnected;
            int x = edge[i + 0] - baseX;
            int y = edge[i + 1] - baseY;
            int xy = x + y * width;
            if (y != 0) {
                topLeftConnected = x != 0 && this.mask[xy - 1 - width];
                topConnected = this.mask[xy + 0 - width];
                topRightConnected = x != width - 1 && this.mask[xy + 1 - width];
            } else {
                topLeftConnected = false;
                topConnected = false;
                topRightConnected = false;
            }
            boolean leftConnected = x != 0 && this.mask[xy - 1];
            boolean bl = rightConnected = x != width - 1 && this.mask[xy + 1];
            if (y != height - 1) {
                bottomLeftConnected = x != 0 && this.mask[xy - 1 + width];
                bottomConnected = this.mask[xy + 0 + width];
                bottomRightConnected = x != width - 1 && this.mask[xy + 1 + width];
            } else {
                bottomLeftConnected = false;
                bottomConnected = false;
                bottomRightConnected = false;
            }
            int directConnection = 0;
            int diagConnection = 0;
            if (topLeftConnected) {
                ++diagConnection;
            }
            if (topConnected) {
                ++directConnection;
            }
            if (topRightConnected) {
                ++diagConnection;
            }
            if (leftConnected) {
                ++directConnection;
            }
            if (rightConnected) {
                ++directConnection;
            }
            if (bottomLeftConnected) {
                ++diagConnection;
            }
            if (bottomConnected) {
                ++directConnection;
            }
            if (bottomRightConnected) {
                ++diagConnection;
            }
            block0 : switch (directConnection) {
                case 0: {
                    switch (diagConnection) {
                        case 0: {
                            perimeter += Math.PI;
                            break block0;
                        }
                        case 1: {
                            cornerEdges += 1.0;
                            perimeter += Math.sqrt(2.0) + 1.5707963267948966;
                            break block0;
                        }
                    }
                    cornerEdges += 2.0;
                    perimeter += 2.0 * Math.sqrt(2.0);
                    break;
                }
                case 1: {
                    switch (diagConnection) {
                        case 0: {
                            sideEdges += 1.0;
                            perimeter += 2.5707963267948966;
                            break block0;
                        }
                    }
                    cornerEdges += 1.0;
                    sideEdges += 1.0;
                    perimeter += 1.0 + Math.sqrt(2.0);
                    break;
                }
                case 2: {
                    if (leftConnected && rightConnected || topConnected && bottomConnected) {
                        double dgc = (double)diagConnection * 0.5;
                        double dtc = 2.0 - dgc;
                        cornerEdges += dgc;
                        sideEdges += dtc;
                        perimeter += dtc + dgc * Math.sqrt(2.0);
                        break;
                    }
                    cornerEdges += 1.0;
                    perimeter += Math.sqrt(2.0);
                    break;
                }
                case 3: {
                    switch (diagConnection) {
                        default: {
                            sideEdges += 1.0;
                            perimeter += 1.0;
                            break block0;
                        }
                        case 3: {
                            cornerEdges += 0.5;
                            sideEdges += 0.5;
                            perimeter += 0.5 + Math.sqrt(2.0) / 2.0;
                            break block0;
                        }
                        case 4: 
                    }
                    cornerEdges += 1.0;
                    perimeter += Math.sqrt(2.0);
                    break;
                }
            }
            i += 2;
        }
        double overShoot = Math.min(sideEdges / 10.0, cornerEdges);
        return perimeter - overShoot;
    }

    public BooleanMask2D getIntersection(BooleanMask2D booleanMask) throws InterruptedException {
        return BooleanMask2D.getIntersection(this, booleanMask);
    }

    public BooleanMask2D getIntersection(Rectangle bounds, boolean[] mask) throws InterruptedException {
        return BooleanMask2D.getIntersection(this.bounds, this.mask, bounds, mask);
    }

    @Deprecated
    public BooleanMask2D getIntersect(BooleanMask2D booleanMask) throws InterruptedException {
        return this.getIntersection(booleanMask);
    }

    @Deprecated
    public BooleanMask2D getIntersect(Rectangle bounds, boolean[] mask) throws InterruptedException {
        return this.getIntersection(bounds, mask);
    }

    public BooleanMask2D getUnion(BooleanMask2D booleanMask) throws InterruptedException {
        return BooleanMask2D.getUnion(this, booleanMask);
    }

    public BooleanMask2D getUnion(Rectangle bounds, boolean[] mask) throws InterruptedException {
        return BooleanMask2D.getUnion(this.bounds, this.mask, bounds, mask);
    }

    public BooleanMask2D getExclusiveUnion(BooleanMask2D booleanMask) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnion(this, booleanMask);
    }

    public BooleanMask2D getExclusiveUnion(Rectangle bounds, boolean[] mask) throws InterruptedException {
        return BooleanMask2D.getExclusiveUnion(this.bounds, this.mask, bounds, mask);
    }

    public BooleanMask2D getSubtraction(BooleanMask2D mask) throws InterruptedException {
        return BooleanMask2D.getSubtraction(this, mask);
    }

    public BooleanMask2D getSubtraction(Rectangle bounds, boolean[] mask) throws InterruptedException {
        return BooleanMask2D.getSubtraction(this.bounds, this.mask, bounds, mask);
    }

    @Deprecated
    public BooleanMask2D getXor(BooleanMask2D booleanMask) throws InterruptedException {
        return this.getExclusiveUnion(booleanMask);
    }

    @Deprecated
    public BooleanMask2D getXor(Rectangle bounds, boolean[] mask) throws InterruptedException {
        return this.getExclusiveUnion(bounds, mask);
    }

    public void add(BooleanMask2D booleanMask) throws InterruptedException {
        this.add(booleanMask.bounds, booleanMask.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Rectangle boundsToAdd, boolean[] maskToAdd) throws InterruptedException {
        if (this.bounds.contains(boundsToAdd)) {
            int offDst = (boundsToAdd.y - this.bounds.y) * this.bounds.width + (boundsToAdd.x - this.bounds.x);
            int offSrc = 0;
            int y = 0;
            while (y < boundsToAdd.height) {
                int x = 0;
                while (x < boundsToAdd.width) {
                    if (maskToAdd[offSrc++]) {
                        this.mask[offDst + x] = true;
                    }
                    ++x;
                }
                offDst += this.bounds.width;
                ++y;
            }
        } else {
            BooleanMask2D result = this.getUnion(boundsToAdd, maskToAdd);
            BooleanMask2D booleanMask2D = this;
            synchronized (booleanMask2D) {
                this.bounds = result.bounds;
                this.mask = result.mask;
            }
        }
    }

    public void intersect(BooleanMask2D booleanMask) throws InterruptedException {
        this.intersect(booleanMask.bounds, booleanMask.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(Rectangle boundsToIntersect, boolean[] maskToIntersect) throws InterruptedException {
        BooleanMask2D result = this.getIntersection(boundsToIntersect, maskToIntersect);
        BooleanMask2D booleanMask2D = this;
        synchronized (booleanMask2D) {
            this.bounds = result.bounds;
            this.mask = result.mask;
        }
    }

    public void exclusiveAdd(BooleanMask2D booleanMask) throws InterruptedException {
        this.exclusiveAdd(booleanMask.bounds, booleanMask.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveAdd(Rectangle boundsToXAdd, boolean[] maskToXAdd) throws InterruptedException {
        if (this.bounds.contains(boundsToXAdd)) {
            int offDst = (boundsToXAdd.y - this.bounds.y) * this.bounds.width + (boundsToXAdd.x - this.bounds.x);
            int offSrc = 0;
            int y = 0;
            while (y < boundsToXAdd.height) {
                int x = 0;
                while (x < boundsToXAdd.width) {
                    if (maskToXAdd[offSrc++]) {
                        this.mask[offDst + x] = !this.mask[offDst + x];
                    }
                    ++x;
                }
                offDst += this.bounds.width;
                ++y;
            }
            this.optimizeBounds();
        } else {
            BooleanMask2D result = this.getExclusiveUnion(boundsToXAdd, maskToXAdd);
            BooleanMask2D booleanMask2D = this;
            synchronized (booleanMask2D) {
                this.bounds = result.bounds;
                this.mask = result.mask;
            }
        }
    }

    public void subtract(Rectangle boundsToSubtract, boolean[] maskToSubtract) {
        Rectangle intersection = this.bounds.intersection(boundsToSubtract);
        if (!intersection.isEmpty()) {
            int offDst = (intersection.y - this.bounds.y) * this.bounds.width + (intersection.x - this.bounds.x);
            int offSrc = (intersection.y - boundsToSubtract.y) * boundsToSubtract.width + (intersection.x - boundsToSubtract.x);
            int y = 0;
            while (y < intersection.height) {
                int x = 0;
                while (x < intersection.width) {
                    if (maskToSubtract[offSrc + x]) {
                        this.mask[offDst + x] = false;
                    }
                    ++x;
                }
                offDst += this.bounds.width;
                offSrc += boundsToSubtract.width;
                ++y;
            }
            this.optimizeBounds();
        }
    }

    @Deprecated
    public void union(BooleanMask2D booleanMask) throws InterruptedException {
        this.add(booleanMask.bounds, booleanMask.mask);
    }

    @Deprecated
    public void union(Rectangle bounds, boolean[] mask) throws InterruptedException {
        this.add(bounds, mask);
    }

    @Deprecated
    public void exclusiveUnion(BooleanMask2D booleanMask) throws InterruptedException {
        this.exclusiveAdd(booleanMask.bounds, booleanMask.mask);
    }

    @Deprecated
    public void exclusiveUnion(Rectangle bounds, boolean[] mask) throws InterruptedException {
        this.exclusiveAdd(bounds, mask);
    }

    @Deprecated
    public void xor(BooleanMask2D booleanMask) throws InterruptedException {
        this.exclusiveAdd(booleanMask);
    }

    @Deprecated
    public void xor(Rectangle bounds, boolean[] mask) throws InterruptedException {
        this.exclusiveAdd(bounds, mask);
    }

    public Rectangle getOptimizedBounds() {
        int sizeX = this.bounds.width;
        int sizeY = this.bounds.height;
        int minX = sizeX;
        int minY = sizeY;
        int maxX = -1;
        int maxY = -1;
        int offset = 0;
        int y = 0;
        while (y < sizeY) {
            int x = 0;
            while (x < sizeX) {
                if (this.mask[offset++]) {
                    if (x < minX) {
                        minX = x;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                }
                ++x;
            }
            ++y;
        }
        if (minX == sizeX) {
            return new Rectangle(this.bounds.x, this.bounds.y, 0, 0);
        }
        return new Rectangle(this.bounds.x + minX, this.bounds.y + minY, maxX - minX + 1, maxY - minY + 1);
    }

    public void optimizeBounds() {
        this.moveBounds(this.getOptimizedBounds());
    }

    @Deprecated
    public void setBounds(Rectangle value) {
        this.moveBounds(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveBounds(Rectangle value) {
        if (!this.bounds.equals(value)) {
            Rectangle oldBounds = new Rectangle(this.bounds);
            Rectangle newBounds = new Rectangle(value);
            oldBounds.translate(-this.bounds.x, -this.bounds.y);
            newBounds.translate(-this.bounds.x, -this.bounds.y);
            boolean[] newMask = new boolean[Math.max(0, newBounds.width) * Math.max(0, newBounds.height)];
            Rectangle intersect = newBounds.intersection(oldBounds);
            if (!intersect.isEmpty()) {
                int offSrc = 0;
                int offDst = 0;
                if (intersect.x > 0) {
                    offSrc += intersect.x;
                }
                if (intersect.y > 0) {
                    offSrc += intersect.y * oldBounds.width;
                }
                if (newBounds.x < 0) {
                    offDst += -newBounds.x;
                }
                if (newBounds.y < 0) {
                    offDst += -newBounds.y * newBounds.width;
                }
                int j = 0;
                while (j < intersect.height) {
                    System.arraycopy(this.mask, offSrc, newMask, offDst, intersect.width);
                    offSrc += oldBounds.width;
                    offDst += newBounds.width;
                    ++j;
                }
            }
            BooleanMask2D booleanMask2D = this;
            synchronized (booleanMask2D) {
                this.mask = newMask;
                this.bounds = value;
            }
        }
    }

    public BooleanMask2D upscale() throws InterruptedException {
        return BooleanMask2D.upscale(this);
    }

    public BooleanMask2D downscale(int nbPointForTrue) throws InterruptedException {
        return BooleanMask2D.downscale(this, nbPointForTrue);
    }

    public BooleanMask2D downscale() throws InterruptedException {
        return BooleanMask2D.downscale(this);
    }

    public Object clone() {
        return new BooleanMask2D((Rectangle)this.bounds.clone(), (boolean[])this.mask.clone());
    }

    private static class Component {
        public DynamicArray.Int points = new DynamicArray.Int(0);
        public List<Component> children = new ArrayList<Component>();
        private Component root = this;

        public void addPoint(int x, int y) {
            this.points.addSingle(x);
            this.points.addSingle(y);
        }

        public void addComponent(Component c) {
            Component croot = c.root;
            if (c != this && croot != this.root) {
                this.children.add(croot);
                croot.setRoot(this.root);
            }
        }

        public boolean isRoot() {
            return this.root == this;
        }

        private void setRoot(Component value) {
            this.root = value;
            int size = this.children.size();
            int c = 0;
            while (c < size) {
                this.children.get(c).setRoot(value);
                ++c;
            }
        }

        public int getTotalSize() {
            int result = this.points.getSize();
            int size = this.children.size();
            int c = 0;
            while (c < size) {
                result += this.children.get(c).getTotalSize();
                ++c;
            }
            return result;
        }

        public int[] getAllPoints() {
            int[] result = new int[this.getTotalSize()];
            this.getAllPoints(result, 0);
            return result;
        }

        private int getAllPoints(int[] result, int offset) {
            int[] intPoints = this.points.asArray();
            System.arraycopy(intPoints, 0, result, offset, intPoints.length);
            int off = offset + intPoints.length;
            int csize = this.children.size();
            int c = 0;
            while (c < csize) {
                off = this.children.get(c).getAllPoints(result, off);
                ++c;
            }
            return off;
        }
    }
}

