/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.canvas.IcyCanvas;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.BooleanMask4D;
import icy.roi.ROI;
import icy.type.point.Point4D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle4D;
import icy.type.rectangle.Rectangle5D;
import icy.util.XMLUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

@Deprecated
public abstract class ROI4D
extends ROI {
    public static final String ID_C = "c";
    protected int c = -1;

    @Deprecated
    public static ArrayList<ROI4D> getROI4DList(ArrayList<ROI> rois) {
        ArrayList<ROI4D> result = new ArrayList<ROI4D>();
        for (ROI roi : rois) {
            if (!(roi instanceof ROI4D)) continue;
            result.add((ROI4D)roi);
        }
        return result;
    }

    public static List<ROI4D> getROI4DList(List<ROI> rois) {
        ArrayList<ROI4D> result = new ArrayList<ROI4D>();
        for (ROI roi : rois) {
            if (!(roi instanceof ROI4D)) continue;
            result.add((ROI4D)roi);
        }
        return result;
    }

    @Override
    public String getDefaultName() {
        return "ROI4D";
    }

    @Override
    public final int getDimension() {
        return 4;
    }

    protected boolean onSamePos(ROI4D roi, boolean shouldContain) {
        int c = this.getC();
        int roiC = roi.getC();
        return !(shouldContain ? c != -1 && c != roiC : c != -1 && roiC != -1 && c != roiC);
    }

    public boolean contains(Point4D p) {
        return this.contains(p.getX(), p.getY(), p.getZ(), p.getT());
    }

    public boolean contains(Rectangle4D r) {
        return this.contains(r.getX(), r.getY(), r.getZ(), r.getT(), r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeT());
    }

    public abstract boolean contains(double var1, double var3, double var5, double var7);

    public abstract boolean contains(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    @Override
    public boolean contains(double x, double y, double z, double t, double c) {
        boolean cok;
        if (this.getC() == -1) {
            cok = true;
        } else {
            boolean bl = cok = c >= (double)this.getC() && c < (double)this.getC() + 1.0;
        }
        return this.contains(x, y, z, t) && cok;
    }

    @Override
    public boolean contains(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeT, double sizeZ, double sizeC) {
        boolean cok;
        if (this.getC() == -1) {
            cok = true;
        } else {
            boolean bl = cok = c >= (double)this.getC() && c + sizeC <= (double)this.getC() + 1.0;
        }
        return this.contains(x, y, z, t, sizeX, sizeY, sizeZ, sizeT) && cok;
    }

    @Override
    public boolean contains(ROI roi) throws InterruptedException {
        if (roi instanceof ROI4D) {
            ROI4D roi4d = (ROI4D)roi;
            if (this.onSamePos(roi4d, true)) {
                BooleanMask4D roiMask;
                if (roi4d.isEmpty()) {
                    return this.contains(roi4d.getPosition4D());
                }
                if (!this.contains(roi4d.getBounds4D())) {
                    return false;
                }
                BooleanMask4D mask = this.getBooleanMask(false);
                if (!mask.contains(roiMask = roi4d.getBooleanMask(false))) {
                    return false;
                }
                mask = this.getBooleanMask(true);
                return mask.contains(roiMask = roi4d.getBooleanMask(true));
            }
            return false;
        }
        return super.contains(roi);
    }

    public boolean intersects(Rectangle4D r) {
        return this.intersects(r.getX(), r.getY(), r.getZ(), r.getT(), r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeT());
    }

    public abstract boolean intersects(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    @Override
    public boolean intersects(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
        boolean cok;
        if (sizeX == 0.0 || sizeY == 0.0 || sizeZ == 0.0 || sizeT == 0.0 || sizeC == 0.0) {
            return false;
        }
        if (this.getC() == -1 || sizeC == Double.POSITIVE_INFINITY) {
            cok = true;
        } else {
            boolean bl = cok = c + sizeC > (double)this.getC() && c < (double)this.getC() + 1.0;
        }
        return cok && this.intersects(x, y, z, t, sizeX, sizeY, sizeZ, sizeT);
    }

    @Override
    public boolean intersects(ROI roi) throws InterruptedException {
        ROI4D roi4d;
        if (roi instanceof ROI4D && this.onSamePos(roi4d = (ROI4D)roi, false)) {
            if (!this.intersects(roi4d.getBounds4D())) {
                return false;
            }
            return this.getBooleanMask(true).intersects(roi4d.getBooleanMask(true));
        }
        return super.intersects(roi);
    }

    public abstract Rectangle4D computeBounds4D();

    @Override
    public Rectangle5D computeBounds5D() {
        Rectangle4D bounds4D = this.computeBounds4D();
        if (bounds4D == null) {
            return new Rectangle5D.Double();
        }
        Rectangle5D.Double result = new Rectangle5D.Double(bounds4D.getX(), bounds4D.getY(), bounds4D.getZ(), bounds4D.getT(), 0.0, bounds4D.getSizeX(), bounds4D.getSizeY(), bounds4D.getSizeZ(), bounds4D.getSizeT(), 0.0);
        if (this.getC() == -1) {
            result.c = Double.NEGATIVE_INFINITY;
            result.sizeC = Double.POSITIVE_INFINITY;
        } else {
            result.c = this.getC();
            result.sizeC = 1.0;
        }
        return result;
    }

    public Rectangle4D.Integer getBounds() {
        return this.getBounds4D().toInteger();
    }

    public Rectangle4D getBounds4D() {
        return this.getBounds5D().toRectangle4D();
    }

    public Point4D.Integer getPosition() {
        Rectangle4D.Integer bounds = this.getBounds();
        return new Point4D.Integer(bounds.x, bounds.y, bounds.z, bounds.t);
    }

    public Point4D getPosition4D() {
        return this.getBounds4D().getPosition();
    }

    @Override
    public boolean canSetBounds() {
        return false;
    }

    public void setBounds4D(Rectangle4D bounds) {
    }

    @Override
    public void setBounds5D(Rectangle5D bounds) {
        this.beginUpdate();
        try {
            if (bounds.getSizeC() == Double.POSITIVE_INFINITY) {
                this.setC(-1);
            } else {
                this.setC((int)bounds.getC());
            }
            this.setBounds4D(bounds.toRectangle4D());
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean canSetPosition() {
        return this.canTranslate();
    }

    public void setPosition4D(Point4D position) {
        if (this.canTranslate()) {
            Point4D oldPos = this.getPosition4D();
            this.translate(position.getX() - oldPos.getX(), position.getY() - oldPos.getY(), position.getZ() - oldPos.getZ(), position.getT() - oldPos.getT());
        }
    }

    @Override
    public void setPosition5D(Point5D position) {
        this.beginUpdate();
        try {
            this.setC((int)position.getC());
            this.setPosition4D(position.toPoint4D());
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean canTranslate() {
        return false;
    }

    public void translate(double dx, double dy, double dz, double dt) {
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(c)) {
            return new boolean[Math.max(0, width) * Math.max(0, height)];
        }
        return this.getBooleanMask2D(x, y, width, height, z, t, inclusive);
    }

    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, int t, boolean inclusive) throws InterruptedException {
        boolean[] result = new boolean[Math.max(0, width) * Math.max(0, height)];
        int offset = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                result[offset] = inclusive ? this.intersects(x + i, y + j, z, t, 1.0, 1.0, 1.0, 1.0) : this.contains(x + i, y + j, z, t, 1.0, 1.0, 1.0, 1.0);
                ++offset;
                ++i;
            }
            if ((j & 0xF) == 15 && Thread.interrupted()) {
                throw new InterruptedException("ROI4D.getBooleanMask2D(..) process interrupted.");
            }
            ++j;
        }
        return result;
    }

    public boolean[] getBooleanMask2D(Rectangle rect, int z, int t, boolean inclusive) throws InterruptedException {
        return this.getBooleanMask2D(rect.x, rect.y, rect.width, rect.height, z, t, inclusive);
    }

    @Override
    public BooleanMask2D getBooleanMask2D(int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(c)) {
            return new BooleanMask2D(new Rectangle(), new boolean[0]);
        }
        return this.getBooleanMask2D(z, t, inclusive);
    }

    public BooleanMask2D getBooleanMask2D(int z, int t, boolean inclusive) throws InterruptedException {
        Rectangle bounds = this.getBounds4D().toRectangle2D().getBounds();
        if (bounds.isEmpty()) {
            return new BooleanMask2D(new Rectangle(), new boolean[0]);
        }
        BooleanMask2D result = new BooleanMask2D(bounds, this.getBooleanMask2D(bounds, z, t, inclusive));
        result.optimizeBounds();
        return result;
    }

    public BooleanMask3D getBooleanMask3D(int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(c)) {
            return new BooleanMask3D();
        }
        if (z == -1) {
            return this.getBooleanMask3D(t, inclusive);
        }
        Rectangle3D.Integer bounds = this.getBounds4D().toRectangle3D().toInteger();
        bounds.setZ(z);
        bounds.setSizeZ(1.0);
        return new BooleanMask3D(bounds, new BooleanMask2D[]{this.getBooleanMask2D(z, t, inclusive)});
    }

    public BooleanMask3D getBooleanMask3D(int t, boolean inclusive) throws InterruptedException {
        Rectangle3D.Integer bounds = this.getBounds4D().toRectangle3D().toInteger();
        BooleanMask2D[] masks = new BooleanMask2D[bounds.sizeZ];
        int z = 0;
        while (z < masks.length) {
            masks[z] = this.getBooleanMask2D(bounds.z + z, t, inclusive);
            ++z;
        }
        return new BooleanMask3D(bounds, masks);
    }

    public BooleanMask4D getBooleanMask4D(int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(c)) {
            return new BooleanMask4D();
        }
        if (z == -1) {
            if (t == -1) {
                return this.getBooleanMask(inclusive);
            }
            Rectangle4D.Integer bounds = this.getBounds4D().toInteger();
            bounds.setT(t);
            bounds.setSizeT(1.0);
            return new BooleanMask4D(bounds, new BooleanMask3D[]{this.getBooleanMask3D(t, inclusive)});
        }
        Rectangle4D.Integer bounds4d = this.getBounds4D().toInteger();
        bounds4d.setZ(z);
        bounds4d.setSizeZ(1.0);
        if (t != -1) {
            bounds4d.setT(t);
            bounds4d.setSizeT(1.0);
        }
        Rectangle3D.Integer bounds3d = (Rectangle3D.Integer)bounds4d.toRectangle3D();
        BooleanMask3D[] masks = new BooleanMask3D[bounds4d.sizeT];
        int i = 0;
        while (i < bounds4d.sizeT) {
            masks[i] = new BooleanMask3D((Rectangle3D.Integer)bounds3d.clone(), new BooleanMask2D[]{this.getBooleanMask2D(z, bounds4d.t + i, inclusive)});
            ++i;
        }
        return new BooleanMask4D(bounds4d, masks);
    }

    public BooleanMask4D getBooleanMask(boolean inclusive) throws InterruptedException {
        Rectangle4D.Integer bounds = this.getBounds();
        BooleanMask3D[] masks = new BooleanMask3D[bounds.sizeT];
        int t = 0;
        while (t < masks.length) {
            masks[t] = this.getBooleanMask3D(bounds.t + t, inclusive);
            ++t;
        }
        return new BooleanMask4D(bounds, masks);
    }

    @Override
    public double computeNumberOfContourPoints() throws InterruptedException {
        return this.getBooleanMask(true).getContourPointsAsIntArray().length / this.getDimension();
    }

    @Override
    public double computeNumberOfPoints() throws InterruptedException {
        double numPoints = 0.0;
        numPoints += (double)this.getBooleanMask(true).getNumberOfPoints();
        numPoints += (double)this.getBooleanMask(false).getNumberOfPoints();
        return numPoints /= 2.0;
    }

    public int getC() {
        return this.c;
    }

    public void setC(int value) {
        int v = value == Integer.MIN_VALUE ? -1 : value;
        if (this.c != v) {
            this.c = v;
            this.roiChanged(false);
        }
    }

    @Override
    public boolean isActiveFor(IcyCanvas canvas) {
        return this.isActiveFor(canvas.getPositionC());
    }

    public boolean isActiveFor(int c) {
        return this.getC() == -1 || c == -1 || this.getC() == c;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.setC(XMLUtil.getElementIntValue(node, ID_C, -1));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        XMLUtil.setElementIntValue(node, ID_C, this.getC());
        return true;
    }
}

