/*
 * Decompiled with CFR 0.152.
 */
package icy.type.dimension;

import java.awt.Dimension;

public abstract class Dimension2D
extends java.awt.geom.Dimension2D {
    public double getSizeX() {
        return this.getWidth();
    }

    public double getSizeY() {
        return this.getHeight();
    }

    public abstract void setSizeX(double var1);

    public abstract void setSizeY(double var1);

    @Override
    public abstract void setSize(double var1, double var3);

    public Dimension getDimInt() {
        return new Dimension((int)Math.ceil(this.getSizeX()), (int)Math.ceil(this.getSizeY()));
    }

    public abstract boolean isInfiniteX();

    public abstract boolean isInfiniteY();

    public boolean equals(Object obj) {
        if (obj instanceof Dimension2D) {
            Dimension2D dim = (Dimension2D)obj;
            return this.getSizeX() == dim.getSizeX() && this.getSizeY() == dim.getSizeY();
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getSizeX() + "," + this.getSizeY() + "]";
    }

    public static class Double
    extends Dimension2D {
        public double sizeX;
        public double sizeY;

        public Double(double sizeX, double sizeY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }

        public Double(double[] sizeXY) {
            int len = sizeXY.length;
            if (len > 0) {
                this.sizeX = sizeXY[0];
            }
            if (len > 1) {
                this.sizeY = sizeXY[1];
            }
        }

        public Double() {
            this(0.0, 0.0);
        }

        @Override
        public double getWidth() {
            return this.sizeX;
        }

        @Override
        public double getHeight() {
            return this.sizeY;
        }

        @Override
        public void setSize(double sizeX, double sizeY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = value;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }
    }

    public static class Float
    extends Dimension2D {
        public float sizeX;
        public float sizeY;

        public Float(float sizeX, float sizeY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }

        public Float(float[] sizeXY) {
            int len = sizeXY.length;
            if (len > 0) {
                this.sizeX = sizeXY[0];
            }
            if (len > 1) {
                this.sizeY = sizeXY[1];
            }
        }

        public Float() {
            this(0.0f, 0.0f);
        }

        @Override
        public double getWidth() {
            return this.sizeX;
        }

        @Override
        public double getHeight() {
            return this.sizeY;
        }

        @Override
        public void setSize(double sizeX, double sizeY) {
            this.sizeX = (float)sizeX;
            this.sizeY = (float)sizeY;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (float)value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (float)value;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }
    }
}

