/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import icy.gui.dialog.IdConfirmDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import icy.util.OpenGLUtil;
import icy.util.ReflectionUtil;
import java.awt.Graphics;
import java.util.concurrent.locks.ReentrantLock;
import jogamp.opengl.GLDrawableHelper;
import vtk.vtkCamera;
import vtk.vtkGenericOpenGLRenderWindow;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkLight;
import vtk.vtkRenderWindow;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;

public class VtkJoglPanel
extends GLJPanel {
    private static final long serialVersionUID = 8821516677188995191L;
    protected vtkGenericOpenGLRenderWindow rw;
    protected vtkRenderer ren;
    protected vtkRenderWindowInteractor wi;
    protected vtkCamera cam;
    protected vtkLight lgt;
    protected ReentrantLock lock;
    protected GLEventImpl glEventImpl;
    protected int lastX;
    protected int lastY;
    protected boolean windowset;
    protected boolean lightingset;
    protected int interactionMode;
    protected boolean rendering;
    private boolean failed;

    public VtkJoglPanel() {
        super((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getMaximum((boolean)true)));
        float[] scales = new float[2];
        this.getRequestedSurfaceScale(scales);
        if (scales[0] == 0.0f || scales[1] == 0.0f) {
            try {
                float[] reqPixelScale = (float[])ReflectionUtil.getFieldObject((Object)this, "reqPixelScale", true);
                reqPixelScale[0] = 1.0f;
                reqPixelScale[1] = 1.0f;
            }
            catch (Throwable t) {
                System.err.println("Couldn't patch GLJPanel.reqPixelScale[] field with Java 17, try using Java 8 instead if you experience some bugs with 3D VTK view.");
            }
        }
        this.rw = new vtkGenericOpenGLRenderWindow();
        this.rw.SetIsDirect(1);
        this.rw.SetSupportsOpenGL(1);
        this.rw.SetIsCurrent(true);
        this.rw.SetPointSmoothing(1);
        this.rw.SetLineSmoothing(1);
        this.rw.SetPolygonSmoothing(1);
        this.rw.SetMultiSamples(4);
        this.rw.AddObserver("WindowFrameEvent", (Object)this, "render");
        this.wi = new vtkGenericRenderWindowInteractor();
        this.wi.SetRenderWindow((vtkRenderWindow)this.rw);
        this.wi.ConfigureEvent();
        this.wi.AddObserver("RenderEvent", (Object)this, "render");
        this.wi.SetEnableRender(false);
        this.ren = new vtkRenderer();
        this.ren.SetLightFollowCamera(1);
        this.cam = null;
        this.lgt = new vtkLight();
        this.lgt.SetAmbientColor(1.0, 1.0, 1.0);
        this.lock = new ReentrantLock();
        this.glEventImpl = new GLEventImpl();
        this.windowset = false;
        this.lightingset = false;
        this.rendering = false;
        this.failed = false;
        this.addGLEventListener(this.glEventImpl);
        this.rw.AddRenderer(this.ren);
        this.cam = this.ren.GetActiveCamera();
        if (!OpenGLUtil.isOpenGLSupported(3) && !IdConfirmDialog.confirm("Warning", "Your graphics card driver does not support OpenGL 3, you may experience issues or crashes with VTK.\nDo you want to try anyway ?", 0, String.valueOf(((Object)((Object)this)).getClass().getName()) + ".notCompatibleDialog")) {
            throw new IcyHandledException("Your graphics card driver is not compatible with OpenGL 3 !");
        }
    }

    protected void delete() {
        if (this.rendering) {
            this.rw.SetAbortRender(1);
            ThreadUtil.sleep(500);
            if (this.rendering) {
                return;
            }
        }
        this.lock.lock();
        try {
            this.rendering = true;
            this.rw.RemoveAllObservers();
            this.wi.RemoveAllObservers();
            this.ren = null;
            this.cam = null;
            this.lgt = null;
            this.wi = null;
            if (!this.rw.GetClassName().equals("vtkXOpenGLRenderWindow")) {
                this.rw = null;
            } else {
                System.out.println("The renderwindow has been kept arount to prevent a crash");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void dispose(Runnable runnable) {
    }

    public void disposeInternal() {
        super.dispose(null);
        this.removeGLEventListener(this.glEventImpl);
        try {
            GLDrawableHelper helper = (GLDrawableHelper)ReflectionUtil.getFieldObject((Object)this, "helper", true);
            ThreadLocal threadLocal = (ThreadLocal)ReflectionUtil.getFieldObject(helper, "perThreadInitAction", true);
            threadLocal.remove();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public vtkRenderer getRenderer() {
        return this.ren;
    }

    public vtkRenderWindow getRenderWindow() {
        return this.rw;
    }

    public vtkCamera getCamera() {
        return this.cam;
    }

    public vtkLight getLight() {
        return this.lgt;
    }

    public vtkRenderWindowInteractor getInteractor() {
        return this.wi;
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public void setBounds(int x, int y, int width, int height) {
        int[] size;
        super.setBounds(x, y, width, height);
        if (this.windowset && ((size = this.rw.GetSize())[0] != width || size[1] != height)) {
            this.lock();
            try {
                this.wi.SetSize(width, height);
                this.rw.SetSize(width, height);
                this.sizeChanged();
            }
            finally {
                this.unlock();
            }
        }
    }

    public void sizeChanged() {
    }

    public void render() {
        if (this.rendering) {
            return;
        }
        this.rendering = true;
        this.lock();
        try {
            this.rw.Render();
        }
        finally {
            this.unlock();
            this.rendering = false;
        }
    }

    public boolean isWindowSet() {
        return this.windowset;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void updateLight() {
        this.lgt.SetPosition(this.cam.GetPosition());
        this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
    }

    public void resetCameraClippingRange() {
        this.lock();
        try {
            this.ren.ResetCameraClippingRange();
        }
        finally {
            this.unlock();
        }
    }

    public void resetCamera() {
        this.lock();
        try {
            this.ren.ResetCamera();
        }
        finally {
            this.unlock();
        }
    }

    public void paint(Graphics g) {
        if (this.failed) {
            return;
        }
        try {
            super.paint(g);
        }
        catch (Throwable t) {
            this.failed = true;
            new FailedAnnounceFrame("An error occured while initializing OpenGL !\nYou may try to update your graphics card driver to fix this issue.", 0);
            IcyExceptionHandler.handleException(t, true);
        }
    }

    class GLEventImpl
    implements GLEventListener {
        GLEventImpl() {
        }

        public void init(GLAutoDrawable drawable) {
            if (!VtkJoglPanel.this.windowset) {
                VtkJoglPanel.this.windowset = true;
                GLContext ctx = drawable.getContext();
                if (!ctx.isCurrent()) {
                    ctx.makeCurrent();
                }
                VtkJoglPanel.this.rw.SetMapped(1);
                VtkJoglPanel.this.rw.SetPosition(0, 0);
                VtkJoglPanel.this.setSize(drawable.getSurfaceWidth(), drawable.getSurfaceHeight());
                VtkJoglPanel.this.rw.InitializeFromCurrentContext();
                if (!VtkJoglPanel.this.lightingset) {
                    VtkJoglPanel.this.lightingset = true;
                    VtkJoglPanel.this.ren.AddLight(VtkJoglPanel.this.lgt);
                    VtkJoglPanel.this.lgt.SetPosition(VtkJoglPanel.this.cam.GetPosition());
                    VtkJoglPanel.this.lgt.SetFocalPoint(VtkJoglPanel.this.cam.GetFocalPoint());
                }
            }
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            VtkJoglPanel.this.setSize(width, height);
        }

        public void display(GLAutoDrawable drawable) {
            VtkJoglPanel.this.render();
        }

        public void dispose(GLAutoDrawable drawable) {
            VtkJoglPanel.this.delete();
        }
    }
}

