/*
 * Decompiled with CFR 0.152.
 */
package icy.workspace;

import icy.file.FileUtil;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.SuccessfullAnnounceFrame;
import icy.gui.frame.progress.TaskFrame;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.preferences.WorkspaceLocalPreferences;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import icy.workspace.Workspace;
import icy.workspace.WorkspaceLoader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class WorkspaceInstaller
implements Runnable {
    private static final WorkspaceInstaller instance = new WorkspaceInstaller();
    private final List<WorkspaceInstallInfo> installFIFO = new ArrayList<WorkspaceInstallInfo>();
    private final List<WorkspaceInstallInfo> removeFIFO = new ArrayList<WorkspaceInstallInfo>();
    private final EventListenerList listeners = new EventListenerList();
    private Workspace installingWorkspace = null;
    private Workspace desinstallingWorkspace = null;
    private boolean installing = false;
    private boolean deinstalling = false;

    private WorkspaceInstaller() {
        new Thread((Runnable)this, "Workspace installer").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(Workspace workspace, boolean showConfirm) {
        if (workspace != null) {
            if (!NetworkUtil.hasInternetAccess()) {
                String text = "Cannot install '" + workspace.getName() + "' workspace : you are not connected to Internet.";
                if (Icy.getMainInterface().isHeadLess()) {
                    System.err.println(text);
                } else {
                    new FailedAnnounceFrame(text, 10);
                }
                return;
            }
            List<WorkspaceInstallInfo> list = WorkspaceInstaller.instance.installFIFO;
            synchronized (list) {
                WorkspaceInstaller.instance.installFIFO.add(new WorkspaceInstallInfo(workspace, showConfirm));
            }
        }
    }

    public static boolean isProcessing() {
        return WorkspaceInstaller.isInstalling() || WorkspaceInstaller.isDesinstalling();
    }

    public static boolean isInstalling() {
        return !WorkspaceInstaller.instance.installFIFO.isEmpty() || WorkspaceInstaller.instance.installing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWaitingForInstall(Workspace workspace) {
        String workspaceName = workspace.getName();
        List<WorkspaceInstallInfo> list = WorkspaceInstaller.instance.installFIFO;
        synchronized (list) {
            WorkspaceInstallInfo info;
            Iterator<WorkspaceInstallInfo> iterator = WorkspaceInstaller.instance.installFIFO.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                info = iterator.next();
            } while (!workspaceName.equals(info.workspace.getName()));
            return true;
        }
    }

    public static Workspace getCurrentInstallingWorkspace() {
        return WorkspaceInstaller.instance.installingWorkspace;
    }

    public static boolean isInstallingWorkspace(Workspace workspace) {
        if (WorkspaceInstaller.instance.installingWorkspace != null && WorkspaceInstaller.instance.installingWorkspace.getName().equals(workspace.getName())) {
            return true;
        }
        return WorkspaceInstaller.isWaitingForInstall(workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void desinstall(Workspace workspace, boolean showConfirm) {
        if (workspace != null) {
            List<WorkspaceInstallInfo> list = WorkspaceInstaller.instance.removeFIFO;
            synchronized (list) {
                WorkspaceInstaller.instance.removeFIFO.add(new WorkspaceInstallInfo(workspace, showConfirm));
            }
        }
    }

    public static boolean isDesinstalling() {
        return !WorkspaceInstaller.instance.removeFIFO.isEmpty() || WorkspaceInstaller.instance.deinstalling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWaitingForDesinstall(Workspace workspace) {
        String workspaceName = workspace.getName();
        List<WorkspaceInstallInfo> list = WorkspaceInstaller.instance.removeFIFO;
        synchronized (list) {
            WorkspaceInstallInfo info;
            Iterator<WorkspaceInstallInfo> iterator = WorkspaceInstaller.instance.removeFIFO.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                info = iterator.next();
            } while (!workspaceName.equals(info.workspace.getName()));
            return true;
        }
    }

    public static boolean isDesinstallingWorkspace(Workspace workspace) {
        if (WorkspaceInstaller.instance.desinstallingWorkspace != null && WorkspaceInstaller.instance.desinstallingWorkspace.getName().equals(workspace.getName())) {
            return true;
        }
        return WorkspaceInstaller.isWaitingForDesinstall(workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            boolean result;
            List<WorkspaceInstallInfo> list;
            WorkspaceInstallInfo installInfo = null;
            boolean empty = this.installFIFO.isEmpty();
            if (!empty) {
                this.installing = true;
                try {
                    while (!empty) {
                        list = this.installFIFO;
                        // MONITORENTER : list
                        installInfo = this.installFIFO.remove(0);
                        empty = this.installFIFO.isEmpty();
                        // MONITOREXIT : list
                        if (!WorkspaceLoader.isLoaded(installInfo.workspace)) {
                            result = this.installInternal(installInfo);
                            this.installed(installInfo.workspace, result);
                        }
                        List<WorkspaceInstallInfo> list2 = this.installFIFO;
                        // MONITORENTER : list2
                        // MONITOREXIT : list2
                    }
                }
                finally {
                    this.installing = false;
                }
            }
            if (!(empty = this.removeFIFO.isEmpty())) {
                this.deinstalling = true;
                try {
                    while (!empty) {
                        list = this.removeFIFO;
                        // MONITORENTER : list
                        installInfo = this.removeFIFO.remove(0);
                        empty = this.removeFIFO.isEmpty();
                        // MONITOREXIT : list
                        result = this.desinstallInternal(installInfo);
                        this.desinstalled(installInfo.workspace, result);
                    }
                }
                finally {
                    this.deinstalling = false;
                }
            }
            ThreadUtil.sleep(200);
        }
    }

    private boolean deleteWorkspace(Workspace workspace) {
        if (!FileUtil.delete(workspace.getLocalFilename(), false)) {
            System.err.println("deleteWorkspace : Can't delete " + workspace.getLocalFilename());
        }
        WorkspaceLoader.reload();
        return true;
    }

    private ArrayList<PluginDescriptor> getLocalPlugins(Workspace workspace) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        for (Workspace.TaskDefinition.BandDefinition.ItemDefinition item : workspace.getAllItems()) {
            PluginDescriptor plugin;
            if (item.isSeparator() || (plugin = PluginLoader.getPlugin(item.getClassName())) == null) continue;
            PluginInstaller.getLocalDependenciesOf(result, plugin);
            PluginDescriptor.addToList(result, plugin);
        }
        return result;
    }

    private ArrayList<PluginDescriptor> getIndependentPlugins(Workspace workspace) {
        ArrayList<PluginDescriptor> result = this.getLocalPlugins(workspace);
        ArrayList<PluginDescriptor> others = new ArrayList<PluginDescriptor>();
        for (Workspace ws : WorkspaceLoader.getWorkspaces()) {
            if (StringUtil.equals(ws.getName(), workspace.getName())) continue;
            others.addAll(this.getLocalPlugins(ws));
        }
        for (PluginDescriptor plugin : others) {
            int i = result.size() - 1;
            while (i >= 0) {
                PluginDescriptor depPlug = result.get(i);
                if (plugin.equals(depPlug) || plugin.requires(depPlug)) {
                    result.remove(i);
                }
                --i;
            }
        }
        return result;
    }

    private boolean installInternal(WorkspaceInstallInfo installInfo) {
        Workspace workspace = installInfo.workspace;
        boolean showConfirm = installInfo.showConfirm;
        this.installingWorkspace = workspace;
        try {
            TaskFrame taskFrame = null;
            int result = 0;
            String workspaceName = workspace.getName();
            if (showConfirm && !Icy.getMainInterface().isHeadLess()) {
                taskFrame = new ProgressFrame("installing workspace '" + workspaceName + "'...");
            }
            try {
                result = workspace.install((ProgressFrame)taskFrame);
                if (result > 0) {
                    if (taskFrame != null) {
                        ((ProgressFrame)taskFrame).setMessage("saving workspace '" + workspaceName + "'...");
                    }
                    workspace.save();
                    if (taskFrame != null) {
                        ((ProgressFrame)taskFrame).setMessage("reloading workspaces list...");
                    }
                    WorkspaceLoader.reload();
                }
            }
            finally {
                if (taskFrame != null) {
                    taskFrame.close();
                }
            }
            String resMess = "Workspace '" + workspaceName + "' installation";
            if (showConfirm && !Icy.getMainInterface().isHeadLess()) {
                switch (result) {
                    default: {
                        new FailedAnnounceFrame(String.valueOf(resMess) + " failed !");
                        break;
                    }
                    case 1: {
                        new SuccessfullAnnounceFrame(String.valueOf(resMess) + " succeed !", 10);
                        break;
                    }
                    case 2: {
                        new SuccessfullAnnounceFrame(String.valueOf(resMess) + " succeed but some plugins cannot be installed.", 10);
                        break;
                    }
                }
            } else {
                switch (result) {
                    default: {
                        System.err.println(String.valueOf(resMess) + " failed !");
                        break;
                    }
                    case 1: {
                        System.out.println(String.valueOf(resMess) + " succeed !");
                        break;
                    }
                    case 2: {
                        System.out.println(String.valueOf(resMess) + " partially succeed (some plugins cannot be installed) !");
                    }
                }
            }
            boolean bl = result > 0;
            return bl;
        }
        finally {
            this.installingWorkspace = null;
        }
    }

    private boolean desinstallInternal(WorkspaceInstallInfo installInfo) {
        Workspace workspace = installInfo.workspace;
        boolean showConfirm = installInfo.showConfirm;
        this.desinstallingWorkspace = workspace;
        try {
            boolean result;
            boolean deletePlugin;
            ArrayList<PluginDescriptor> independentPlugins = new ArrayList<PluginDescriptor>();
            String workspaceDesc = workspace.getName();
            TaskFrame taskFrame = null;
            if (showConfirm) {
                String message = "<html>Do you want to also remove the associated plugins ?</html>";
                deletePlugin = ConfirmDialog.confirm(message);
            } else {
                deletePlugin = true;
            }
            if (deletePlugin) {
                if (showConfirm && !Icy.getMainInterface().isHeadLess()) {
                    taskFrame = new ProgressFrame("checking plugins dependences...");
                }
                try {
                    independentPlugins.addAll(this.getIndependentPlugins(workspace));
                }
                finally {
                    if (taskFrame != null) {
                        taskFrame.close();
                    }
                }
            }
            if (showConfirm) {
                taskFrame = new ProgressFrame("removing workspace '" + workspaceDesc + "'...");
            }
            try {
                for (PluginDescriptor plugin : independentPlugins) {
                    if (!plugin.isInstalled()) continue;
                    PluginInstaller.desinstall(plugin, false, false);
                }
                PluginInstaller.waitDesinstall();
                result = this.deleteWorkspace(workspace);
            }
            finally {
                if (taskFrame != null) {
                    taskFrame.close();
                }
            }
            String resMess = "Workspace '" + workspaceDesc + "' remove";
            if (showConfirm && !Icy.getMainInterface().isHeadLess()) {
                if (result) {
                    new SuccessfullAnnounceFrame(String.valueOf(resMess) + " succeed !", 10);
                } else {
                    new FailedAnnounceFrame(String.valueOf(resMess) + " failed !");
                }
            } else if (result) {
                System.out.println(String.valueOf(resMess) + " succeed !");
            } else {
                System.err.println(String.valueOf(resMess) + " failed !");
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.desinstallingWorkspace = null;
        }
    }

    private void installed(Workspace workspace, boolean result) {
        if (result) {
            WorkspaceLocalPreferences.setWorkspaceEnable(workspace.getName(), true);
            Icy.announceRestart();
        }
        this.fireInstalledEvent(new WorkspaceInstallerEvent(workspace, result));
    }

    private void desinstalled(Workspace workspace, boolean result) {
        if (result) {
            Icy.announceRestart();
        }
        this.fireRemovedEvent(new WorkspaceInstallerEvent(workspace, result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(WorkspaceInstallerListener listener) {
        EventListenerList eventListenerList = WorkspaceInstaller.instance.listeners;
        synchronized (eventListenerList) {
            WorkspaceInstaller.instance.listeners.add(WorkspaceInstallerListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(WorkspaceInstallerListener listener) {
        EventListenerList eventListenerList = WorkspaceInstaller.instance.listeners;
        synchronized (eventListenerList) {
            WorkspaceInstaller.instance.listeners.remove(WorkspaceInstallerListener.class, listener);
        }
    }

    private void fireInstalledEvent(WorkspaceInstallerEvent e) {
        WorkspaceInstallerListener[] workspaceInstallerListenerArray = (WorkspaceInstallerListener[])this.listeners.getListeners(WorkspaceInstallerListener.class);
        int n = workspaceInstallerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceInstallerListener listener = workspaceInstallerListenerArray[n2];
            listener.workspaceInstalled(e);
            ++n2;
        }
    }

    private void fireRemovedEvent(WorkspaceInstallerEvent e) {
        WorkspaceInstallerListener[] workspaceInstallerListenerArray = (WorkspaceInstallerListener[])this.listeners.getListeners(WorkspaceInstallerListener.class);
        int n = workspaceInstallerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceInstallerListener listener = workspaceInstallerListenerArray[n2];
            listener.workspaceRemoved(e);
            ++n2;
        }
    }

    private static class WorkspaceInstallInfo {
        final Workspace workspace;
        final boolean showConfirm;

        public WorkspaceInstallInfo(Workspace workspace, boolean showConfirm) {
            this.workspace = workspace;
            this.showConfirm = showConfirm;
        }
    }

    public static class WorkspaceInstallerEvent {
        private final Workspace workspace;
        private final boolean successed;

        public WorkspaceInstallerEvent(Workspace workspace, boolean successed) {
            this.workspace = workspace;
            this.successed = successed;
        }

        public Workspace getWorkspace() {
            return this.workspace;
        }

        public boolean getSuccessed() {
            return this.successed;
        }
    }

    public static interface WorkspaceInstallerListener
    extends EventListener {
        public void workspaceInstalled(WorkspaceInstallerEvent var1);

        public void workspaceRemoved(WorkspaceInstallerEvent var1);
    }
}

