/*
 * Decompiled with CFR 0.152.
 */
package icy.updater;

import icy.common.Version;
import icy.file.FileUtil;
import icy.network.NetworkUtil;
import icy.preferences.ApplicationPreferences;
import icy.preferences.IcyPreferences;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.update.ElementDescriptor;
import icy.update.Updater;
import icy.updater.UpdateFrame;
import icy.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class Main {
    @Deprecated
    private static final String ARG_NOUPDATE = "-noupdate";
    @Deprecated
    private static final String ARG_RESTART = "-restart";
    private static final String ICY_JARNAME = "icy.jar";
    private static final String ICY_FOLDER_OSX = "Icy.app";
    private static final String PARAM_MAX_MEMORY = "-Xmx";
    private static final String PARAM_STACK_SIZE = "-Xss";
    public static Version version = new Version("2.3.0.0");
    static final OutPrintStream stdStream = new OutPrintStream(System.out, false);
    static final OutPrintStream errStream = new OutPrintStream(System.err, true);
    static UpdateFrame frame = null;
    static String extraArgs = "";
    static String strLog = "";

    public static void main(String[] args) {
        boolean update;
        boolean oldVersion = false;
        boolean start = true;
        IcyPreferences.init();
        NetworkUtil.updateNetworkSetting();
        for (String arg : args) {
            if (!arg.equals(ARG_RESTART)) continue;
            oldVersion = true;
        }
        if (oldVersion) {
            update = true;
            for (String arg : args) {
                if (!arg.equals(ARG_NOUPDATE)) continue;
                update = false;
            }
        } else {
            update = false;
            for (String arg : args) {
                if (arg.equals("-update")) {
                    update = true;
                    continue;
                }
                if (!arg.equals("-nostart")) continue;
                start = false;
            }
        }
        for (String arg : args) {
            if (arg.equals("-update") || arg.equals("-nostart") || arg.equals(ARG_NOUPDATE) || arg.equals(ARG_RESTART)) continue;
            extraArgs = extraArgs + " " + arg;
        }
        System.setOut(stdStream);
        System.setErr(errStream);
        if (Main.process(update, start)) {
            if (frame != null) {
                if (!update && frame.isVisible()) {
                    ThreadUtil.sleep(5000);
                }
                frame.dispose();
            }
            System.exit(0);
        } else if (frame != null) {
            frame.setCanClose(true);
        } else {
            System.exit(1);
        }
    }

    private static boolean process(final boolean update, boolean start) {
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                if (SystemUtil.isHeadLess()) {
                    frame = null;
                } else {
                    frame = new UpdateFrame("Icy Updater");
                    if (update) {
                        frame.setVisible(true);
                    }
                }
            }
        });
        String directory = FileUtil.getApplicationDirectory();
        if (update) {
            File oldFile;
            File parentFile;
            File newFile;
            String icyJarPath = directory + '/' + ICY_JARNAME;
            if (!Main.waitForLock(icyJarPath)) {
                System.err.println("File " + icyJarPath + " is locked, aborting udpate...");
                Main.report(strLog);
                return false;
            }
            if (!Main.doUpdate()) {
                return false;
            }
            if (SystemUtil.isMac() && !(newFile = new File(parentFile = (oldFile = new File("").getAbsoluteFile()).getParentFile(), ICY_FOLDER_OSX).getAbsoluteFile()).exists()) {
                if (!Main.doOSXFolderNameUpdate(parentFile, oldFile, newFile)) {
                    return false;
                }
                if (start) {
                    return Main.startICY_OSX(newFile.getAbsolutePath(), parentFile.getAbsolutePath());
                }
                return true;
            }
        }
        if (start) {
            return Main.startICY(directory);
        }
        return true;
    }

    public static boolean doUpdate() {
        Main.setState("Checking java version", 1);
        if (!Main.checkMinimumJavaVersion(8.0)) {
            System.err.println("New version of Icy requires Java 8 or above, please update your java version.");
            System.err.println();
            System.err.println("You can download Java 8 here:");
            System.err.println("http://icy.bioimageanalysis.org/download/");
            return false;
        }
        ArrayList<ElementDescriptor> localElements = Updater.getLocalElements();
        ArrayList<ElementDescriptor> updateElements = Updater.getUpdateElements(localElements);
        boolean result = true;
        for (ElementDescriptor updateElement : updateElements) {
            String updateElementName = updateElement.getName();
            if (updateElementName.equals("ICY Updater")) {
                Updater.updateElementInfos(updateElement, localElements);
                continue;
            }
            Main.setState("Updating : " + updateElementName, updateElements.indexOf(updateElement) * 60 / updateElements.size());
            try {
                if (Updater.udpateElement(updateElement, localElements)) continue;
                localElements = Updater.getLocalElements();
                Updater.clearElementInfos(updateElement, localElements);
                result = false;
                break;
            }
            catch (InterruptedException exc) {
                System.err.println("Process interrupted !");
                result = false;
            }
        }
        Main.setState("Checking...", 60);
        if (!result) {
            System.err.println("Update processing has failed.");
            FileUtil.delete(Updater.UPDATE_DIRECTORY, true);
            if (Updater.restore()) {
                System.out.println("");
                System.out.println("Files correctly restored.");
                FileUtil.delete(Updater.BACKUP_DIRECTORY, true);
            } else {
                System.err.println("");
                System.err.println("Some files cannot be restored, try to restore them manually from 'backup' directory.");
                System.err.println("If Icy doesn't start anymore you may need to reinstall the application.");
            }
            Updater.validateElements(localElements);
            if (!Updater.saveElementsToXML(localElements, "version.xml", false)) {
                System.err.println("Error while saving version.xml file.");
            }
            Main.report(strLog);
        } else {
            Main.setState("Deleting obsoletes...", 60);
            Updater.deleteObsoletes();
            Main.setState("Cleaning...", 70);
            FileUtil.delete(Updater.UPDATE_DIRECTORY, true);
            FileUtil.delete(Updater.BACKUP_DIRECTORY, true);
            if (updateElements.size() == 0) {
                System.out.println("Nothing to update.");
            } else {
                Main.setState("Updating XML...", 90);
                Updater.validateElements(localElements);
                if (!Updater.saveElementsToXML(localElements, "version.xml", false)) {
                    System.out.println("Error while saving version.xml file.");
                    System.out.println("The new version is correctly installed but version number informations");
                    System.out.println("will stay outdated until the next update.");
                } else {
                    System.out.println("Update succefully completed.");
                }
            }
        }
        if (result) {
            Main.setState("Succeed !", 100);
        } else {
            Main.setState("Failed !", 100);
        }
        return result;
    }

    private static boolean doOSXFolderNameUpdate(File parentFile, File oldFile, File newFile) {
        String parentFolder = FileUtil.getGenericPath(parentFile.getAbsolutePath());
        String cmd = "mv " + oldFile.getAbsolutePath() + " " + newFile.getAbsolutePath();
        try {
            System.out.print("Renaming app: " + cmd);
            Process p = SystemUtil.exec(cmd, parentFolder);
            if (p == null) {
                return false;
            }
            Thread.sleep(1000L);
            Main.outputStreams(p);
            System.out.println(" - exit code = " + p.waitFor());
            Thread.sleep(1000L);
            System.out.print("Removing security check...");
            p = SystemUtil.exec("xattr -dr com.apple.quarantine " + newFile.getAbsolutePath(), parentFolder);
            if (p == null) {
                return false;
            }
            Thread.sleep(1000L);
            Main.outputStreams(p);
            System.out.println(" exit code = " + p.waitFor());
            Thread.sleep(1000L);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkMinimumJavaVersion(double value) {
        return SystemUtil.getJavaVersionAsNumber() >= value;
    }

    private static String getVMParams() {
        int maxMemory = ApplicationPreferences.getMaxMemoryMB();
        int stackSize = ApplicationPreferences.getStackSizeKB();
        String vmParams = ApplicationPreferences.getExtraVMParams();
        String osVmParams = ApplicationPreferences.getOSExtraVMParams();
        String result = "";
        if (maxMemory != -1) {
            result = result + " -Xmx" + maxMemory + "m";
        }
        if (stackSize != -1) {
            result = result + " -Xss" + stackSize + "k";
        }
        if (!StringUtil.isEmpty(vmParams)) {
            result = result + " " + vmParams;
        }
        if (!StringUtil.isEmpty(osVmParams)) {
            result = result + " " + osVmParams;
        }
        return result;
    }

    private static String getAppParams() {
        return ApplicationPreferences.getAppParams();
    }

    public static boolean startICY(String directory) {
        block7: {
            Process process;
            Main.setState("Launching Icy...", 0);
            if (frame != null) {
                frame.setProgressVisible(false);
            }
            if ((process = SystemUtil.execJAR(ICY_JARNAME, Main.getVMParams(), Main.getAppParams() + extraArgs, directory)) == null) {
                System.err.println("Can't launch execJAR(icy.jar, " + Main.getVMParams() + ", " + Main.getAppParams() + extraArgs + "," + directory + ")");
                return false;
            }
            try {
                ThreadUtil.sleep(2000);
                Main.outputStreams(process);
                if (process.exitValue() == 0) break block7;
                try {
                    Main.setState("Error while launching Icy", 0);
                    System.err.println("Can't launch execJAR(icy.jar, " + Main.getVMParams() + ", " + Main.getAppParams() + extraArgs + "," + directory + ")");
                    System.out.println();
                    System.out.println("Trying to launch without specific parameters...");
                    System.out.println();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Main.startICYSafeMode(directory);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (Exception e) {
                System.err.println("Error while launching Icy: " + e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean startICYSafeMode(String directory) {
        block7: {
            Process process;
            Main.setState("Launching Icy (safe mode)...", 0);
            if (frame != null) {
                frame.setProgressVisible(false);
            }
            if ((process = SystemUtil.execJAR(ICY_JARNAME, "", "", directory)) == null) {
                System.err.println("Can't launch execJAR(icy.jar, \"\", \"\", " + directory + ")");
                System.out.println();
                System.out.println("Try to manually launch the following command :");
                System.out.println("java -jar updater.jar");
                return false;
            }
            try {
                ThreadUtil.sleep(2000);
                Main.outputStreams(process);
                if (process.exitValue() == 0) break block7;
                try {
                    Main.setState("Error while launching Icy (safe mode)", 0);
                    System.err.println("Can't launch execJAR(icy.jar, \"\", \"\", " + directory + ")");
                    System.out.println();
                    System.out.println("Try to manually launch the following command :");
                    System.out.println("java -jar updater.jar");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (Exception e) {
                System.err.println("Error while launching Icy: " + e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean startICY_OSX(String appPackage, String directory) {
        block7: {
            Process process;
            Main.setState("Launching Icy (OSX mode)...", 0);
            if (frame != null) {
                frame.setProgressVisible(false);
            }
            if ((process = SystemUtil.exec("open -a " + appPackage, directory)) == null) {
                System.err.println("Can't launch Icy..");
                System.out.println();
                System.out.println("Try to launch it manually.");
                return false;
            }
            try {
                ThreadUtil.sleep(2000);
                Main.outputStreams(process);
                if (process.exitValue() == 0) break block7;
                try {
                    Main.setState("Error while launching Icy", 0);
                    System.err.println("Can't launch Icy..");
                    System.out.println();
                    System.out.println("Try to launch it manually.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (Exception e) {
                System.err.println("Error while launching Icy: " + e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void setState(final String state, final int progress) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (frame != null) {
                    frame.setTitle(state);
                    frame.setProgress(progress);
                }
            }
        });
    }

    private static boolean waitForLock(String lockName) {
        long start = System.currentTimeMillis();
        File f = new File(lockName);
        if (!f.setWritable(true, false)) {
            f.setWritable(true, true);
        }
        if (f.exists()) {
            while (!f.canWrite() && System.currentTimeMillis() - start < 15000L) {
                System.gc();
                ThreadUtil.sleep(100);
                if (f.setWritable(true, false)) continue;
                f.setWritable(true, true);
            }
            return f.canWrite();
        }
        return true;
    }

    private static void report(String errorLog) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("pluginClassName", "");
        values.put("errorLog", "Updater version " + version + "\n\n" + errorLog);
        NetworkUtil.report(values);
    }

    private static void outputStreams(Process process) throws IOException {
        BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        OutputStream outStr = process.getOutputStream();
        BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            outStr.write(32);
            while (errReader.ready()) {
                System.err.println(errReader.readLine());
            }
            while (inReader.ready()) {
                System.out.println(inReader.readLine());
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static class OutPrintStream
    extends PrintStream {
        boolean isStdErr;

        public OutPrintStream(PrintStream out, boolean isStdErr) {
            super(out);
            this.isStdErr = isStdErr;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            if (buf == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            String str = new String(buf, off, len);
            strLog = strLog + str;
            if (frame != null) {
                frame.addMessage(str, this.isStdErr);
            }
        }
    }
}

