/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGUI;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.ylemontag.mathoperations.Controller;
import plugins.ylemontag.mathoperations.DimensionsPickerComponent;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.SubSequence;
import plugins.ylemontag.mathoperations.Variant;

public abstract class MathOperationAbstractPlugin
extends EzPlug
implements EzStoppable {
    private Timer _timer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MathOperationAbstractPlugin.this.refreshProgressBar();
        }
    });
    private Controller _controller;

    protected MathOperationAbstractPlugin() {
        this._timer.start();
    }

    private void showOutput(Variant out, String description) {
        switch (out.getType()) {
            case SCALAR: 
            case ARRAY: {
                new AnnounceFrame(description + " = " + out);
                break;
            }
            case SEQUENCE: {
                Icy.getMainInterface().addSequence(out.getAsSequence());
                break;
            }
            default: {
                throw new RuntimeException("Unreachable code point");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coreExecute(Functor functor, EzGroupVariant ... inputs) {
        Variant[] variants = new Variant[inputs.length];
        String[] names = new String[inputs.length];
        for (int k = 0; k < inputs.length; ++k) {
            variants[k] = inputs[k].getInput();
            names[k] = variants[k].getRepresentation(true);
        }
        String description = functor.describeOperation(names);
        this._controller = new Controller();
        try {
            Variant out = functor.apply(variants, this._controller);
            this.showOutput(out, description);
        }
        catch (Functor.InconsistentArguments err) {
            throw new IcyHandledException("Error while executing the operation " + description + ".\n" + err.getMessage());
        }
        catch (Controller.CanceledByUser err) {
            new AnnounceFrame("The operation " + description + " has been canceled");
        }
        finally {
            this._controller = null;
        }
    }

    public void clean() {
        this._timer.stop();
    }

    public void stopExecution() {
        Controller controller = this._controller;
        if (controller != null) {
            controller.cancelComputation();
        }
    }

    private void refreshProgressBar() {
        EzGUI gui = this.getUI();
        if (gui == null) {
            return;
        }
        Controller controller = this._controller;
        gui.setProgressBarValue(controller == null ? 0.0 : controller.getProgress());
    }

    private static class IndexRange {
        public boolean valid;
        public int[] subrange;

        public IndexRange() {
            this.valid = true;
            this.subrange = null;
        }

        public IndexRange(boolean v, int[] sr) {
            this.valid = v;
            this.subrange = sr;
        }
    }

    private static class VarDimensionsPicker
    extends Var<IndexRange> {
        private DimensionId _dimension;

        public VarDimensionsPicker(String name, DimensionId dimension) {
            super(name, IndexRange.class, (Object)new IndexRange());
        }

        public VarEditor<IndexRange> createVarEditor() {
            return new Editor(this);
        }

        private class Editor
        extends SwingVarEditor<IndexRange> {
            private DimensionsPickerComponent _component;
            private boolean _shuntVariableUpdate;
            private boolean _shuntComponentUpdate;

            public Editor(VarDimensionsPicker variable) {
                super((Var)variable);
                this._shuntVariableUpdate = false;
                this._shuntComponentUpdate = false;
            }

            protected JComponent createEditorComponent() {
                this._component = new DimensionsPickerComponent(VarDimensionsPicker.this._dimension);
                this._component.addValueListener(new DimensionsPickerComponent.ValueListener(){

                    @Override
                    public void valueChanged(boolean valid, int[] newValue) {
                        if (Editor.this._shuntVariableUpdate) {
                            return;
                        }
                        Editor.this._shuntComponentUpdate = true;
                        Editor.this.variable.setValue((Object)new IndexRange(valid, newValue));
                        Editor.this._shuntComponentUpdate = false;
                    }
                });
                return this._component;
            }

            protected void activateListeners() {
                this._shuntVariableUpdate = false;
            }

            protected void deactivateListeners() {
                this._shuntVariableUpdate = true;
            }

            protected void updateInterfaceValue() {
                if (this._shuntComponentUpdate) {
                    return;
                }
                IndexRange value = (IndexRange)this.variable.getValue();
                if (value.valid) {
                    this._component.setValue(value.subrange);
                }
            }
        }
    }

    private static class EzVarDimensionsPicker
    extends EzVar<IndexRange> {
        private DimensionId _dimension;
        private EzVarSequence _sequence;

        public EzVarDimensionsPicker(String name, DimensionId dimension, EzVarSequence sequence) {
            super((Var)new VarDimensionsPicker(name, dimension), null);
            this._dimension = dimension;
            this._sequence = sequence;
        }

        private boolean shouldBeVisible() {
            Sequence sequence = (Sequence)this._sequence.getValue();
            return sequence != null && sequence.getSize(this._dimension) >= 2;
        }

        public int[] getValidatedIndexRange() {
            if (!this.shouldBeVisible()) {
                return null;
            }
            IndexRange value = (IndexRange)this.getValue();
            if (!value.valid) {
                throw new IcyHandledException("The selected index range for " + this.name + " is not valid.");
            }
            if (value.subrange != null && value.subrange.length == 0) {
                throw new IcyHandledException("The selected index range for " + this.name + " is empty.");
            }
            return value.subrange;
        }
    }

    protected static class EzGroupVariant
    extends EzGroup {
        private String _label;
        private EzVarEnum<Variant.Type> _type;
        private EzVarDouble _scalar;
        private EzVarDoubleArrayNative _array;
        private EzVarSequence _seq;
        private EzVarDimensionsPicker _dimT;
        private EzVarDimensionsPicker _dimZ;
        private EzVarDimensionsPicker _dimC;

        public EzGroupVariant(String label) {
            this(label, (EzVarEnum<Variant.Type>)new EzVarEnum("Type", (Enum[])EzGroupVariant.makeAvailableTypes(), (Enum)Variant.Type.SEQUENCE), new EzVarDouble("Scalar", 0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01), new EzVarDoubleArrayNative("Array", (double[][])null, true), new EzVarSequence("Sequence"));
        }

        private EzGroupVariant(String label, EzVarEnum<Variant.Type> type, EzVarDouble scalar, EzVarDoubleArrayNative array, EzVarSequence seq) {
            this(label, type, scalar, array, seq, new EzVarDimensionsPicker("T", DimensionId.T, seq), new EzVarDimensionsPicker("Z", DimensionId.Z, seq), new EzVarDimensionsPicker("C", DimensionId.C, seq));
        }

        private EzGroupVariant(String label, EzVarEnum<Variant.Type> type, EzVarDouble scalar, EzVarDoubleArrayNative array, EzVarSequence seq, EzVarDimensionsPicker dimT, EzVarDimensionsPicker dimZ, EzVarDimensionsPicker dimC) {
            super(label, new EzComponent[]{type, scalar, array, seq, dimT, dimZ, dimC});
            this._label = label;
            this._type = type;
            this._scalar = scalar;
            this._array = array;
            this._seq = seq;
            this._dimT = dimT;
            this._dimZ = dimZ;
            this._dimC = dimC;
            this._type.addVisibilityTriggerTo((EzComponent)this._scalar, (Object[])new Variant.Type[]{Variant.Type.SCALAR});
            this._type.addVisibilityTriggerTo((EzComponent)this._array, (Object[])new Variant.Type[]{Variant.Type.ARRAY});
            this._type.addVisibilityTriggerTo((EzComponent)this._seq, (Object[])new Variant.Type[]{Variant.Type.SEQUENCE});
            this.refreshDimensionsPickerVisibility();
            this._type.addVarChangeListener((EzVarListener)new EzVarListener<Variant.Type>(){

                public void variableChanged(EzVar<Variant.Type> source, Variant.Type newValue) {
                    this.refreshDimensionsPickerVisibility();
                }
            });
            this._seq.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

                public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                    this.refreshDimensionsPickerVisibility();
                }
            });
        }

        public Variant getInput() {
            switch ((Variant.Type)((Object)this._type.getValue())) {
                case SCALAR: {
                    return Variant.wrap((Double)this._scalar.getValue(true));
                }
                case ARRAY: {
                    return Variant.wrap((double[])this._array.getValue(true));
                }
                case SEQUENCE: {
                    return this.getSequenceOrSubSequence();
                }
            }
            throw new RuntimeException("Unreachable code point");
        }

        private Variant getSequenceOrSubSequence() {
            SubSequence subSeq = new SubSequence((Sequence)this._seq.getValue(true));
            subSeq.setT(this._dimT.getValidatedIndexRange());
            subSeq.setZ(this._dimZ.getValidatedIndexRange());
            subSeq.setC(this._dimC.getValidatedIndexRange());
            if (!subSeq.isValid()) {
                throw new IcyHandledException("The selected range of index in the sequence " + subSeq.getSequence().getName() + " (variable '" + this._label + "') is not valid.");
            }
            if (subSeq.isFullySelected()) {
                return Variant.wrap(subSeq.getSequence());
            }
            return Variant.wrap(subSeq);
        }

        private void refreshDimensionsPickerVisibility() {
            boolean sequenceIsVisible = this._type.getValue() == Variant.Type.SEQUENCE;
            this._dimT.setVisible(sequenceIsVisible && this._dimT.shouldBeVisible());
            this._dimZ.setVisible(sequenceIsVisible && this._dimZ.shouldBeVisible());
            this._dimC.setVisible(sequenceIsVisible && this._dimC.shouldBeVisible());
        }

        private static Variant.Type[] makeAvailableTypes() {
            return new Variant.Type[]{Variant.Type.SCALAR, Variant.Type.ARRAY, Variant.Type.SEQUENCE};
        }
    }
}

