/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker.LinearProgramming;

import java.util.ArrayList;
import plugins.nchenouard.linearprogrammingfullsimplex.CanonicalProgramParameters;
import plugins.nchenouard.linearprogrammingfullsimplex.CanonicalSimplexProgram;
import plugins.nchenouard.linearprogrammingfullsimplex.SimplexLEXICO;
import plugins.nchenouard.particletracking.MHTracker.LinearProgramming.HierarchicalProcedureResult;

public class HierarchicalLP {
    static double tolerance = 1.0E-4;
    public static boolean wroteFile = false;

    public static HierarchicalProcedureResult hierarchicalBinarySimplex(CanonicalSimplexProgram program, boolean display) {
        if (program == null) {
            return null;
        }
        CanonicalProgramParameters p = program.getParameters();
        double[][] AClone = new double[p.A.length][];
        for (int i = 0; i < AClone.length; ++i) {
            AClone[i] = (double[])p.A[i].clone();
        }
        if (program.solvePrimalSimplex()) {
            double[] solution = program.getSolution();
            if (solution == null) {
                return null;
            }
            int idxNonBool = -1;
            for (int i = 0; i < program.getNumVariables(); ++i) {
                if (!(Math.abs(solution[i]) > tolerance) || !(Math.abs(1.0 - solution[i]) > tolerance)) continue;
                idxNonBool = i;
                break;
            }
            if (idxNonBool < 0) {
                HierarchicalProcedureResult result = new HierarchicalProcedureResult();
                result.solution = solution;
                result.score = program.getScore();
                return result;
            }
            System.out.println("Non binary");
            CanonicalSimplexProgram p0 = HierarchicalLP.createSubFixedProblem(program, idxNonBool, 0);
            HierarchicalProcedureResult result0 = null;
            double score0 = 0.0;
            if (p0 != null) {
                result0 = HierarchicalLP.hierarchicalBinarySimplex(p0, display);
                if (result0 != null) {
                    score0 = result0.score;
                }
            } else {
                System.out.println("Non feasible sub problem");
            }
            CanonicalSimplexProgram p1 = HierarchicalLP.createSubFixedProblem(program, idxNonBool, 1);
            HierarchicalProcedureResult result1 = null;
            double score1 = 0.0;
            if (p1 != null) {
                result1 = HierarchicalLP.hierarchicalBinarySimplex(p1, display);
                if (result1 != null) {
                    score1 = result1.score + program.getParameters().c[idxNonBool];
                }
            } else {
                System.out.println("Non feasible sub problem");
            }
            if (result0 == null && result1 == null) {
                System.out.println("Both sub problem non feasible");
                return null;
            }
            if (result0 != null) {
                if (result1 == null || score0 >= score1) {
                    HierarchicalProcedureResult result = new HierarchicalProcedureResult();
                    result.solution = HierarchicalLP.fillIncompleteSolution(result0.solution, idxNonBool, 0.0);
                    result.score = score0;
                    result.hadNonBinary = true;
                    return result;
                }
                HierarchicalProcedureResult result = new HierarchicalProcedureResult();
                result.solution = HierarchicalLP.fillIncompleteSolution(result1.solution, idxNonBool, 1.0);
                result.score = score1;
                result.hadNonBinary = true;
                return result;
            }
            HierarchicalProcedureResult result = new HierarchicalProcedureResult();
            result.solution = HierarchicalLP.fillIncompleteSolution(result1.solution, idxNonBool, 1.0);
            result.score = score1;
            result.hadNonBinary = true;
            return result;
        }
        System.out.println("SOLVE FAILED");
        return null;
    }

    public static HierarchicalProcedureResult hierarchicalBinarySimplex(CanonicalSimplexProgram program) {
        if (program == null) {
            return null;
        }
        if (program.solvePrimalSimplex()) {
            double[] solution = program.getSolution();
            if (solution == null) {
                return null;
            }
            int idxNonBool = -1;
            for (int i = 0; i < program.getNumVariables(); ++i) {
                if (!(Math.abs(solution[i]) > tolerance) || !(Math.abs(1.0 - solution[i]) > tolerance)) continue;
                idxNonBool = i;
                break;
            }
            if (idxNonBool < 0) {
                HierarchicalProcedureResult result = new HierarchicalProcedureResult();
                result.solution = solution;
                result.score = program.getScore();
                return result;
            }
            CanonicalSimplexProgram p0 = HierarchicalLP.createSubFixedProblem(program, idxNonBool, 0);
            HierarchicalProcedureResult result0 = null;
            double score0 = 0.0;
            if (p0 != null) {
                result0 = HierarchicalLP.hierarchicalBinarySimplex(p0);
                if (result0 != null) {
                    score0 = result0.score;
                }
            } else {
                System.out.println("Non feasible sub problem");
            }
            CanonicalSimplexProgram p1 = HierarchicalLP.createSubFixedProblem(program, idxNonBool, 1);
            HierarchicalProcedureResult result1 = null;
            double score1 = 0.0;
            if (p1 != null) {
                result1 = HierarchicalLP.hierarchicalBinarySimplex(p1);
                if (result1 != null) {
                    score1 = result1.score + program.getParameters().c[idxNonBool];
                }
            } else {
                System.out.println("Non feasible sub problem");
            }
            if (result0 == null && result1 == null) {
                System.out.println("Both sub problem non feasible");
                return null;
            }
            if (result0 != null) {
                if (result1 == null || score0 >= score1) {
                    HierarchicalProcedureResult result = new HierarchicalProcedureResult();
                    result.solution = HierarchicalLP.fillIncompleteSolution(result0.solution, idxNonBool, 0.0);
                    result.score = score0;
                    result.hadNonBinary = true;
                    return result;
                }
                HierarchicalProcedureResult result = new HierarchicalProcedureResult();
                result.solution = HierarchicalLP.fillIncompleteSolution(result1.solution, idxNonBool, 1.0);
                result.score = score1;
                result.hadNonBinary = true;
                return result;
            }
            HierarchicalProcedureResult result = new HierarchicalProcedureResult();
            result.solution = HierarchicalLP.fillIncompleteSolution(result1.solution, idxNonBool, 1.0);
            result.score = score1;
            result.hadNonBinary = true;
            return result;
        }
        System.out.println("SOLVE FAILED");
        return null;
    }

    private static double[] fillIncompleteSolution(double[] solution, int idxNonBool, double val) {
        if (solution == null) {
            return null;
        }
        double[] completeSolution = new double[solution.length + 1];
        if (idxNonBool > 0) {
            System.arraycopy(solution, 0, completeSolution, 0, idxNonBool);
        }
        if (idxNonBool < solution.length) {
            System.arraycopy(solution, idxNonBool, completeSolution, idxNonBool + 1, solution.length - idxNonBool);
        }
        completeSolution[idxNonBool] = val;
        return completeSolution;
    }

    private static CanonicalSimplexProgram createSubFixedProblem(CanonicalSimplexProgram program, int idxNonBool, int val) {
        CanonicalProgramParameters p = program.getParameters();
        int numVariables = p.c.length;
        int numConstraints = p.b.length;
        ArrayList<double[]> constraints = new ArrayList<double[]>(numConstraints);
        ArrayList<Double> bVals = new ArrayList<Double>(numConstraints);
        ArrayList<Boolean> eqVals = new ArrayList<Boolean>(numConstraints);
        for (int i = 0; i < numConstraints; ++i) {
            double[] vector = new double[numVariables - 1];
            if (idxNonBool > 0) {
                System.arraycopy(p.A[i], 0, vector, 0, idxNonBool);
            }
            if (idxNonBool < numVariables - 1) {
                System.arraycopy(p.A[i], idxNonBool + 1, vector, idxNonBool, numVariables - 1 - idxNonBool);
            }
            boolean isZero = true;
            for (int j = 0; j < vector.length; ++j) {
                if (vector[j] == 0.0) continue;
                isZero = false;
                break;
            }
            if (isZero) continue;
            double modifiedB = p.b[i] - (double)val * p.A[i][idxNonBool];
            if (modifiedB < 0.0) {
                if (modifiedB + tolerance < 0.0) {
                    return null;
                }
                modifiedB = 0.0;
            }
            boolean alreadyIn = false;
            int vectorIdx = -1;
            for (int k = 0; k < constraints.size(); ++k) {
                boolean sameVector = true;
                double[] v1 = (double[])constraints.get(k);
                for (int kk = 0; kk < vector.length; ++kk) {
                    if (vector[kk] == v1[kk]) continue;
                    sameVector = false;
                    break;
                }
                if (!(alreadyIn = sameVector)) continue;
                vectorIdx = k;
                break;
            }
            if (alreadyIn) {
                if (p.equalityConstraints[i]) {
                    if (((Boolean)eqVals.get(vectorIdx)).booleanValue()) {
                        if (!(Math.abs(modifiedB - (Double)bVals.get(vectorIdx)) > tolerance)) continue;
                        return null;
                    }
                    if (modifiedB <= (Double)bVals.get(vectorIdx)) {
                        bVals.set(vectorIdx, modifiedB);
                        eqVals.set(vectorIdx, true);
                        continue;
                    }
                    return null;
                }
                if (((Boolean)eqVals.get(vectorIdx)).booleanValue()) {
                    if (!(modifiedB < (Double)bVals.get(vectorIdx))) continue;
                    return null;
                }
                if (!(modifiedB < (Double)bVals.get(vectorIdx))) continue;
                bVals.set(vectorIdx, modifiedB);
                continue;
            }
            constraints.add(vector);
            eqVals.add(p.equalityConstraints[i]);
            bVals.add(modifiedB);
        }
        if (!constraints.isEmpty()) {
            double[][] A = new double[constraints.size()][];
            double[] b = new double[A.length];
            boolean[] eq = new boolean[A.length];
            for (int i = 0; i < constraints.size(); ++i) {
                A[i] = (double[])constraints.get(i);
                b[i] = (Double)bVals.get(i);
                eq[i] = (Boolean)eqVals.get(i);
            }
            double[] c = new double[numVariables - 1];
            if (idxNonBool > 0) {
                System.arraycopy(p.c, 0, c, 0, idxNonBool);
            }
            if (idxNonBool < numVariables - 1) {
                System.arraycopy(p.c, idxNonBool + 1, c, idxNonBool, numVariables - 1 - idxNonBool);
            }
            return new SimplexLEXICO((double[][])A, b, c, p.maximization, eq);
        }
        return null;
    }
}

