/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.optim.SimpleBoxedSet;

public class DoubleBoxedSet
extends SimpleBoxedSet {
    private double[] lo = null;
    private double[] up = null;
    private int bound = 0;

    public DoubleBoxedSet(DoubleShapedVectorSpace space) {
        super(space);
    }

    private double[] getData(Vector vec) {
        this.space.check(vec);
        return ((DoubleShapedVector)vec).getData();
    }

    @Override
    public void setLowerBound(double val) {
        if (val > Double.NEGATIVE_INFINITY) {
            this.lo = new double[]{val};
            this.bound = this.bound / 3 * 3 + 1;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setLowerBound(Vector vec) {
        if (vec != null) {
            this.lo = this.getData(vec);
            this.bound = this.bound / 3 * 3 + 2;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setUpperBound(double val) {
        if (val < Double.POSITIVE_INFINITY) {
            this.up = new double[]{val};
            this.bound = this.bound % 3 + 3;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public void setUpperBound(Vector vec) {
        if (vec != null) {
            this.up = this.getData(vec);
            this.bound = this.bound % 3 + 6;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public final void projectVariables(Vector dst, Vector vec) {
        double[] xp = this.getData(dst);
        double[] x = this.getData(vec);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (xp == x) break;
                System.arraycopy(xp, 0, x, 0, n);
                break;
            }
            case 1: {
                double a = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    double t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    double t = x[i];
                    double a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 3: {
                double b = this.up[0];
                for (int i = 0; i < n; ++i) {
                    double t = x[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 4: {
                double a = this.lo[0];
                double b = this.up[0];
                for (int i = 0; i < n; ++i) {
                    double t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 5: {
                double b = this.up[0];
                for (int i = 0; i < n; ++i) {
                    double t = x[i];
                    double a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    double t = x[i];
                    double b = this.up[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 7: {
                double a = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    double t = x[i];
                    double b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < n; ++i) {
                    double a = this.lo[i];
                    double t = x[i];
                    double b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
        }
    }

    @Override
    public void projectDirection(Vector dst, Vector vec, Vector dir, int orient) {
        double[] dp = this.getData(dst);
        double[] x = this.getData(vec);
        double[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (dp == d) break;
                System.arraycopy(dp, 0, d, 0, n);
                break;
            }
            case 1: {
                double a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0 || x[i] > a ? d[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0 || x[i] > a ? d[i] : 0.0;
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0 || x[i] > this.lo[i] ? d[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0 || x[i] > this.lo[i] ? d[i] : 0.0;
                    }
                }
                break;
            }
            case 3: {
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0 || x[i] < b ? d[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0 || x[i] < b ? d[i] : 0.0;
                    }
                }
                break;
            }
            case 4: {
                double a = this.lo[0];
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
            case 5: {
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0 || x[i] < this.up[i] ? d[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0 || x[i] < this.up[i] ? d[i] : 0.0;
                    }
                }
                break;
            }
            case 7: {
                double a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void findFreeVariables(Vector dst, Vector vec, Vector dir, int orient) {
        double[] w = this.getData(dst);
        double[] x = this.getData(vec);
        double[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                for (int i = 0; i < n; ++i) {
                    w[i] = 1.0;
                }
                break;
            }
            case 1: {
                double a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? (double)(x[i] > a ? 1 : 0) : (double)(d[i] > 0.0 ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] > 0.0 ? (double)(x[i] > a ? 1 : 0) : (double)(d[i] < 0.0 ? 1 : 0);
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? (double)(x[i] > this.lo[i] ? 1 : 0) : (double)(d[i] > 0.0 ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] > 0.0 ? (double)(x[i] > this.lo[i] ? 1 : 0) : (double)(d[i] < 0.0 ? 1 : 0);
                    }
                }
                break;
            }
            case 3: {
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? 1.0 : (double)(d[i] > 0.0 ? x[i] < b : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0 ? 1.0 : (double)(d[i] < 0.0 ? x[i] < b : false);
                }
                break;
            }
            case 4: {
                double a = this.lo[0];
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? (double)(x[i] > a ? 1 : 0) : (double)(d[i] > 0.0 ? x[i] < b : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0 ? (double)(x[i] > a ? 1 : 0) : (double)(d[i] < 0.0 ? x[i] < b : false);
                }
                break;
            }
            case 5: {
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? (double)(x[i] > this.lo[i] ? 1 : 0) : (double)(d[i] > 0.0 ? x[i] < b : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0 ? (double)(x[i] > this.lo[i] ? 1 : 0) : (double)(d[i] < 0.0 ? x[i] < b : false);
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? 1.0 : (double)(d[i] > 0.0 ? x[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0 ? 1.0 : (double)(d[i] < 0.0 ? x[i] < this.up[i] : false);
                }
                break;
            }
            case 7: {
                double a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? (double)(x[i] > a ? 1 : 0) : (double)(d[i] > 0.0 ? x[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0 ? (double)(x[i] > a ? 1 : 0) : (double)(d[i] < 0.0 ? x[i] < this.up[i] : false);
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0 ? (double)(x[i] > this.lo[i] ? 1 : 0) : (double)(d[i] > 0.0 ? x[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0 ? (double)(x[i] > this.lo[i] ? 1 : 0) : (double)(d[i] < 0.0 ? x[i] < this.up[i] : false);
                }
                break;
            }
        }
    }

    @Override
    public double[] findStepLimits(Vector vec, Vector dir, int orient) {
        double[] x = this.getData(vec);
        double[] d = this.getData(dir);
        int n = x.length;
        double s3 = Double.POSITIVE_INFINITY;
        double s2 = Double.POSITIVE_INFINITY;
        double s1 = Double.POSITIVE_INFINITY;
        switch (this.bound) {
            case 1: {
                s3 = 0.0;
                double a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p < 0.0) {
                            double s = (a - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p > 0.0) {
                            double s = (x[i] - a) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 2: {
                s3 = 0.0;
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p < 0.0) {
                            double s = (this.lo[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p > 0.0) {
                            double s = (x[i] - this.lo[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 3: {
                s3 = 0.0;
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p > 0.0) {
                            double s = (b - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p < 0.0) {
                            double s = (x[i] - b) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 4: {
                s3 = 0.0;
                double a = this.lo[0];
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p > 0.0) {
                            s = (b - x[i]) / p;
                        } else {
                            if (!(p < 0.0)) continue;
                            s = (a - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p < 0.0) {
                            s = (x[i] - b) / p;
                        } else {
                            if (!(p > 0.0)) continue;
                            s = (x[i] - a) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
            case 5: {
                s3 = 0.0;
                double b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p > 0.0) {
                            s = (b - x[i]) / p;
                        } else {
                            if (!(p < 0.0)) continue;
                            s = (this.lo[i] - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p < 0.0) {
                            s = (x[i] - b) / p;
                        } else {
                            if (!(p > 0.0)) continue;
                            s = (x[i] - this.lo[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
            case 6: {
                s3 = 0.0;
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p > 0.0) {
                            double s = (this.up[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double p = d[i];
                        if (p < 0.0) {
                            double s = (x[i] - this.up[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0)) continue;
                        s3 = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 7: {
                s3 = 0.0;
                double a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p > 0.0) {
                            s = (this.up[i] - x[i]) / p;
                        } else {
                            if (!(p < 0.0)) continue;
                            s = (a - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p < 0.0) {
                            s = (x[i] - this.up[i]) / p;
                        } else {
                            if (!(p > 0.0)) continue;
                            s = (x[i] - a) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
            case 8: {
                s3 = 0.0;
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p > 0.0) {
                            s = (this.up[i] - x[i]) / p;
                        } else {
                            if (!(p < 0.0)) continue;
                            s = (this.lo[i] - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double s;
                        double p = d[i];
                        if (p < 0.0) {
                            s = (x[i] - this.up[i]) / p;
                        } else {
                            if (!(p > 0.0)) continue;
                            s = (x[i] - this.lo[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
        }
        return new double[]{s1, s2, s3};
    }
}

