package plugins.ylemontag.sequencecomparator;

import icy.sequence.Sequence;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Some useful static functions for sequence comparison
 */
public class CompareUtil
{
	/**
	 * Check whether two sequences have the same size or not
	 */
	public static boolean haveSameSize(Sequence ref, Sequence seq)
	{
		return
			ref.getSizeX()==seq.getSizeX() &&
			ref.getSizeY()==seq.getSizeY() &&
			ref.getSizeZ()==seq.getSizeZ() &&
			ref.getSizeT()==seq.getSizeT() &&
			ref.getSizeC()==seq.getSizeC();
	}
	
	/**
	 * Check whether two sequences have the same size except on the T coordinate,
	 * where ref is expected to have just 1 frame
	 */
	public static boolean comparableWithTExtent(Sequence ref, Sequence seq)
	{
		return ref.getSizeT()==1 &&
			ref.getSizeX()==seq.getSizeX() &&
			ref.getSizeY()==seq.getSizeY() &&
			ref.getSizeZ()==seq.getSizeZ() &&
			ref.getSizeC()==seq.getSizeC();
	}
	
	/**
	 * Check whether two sequences have the same size except on the Z coordinate,
	 * where ref is expected to have just 1 slice
	 */
	public static boolean comparableWithZExtent(Sequence ref, Sequence seq)
	{
		return ref.getSizeZ()==1 &&
			ref.getSizeX()==seq.getSizeX() &&
			ref.getSizeY()==seq.getSizeY() &&
			ref.getSizeT()==seq.getSizeT() &&
			ref.getSizeC()==seq.getSizeC();
	}
	
	/**
	 * Check whether two sequences have the same size except on the Z and T coordinates,
	 * where ref is expected to have just 1 slice and 1 frame
	 */
	public static boolean comparableWithZTExtent(Sequence ref, Sequence seq)
	{
		return ref.getSizeZ()==1 && ref.getSizeT()==1 &&
			ref.getSizeX()==seq.getSizeX() &&
			ref.getSizeY()==seq.getSizeY() &&
			ref.getSizeC()==seq.getSizeC();
	}
	
	/**
	 * Check whether two sequence are comparable, according the given extend flags
	 */
	public static boolean areComparable(Sequence ref, Sequence seq, boolean extendZ, boolean extendT)
	{
		if(extendZ) {
			if(extendT) {
				return comparableWithZTExtent(ref, seq);
			}
			else {
				return comparableWithZExtent(ref, seq);
			}
		}
		else {
			if(extendT) {
				return comparableWithTExtent(ref, seq);
			}
			else {
				return haveSameSize(ref, seq);
			}
		}
	}
}
