package plugins.tboudier.analysis3d;

import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.IcyFrame;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.VarWorkbook;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class Analysis3D extends EzPlug implements Block, EzStoppable {

    static IcyFrame mainFrame;
    private final EzVarSequence varSequence = new EzVarSequence(
            "Input Sequence");
    private final EzVarBoolean EZVarVol = new EzVarBoolean("Volume Analysis",
            true);
    private final EzVarBoolean EZVarShape = new EzVarBoolean("Shape Analysis",
            true);
    // private final Workbook wb = new HSSFWorkbook();
    final private VarWorkbook bookAnalysis = new VarWorkbook("Workbook-Analysis", (Workbook) null);

    @Override
    protected void initialize() {
        super.addEzComponent(varSequence);
        super.addEzComponent(EZVarVol);
        super.addEzComponent(EZVarShape);
    }

    @Override
    protected void execute() {
        final boolean gui = !isHeadLess();
        Sequence seq = varSequence.getValue();
        if (seq == null) {
            if (gui) {
                MessageDialog.showDialog("Open a labelled image first.");
            }
            return;
        }
        double resXY = seq.getPixelSizeX();
        double resZ = seq.getPixelSizeZ();

        if ((!EZVarVol.getValue()) && (!EZVarShape.getValue())) {
            if (gui) {
                MessageDialog.showDialog("No measure selected");
            }
            return;
        }

        // TEST ICY AREA3D selected
        ArrayList<ROI3D> rois = seq.getSelectedROI3Ds();
        if (rois.isEmpty()) {
            rois = seq.getROI3Ds();
        }
        if (rois.isEmpty()) {
            if (gui) {
                MessageDialog.showDialog("No 3D Rois found");
            }
            return;
        }
        if (gui) {
            super.getUI().setProgressBarVisible(true);
        }
        int ii = 0;
        int nb = rois.size();
        double[][] vols;
        double[][] shapes;
        int nbShapes = 10;
        int nbVols = 8;
        shapes = new double[nb][nbShapes];
        vols = new double[nb][nbVols];
        String[] ids = new String[nb];
        for (ROI3D roi : rois) {
            // ids[ii] = roi.getId();
            ids[ii] = roi.getName();
            if (roi.isEmpty())
                continue;
            Point3D[] points = roi.getBooleanMask(true).getPoints();
            ArrayList<Voxel3D> voxs = new ArrayList<Voxel3D>();
            if (points.length == 0) continue;
            for (Point3D point : points) {
                voxs.add(new Voxel3D(point.getX(), point.getY(), point.getZ(), 1));
            }
            Object3D obj = new Object3DVoxels(voxs);
            obj.setCalibration(resXY, resZ, "um");
            if (EZVarShape.getValue()) {
                shapes[ii][0] = obj.getCompactness(false);
                shapes[ii][1] = obj.getSphericity(false);
                shapes[ii][2] = ((Object3DVoxels) obj).getCompactnessCorrected();
                shapes[ii][3] = ((Object3DVoxels) obj).getSphericityCorrected();
                shapes[ii][4] = obj.getCompactness(true);
                shapes[ii][5] = obj.getSphericity(true);
                shapes[ii][6] = ((Object3DVoxels) obj).getDiscreteCompactness();
                shapes[ii][7] = obj.getMainElongation();
                shapes[ii][8] = obj.getMedianElongation();
                shapes[ii][9] = obj.getRatioEllipsoid();
            }
            if (EZVarVol.getValue()) {
                vols[ii][0] = obj.getVolumeUnit();
                vols[ii][1] = obj.getVolumePixels();
                vols[ii][2] = obj.getAreaUnit();
                vols[ii][3] = obj.getAreaPixels();
                vols[ii][4] = obj.getFeret();
                vols[ii][5] = obj.getDistCenterMean();
                vols[ii][6] = obj.getDistCenterMin();
                vols[ii][7] = obj.getDistCenterMax();
            }
            if (gui) {
                super.getUI().setProgressBarMessage("Object " + (ii + 1));
            }
            if (gui) {
                super.getUI().setProgressBarValue((double) (ii + 1) / (double) nb);
            }
            ii++;
        }
        System.out.println("");

        // create workbook
        // Workbook wb = bookMereo.getValue();
        Workbook wb = bookAnalysis.getValue();
        boolean newworkbook = false;
        if (wb == null) {
            bookAnalysis.setValue(wb = new HSSFWorkbook());
            newworkbook = true;
        }
        final boolean newWb = newworkbook;
        // wbvar = new VarWorkbook("workbook", wb);
        int nbSheet = 1;
        while (wb.getSheet("Analysis-" + nbSheet) != null) {
            nbSheet++;
        }
        // System.out.println("Nb sheet : " + nbSheet + " " + newworkbook);
        // remove existing sheet
        // for (int i = nbSheet; i >= 0; i--)
        if (newworkbook == false) wb.removeSheetAt(0);
        String sheetName = "Analysis3D";
        // System.out.println("Sheet name proposed Mereo-1 : " + sheetName + " "
        // + wb.getActiveSheetIndex() + " " + wb.getSheet("Mereo-1"));
        wb.createSheet(sheetName);
        Sheet sheet = wb.getSheet(sheetName);
        Row row = sheet.createRow(0);
        int nbCol = 1;
        row.createCell(0).setCellValue("Obj");
        row.createCell(1).setCellValue("Seq");
        if (EZVarVol.getValue()) {
            row.createCell(2).setCellValue("Volume (unit)");
            row.createCell(3).setCellValue("Volume (pix)");
            row.createCell(4).setCellValue("Area (unit)");
            row.createCell(5).setCellValue("Area (pix)");
            row.createCell(6).setCellValue("Feret (unit)");
            row.createCell(7).setCellValue("Mean DC (unit)");
            row.createCell(8).setCellValue("Min DC (unit)");
            row.createCell(9).setCellValue("Max DC (unit)");
            nbCol += nbVols;
        }
        if (EZVarShape.getValue()) {
            row.createCell(nbCol + 1).setCellValue("Compactness (pix)");
            row.createCell(nbCol + 2).setCellValue("Sphericity (pix)");
            row.createCell(nbCol + 3).setCellValue("CompactnessCorr (pix)");
            row.createCell(nbCol + 4).setCellValue("SphericityCorr (pix)");
            row.createCell(nbCol + 5).setCellValue("Compactness (unit)");
            row.createCell(nbCol + 6).setCellValue("Sphericity (unit)");
            row.createCell(nbCol + 7).setCellValue("CompDiscrete (pix)");
            row.createCell(nbCol + 8).setCellValue("Elongation (unit)");
            row.createCell(nbCol + 9).setCellValue("Flatness (unit)");
            row.createCell(nbCol + 10).setCellValue("Ratio Ell (unit)");
            nbCol += nbShapes;
        }

        // seq name
        for (int i = 0; i < nb; i++) {
            row = sheet.createRow((i + 1));
            row.createCell(0).setCellValue(ids[i]);
            row.createCell(1).setCellValue(seq.getName());
            nbCol = 0;
            if (EZVarVol.getValue()) {
                for (int j = 0; j < nbVols; j++) {
                    row.createCell(j + 2).setCellValue(vols[i][j]);
                }
                nbCol = 8;
            }
            if (EZVarShape.getValue()) {
                for (int j = 0; j < nbShapes; j++) {
                    row.createCell(nbCol + j + 2).setCellValue(shapes[i][j]);
                }
            }
        }
        if (gui) {
            ThreadUtil.invokeNow(new Runnable() {
                @Override
                public void run() {
                    if (!gui) {
                        return;
                    }
                    if (!newWb) {
                        mainFrame.setVisible(false);
                        mainFrame.dispose();
                    }

                    mainFrame = new IcyFrame("Analysis workbook");
                    mainFrame.setResizable(true);
                    mainFrame.setLayout(new BorderLayout());

                    // VarWorkbook wbvar = new VarWorkbook("Mereo workbook",
                    // wb);
                    WorkbookEditor ed = new WorkbookEditor(bookAnalysis);
                    ed.setEnabled(true);

                    JComponent cp = ed.getEditorComponent();
                    cp.setPreferredSize(new Dimension(600, 600));

                    mainFrame.add(cp, BorderLayout.CENTER);

                    JButton buttonSave = new JButton("Save workbook as...");
                    buttonSave.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String path = SaveDialog.chooseFile("Save workbook as...", null, "Workbook", ".xls");
                            if (path == null) {
                                return;
                            }
                            //WorkbookToFile.saveAsSpreadSheet(bookAnalysis.getValue(), path, WorkbookToFile.MergePolicy.Overwrite);

                            try {
                                FileOutputStream fos = new FileOutputStream(path);
                                bookAnalysis.getValue().write(fos);
                                fos.close();

                            } catch (IOException e1) {
                                MessageDialog.showDialog(e1.getMessage(), MessageDialog.ERROR_MESSAGE);
                            }
                        }
                    });
                    JPanel southPanel = new JPanel();
                    southPanel.add(buttonSave);
                    mainFrame.add(southPanel, BorderLayout.SOUTH);

                    // Pack and show the window
                    mainFrame.pack();
                    mainFrame.addToMainDesktopPane();
                    mainFrame.setVisible(true);
                }
            });
        }

    }

    @Override
    public void clean() {
        //
    }

    @Override
    public void stopExecution() {
        System.out.println("3D Analysis plugin stopped.");
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("Sequence", varSequence.getVariable());
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("Analysis", bookAnalysis);
    }
}
