/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.Format;
import java.util.EventListener;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IcyTextField
extends JFormattedTextField
implements DocumentListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 4294607311366304781L;
    @Deprecated
    protected boolean consumeCharKeyPressEvent;
    protected boolean changed;

    public IcyTextField() {
        this.init();
    }

    public IcyTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.init();
    }

    public IcyTextField(Format format) {
        super(format);
        this.init();
    }

    public IcyTextField(Object value) {
        super(value);
        this.init();
    }

    protected void init() {
        this.changed = false;
        this.consumeCharKeyPressEvent = false;
        this.getDocument().addDocumentListener(this);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    protected void internalTextChanged(boolean validate) {
        if (!validate) {
            this.changed = true;
            this.textChanged(false);
        } else if (this.changed) {
            this.textChanged(true);
            this.changed = false;
        }
    }

    protected void textChanged(boolean validate) {
        this.fireTextChanged(validate);
    }

    protected void fireTextChanged(boolean validate) {
        TextChangeListener[] textChangeListenerArray = (TextChangeListener[])this.listenerList.getListeners(TextChangeListener.class);
        int n = textChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextChangeListener listener = textChangeListenerArray[n2];
            listener.textChanged(this, validate);
            ++n2;
        }
    }

    public void setUnchanged() {
        this.changed = false;
    }

    public void addTextChangeListener(TextChangeListener listener) {
        this.listenerList.add(TextChangeListener.class, listener);
    }

    public void removeTextChangeListener(TextChangeListener listener) {
        this.listenerList.remove(TextChangeListener.class, listener);
    }

    @Deprecated
    public void setConsumeCharKeyPressEvent(boolean consumeCharKeyPressEvent) {
        this.consumeCharKeyPressEvent = consumeCharKeyPressEvent;
    }

    @Deprecated
    public boolean getConsumeCharKeyPressEvent() {
        return this.consumeCharKeyPressEvent;
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        super.processComponentKeyEvent(e);
        if (this.consumeCharKeyPressEvent) {
            char c = e.getKeyChar();
            if (e.getID() == 401 && Character.isDefined(c) && !Character.isISOControl(c)) {
                e.consume();
            }
        }
    }

    @Override
    public void setText(String t) {
        if (StringUtil.equals(t, this.getText(), false)) {
            return;
        }
        super.setText(t);
        this.internalTextChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.internalTextChanged(false);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.internalTextChanged(false);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.internalTextChanged(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.internalTextChanged(true);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.internalTextChanged(true);
    }

    public static interface TextChangeListener
    extends EventListener {
        public void textChanged(IcyTextField var1, boolean var2);
    }
}

