/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.button.IcyToggleButton;
import icy.gui.util.ComponentUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.util.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class PopupPanel
extends JPanel {
    private static final long serialVersionUID = -5208183544572376729L;
    protected final PopupTitlePanel topPanel;
    protected final JPanel mainPanel;
    protected final boolean subPopupPanel;

    @Deprecated
    public PopupPanel(String title, int panelHeight, boolean subPopupPanel) {
        this(title, subPopupPanel);
    }

    @Deprecated
    public PopupPanel(String title, int panelHeight) {
        this(title, false);
    }

    public PopupPanel(String title, JPanel panel, boolean subPanel) {
        this.topPanel = new PopupTitlePanel(title, ResourceUtil.ICON_PANEL_COLLAPSE);
        this.mainPanel = panel;
        this.subPopupPanel = subPanel;
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.refresh();
    }

    public PopupPanel(String title, JPanel panel) {
        this(title, panel, false);
    }

    public PopupPanel(String title, boolean subPanel) {
        this(title, new JPanel(), subPanel);
    }

    public PopupPanel(String title) {
        this(title, false);
    }

    @Deprecated
    public PopupPanel() {
        this("no title", false);
    }

    public String getTitle() {
        return this.topPanel.getText();
    }

    public void setTitle(String value) {
        this.topPanel.setText(value);
    }

    public PopupTitlePanel getTitlePanel() {
        return this.topPanel;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isCollapsed() {
        return !this.isExpanded();
    }

    public boolean isExpanded() {
        return this.topPanel.isSelected();
    }

    public void setExpanded(boolean value) {
        if (this.topPanel.isSelected() != value) {
            this.topPanel.setSelected(value);
            this.refresh();
        }
    }

    public boolean isSubPopupPanel() {
        return this.subPopupPanel;
    }

    public void expand() {
        this.setExpanded(true);
    }

    public void collapse() {
        this.setExpanded(false);
    }

    void refresh() {
        if (this.subPopupPanel) {
            if (this.topPanel.isSelected()) {
                this.topPanel.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_NODE_EXPANDED, 10)));
            } else {
                this.topPanel.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_NODE_COLLAPSED, 10)));
            }
        } else if (this.topPanel.isSelected()) {
            this.topPanel.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_NODE_EXPANDED, 14)));
        } else {
            this.topPanel.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_NODE_COLLAPSED, 14)));
        }
        this.mainPanel.setVisible(this.topPanel.isSelected());
    }

    private class PopupTitlePanel
    extends IcyToggleButton {
        private static final long serialVersionUID = -6311966421110920079L;

        public PopupTitlePanel(String text, Image image) {
            super(text, new IcyIcon(image, 14));
            this.setHorizontalAlignment(10);
            this.setFocusPainted(false);
            if (PopupPanel.this.subPopupPanel) {
                ComponentUtil.setFixedHeight(this, this.getTextSize().height);
            } else {
                ComponentUtil.setFontBold(this);
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupPanel.this.refresh();
                }
            });
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.updateIconTextGap();
        }

        @Override
        public void setIcon(Icon defaultIcon) {
            super.setIcon(defaultIcon);
            this.updateIconTextGap();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.updateIconTextGap();
        }

        private Dimension getTextSize() {
            String text = this.getText();
            if (text != null) {
                Rectangle2D r = GraphicsUtil.getStringBounds(this, text);
                return new Dimension((int)r.getWidth(), (int)r.getHeight());
            }
            return new Dimension(0, 0);
        }

        private void updateIconTextGap() {
            int width = this.getWidth();
            Icon icon = this.getIcon();
            if (width != 0 && icon != null) {
                int iconTextGap = (width - this.getTextSize().width) / 2;
                this.setIconTextGap(iconTextGap -= icon.getIconWidth() + 10);
            }
        }
    }
}

